/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.sony.jpeg;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.sony.SonyCameraSrv;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;

public class SonyJPEGVideoSourceClient
extends JPEGVideoSourceClient
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.sony.jpeg.SonyJPEGVideoSourceClient";
    private HttpServerPushHandler httpServerPushHandler = null;
    private int streamNumber = 1;
    private boolean isPalFormat = false;
    private int errorCode = 0;
    private String serverPushURL;

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    @Override
    public int init() {
        this.errorCode = super.init(false);
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        try {
            long fps = (this.highestFramerate + 999L) / 1000L;
            String seeTecID = Long.toHexString(System.currentTimeMillis() & 0xFFFFFFFFL);
            long entityType = super.getVideoSrv().getEntityType();
            this.errorCode = entityType == 210506L || entityType == 210507L || entityType == 210516L || entityType == 210517L || entityType == 210520L || entityType == 210521L || entityType == 210522L || entityType == 210523L || entityType == 210524L || entityType == 210525L || entityType == 210515L || entityType == 210513L ? this.handleSony(fps, seeTecID) : (this.getVideoSrv().getDevice().getDeviceType() == 200623L ? this.handleSony_Vx(fps, seeTecID) : (entityType == 210531L || entityType == 210526L || entityType == 210532L || entityType == 210527L || entityType == 210533L || entityType == 210528L || entityType == 210529L || entityType == 210534L || entityType == 210530L || entityType == 210535L || entityType == 210536L || entityType == 210537L || entityType == 210538L || entityType == 210539L || entityType == 210540L || entityType == 210541L || entityType == 210542L || this.getVideoSrv().getDevice().getDeviceType() == 200633L || this.getVideoSrv().getDevice().getDeviceType() == 200630L || this.getVideoSrv().getDevice().getDeviceType() == 200631L || this.getVideoSrv().getDevice().getDeviceType() == 200632L ? this.handleSony_5Gen(fps) : this.handleSony_RZx_Px_CSx(fps, seeTecID)));
            if (this.errorCode != 0) {
                this.logger.error("Error while initializing " + this + ", error code: " + this.errorCode);
                return this.errorCode;
            }
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
            return this.errorCode;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return this.errorCode;
        }
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            boolean asynchronous = false;
            this.httpServerPushHandler = new HttpServerPushHandler();
            this.networkParameter.setSoTimeout(5000);
            this.errorCode = this.httpServerPushHandler.init(this, this.networkParameter, this.serverPushURL);
            if (this.errorCode != 0) {
                this.logger.error("Error [" + this.errorCode + "] with " + this.httpServerPushHandler);
            } else {
                this.errorCode = this.httpServerPushHandler.startServerPush(asynchronous);
            }
        }
        catch (Exception e) {
            this.logger.error("Starting serverpush for " + this.getVideoSrv().getDevice() + " failed.", (Throwable)e);
            this.errorCode = -21601;
            return;
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    private int handleSony_Vx(long fps, String seeTecID) {
        StringBuffer sbURL = new StringBuffer(256);
        int camID = 1;
        long entityType = super.getVideoSrv().getEntityType();
        try {
            camID = this.getVideoSrv().getVideoSourceCnf().getPtzAddress();
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Reading configuration from " + super.getVideoSrv() + " failed :-(");
            return -20001;
        }
        if (entityType == 219900L) {
            sbURL.append("/command/system.cgi?");
            sbURL.append("Cam");
            sbURL.append(this.videoSourceNr);
            sbURL.append("Protocol=99");
        } else {
            sbURL.append("/command/system.cgi?");
            sbURL.append("Cam");
            sbURL.append(this.videoSourceNr);
            sbURL.append("ID=");
            sbURL.append(camID - 1);
        }
        this.errorCode = this.setStreamParameter(sbURL.toString());
        if (this.errorCode != 0) {
            this.logger.error("Setting stream parameter failed with error [" + this.errorCode + "] :-(");
            return this.errorCode;
        }
        sbURL = new StringBuffer();
        sbURL.append("/command/videoset.cgi?sid=");
        sbURL.append(seeTecID);
        sbURL.append("&ChannelNO=");
        sbURL.append(this.videoSourceNr);
        if (this.width == 720) {
            sbURL.append("&ImageSize=0");
        } else if (this.width == 640) {
            sbURL.append("&ImageSize=1");
        } else {
            sbURL.append("&ImageSize=2");
        }
        this.errorCode = this.setStreamParameter(sbURL.toString());
        if (this.errorCode != 0) {
            this.logger.error("Setting stream parameter failed with error [" + this.errorCode + "]");
            return this.errorCode;
        }
        sbURL = new StringBuffer(256);
        if (this.useDateTime) {
            sbURL.append("/command/osd.cgi?ChannelNo=");
            sbURL.append(this.videoSourceNr);
            sbURL.append("&partno=1&available=1&TextMode=1");
        } else if (this.useTitle) {
            sbURL.append("/command/osd.cgi?ChannelNo=");
            sbURL.append(this.videoSourceNr);
            sbURL.append("&partno=1&available=1&TextMode=0&text=");
            sbURL.append(this.title);
        } else {
            sbURL.append("/command/osd.cgi?ChannelNo=");
            sbURL.append(this.videoSourceNr);
            sbURL.append("&partno=1&available=0");
        }
        this.errorCode = this.setStreamParameter(sbURL.toString());
        if (this.errorCode != 0) {
            this.logger.error("Setting title/date failed with error [" + this.errorCode + "]");
            return this.errorCode;
        }
        int[] allowedValues = new int[]{1, 2, 3, 4, 5, 6, 8, 12, 25};
        fps = (fps = (long)Tools.convertToCameraValues(allowedValues, (int)fps)) == 25L ? 0L : fps;
        sbURL = new StringBuffer(256);
        sbURL.append("/command/videoselect.cgi?sid=");
        sbURL.append(seeTecID);
        sbURL.append("&ChannelNO=");
        sbURL.append(this.videoSourceNr);
        sbURL.append("&ImageCodec=0");
        sbURL.append("&JpQuality=");
        sbURL.append((100000 - this.quality) / 10001 + 1);
        sbURL.append("&JpFrameRate=");
        sbURL.append(fps);
        this.errorCode = this.setStreamParameter(sbURL.toString());
        if (this.errorCode != 0) {
            this.logger.error("Setting stream parameter failed with error [" + this.errorCode + "]");
            return this.errorCode;
        }
        this.errorCode = this.setStreamParameter(sbURL.toString());
        if (this.errorCode != 0) {
            this.logger.error("Setting stream parameter failed with error [" + this.errorCode + "]");
            return this.errorCode;
        }
        this.errorCode = this.setStreamParameter(sbURL.toString());
        if (this.errorCode != 0) {
            this.logger.error("Setting stream parameter failed with error [" + this.errorCode + "]");
            return this.errorCode;
        }
        this.serverPushURL = "/command/image.cgi?ChannelNO=" + this.videoSourceNr + "&speed=" + fps;
        return this.errorCode;
    }

    private int handleSony_RZx_Px_CSx(long fps, String seeTecID) {
        StringBuilder sbURL = new StringBuilder(256);
        if (super.getVideoSrv().getEntityType() == 210505L || super.getVideoSrv().getEntityType() == 210509L || super.getVideoSrv().getEntityType() == 210518L || super.getVideoSrv().getEntityType() == 210519L || super.getVideoSrv().getEntityType() == 210510L) {
            sbURL.append("/command/camera.cgi?sid=");
            sbURL.append(seeTecID);
            sbURL.append("&ImageCodec=jpeg");
            sbURL.append("&ImageSize=");
            sbURL.append(this.width);
            sbURL.append(",2");
            sbURL.append("&JpQuality=");
            sbURL.append((100000 - this.quality) / 20001 + 1);
        } else if (super.getVideoSrv().getEntityType() == 210502L) {
            sbURL.append("/command/camera.cgi?sid=");
            sbURL.append(seeTecID);
            sbURL.append("&ImageSize=8");
            sbURL.append("&ImageSizeOption=");
            sbURL.append(this.width);
            sbURL.append(",0");
            sbURL.append("&Quality=");
            sbURL.append((100000 - this.quality) / 10001 + 1);
        } else if (super.getVideoSrv().getEntityType() == 210514L) {
            sbURL.append("/command/camera.cgi?sid=");
            sbURL.append(seeTecID);
            sbURL.append("&ImageCodec=jpeg");
            sbURL.append("&JpImageSize=").append(this.width).append(",2");
            sbURL.append("&JpQuality=");
            sbURL.append(this.quality / 10001 + 1);
        } else {
            String imageSize = "";
            if (this.width == 736) {
                imageSize = "&JpImageSize=0";
            } else if (this.width == 640) {
                imageSize = "&JpImageSize=3";
            } else if (this.width == 320) {
                imageSize = "&JpImageSize=6";
            } else if (this.width == 160) {
                imageSize = "&JpImageSize=7";
            }
            sbURL.append("/command/camera.cgi?sid=");
            sbURL.append(seeTecID);
            sbURL.append("&ImageCodec=jpeg");
            sbURL.append(imageSize);
            sbURL.append("&Quality=");
            sbURL.append((100000 - this.quality) / 10001 + 1);
        }
        String url = sbURL.toString();
        try {
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)true);
        }
        catch (SeeTecException ex) {
            this.logger.error("Setting stream parameter failed with error [" + ex.getMessage() + "] :-(");
            return ex.getErrorCode();
        }
        StringBuilder sb = new StringBuilder(256);
        if (super.getVideoSrv().getEntityType() == 210514L) {
            sb.append("/image?speed=");
            sb.append(fps);
        } else {
            sb.append("/image?sid=");
            sb.append(seeTecID);
            sb.append("&speed=");
            sb.append(fps);
        }
        this.serverPushURL = sb.toString();
        return this.errorCode;
    }

    private int handleSony(long fps, String seeTecID) {
        StringBuilder sbURL = new StringBuilder(256);
        sbURL.append("/command/camera.cgi?sid=");
        sbURL.append(seeTecID);
        sbURL.append("&ImageCodec=jpeg");
        sbURL.append("&JpImageSize=");
        sbURL.append(this.width);
        sbURL.append(",2");
        sbURL.append("&JpQuality=");
        sbURL.append((100000 - this.quality) / 10001 + 1);
        String url = sbURL.toString();
        try {
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MIN_VALUE);
        }
        catch (SeeTecException e) {
            this.logger.error("Setting stream parameter failed with error [" + e.getErrorCode() + "]", (Throwable)e);
            return e.getErrorCode();
        }
        this.serverPushURL = "/image?speed=" + fps;
        return this.errorCode;
    }

    private int handleSony_5Gen(long nFPS) {
        int[] allowedValues;
        this.errorCode = 0;
        int fps = 0;
        long entityType = super.getVideoSrv().getEntityType();
        this.networkParameter.setSoTimeout(5000);
        SonyCameraSrv sonyCameraSrv = (SonyCameraSrv)this.getVideoSrv();
        try {
            this.isPalFormat = sonyCameraSrv.isPalFormat();
            this.streamNumber = sonyCameraSrv.getStreamNumber(this.listener.getDynamicVideoProfileID());
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while getting stream number for " + this);
            return ex.getErrorCode();
        }
        try {
            this.networkParameter.setSoTimeout(10000);
            byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/command/inquiry.cgi?inqjs=camera", (int)Integer.MAX_VALUE, (boolean)false, (String)("ImageCodec" + this.streamNumber));
            if (result != null && !new String(result).contains("ImageCodec" + this.streamNumber + "=\"jpeg\"")) {
                this.logger.info("Changing codec: setting MJPEG for stream " + this.streamNumber);
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/command/camera.cgi?ImageCodec" + this.streamNumber + "=jpeg"), (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/command/inquiry.cgi?inqjs=camera", (int)Integer.MAX_VALUE, (boolean)true);
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException ex) {
        }
        catch (SeeTecException ex) {
            this.logger.info("Exception occured while retrieving camera setup: " + ex.getMessage());
            return ex.getErrorCode();
        }
        StringBuilder sbURL = new StringBuilder(256);
        sbURL.append("/command/camera.cgi?JpQuality=");
        sbURL.append(this.quality / 10001 + 1);
        if (entityType == 210528L || entityType == 210535L || entityType == 210536L || entityType == 210541L || entityType == 210542L) {
            allowedValues = new int[]{1, 2, 3, 4, 5, 6, 8, 10, 12, 15, 16, 20, 25, 30};
            fps = Tools.convertToCameraValues(allowedValues, (int)nFPS);
        } else if (entityType == 210540L) {
            allowedValues = new int[]{1, 2, 3, 4, 5, 6, 8, 10, 12, 15, 16, 20, 25};
            fps = Tools.convertToCameraValues(allowedValues, (int)nFPS);
        } else if (entityType == 210526L || entityType == 210532L || entityType == 210527L || entityType == 210533L || entityType == 210529L || entityType == 210538L || entityType == 210537L || entityType == 210534L) {
            allowedValues = new int[]{1, 2, 3, 4, 5, 6, 8, 10, 15, 20, 25, 30};
            fps = Tools.convertToCameraValues(allowedValues, (int)nFPS);
        } else if (entityType == 210539L) {
            allowedValues = new int[]{1, 2, 3, 4, 5, 6, 8, 12, 16, 20, 25};
            fps = Tools.convertToCameraValues(allowedValues, (int)nFPS);
        } else if (this.isPalFormat) {
            allowedValues = new int[]{1, 2, 3, 4, 5, 6, 8, 12, 16, 20, 25};
            fps = Tools.convertToCameraValues(allowedValues, (int)nFPS);
        } else {
            allowedValues = new int[]{1, 2, 3, 4, 5, 6, 8, 10, 15, 20, 25, 30};
            fps = Tools.convertToCameraValues(allowedValues, (int)nFPS);
        }
        if (this.width >= 1920) {
            fps = fps > 25 ? 25 : fps;
        }
        sbURL.append("&FrameRate");
        sbURL.append(this.streamNumber);
        sbURL.append("=");
        sbURL.append(fps);
        String url = sbURL.toString();
        try {
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while setting stream parameters for " + this + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
        this.serverPushURL = "/mjpeg";
        return this.errorCode;
    }

    private int setStreamParameter(String url) {
        if (this.isShutdown()) {
            this.logger.warn(this + " is already shutting down!");
            return 0;
        }
        try {
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)200);
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/command/inquiry.cgi?inqjs=camera", (int)Integer.MAX_VALUE, (boolean)true);
            return 0;
        }
        catch (SeeTecException ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            return ex.getErrorCode();
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            int statusCode = -21654;
            this.logger.error(this + " cannot establish connection to [" + this.host + ":" + this.port + "]");
            return statusCode;
        }
    }

    public long getMilliCompression() {
        return this.quality;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.httpServerPushHandler != null) {
            this.httpServerPushHandler.shutdown();
        }
        return super.shutdown();
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        if (this.isShutdown()) {
            return;
        }
        this.listener.sendStatusService(nStatusCode);
    }

    @Override
    public void notifyForNetworkProblems() {
        if (this.isShutdown()) {
            return;
        }
        this.sendStatusService(-21603);
        this.shutdown();
    }

    public int setImageParameters(int fps) {
        int[] allowedValues;
        this.errorCode = 0;
        int framerate = fps;
        long entityType = super.getVideoSrv().getEntityType();
        if (entityType == 210528L || entityType == 210536L || entityType == 210537L) {
            allowedValues = new int[]{1, 2, 3, 4, 5, 6, 8, 10, 12, 15, 16, 20, 25, 30};
            framerate = Tools.convertToCameraValues(allowedValues, framerate);
        } else if (entityType == 210526L || entityType == 210532L || entityType == 210527L || entityType == 210533L || entityType == 210529L || entityType == 210534L) {
            allowedValues = new int[]{1, 2, 3, 4, 5, 6, 8, 10, 15, 20, 25, 30};
            framerate = Tools.convertToCameraValues(allowedValues, framerate);
        } else if (this.isPalFormat) {
            allowedValues = new int[]{1, 2, 3, 4, 5, 6, 8, 12, 16, 20, 25};
            framerate = Tools.convertToCameraValues(allowedValues, framerate);
        } else {
            allowedValues = new int[]{1, 2, 3, 4, 5, 6, 8, 10, 15, 20, 25, 30};
            framerate = Tools.convertToCameraValues(allowedValues, framerate);
        }
        StringBuilder sbURL = new StringBuilder(256);
        sbURL.append("/command/camera.cgi?FrameRate");
        sbURL.append(this.streamNumber).append("=");
        sbURL.append(framerate);
        String url = sbURL.toString();
        try {
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/command/inquiry.cgi?inqjs=camera", (int)Integer.MAX_VALUE, (boolean)true);
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while setting stream parameters for " + this + ": " + ex.getMessage());
            this.errorCode = ex.getErrorCode();
        }
        return this.errorCode;
    }
}

