/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.sony;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.HttpStreamHandler;
import de.seetec.v5.re.cm.device.shared.net.rtsp.HttpStreamListenerIntf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelper;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.sony.SonyCameraSrv;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.re.shared.MpegProfile;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.SSLConstantsIntf;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class SonyVideoSourceClient_6thGen
extends StreamingVideoSourceClientRTSP
implements HttpServerPushListenerIntf,
HttpStreamListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.sony.SonyVideoSourceClient_6thGen";
    private boolean isPalFormat;
    private int streamNumber = 1;
    private SonyCameraSrv sonyCameraSrv;
    private AudioHandler audioHandler;
    private Thread audioHandlerThread = null;
    private HttpStreamHandler httpStreamHandler = null;
    private ByteArrayOutputStream baos = null;

    @Override
    protected int init() {
        CharSequence url;
        String area2Text;
        String area1Text;
        String string;
        String rotateAbility;
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        this.sonyCameraSrv = (SonyCameraSrv)this.getVideoSrv();
        try {
            if (this.sonyCameraSrv.getSonyGeneration() > 5) {
                this.streamNumber = this.sonyCameraSrv.getStreamNumber(this.listener.getDynamicVideoProfileID());
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while getting stream number for " + this);
            return ex.getErrorCode();
        }
        this.logger.info("init started for" + this.getVideoSrv());
        this.networkParameter.setSoTimeout(10000);
        try {
            this.isPalFormat = this.sonyCameraSrv.isPalFormat();
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while checking video format for " + this + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
        this.iFrameDist = this.iFrameDistMS / 1000;
        int iFrameLowerLimit = 1;
        int iFrameUpperLimit = 5;
        int[] iFrameLimits = this.sonyCameraSrv.getVideoParameterAsInt("IFrameInterval" + this.streamNumber);
        if (iFrameLimits.length == 2) {
            iFrameLowerLimit = iFrameLimits[0];
            iFrameUpperLimit = iFrameLimits[1];
        }
        this.iFrameDist = this.iFrameDist < (long)iFrameLowerLimit ? (long)iFrameLowerLimit : this.iFrameDist;
        this.iFrameDist = this.iFrameDist > (long)iFrameUpperLimit ? (long)iFrameUpperLimit : this.iFrameDist;
        float[] possibleFramerates = this.sonyCameraSrv.getVideoParameterAsFloat("Framerate" + this.streamNumber);
        this.fps = this.fps > 30000L ? (this.isPalFormat ? 50000L : 60000L) : (long)((int)(Tools.convertToCameraValues(possibleFramerates, (float)this.fps / 1000.0f) * 1000.0f));
        String sFPS = Tools.convertDoubleToString((float)this.fps / 1000.0f, Locale.US);
        String codec = "h264";
        if (this.videoCodec == Codec.MJPEG) {
            codec = "jpeg";
        }
        if (this.videoCodec == Codec.MJPEG || !this.isConstantBitrateUsed) {
            int[] qualityLimits;
            int qualityLowerLimit = 1;
            int qualityUpperLimit = 10;
            String readParameterString = "H264Quality" + this.streamNumber;
            if (this.videoCodec == Codec.MJPEG) {
                readParameterString = this.sonyCameraSrv.getSonyGeneration() == 6 ? readParameterString.replace("H264Quality", "Quality") : readParameterString.replace("H264Quality", "JpegQuality");
            }
            int[] nArray = qualityLimits = this.sonyCameraSrv.getSonyGeneration() > 6 && this.videoCodec != Codec.MJPEG ? new int[]{} : this.sonyCameraSrv.getVideoParameterAsInt(readParameterString);
            if (qualityLimits.length == 2) {
                qualityLowerLimit = qualityLimits[0];
                qualityUpperLimit = qualityLimits[1];
            }
            this.quality = this.quality * qualityUpperLimit / 100000 + 1;
            this.quality = this.quality > qualityUpperLimit ? qualityUpperLimit : this.quality;
            this.quality = this.quality < qualityLowerLimit ? qualityLowerLimit : this.quality;
        }
        int[] allowedValues = new int[]{64, 128, 256, 384, 512, 768, 1000, 1500, 2000, 3000, 4000, 5000, 6000, 7000, 8000, 16000, 24000, 32000};
        this.bandwidth = Tools.convertToCameraValues(allowedValues, this.bandwidth / 1024);
        int bitrateLowerLimit = 1;
        int bitrateUpperLimit = 10;
        int[] bitrateLimits = this.sonyCameraSrv.getVideoParameterAsInt("Bitrate" + this.streamNumber);
        if (bitrateLimits.length == 2) {
            bitrateLowerLimit = bitrateLimits[0];
            bitrateUpperLimit = bitrateLimits[1];
        }
        this.bandwidth = this.bandwidth < bitrateLowerLimit ? bitrateLowerLimit : this.bandwidth;
        this.bandwidth = this.bandwidth > bitrateUpperLimit ? bitrateUpperLimit : this.bandwidth;
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (this.isAudioEnabled) {
            parameters.put("AudioIn", "on");
            if (this.audioCodec == Codec.G711U || this.audioCodec == Codec.G711A) {
                parameters.put("AudInCodec", "g711_" + this.audioBitrate / 1000);
            }
            if (this.audioCodec == Codec.G726) {
                parameters.put("AudInCodec", "g726_" + this.audioBitrate / 1000);
            }
        } else {
            parameters.put("AudioIn", "off");
        }
        parameters.put("ImageSize" + this.streamNumber, this.width + "%2C" + this.height);
        parameters.put("ImageCodec" + this.streamNumber, codec);
        try {
            parameters.put("RTSPPort", this.listener.getVideoSourceParameter().getRtspPort() + "");
        }
        catch (ConfigurationException exception) {
            this.logger.warn("RTSP port could not be read", (Throwable)exception);
        }
        parameters.put("FrameRate" + this.streamNumber, sFPS);
        if (this.videoCodec == Codec.MJPEG) {
            parameters.put("JpegQuality" + this.streamNumber, "" + this.quality);
        } else {
            parameters.put("IFrameInterval" + this.streamNumber, "" + this.iFrameDist);
            if (this.isConstantBitrateUsed) {
                parameters.put("CBR" + this.streamNumber, "on");
                parameters.put("BitRate" + this.streamNumber, "" + this.bandwidth);
            } else {
                parameters.put("CBR" + this.streamNumber, "off");
                parameters.put("VBRMode" + this.streamNumber, "bitratelimit");
                parameters.put("VBRBitrateMax" + this.streamNumber, "" + this.bandwidth);
                if (this.sonyCameraSrv.getSonyGeneration() == 7) {
                    parameters.put("BitRate" + this.streamNumber, "" + this.bandwidth);
                }
                if (this.sonyCameraSrv.getSonyGeneration() == 6) {
                    parameters.put("H264Quality" + this.streamNumber, "" + this.quality);
                }
            }
        }
        if (this.getVideoSrv().getEntityType() == 210553L && (rotateAbility = this.sonyCameraSrv.readSystemConfiguration("EflipFunc", false)).contains("1")) {
            String rotateFlag = this.rotationAngle == 180 ? "on" : "off";
            parameters.put("Eflip", rotateFlag);
        }
        try {
            MpegProfile mpegProfile = this.listener.getVideoSourceParameter().getMpegProfile();
            if (mpegProfile == MpegProfile.HIGH) {
                parameters.put("H264Profile" + this.streamNumber, "high");
            }
            if (mpegProfile == MpegProfile.MAIN) {
                parameters.put("H264Profile" + this.streamNumber, "main");
            }
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Can't get MpegProfile for " + this);
        }
        ArrayList<String> parametersToRemove = new ArrayList<String>();
        boolean readConfig = true;
        for (Map.Entry entry : parameters.entrySet()) {
            String string2 = (String)entry.getKey();
            String config = this.sonyCameraSrv.readConfiguration(string2, readConfig);
            if (config == null || config.replaceAll(",", "%2C").equals(entry.getValue())) {
                parametersToRemove.add(string2);
            }
            readConfig = false;
        }
        for (String string3 : parametersToRemove) {
            parameters.remove(string3);
        }
        if (!parameters.isEmpty()) {
            StringBuilder url2 = new StringBuilder("/command/camera.cgi?");
            for (Map.Entry entry : parameters.entrySet()) {
                url2.append("&").append((String)entry.getKey()).append("=").append((String)entry.getValue());
            }
            try {
                String string4 = url2.toString().replace("?&", "?");
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)string4, (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
            }
            catch (SeeTecException seeTecException) {
                this.logger.error("Exception while setting image parameters for " + this + ": " + seeTecException.getMessage());
                return seeTecException.getErrorCode();
            }
        }
        HashMap<String, String> osdParameters = new HashMap<String, String>();
        String string5 = this.sonyCameraSrv.readOSDConfiguration("SiEnableImage" + this.streamNumber, true);
        String string6 = string = this.useTitle || this.useDateTime ? "on" : "off";
        if (!string5.equals(string)) {
            osdParameters.put("SiEnableImage" + this.streamNumber, string);
        }
        String currentSettingArea1 = this.sonyCameraSrv.readOSDConfiguration("SiFormatArea1Image" + this.streamNumber, false);
        String currentSettingArea2 = this.sonyCameraSrv.readOSDConfiguration("SiFormatArea2Image" + this.streamNumber, false);
        String string7 = area1Text = this.useTitle ? this.title.replace("+", "%20") : "";
        if (!currentSettingArea1.equals(area1Text)) {
            osdParameters.put("SiFormatArea1Image" + this.streamNumber, area1Text);
        }
        String string8 = area2Text = this.useDateTime ? "<datetime>" : "";
        if (!currentSettingArea2.equals(area2Text)) {
            osdParameters.put("SiFormatArea2Image" + this.streamNumber, area2Text);
        }
        if (!osdParameters.isEmpty()) {
            url = new StringBuilder("/command/superimpose.cgi?");
            for (Map.Entry entry : osdParameters.entrySet()) {
                ((StringBuilder)url).append("&").append((String)entry.getKey()).append("=").append((String)entry.getValue());
            }
            try {
                String parameterString = ((StringBuilder)url).toString().replace("?&", "?");
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)parameterString, (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while setting OSD parameters for " + this + ": " + ex.getMessage());
                return ex.getErrorCode();
            }
        }
        if (this.videoCodec == Codec.MJPEG) {
            url = "/image" + this.streamNumber;
            HttpServerPushHandler httpServerPushHandler = new HttpServerPushHandler();
            httpServerPushHandler.init(this, this.networkParameter, (String)url, 1024, "----myboundary".getBytes());
            httpServerPushHandler.startServerPush(true);
        } else {
            this.respectEveryParameterSet = true;
            this.enableDeliverPPSBeforePFrameIfAvailable = true;
            if (this.transmissionID == TransmissionType.HTTP) {
                if (this.isAudioEnabled) {
                    this.audioHandler = new AudioHandler();
                    this.audioHandlerThread = new Thread((Runnable)this.audioHandler, this.audioHandler.toString());
                    this.audioHandlerThread.start();
                }
                url = "/image" + this.streamNumber;
                this.httpStreamHandler = new HttpStreamHandler();
                this.errorCode = this.httpStreamHandler.init(this, this.networkParameter, (String)url);
                if (this.errorCode != 0) {
                    this.logger.error("Exception while initializing HTTP stream handler for " + this + " Error: " + this.errorCode);
                    return this.errorCode;
                }
                this.errorCode = this.httpStreamHandler.startStreaming(true, false);
                if (this.errorCode != 0) {
                    this.logger.error("Exception while starting HTTP reading for " + this + " Error: " + this.errorCode);
                    return this.errorCode;
                }
            } else {
                this.rtspUrl = "rtsp://" + this.getHost() + "/video" + this.streamNumber;
                this.rtspSettings = new RTSPStreamSettings();
                try {
                    if (this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, 15000, this.isAudioEnabled, 4, this.rtspUrl) != 0) {
                        this.logger.error("Error while initializing Settings for RTSP streaming for " + this);
                        return -20001;
                    }
                }
                catch (ConfigurationException ex) {
                    this.logger.warn("Could not initialize rtspSettings for " + this);
                    this.logger.warn((Object)ex, (Throwable)ex);
                }
                this.rtspSettings.setRange("npt=now-");
                this.rtspSettings.setTcpChannel(0);
                try {
                    this.rtspHandler = this.rtspSettings.getRTSPHandler();
                }
                catch (SeeTecException ex) {
                    this.logger.error("Exception while retrieving RTSP Handler for " + this + ": " + ex.getMessage());
                    return ex.getErrorCode();
                }
                if (this.rtspHandler.start() != 0) {
                    this.logger.error("Error while startint RTSP Handler for " + this);
                    return -20001;
                }
                this.publishRTSPUrl(this.rtspUrl);
            }
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.rtspHandler != null) {
            this.rtspHandler.shutdown();
            this.rtspHandler = null;
        }
        super.shutdown();
        this.logger.info("shutdown done for " + this.getVideoSrv());
        return 0;
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public void sendStatusService(int statusCode) {
        if (this.listener != null) {
            this.listener.sendStatusService(statusCode);
        } else {
            this.logger.error("Listener null for " + this);
        }
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21656);
        this.shutdown();
    }

    @Override
    public synchronized void deliverRawContent(byte[] rawHTTPContent) {
        try {
            if (rawHTTPContent != null && rawHTTPContent.length > 0) {
                int firstIndex;
                if (this.baos == null) {
                    this.baos = new ByteArrayOutputStream();
                }
                this.baos.write(rawHTTPContent);
                byte[] data = this.baos.toByteArray();
                this.baos.reset();
                while (true) {
                    firstIndex = Basic.indexOfByteArray((byte[])data, (byte[])StreamingHelper.START_SEQUENCE, (int)0, (boolean)true);
                    int secondIndex = Basic.indexOfByteArray((byte[])data, (byte[])StreamingHelper.START_SEQUENCE, (int)(firstIndex + StreamingHelper.START_SEQUENCE.length), (boolean)true);
                    if (firstIndex == -1 || secondIndex == -1) break;
                    this.deliverH264Data(Arrays.copyOfRange(data, firstIndex, secondIndex), true, Long.MIN_VALUE);
                    ByteArrayOutputStream tmp = new ByteArrayOutputStream();
                    tmp.write(data, 0, firstIndex);
                    tmp.write(data, secondIndex, data.length - secondIndex);
                    data = tmp.toByteArray();
                }
                if (firstIndex != -1) {
                    this.baos.write(data, firstIndex, data.length - firstIndex);
                    return;
                }
                this.baos.write(data);
                return;
            }
        }
        catch (Exception e) {
            this.logger.error("Content length: " + rawHTTPContent.length + " for " + this.getVideoSrv(), (Throwable)e);
            if (rawHTTPContent.length < 100) {
                this.logger.error("Content: " + Basic.byteArrayToHexString((byte[])rawHTTPContent, (int)0, (int)rawHTTPContent.length));
            }
            this.logger.error("Content: " + Basic.byteArrayToHexString((byte[])rawHTTPContent, (int)0, (int)100));
        }
    }

    @Override
    public void deliverContent(HttpServerPushContent httpServerPushContent) {
        try {
            MediaFrame mediaFrame = StreamingHelper.createSeeTecVideoFrameHeader(Codec.MJPEG, httpServerPushContent.getContentBody(), false);
            super.deliverFrameCreateServerTimestamp(0, mediaFrame);
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while creating video frame for " + this + " : " + ex.getMessage());
        }
    }

    private class AudioHandler
    implements HttpStreamListenerIntf,
    Runnable {
        private boolean isShutdown = true;
        private boolean headerRemoved;

        private AudioHandler() {
        }

        @Override
        public void run() {
            String url = "/audio";
            SonyVideoSourceClient_6thGen.this.httpStreamHandler = new HttpStreamHandler();
            if ((SonyVideoSourceClient_6thGen.this.errorCode = SonyVideoSourceClient_6thGen.this.httpStreamHandler.init(this, SonyVideoSourceClient_6thGen.this.networkParameter, url)) != 0) {
                SonyVideoSourceClient_6thGen.this.logger.error("Exception while initializing HTTP stream handler for " + this + " Error: " + SonyVideoSourceClient_6thGen.this.errorCode);
            }
            if ((SonyVideoSourceClient_6thGen.this.errorCode = SonyVideoSourceClient_6thGen.this.httpStreamHandler.startStreaming(true, false)) != 0) {
                SonyVideoSourceClient_6thGen.this.logger.error("Exception while starting HTTP reading for " + this + " Error: " + SonyVideoSourceClient_6thGen.this.errorCode);
            }
            this.isShutdown = false;
        }

        @Override
        public boolean isShutdown() {
            return this.isShutdown && SonyVideoSourceClient_6thGen.this.httpStreamHandler.isShutdown();
        }

        @Override
        public void deliverRawContent(byte[] data) {
            if (!this.headerRemoved && Basic.indexOfByteArray((byte[])data, (byte[])SSLConstantsIntf.DOUBLE_CRLF_BYTE, (int)0) != -1) {
                this.headerRemoved = true;
                return;
            }
            try {
                MediaFrame mediaFrame = StreamingHelper.createSeeTecAudioFrameHeader(SonyVideoSourceClient_6thGen.this.audioCodec, SonyVideoSourceClient_6thGen.this.audioBitrate % 8000 == 0 ? (int)(SonyVideoSourceClient_6thGen.this.audioBitrate / 8000) : 0, data);
                SonyVideoSourceClient_6thGen.this.deliverFrameCreateServerTimestamp(16, mediaFrame);
            }
            catch (Throwable t) {
                SonyVideoSourceClient_6thGen.this.logger.error("Ignoring packet due to unexpected error: " + t.getMessage(), t);
            }
        }

        @Override
        public void notifyForNetworkProblems() {
            this.sendStatusService(-21656);
            SonyVideoSourceClient_6thGen.this.listener.notifyForNetworkProblems();
            this.shutdown();
        }

        @Override
        public void sendStatusService(int statusCode) {
            SonyVideoSourceClient_6thGen.this.listener.sendStatusService(statusCode);
        }

        private void shutdown() {
            if (SonyVideoSourceClient_6thGen.this.httpStreamHandler != null) {
                SonyVideoSourceClient_6thGen.this.httpStreamHandler.shutdown();
                SonyVideoSourceClient_6thGen.this.httpStreamHandler = null;
            }
            this.isShutdown = true;
        }
    }
}

