/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.sony;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.sony.SonyDevice;
import de.seetec.v5.re.cm.device.video.sony.SonyIOHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;

public class SonyIOHandler_5thGen
extends SonyIOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.sony.SonyIOHandler_5thGen";
    private boolean useContentLength = true;
    private SonyDevice sonyDevice = null;

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            while (!(this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device.isShutdown())) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.checkDigitalInputs();
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        this.logger.info("Thread of this " + this + " finished :-)");
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    private void checkDigitalInputs() {
        int errorCode = 0;
        int[] inputValues = new int[super.getHighestInputNumber()];
        errorCode = this.readDigitalInputs(inputValues);
        if (errorCode != 0) {
            this.logger.warn("Reading inputs failed with error [" + errorCode + "]");
            return;
        }
        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
        for (int i = 0; i < iServices.length; ++i) {
            iServices[i].checkInput(inputValues);
        }
    }

    private int readDigitalInputs(int[] inputs) {
        int errorCode = 0;
        try {
            String url = "/command/inquiry.cgi?inq=sensor";
            byte[] result = this.useContentLength ? NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)true) : NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)275);
            String sResult = new String(result);
            if (!sResult.toLowerCase().contains("content-length")) {
                this.useContentLength = false;
            }
            for (int i = 1; i <= inputs.length; ++i) {
                inputs[i - 1] = sResult.toLowerCase().contains("sensor" + i + "=1") ? 1 : 0;
            }
            return errorCode;
        }
        catch (SeeTecException ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            return ex.getErrorCode();
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int writeDigitalOutput(int number, int value, long holdTime) {
        try {
            IOHandler.HoldTimer holdTimer;
            int errorCode;
            if (this.sonyDevice == null) {
                this.sonyDevice = (SonyDevice)this.device;
            }
            String enableAlarms = "/command/alarmout.cgi?AlarmOut" + number + "Func=on&Ao" + number + "ManualFunc=on";
            if (this.sonyDevice.getSonyGeneration() > 5) {
                enableAlarms = enableAlarms + "&AlarmOutFuncAo" + number + "=on";
            }
            if (NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)enableAlarms, (int)Integer.MIN_VALUE) == null) {
                this.logger.error("Could not set alarm output to on.");
            }
            String url = "/command/main.cgi?Trigger=alarmout" + number + (value == 0 ? "off" : "on");
            if (this.sonyDevice.getSonyGeneration() > 5) {
                url = "/command/trigger.cgi?Alarmout" + number + (value == 0 ? "=off" : "=on");
            }
            int wantedLength = 32;
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)wantedLength);
            if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(number, value > 0 ? 0 : 1, holdTime)) != 0) {
                holdTimer.shutdown();
                this.logger.warn("Creating " + holdTimer + " failed with error [" + errorCode + "] :-(");
            }
            return 0;
        }
        catch (SeeTecException sex) {
            this.logger.error((Object)sex, (Throwable)sex);
            return sex.getErrorCode();
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }
}

