/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.siqura.onvif;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerIntf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPResponse;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.videoprofile.AdditionalVideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videoprofile.BasicVideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.siqura.SiquraDevice;
import de.seetec.v5.re.cm.device.video.siqura.SiquraIOHandler;
import de.seetec.v5.re.cm.device.video.siqura.SiquraOnvifHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.siqura.SiquraOnvifMotionDetectionHandler;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.Reader;
import java.io.StringReader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.onvif.ver10.media.wsdl.Media;
import org.onvif.ver10.schema.AudioEncoderConfiguration;
import org.onvif.ver10.schema.AudioEncoding;
import org.onvif.ver10.schema.Profile;

public class SiquraOnvifVideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.siqura.mpeg.SiquraOnvifVideoSourceClient";
    private MDHandler mdHandler = null;

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public void sendStatusService(int errorCode) {
        this.listener.sendStatusService(errorCode);
    }

    @Override
    public int init() {
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        try {
            SiquraDevice siquraDevice = (SiquraDevice)this.getVideoSrv().getDevice();
            OnvifCore onvifCore = siquraDevice.getOnvifCore();
            String profileToken = "";
            if (this.listener instanceof BasicVideoProfileHandler) {
                profileToken = "Profile1";
                this.logger.info("BasicVideoProfileHandler");
            } else if (this.listener instanceof AdditionalVideoProfileHandler) {
                profileToken = "Profile2";
                this.logger.info("AdditionalVideoProfileHandler");
            }
            this.logger.info(profileToken + " will be used!");
            Media mediaService = onvifCore.getMediaService().getOnvifMediaService();
            Profile profile = mediaService.getProfile(profileToken);
            String streamUri = "";
            if (this.listener instanceof BasicVideoProfileHandler) {
                streamUri = this.videoCodec == Codec.H264 ? "rtsp://" + this.getHost() + "/h264" : "rtsp://" + this.getHost() + "/jpeg";
            }
            if (this.listener instanceof AdditionalVideoProfileHandler) {
                streamUri = this.videoCodec == Codec.H264 ? "rtsp://" + this.getHost() + "/h264_2" : "rtsp://" + this.getHost() + "/jpeg";
            }
            this.logger.info("streamUri: " + streamUri);
            this.rtspUrl = streamUri;
            try {
                if (this.isAudioEnabled) {
                    AudioEncoding audioEncoding = null;
                    if (this.audioCodec == Codec.G711U) {
                        this.audioCodec = Codec.G711A;
                        audioEncoding = AudioEncoding.G_711;
                    } else if (this.audioCodec == Codec.G726) {
                        audioEncoding = AudioEncoding.G_726;
                    }
                    if (profile.getAudioSourceConfiguration() == null) {
                        mediaService.addAudioSourceConfiguration(profileToken, "AudioSource1");
                    }
                    if (profile.getAudioEncoderConfiguration() == null) {
                        mediaService.addAudioEncoderConfiguration(profileToken, "AudioEncoder1");
                    }
                    AudioEncoderConfiguration audioEncoderConfiguration = profile.getAudioEncoderConfiguration();
                    audioEncoderConfiguration.setEncoding(audioEncoding);
                    if (audioEncoding == AudioEncoding.G_711) {
                        audioEncoderConfiguration.setBitrate(40000);
                        audioEncoderConfiguration.setSampleRate(16000);
                    } else if (audioEncoding == AudioEncoding.G_726) {
                        audioEncoderConfiguration.setBitrate(32000);
                        audioEncoderConfiguration.setSampleRate(8000);
                    }
                    mediaService.setAudioEncoderConfiguration(audioEncoderConfiguration, true);
                } else {
                    if (profile.getAudioSourceConfiguration() != null) {
                        mediaService.removeAudioSourceConfiguration(profileToken);
                    }
                    if (profile.getAudioEncoderConfiguration() != null) {
                        mediaService.removeAudioEncoderConfiguration(profileToken);
                    }
                }
            }
            catch (Exception exception) {
                this.logger.info((Object)exception);
                this.isAudioEnabled = false;
            }
        }
        catch (Exception exception) {
            this.logger.info(exception.getMessage() + this);
        }
        this.rtspSettings = new RTSPStreamSettings();
        try {
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 4, "*");
            if (this.errorCode != 0) {
                this.logger.error("Initialization of RTSPSettings failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Could not initialize rtspSettings for " + this);
            this.logger.warn((Object)ex, (Throwable)ex);
        }
        boolean mdActivated = this.getVideoSrv().getHardwareMotionDetection() != null;
        DigitalInputSrv[] digitalInputSrvs = ((SiquraIOHandler)this.getVideoSrv().getDevice().getIOHandler()).getDigitalInputSrv();
        if (mdActivated || digitalInputSrvs.length > 0) {
            this.logger.info("MD enabled for " + this.getVideoSrv());
            this.mdHandler = new MDHandler(this);
            this.rtspSettings.enableMetadata(this.mdHandler);
            this.rtspSettings.setMetadataTimeout(this.networkParameter.getSoTimeout());
        }
        this.rtspSettings.setKeepAliveInterval(3000);
        try {
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while initializing RTSP Handler : " + ex.getMessage() + " for " + this.getVideoSrv());
            return ex.getErrorCode();
        }
        this.errorCode = this.rtspHandler.start();
        if (this.errorCode != 0) {
            this.logger.error("Start of RTSPHandler failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
            return this.errorCode;
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.mdHandler != null) {
            this.mdHandler.shutdown();
            this.mdHandler = null;
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    private class MDHandler
    implements RTSPHandlerIntf {
        SiquraOnvifVideoSourceClient daddy = null;

        public MDHandler(SiquraOnvifVideoSourceClient daddy) {
            this.daddy = daddy;
        }

        @Override
        public void onNetworkError(int error) {
            if (this.daddy != null) {
                this.daddy.onNetworkError(error);
            }
        }

        @Override
        public void processData(byte[] data) {
            boolean offset = false;
            if (data[1] != -56) {
                String content = new String(data, 12, data.length - 12);
                int intValue = 0;
                boolean booleanValue = false;
                try {
                    SiquraOnvifHardwareMotionDetection siquraOnvifHardwareMotionDetection;
                    SAXBuilder parser = new SAXBuilder();
                    Document document = parser.build((Reader)new StringReader(content.trim()));
                    Element rootElement = document.getRootElement();
                    Namespace namespaceTT = Namespace.getNamespace((String)"tt", (String)"http://www.onvif.org/ver10/schema");
                    Namespace namespaceWSNT = Namespace.getNamespace((String)"wsnt", (String)"http://docs.oasis-open.org/wsn/b-2");
                    Element messageElement = rootElement.getChild("Event", namespaceTT).getChild("NotificationMessage", namespaceWSNT).getChild("Message", namespaceWSNT).getChild("Message", namespaceTT);
                    if (messageElement.getChild("Source", namespaceTT).getChild("SimpleItem", namespaceTT).getAttribute("Name").getValue().equals("VideoSourceConfigurationToken") && (intValue = messageElement.getChild("Data", namespaceTT).getChild("SimpleItem", namespaceTT).getAttribute("Value").getIntValue()) > 0 && (siquraOnvifHardwareMotionDetection = (SiquraOnvifHardwareMotionDetection)SiquraOnvifVideoSourceClient.this.getVideoSrv().getHardwareMotionDetection()) != null && siquraOnvifHardwareMotionDetection.getMotionDetectionHandler() != null) {
                        ((SiquraOnvifMotionDetectionHandler)((Object)siquraOnvifHardwareMotionDetection.getMotionDetectionHandler())).processMotionDetection(0);
                    }
                    if (messageElement.getChild("Source", namespaceTT).getChild("SimpleItem", namespaceTT).getAttribute("Name").getValue().equals("RelayToken")) {
                        booleanValue = messageElement.getChild("Data", namespaceTT).getChild("SimpleItem", namespaceTT).getAttribute("Value").getBooleanValue();
                        SiquraDevice siquraDevice = (SiquraDevice)SiquraOnvifVideoSourceClient.this.getVideoSrv().getDevice();
                        SiquraIOHandler siquraIOHandler = (SiquraIOHandler)siquraDevice.getIOHandler();
                        siquraIOHandler.setAlarm(booleanValue);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void shutdown() {
            this.daddy = null;
        }

        @Override
        public void sendStatusService(int errorCode) {
            SiquraOnvifVideoSourceClient.this.listener.sendStatusService(errorCode);
        }

        @Override
        public void sendDescribeResponse(RTSPResponse response) {
        }

        @Override
        public void setSSRCfromRTSP(String ssrc) {
        }
    }
}

