/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.siqura.mpeg;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.siqura.SiquraCameraSrv;
import de.seetec.v5.re.cm.device.video.siqura.SiquraDevice;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class SiquraH264VideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.siqura.mpeg.SiquraH264VideoSourceClient";
    private SiquraDevice siquraDevice;
    private int sourceNumber;
    private int encoderNumber;
    private int frameRateDivider;
    private long entityID;
    private int h264StreamNumber = 1;
    private int videoSystem;
    private float maximalFramerate;
    private double framerate;

    @Override
    public int init() {
        try {
            try {
                this.networkParameter.setSoTimeout(5000);
                if (this.siquraDevice == null) {
                    this.siquraDevice = (SiquraDevice)((SiquraCameraSrv)this.getVideoSrv()).getDevice();
                }
                try {
                    this.siquraDevice.testCredentials(this.networkParameter);
                }
                catch (SeeTecException ex) {
                    this.logger.error("Exception while testing connectivity for " + this + ": " + ex.getMessage());
                    this.shutdown();
                    return -21657;
                }
                SiquraCameraSrv siquraCameraSrv = (SiquraCameraSrv)this.getVideoSrv();
                this.sourceNumber = this.listener.getVideoSourceParameter().getServerEntryNo();
                StringBuffer url = null;
                Object result = null;
                this.errorCode = super.init();
                if (this.errorCode != 0) {
                    this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this.getVideoSrv());
                    return this.errorCode;
                }
                if (!this.siquraDevice.isGlobalParametersSet()) {
                    this.siquraDevice.setGlobalParameters(this.sourceNumber, this.useDateTime, this.useTitle, this.title);
                }
                this.entityID = super.getVideoSrv().getDevice().getDeviceType();
                if (this.entityID == 203200L || this.entityID == 203202L) {
                    this.encoderNumber = 4;
                } else if (this.entityID == 203201L || this.entityID == 203206L) {
                    this.encoderNumber = this.h264StreamNumber = siquraCameraSrv.getH264StreamNumber(this.listener);
                }
                this.videoSystem = this.siquraDevice.getVideoSystem(this.sourceNumber);
                this.resolutionTag = this.siquraDevice.getResolutionTag(this.width, this.height, this.videoSystem);
                if (this.resolutionTag == null) {
                    this.logger.error("Resolution " + this.width + " x " + this.height + " not supported for " + this.getVideoSrv());
                    return -21655;
                }
                this.iFrameDist = Tools.convertIFrameDistMStoFrameCount(this.fps, this.iFrameDistMS, 1, 255);
                this.quality /= 1000;
                this.quality = this.quality < 1 ? 1 : this.quality;
                this.maximalFramerate = this.siquraDevice.getMaximalFramerate(this.videoSystem, Codec.H264, this.encoderNumber, this.sourceNumber);
                this.framerate = (double)this.fps / 1000.0;
                this.frameRateDivider = (int)((double)this.maximalFramerate / this.framerate + 0.5);
                this.bandwidth /= 1024;
                this.bandwidth = this.bandwidth < 10 ? 10 : this.bandwidth;
                this.bandwidth = this.bandwidth > 6000 ? 6000 : this.bandwidth;
                url = new StringBuffer("/params/set.cgi?");
                url.append("Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".Enable=True");
                url.append("&Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".FrameRateDivider=").append(this.frameRateDivider);
                url.append("&Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".Resolution=").append(this.resolutionTag);
                url.append("&Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".GopLength=").append(this.iFrameDist);
                if (this.isConstantBitrateUsed) {
                    url.append("&Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".BitRateMode=Constant%20bitrate");
                    url.append("&Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".BitRate=").append(this.bandwidth);
                } else {
                    url.append("&Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".BitRateMode=Constant%20quality");
                    url.append("&Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".CqmQuality=").append(this.quality);
                }
                url.append("&Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".Tx-1.RtpControlMode=Floodguard");
                url.append("&Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".Enable=True");
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE);
                if (this.isAudioEnabled) {
                    this.logger.info("Audio Parameter: " + this.audioCodec + " with " + this.audioBitrate + "bit for " + this.getVideoSrv().getDevice());
                    url = new StringBuffer("/params/set.cgi?");
                    url.append("Audio-1.Input-").append(this.sourceNumber).append(".Enable=True");
                    url.append("&Audio-1.Encoder-1.AudioFormat=");
                    if (this.audioCodec == Codec.G711U) {
                        url.append("u-law%208bit");
                    } else if (this.audioCodec == Codec.PCM) {
                        url.append("PCM%2016bit");
                    } else {
                        this.logger.error("Unknown audio encoding type: " + this.audioCodec + " for " + this.getVideoSrv().getDevice());
                        return -21601;
                    }
                    try {
                        NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE);
                    }
                    catch (SeeTecException e) {
                        this.logger.error("Exception while setting Audio association for " + this.getVideoSrv(), (Throwable)e);
                        return e.getErrorCode();
                    }
                }
                this.rtspUrl = "rtsp://" + this.getHost() + "/VideoInput/" + this.videoSourceNr + "/h264/" + this.h264StreamNumber;
                this.rtspSettings = new RTSPStreamSettings();
                this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 2, this.rtspUrl);
                if (this.errorCode != 0) {
                    this.logger.error("Initialization of RTSPSettings failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                    return this.errorCode;
                }
                int[] res = new int[]{this.width, this.height};
                this.rtspSettings.setCheckResolution(true, res);
                this.rtspHandler = this.rtspSettings.getRTSPHandler();
                this.errorCode = this.rtspHandler.start();
                if (this.errorCode != 0) {
                    this.logger.error("Start of RTSPHandler failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                    return this.errorCode;
                }
                this.logger.info("init done for" + this.getVideoSrv());
                return 0;
            }
            catch (ConfigurationException ex) {
                this.logger.error("Exception occured while setting camera parameters for " + this + ": " + ex.getMessage());
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception occured while setting camera parameters for " + this + ": " + ex.getMessage());
                return ex.getErrorCode();
            }
            return 0;
        }
        catch (Throwable t) {
            this.logger.error("Unexpected exception while initialization for " + this, t);
            return -20000;
        }
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public void notifyForNetworkProblems() {
        this.logger.error("Network problem from HTTPStreamHandler signalied. Shutting down.");
        this.shutdown();
    }

    @Override
    public void sendStatusService(int statusCode) {
        this.listener.sendStatusService(statusCode);
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }
}

