/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.siqura.jpeg;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.siqura.SiquraDevice;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;

public class SiquraJPEGVideoSourceClientRTSP
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.siqura.jpeg.SiquraJPEGVideoSourceClientRTSP";
    private SiquraDevice siquraDevice;
    private String resolutionTag;
    private int sourceNumber;
    private int frameRateDivider;
    private int encoderNumber;
    private int quality;
    private int videoSystem;
    private float maximalFramerate;

    @Override
    public int init() {
        int errorCode = 0;
        errorCode = super.init();
        if (errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + errorCode + " for " + this);
            return errorCode;
        }
        if (this.siquraDevice == null) {
            this.siquraDevice = (SiquraDevice)this.getVideoSrv().getDevice();
        }
        try {
            this.siquraDevice.testCredentials(this.networkParameter);
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while testing connectivity for " + this + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        try {
            StringBuilder url = new StringBuilder(256);
            this.sourceNumber = this.listener.getVideoSourceParameter().getServerEntryNo();
            this.fps = (int)((this.fps + 999L) / 1000L);
            this.quality = 100 - (this.quality + 999) / 1000;
            this.quality = this.quality < 1 ? 1 : this.quality;
            this.quality = this.quality > 100 ? 100 : this.quality;
            this.encoderNumber = 1;
            this.videoSystem = this.siquraDevice.getVideoSystem(this.sourceNumber);
            this.resolutionTag = this.siquraDevice.getResolutionTag(this.width, this.height, this.videoSystem);
            if (this.resolutionTag == null) {
                this.logger.error("Resolution " + this.width + " x " + this.height + "not supported for " + this);
                this.shutdown();
            }
            if (!this.siquraDevice.isGlobalParametersSet()) {
                this.siquraDevice.setGlobalParameters(this.sourceNumber, this.useDateTime, this.useTitle, this.title);
            }
            this.maximalFramerate = this.siquraDevice.getMaximalFramerate(this.videoSystem, Codec.MJPEG, this.encoderNumber, this.sourceNumber);
            this.frameRateDivider = (int)((double)(this.maximalFramerate / (float)this.fps) + 0.5);
            url.append("/params/set.cgi?");
            url.append("Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".Enable=True");
            url.append("&Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".FrameRateDivider=").append(this.frameRateDivider);
            url.append("&Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".Quality=").append(this.quality);
            url.append("&Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".Resolution=").append(this.resolutionTag);
            url.append("&Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".Enable=True");
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE);
            this.rtspUrl = "rtsp://" + this.getHost() + "/videoinput/" + this.videoSourceNr + "/mjpeg/" + this.encoderNumber;
            this.rtspSettings = new RTSPStreamSettings();
            errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 2, this.rtspUrl);
            if (errorCode != 0) {
                this.logger.error("Initialization of RTSPSettings failed with errorCode: " + errorCode + " for " + this.getVideoSrv());
                return errorCode;
            }
            int[] res = new int[]{this.width, this.height};
            this.rtspSettings.setCheckResolution(true, res);
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            errorCode = this.rtspHandler.start();
            if (errorCode != 0) {
                this.logger.error("Start of RTSPHandler failed with errorCode: " + errorCode + " for " + this.getVideoSrv());
                return errorCode;
            }
            this.logger.info("init done for" + this.getVideoSrv());
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error("Trouble with JPEGServerPushStream of " + super.getVideoSrv());
            this.logger.error((Object)ex, ex);
            return errorCode;
        }
    }

    public int setFramerate(double fps) {
        fps /= 1000.0;
        int errorCode = 0;
        try {
            this.frameRateDivider = (int)((double)this.maximalFramerate / fps + 0.5);
            String url = "/params/set.cgi?Video-" + this.sourceNumber + ".Encoder-" + this.encoderNumber + ".FramerateDivider=" + this.frameRateDivider;
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE);
        }
        catch (Exception ex) {
            this.logger.error("Exception while setting new framerate for " + this + ": " + ex.getMessage());
            errorCode = -20100;
        }
        return errorCode;
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public void sendStatusService(int statusCode) {
        this.listener.sendStatusService(statusCode);
    }
}

