/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.siqura.jpeg;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.siqura.SiquraDevice;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;

public class SiquraJPEGVideoSourceClient
extends JPEGVideoSourceClient
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.siqura.jpeg.SiquraJPEGVideoSourceClient";
    private SiquraDevice siquraDevice;
    private int fps;
    private String resolutionTag;
    private int sourceNumber;
    private int frameRateDivider;
    private int encoderNumber;
    private int quality;
    private String serverPushURL;
    private int videoSystem;
    private float maximalFramerate;

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    @Override
    public int init() {
        int errorCode = 0;
        errorCode = super.init(false);
        if (errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + errorCode + " for " + this);
            return errorCode;
        }
        if (this.siquraDevice == null) {
            this.siquraDevice = (SiquraDevice)this.getVideoSrv().getDevice();
        }
        try {
            this.siquraDevice.testCredentials(this.networkParameter);
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while testing connectivity for " + this + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        try {
            StringBuilder url = new StringBuilder(256);
            this.sourceNumber = this.listener.getVideoSourceParameter().getServerEntryNo();
            this.fps = (int)((this.highestFramerate + 999L) / 1000L);
            this.quality = 100 - (this.quality + 999) / 1000;
            this.quality = this.quality < 1 ? 1 : this.quality;
            this.quality = this.quality > 100 ? 100 : this.quality;
            long entityID = super.getVideoSrv().getDevice().getDeviceType();
            this.encoderNumber = entityID == 203201L || entityID == 203200L ? 3 : 1;
            this.videoSystem = this.siquraDevice.getVideoSystem(this.sourceNumber);
            this.resolutionTag = this.siquraDevice.getResolutionTag(this.width, this.height, this.videoSystem);
            if (this.resolutionTag == null) {
                this.logger.error("Resolution " + this.width + " x " + this.height + "not supported for " + this);
                this.shutdown();
            }
            if (!this.siquraDevice.isGlobalParametersSet()) {
                this.siquraDevice.setGlobalParameters(this.sourceNumber, this.useDateTime, this.useTitle, this.title);
            }
            this.maximalFramerate = this.siquraDevice.getMaximalFramerate(this.videoSystem, Codec.MJPEG, this.encoderNumber, this.sourceNumber);
            this.frameRateDivider = (int)((double)(this.maximalFramerate / (float)this.fps) + 0.5);
            url.append("/params/set.cgi?");
            url.append("Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".Enable=True");
            url.append("&Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".FrameRateDivider=").append(this.frameRateDivider);
            url.append("&Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".Quality=").append(this.quality);
            url.append("&Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".Resolution=").append(this.resolutionTag);
            url.append("&Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".Enable=True");
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE);
        }
        catch (Throwable ex) {
            this.logger.error("Trouble with JPEGServerPushStream of " + super.getVideoSrv());
            this.logger.error((Object)ex, ex);
        }
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
        return errorCode;
    }

    @Override
    public void run() {
        int errorCode = 0;
        HttpServerPushHandler httpServerPushHandler = null;
        super.setRunFinished(CLASS_NAME, false);
        this.networkParameter.setSoTimeout(5000);
        boolean asynchronous = false;
        httpServerPushHandler = new HttpServerPushHandler();
        this.serverPushURL = "/mjpeg/video" + this.sourceNumber + ".jpg";
        errorCode = httpServerPushHandler.init(this, this.networkParameter, this.serverPushURL);
        if (errorCode != 0) {
            this.logger.error("Error [ " + errorCode + " ]with " + httpServerPushHandler);
        } else {
            errorCode = httpServerPushHandler.startServerPush(asynchronous);
            if (errorCode != 0) {
                this.logger.warn("ServerPush of " + httpServerPushHandler + " terminated with error [ " + errorCode + " ]");
            }
        }
        httpServerPushHandler.shutdown();
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        this.listener.sendStatusService(nStatusCode);
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        this.shutdown();
    }

    public int setFramerate(double fps) {
        fps /= 1000.0;
        int errorCode = 0;
        try {
            this.frameRateDivider = (int)((double)this.maximalFramerate / fps + 0.5);
            String url = "/params/set.cgi?Video-" + this.sourceNumber + ".Encoder-" + this.encoderNumber + ".FramerateDivider=" + this.frameRateDivider;
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE);
        }
        catch (Exception ex) {
            this.logger.error("Exception while setting new framerate for " + this + ": " + ex.getMessage());
            errorCode = -20100;
        }
        return errorCode;
    }
}

