/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.siqura;

import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifDevice;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifException;
import de.seetec.v5.re.cm.device.video.siqura.SiquraIOHandler;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class SiquraDevice
extends VideoServer {
    private String firmwareVersion = null;
    private byte[] result = null;
    private int errorCode;
    private NetworkParameter networkParameter;
    private boolean globalParametersSet = false;
    private boolean credentialsTested = false;
    private static final int PAL = 1;
    private static final int NTSC = 2;
    private OnvifCore onvifCore = null;

    @Override
    public int initializeDevice(long nSrvType) {
        block10: {
            super.initializeDevice(nSrvType);
            if (this.isOnvifDevice()) {
                try {
                    if (this.networkParameter == null) {
                        this.networkParameter = this.getDeviceCnf().getNetworkParameter();
                    }
                    if (this.networkParameter == null) break block10;
                    if (this.onvifCore == null) {
                        this.onvifCore = new OnvifCore();
                    }
                    String user = null;
                    if (this.networkParameter.getUserPWD() != null && this.networkParameter.getUserPWD()[0] != null) {
                        user = this.networkParameter.getUserPWD()[0];
                    }
                    String pw = null;
                    if (this.networkParameter.getUserPWD() != null && this.networkParameter.getUserPWD()[1] != null) {
                        pw = this.networkParameter.getUserPWD()[1];
                    }
                    boolean useAuthorization = false;
                    if (user != null && pw != null) {
                        useAuthorization = true;
                    }
                    OnvifDevice onvifDevice = new OnvifDevice(this.getDeviceEntity().getEntityName(), this.networkParameter, user, pw, "PasswordDigest", useAuthorization);
                    try {
                        this.onvifCore.init(onvifDevice, this.logger.isDebugEnabled());
                    }
                    catch (OnvifException onvifException) {
                        this.onvifCore.shutdown();
                        this.errorCode = onvifException.getErrorCode();
                        this.logger.error(onvifException.getCause().getMessage());
                        return this.errorCode;
                    }
                }
                catch (ConfigurationException exception) {
                    this.logger.info((Object)exception);
                }
            }
        }
        return 0;
    }

    @Override
    protected IOHandler createIOHandler() {
        return new SiquraIOHandler();
    }

    @Override
    protected boolean isSupportingIO() {
        return true;
    }

    @Override
    public String getFirmwareVersion() {
        if (this.firmwareVersion == null) {
            this.firmwareVersion = this.determineFirmwareVersion();
        }
        return this.firmwareVersion;
    }

    private String determineFirmwareVersion() {
        try {
            String url = "/params/get.cgi?General.ProductVersion";
            this.result = NetworkHelper.readGetRequest((NetworkParameter)this.getDeviceCnf().getNetworkParameter(), (String)url, (int)Integer.MAX_VALUE);
            if (this.result == null) {
                this.logger.error("Could not read firmware version from " + this);
            } else {
                String[] firmwareLines = new String(this.result).split("=");
                if (firmwareLines.length == 2) {
                    return firmwareLines[1];
                }
            }
        }
        catch (ConfigurationException ex) {
            this.logger.error("Configuration exception while reading firmware version of " + this + ": " + ex.getMessage());
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while reading firmware version of " + this + ": " + ex.getMessage());
        }
        return "<unknown>";
    }

    public String getResolutionTag(int width, int height, int videoSystem) {
        String resolution = null;
        if (videoSystem == 1) {
            if (width == 1920 && height == 1080) {
                resolution = "1080p";
            } else if (width == 1280 && height == 960) {
                resolution = "QUADVGA";
            } else if (width == 1280 && height == 1024) {
                resolution = "SXGA";
            } else if (width == 1280 && height == 720) {
                resolution = "720p";
            } else if (width == 720) {
                resolution = height == 288 ? "2CIF" : "D1";
            } else if (width == 640) {
                resolution = "VGA";
            } else if (width == 480) {
                resolution = "2/3%20D1";
            } else if (width == 320) {
                resolution = "QVGA";
            } else if (width == 352) {
                if (height == 576) {
                    resolution = "1/2%20D1";
                } else if (height == 288) {
                    resolution = "CIF";
                }
            } else if (width == 176) {
                resolution = "QCIF";
            }
        } else {
            width = width == 576 ? 480 : width;
            height = height == 576 ? 480 : height;
            width = width == 288 ? 240 : width;
            height = height == 288 ? 240 : height;
            int n = width = width == 144 ? 128 : width;
            if (width == 1920 && height == 1080) {
                resolution = "1080p";
            } else if (width == 1280 && height == 960) {
                resolution = "QUADVGA";
            } else if (width == 1280 && height == 1024) {
                resolution = "SXGA";
            } else if (width == 1280 && height == 720) {
                resolution = "720p";
            } else if (width == 720) {
                resolution = height == 240 ? "2CIF" : "D1";
            } else if (width == 640) {
                resolution = "VGA";
            } else if (width == 480) {
                resolution = "2/3%20D1";
            } else if (width == 320) {
                resolution = "QVGA";
            } else if (width == 352) {
                if (height == 480) {
                    resolution = "1/2%20D1";
                } else if (height == 240) {
                    resolution = "CIF";
                }
            } else if (width == 176) {
                resolution = "QCIF";
            }
        }
        return resolution;
    }

    public int getVideoSystem(int sourceNumber) throws SeeTecException, ConfigurationException {
        this.result = NetworkHelper.readGetRequest((NetworkParameter)this.getDeviceCnf().getNetworkParameter(), (String)("/params/get.cgi?Video-" + sourceNumber + ".Input-1.ActualVideoStandard"), (int)Integer.MAX_VALUE);
        if (this.result == null) {
            throw new SeeTecException(-20100, "Could not connect to encoder");
        }
        String resultString = new String(this.result);
        if (resultString.toLowerCase().indexOf("unauthorized") != -1) {
            throw new SeeTecException(-21657, "Authentication failed");
        }
        String[] videoStandards = resultString.split("=");
        if (videoStandards.length > 0 && videoStandards[1].toLowerCase().indexOf("ntsc") != -1) {
            return 2;
        }
        return 1;
    }

    public float getMaximalFramerate(int videoSystem, Codec codec, int encoderNumber, int videoSource) {
        if (this.getDeviceType() == 203200L || this.getDeviceType() == 203206L) {
            if (videoSystem == 2) {
                return 30.0f;
            }
            return 25.0f;
        }
        if (this.getDeviceType() == 203202L) {
            if (codec == Codec.MJPEG) {
                return 3.13f;
            }
            if (videoSystem == 2) {
                return 30.0f;
            }
            return 25.0f;
        }
        if (this.getDeviceType() == 203201L) {
            if (codec == Codec.MJPEG) {
                return 6.25f;
            }
            if (videoSystem == 2) {
                return 30.0f;
            }
            return 25.0f;
        }
        if (videoSystem == 2) {
            return 30.0f;
        }
        return 25.0f;
    }

    public int testCredentials(NetworkParameter networkParameter) throws SeeTecException {
        if (!this.credentialsTested) {
            String testUrl = "/frame.html";
            this.result = NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)testUrl, (int)Integer.MAX_VALUE);
            if (this.result == null) {
                this.logger.error("Error connecting to camera for " + this);
                return -20100;
            }
            if (new String(this.result).toLowerCase().indexOf("unauthorized") != -1) {
                this.logger.error("Wrong Authentication data for " + this);
                return -21657;
            }
        }
        this.credentialsTested = true;
        return 0;
    }

    public int setGlobalParameters(int videoSourceNumber, boolean useDateTime, boolean useTitle, String title) throws ConfigurationException, SeeTecException {
        this.errorCode = 0;
        StringBuilder url = new StringBuilder("/params/set.cgi?");
        if (useTitle && title != null) {
            title = title.replace("+", "%20");
            url.append("&Video-").append(videoSourceNumber).append(".Osd-1.Enable=True");
            url.append("&Video-").append(videoSourceNumber).append(".Osd-1.Alignment=Top%20left");
            url.append("&Video-").append(videoSourceNumber).append(".Osd-1.Text=").append(title);
        } else {
            url.append("&Video-").append(videoSourceNumber).append(".Osd-1.Enable=False");
        }
        if (useDateTime) {
            url.append("&Video-").append(videoSourceNumber).append(".Osd-2.Enable=True");
            url.append("&Video-").append(videoSourceNumber).append(".Osd-2.Alignment=Bottom%20left");
            url.append("&Video-").append(videoSourceNumber).append(".Osd-2.Text=DT(%25Y-%25m-%25d%20%25H:%25M:%25S)");
        } else {
            url.append("&Video-").append(videoSourceNumber).append(".Osd-2.Enable=False");
        }
        this.networkParameter = this.getDeviceCnf().getNetworkParameter();
        String urlString = url.toString().trim();
        urlString = urlString.replace("?&", "?");
        this.result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)urlString, (int)Integer.MAX_VALUE);
        if (this.result == null) {
            throw new SeeTecException(-20100, "Could not set On Screen Display for " + this);
        }
        String resultString = new String(this.result);
        if (resultString.toLowerCase().indexOf("unauthorized") != -1) {
            throw new SeeTecException(-21657, "Error using authorization");
        }
        this.logger.info("Firmware version for " + this + ": " + this.getFirmwareVersion());
        this.globalParametersSet = true;
        return this.errorCode;
    }

    public boolean isGlobalParametersSet() {
        return this.globalParametersSet;
    }

    public static int getNTSC() {
        return 2;
    }

    public static int getPAL() {
        return 1;
    }

    public final OnvifCore getOnvifCore() {
        if (this.onvifCore != null) {
            return this.onvifCore;
        }
        return null;
    }

    public final boolean isOnvifDevice() {
        long deviceType = this.getDeviceType();
        return deviceType == 203203L || deviceType == 203204L || deviceType == 203205L;
    }

    boolean hasAuxOutput() {
        long deviceType = this.getDeviceType();
        return deviceType == 203206L;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        return null;
    }
}

