/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.siqura;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetectionCnf;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.siqura.SiquraCameraControl;
import de.seetec.v5.re.cm.device.video.siqura.SiquraDevice;
import de.seetec.v5.re.cm.device.video.siqura.SiquraHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.siqura.SiquraHardwareMotionDetectionCnf;
import de.seetec.v5.re.cm.device.video.siqura.jpeg.SiquraJPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.siqura.jpeg.SiquraJPEGVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.siqura.mpeg.SiquraH264VideoSourceClient;
import de.seetec.v5.re.cm.device.video.siqura.onvif.SiquraOnvifVideoSourceClient;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.HashMap;
import java.util.Map;

public class SiquraCameraSrv
extends LiveCameraSrv {
    private int preparationError = 0;
    private SiquraHardwareMotionDetectionCnf siquraHardwareMotionDetectionCnf;
    private HardwareMotionDetectionCnf[] hardwareMotionDetectionCnf = new HardwareMotionDetectionCnf[1];
    private boolean motionDetectionAlreadyStarted = false;
    private Map<Integer, Integer> streams = new HashMap<Integer, Integer>();
    private boolean h264StreamsSet = false;

    public final int init(Core core, Device device, Entity entity, int preparationError) {
        this.preparationError = preparationError;
        return this.init(core, device, entity);
    }

    @Override
    public CameraControl createCameraControl(Long nEntityType) {
        return new SiquraCameraControl();
    }

    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        int errorCode = 0;
        VideoSourceClient videoSourceClient = null;
        this.logger.info("Creating new [ VideoSourceClient ] with VideoProfileHandler=" + listener + " ...");
        try {
            if (this.preparationError != 0) {
                this.sendStatusService(this.preparationError);
                errorCode = this.preparationError;
            } else {
                if (!(this.device.getDeviceType() != 203201L && this.device.getDeviceType() != 203206L || this.h264StreamsSet)) {
                    this.setH264Streams();
                    this.h264StreamsSet = true;
                }
                int streamingMode = listener.getVideoSourceParameter().getMediaCodec().getType();
                SiquraDevice siquraDevice = (SiquraDevice)this.getDevice();
                if (siquraDevice.isOnvifDevice()) {
                    videoSourceClient = new SiquraOnvifVideoSourceClient();
                } else {
                    videoSourceClient = streamingMode == Codec.H264.getType() ? new SiquraH264VideoSourceClient() : (listener.getVideoSourceParameter().getTransmissionID() == TransmissionType.RTP_OVER_UDP_UNICAST ? new SiquraJPEGVideoSourceClientRTSP() : new SiquraJPEGVideoSourceClient());
                    if (this.getHardwareMotionDetection() == null && !this.motionDetectionAlreadyStarted) {
                        this.motionDetectionAlreadyStarted = true;
                        this.logger.info("Starting Tampering Detection for " + this);
                        this.siquraHardwareMotionDetectionCnf = new SiquraHardwareMotionDetectionCnf();
                        this.hardwareMotionDetectionCnf[0] = this.siquraHardwareMotionDetectionCnf;
                        this.hardwareMotionDetection = new SiquraHardwareMotionDetection();
                        this.hardwareMotionDetection.init(this, this.hardwareMotionDetectionCnf);
                    }
                }
                errorCode = videoSourceClient.init(core, this, listener);
            }
            if (errorCode != 0) {
                if (videoSourceClient != null) {
                    videoSourceClient.shutdown();
                    videoSourceClient = null;
                }
                this.logger.error("Initializing [ VideoSourceClient ] for " + this + " failed with error [ " + errorCode + " ] :-( ");
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
        }
        catch (SeeTecException seetecEx) {
            throw seetecEx;
        }
        catch (Throwable ex) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            this.logger.error((Object)ex, ex);
            this.logger.error("Creating [VideoSourceClient] for " + this + " failed :-(");
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        return videoSourceClient;
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] resolution) throws SeeTecException {
        byte[] doubleLine = new byte[]{13, 10, 13, 10};
        byte[] result = null;
        try {
            String url = "/video.jpg";
            result = NetworkHelper.readGetRequest((NetworkParameter)this.getDevice().getDeviceCnf().getNetworkParameter(), (String)url, (int)Integer.MAX_VALUE);
            if (result != null) {
                int firstDoubleLineDelimiter = Basic.indexOfByteArray((byte[])result, (byte[])doubleLine, (int)0);
                byte[] frame = new byte[result.length - firstDoubleLineDelimiter];
                System.arraycopy(result, firstDoubleLineDelimiter, frame, 0, frame.length);
                return new ContentFrame(0, frame);
            }
            this.logger.error("Error while requesting snapshot for " + this.getDevice());
            throw new SeeTecException(-20001, "Unknown exception while requesting snapshot");
        }
        catch (SeeTecException e) {
            this.logger.error("Exception while requesting snapshot for " + this.getDevice(), (Throwable)e);
            throw e;
        }
        catch (Exception ex) {
            this.logger.error("Exception while requesting snapshot for " + this.getDevice());
            this.logger.error((Object)ex, (Throwable)ex);
            throw new SeeTecException(-20001, "Unknown exception while requesting snapshot");
        }
    }

    private void setH264Streams() {
        int streamNumber = 1;
        try {
            VideoProfileHandler videoProfileHandler = this.getBasicVideoProfileHandler();
            if (videoProfileHandler.getVideoSourceParameter().getMediaCodec() == Codec.H264) {
                this.streams.put(videoProfileHandler.getDynamicVideoProfileID(), streamNumber++);
            }
            VideoProfileHandler[] videoProfileHandlers = this.getAdditionalVideoProfileHandler();
            for (int i = 0; i < videoProfileHandlers.length; ++i) {
                videoProfileHandler = videoProfileHandlers[i];
                if (videoProfileHandler.getVideoSourceParameter().getMediaCodec() != Codec.H264) continue;
                this.streams.put(videoProfileHandler.getDynamicVideoProfileID(), streamNumber++);
            }
        }
        catch (ConfigurationException ex) {
            this.logger.error("Exception while matching Seetec streams to camera streams for " + this);
            this.logger.error((Object)ex, (Throwable)ex);
        }
    }

    public int getH264StreamNumber(VideoProfileHandler listener) {
        return this.streams.get(listener.getDynamicVideoProfileID());
    }
}

