/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.siqura;

import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.net.URLEncoder;
import java.util.Vector;

public class SiquraCameraControl
extends CameraControl {
    private int errorCode;
    private int sourceNumber = -1;

    private int sendCameraCommand(String url) {
        try {
            if (this.sourceNumber == -1) {
                this.sourceNumber = this.videoSrv.getVideoSourceCnf().getServerEntryNo();
            }
            String completeUrl = "/api/ptz.cgi?PTZNumber=" + this.sourceNumber + url;
            this.videoSrv.notifyForCameraControl();
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)completeUrl, (int)Integer.MAX_VALUE);
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        return 0;
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        int pan = 0;
        int tilt = 0;
        int zoom = 0;
        if (panSpeed != null) {
            this.previousPanSpeed = pan = panSpeed / 1000;
        } else {
            pan = this.previousPanSpeed;
        }
        if (tiltSpeed != null) {
            this.previousTiltSpeed = tilt = tiltSpeed / 1000;
        } else {
            tilt = this.previousTiltSpeed;
        }
        if (zoomSpeed != null) {
            this.previousZoomSpeed = zoom = zoomSpeed / 1000;
        } else {
            zoom = this.previousZoomSpeed;
        }
        try {
            StringBuilder sb = new StringBuilder("&PanSpeed=").append(pan).append("&TiltSpeed=").append(tilt).append("&ZoomSpeed=").append(zoom);
            return this.sendCameraCommand(sb.toString());
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        return 0;
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer heigth, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        return 0;
    }

    @Override
    public int setContinuousIris(Integer value) {
        return this.sendCameraCommand("&IrisSpeed=" + value);
    }

    @Override
    public int setAutoIris(Boolean active) {
        try {
            if (this.sourceNumber == -1) {
                this.sourceNumber = this.videoSrv.getVideoSourceCnf().getServerEntryNo();
            }
            StringBuilder url = new StringBuilder("/params/set.cgi?Data-1.Ptz-" + this.sourceNumber + ".AutoIris=");
            if (active.booleanValue()) {
                url.append("On");
            } else {
                url.append("Off");
            }
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString());
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception occured while setting Auto-Iris on " + this + ": " + ex.getMessage());
            return -20100;
        }
        catch (ConfigurationException ex) {
            this.logger.error("Exception occured while setting Auto-Iris on " + this + ": " + ex.getMessage());
            return -20100;
        }
        return 0;
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        return 0;
    }

    @Override
    public int setContinuousFocus(Integer value) {
        return this.sendCameraCommand("&FocusSpeed=" + value);
    }

    @Override
    public int setAutoFocus(Boolean active) {
        try {
            if (this.sourceNumber == -1) {
                this.sourceNumber = this.videoSrv.getVideoSourceCnf().getServerEntryNo();
            }
            StringBuilder url = new StringBuilder("/params/set.cgi?Data-1.Ptz-" + this.sourceNumber + ".AutoFocus=");
            if (active.booleanValue()) {
                url.append("On");
            } else {
                url.append("Off");
            }
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString());
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception occured while setting Auto Focus on " + this + ": " + ex.getMessage());
            return -20100;
        }
        catch (ConfigurationException ex) {
            this.logger.error("Exception occured while setting Auto Focus on " + this + ": " + ex.getMessage());
            return -20100;
        }
        return 0;
    }

    @Override
    public int setZeroLux(Boolean active) {
        try {
            if (this.sourceNumber == -1) {
                this.sourceNumber = this.videoSrv.getVideoSourceCnf().getServerEntryNo();
            }
            StringBuilder url = new StringBuilder("/params/set.cgi?Data-1.Ptz-" + this.sourceNumber + ".IrCutFilter=");
            if (active.booleanValue()) {
                url.append("Off");
            } else {
                url.append("On");
            }
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString());
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception occured while setting Day/Night mode on " + this + ": " + ex.getMessage());
            return -20100;
        }
        catch (ConfigurationException ex) {
            this.logger.error("Exception occured while setting Day/Night mode on " + this + ": " + ex.getMessage());
            return -20100;
        }
        return 0;
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        try {
            if (this.sourceNumber == -1) {
                this.sourceNumber = this.videoSrv.getVideoSourceCnf().getServerEntryNo();
            }
            StringBuilder url = new StringBuilder("/params/set.cgi?Data-1.Ptz-" + this.sourceNumber + ".IrCutFilter=");
            if (active.booleanValue()) {
                url.append("Auto");
            } else {
                url.append("Off");
            }
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString());
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception occured while setting Day/Night mode on " + this + ": " + ex.getMessage());
            return -20100;
        }
        catch (ConfigurationException ex) {
            this.logger.error("Exception occured while setting Day/Night mode on " + this + ": " + ex.getMessage());
            return -20100;
        }
        return 0;
    }

    @Override
    public int setHomePosition() {
        return 0;
    }

    @Override
    public int addPresetPosition(Vector<byte[]> result, Long presetID, String presetName) {
        int presetPosition = -1;
        try {
            int i;
            byte[] vector = new byte[256];
            for (i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                vector[Integer.parseInt((String)presetCnf.getPresetPosition())] = 1;
            }
            for (i = 1; i <= vector.length; ++i) {
                if (vector[i] != 0) continue;
                presetPosition = i;
                break;
            }
            if (presetPosition < 0) {
                this.logger.error("Cannot add preset [ " + presetName + " ], 'cause no more free preset positions are available for " + this + " :-( ");
                return -21600;
            }
            presetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, "" + presetPosition, presetName);
            this.presetList.addElement(presetCnf);
            result.addElement(presetCnf.getPresetCnf());
            this.sendCameraCommand("&SetPreset=" + presetPosition);
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            this.logger.error("Adding preset [ " + presetName + " ] failed :-( ");
            return -21600;
        }
    }

    @Override
    public int setPresetPosition(String presetName) {
        try {
            presetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                if (!presetName.equals(presetCnf.getPresetName())) continue;
                this.errorCode = this.sendCameraCommand("&GotoPreset=" + presetCnf.getPresetPosition());
                return this.errorCode;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Setting preset [ " + presetName + " ] failed :-( ");
            return -21600;
        }
        this.logger.error("Preset [ " + presetName + " ] not available :-( ");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }

    @Override
    public int removePresetPosition(String presetName) {
        try {
            String encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = (PresetCnf)this.presetList.elementAt(i);
                if (!encodedPresetName.equals(presetCnf.getPresetName())) continue;
                this.presetList.removeElementAt(i);
                return 0;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Removing preset [" + presetName + "] failed :-(");
            return -21600;
        }
        this.logger.error("Preset [" + presetName + "] not available :-(");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }
}

