/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.siemens;

import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.video.siemens.SiemensDevice;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import org.apache.logging.log4j.LogManager;

public class SiemensMotionDetectionHandler
extends MotionDetectionHandler
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.siemens.SiemensMotionDetectionHandler";
    private NetworkParameter networkParameter = null;

    public SiemensMotionDetectionHandler() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public int init(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        this.listener = hardwareMotionDetection;
        if (this.listener == null) {
            return -20003;
        }
        try {
            this.networkParameter = this.listener.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter();
        }
        catch (ConfigurationException ex) {
            this.logger.info("Exception while getting Network Parameters: " + (Object)((Object)ex));
        }
        SiemensDevice siemensDevice = (SiemensDevice)this.listener.getVideoSrv().getDevice();
        try {
            if (siemensDevice.getOidValue(this.networkParameter, "40.99.1", "40.2.1").equals("1")) {
                this.logger.warn("Motion Detection on Camera is DISABLED for " + this);
                this.logger.info("Trying to enable Motion Detection...");
                if (NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/set?40.2.1=2", (int)Integer.MAX_VALUE) == null) {
                    this.logger.error("Could not enable Motion Detection on camera for " + this);
                }
                if (siemensDevice.getOidValue(this.networkParameter, "40.99.1", "40.2.1").equals("1")) {
                    this.logger.error("Could not enable Motion Detection on camera for " + this);
                }
            }
        }
        catch (SeeTecException ex) {
            this.logger.warn("Exception occured while trying to activate Motion Detection on camera for " + this + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
        return 0;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        super.shutdown();
        return 0;
    }

    public void processMotionDetection() {
        if (this.listener != null) {
            this.listener.evaluateWindow(0);
        }
    }

    @Override
    public void notifyForNetworkProblems() {
        this.logger.info("Network problem signaled for " + this.listener.getVideoSrv());
    }

    @Override
    public void deliverContent(HttpServerPushContent arg0) {
    }

    @Override
    public void sendStatusService(int arg0) {
    }

    @Override
    public boolean isShutdown() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

