/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.siemens;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileComparator;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.siemens.SiemensCameraControl;
import de.seetec.v5.re.cm.device.video.siemens.SiemensDevice;
import de.seetec.v5.re.cm.device.video.siemens.SiemensVideoSourceClient;
import de.seetec.v5.re.cm.device.video.siemens.jpeg.SiemensJPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.siemens.jpeg.SiemensJPEGVideoSourceClient_1345;
import de.seetec.v5.re.cm.device.video.siemens.mpeg.SiemensMPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.siemens.mpeg.SiemensMPEGVideoSourceClient_1345;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SiemensCameraSrv
extends LiveCameraSrv {
    private String cookie = null;
    private byte[] result;
    private SiemensDevice siemensDevice;
    private boolean videoSourceParametersSet = false;
    private Map<Integer, Integer> streams = new HashMap<Integer, Integer>();
    private NetworkParameter networkParameter;
    private final Object SEMAPHORE = new Object();

    public String getCookie() {
        return this.cookie;
    }

    public void setCookie(String value) {
        this.cookie = value;
    }

    @Override
    public CameraControl createCameraControl(Long entityType) {
        return new SiemensCameraControl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        Object object = this.SEMAPHORE;
        synchronized (object) {
            int errorCode = 0;
            VideoSourceClient videoSourceClient = null;
            if (this.siemensDevice == null) {
                this.siemensDevice = (SiemensDevice)this.getDevice();
            }
            long deviceType = this.getDevice().getDeviceType();
            long entityType = super.getEntityType();
            if (super.getEntityType() != 212203L && super.getEntityType() != 212200L) {
                try {
                    this.networkParameter = this.getDevice().getDeviceCnf().getNetworkParameter();
                    if (deviceType == 202207L) {
                        int cameraID = super.getVideoSourceCnf().getPtzAddress();
                        this.result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/cgi-bin/set?110.0.2=" + cameraID), (int)Integer.MAX_VALUE, (boolean)false, (String)null);
                        if (this.streams.isEmpty()) {
                            this.streams.put(this.getBasicVideoProfileHandler().getDynamicVideoProfileID(), 0);
                            for (int i = 0; i < 2; ++i) {
                                if (this.getAdditionalVideoProfileHandler() == null || this.getAdditionalVideoProfileHandler().length <= i) continue;
                                this.streams.put(this.getAdditionalVideoProfileHandler()[i].getDynamicVideoProfileID(), i + 1);
                            }
                        }
                    } else if (deviceType == 202209L) {
                        ArrayList<VideoProfileHandler> handlers = new ArrayList<VideoProfileHandler>();
                        handlers.add(this.getBasicVideoProfileHandler());
                        if (this.getAdditionalVideoProfileHandler() != null && this.getAdditionalVideoProfileHandler().length > 0) {
                            Collections.addAll(handlers, this.getAdditionalVideoProfileHandler());
                        }
                        Collections.sort(handlers, new VideoProfileComparator(VideoProfileComparator.ORDER_MODE.RESOLUTION_ONLY));
                        for (int i = 0; i < 3; ++i) {
                            if (handlers.size() > i) {
                                this.logger.info("Siemens CxMW3025 stream " + i + " is " + ((VideoProfileHandler)handlers.get(i)).getVideoSourceParameter().getMediaCodec().name() + " with " + ((VideoProfileHandler)handlers.get(i)).getVideoSourceParameter().getImageSize()[0] + "x" + ((VideoProfileHandler)handlers.get(i)).getVideoSourceParameter().getImageSize()[1]);
                                this.streams.put(((VideoProfileHandler)handlers.get(i)).getDynamicVideoProfileID(), i);
                                if (((VideoProfileHandler)handlers.get(i)).getVideoSourceParameter().getMediaCodec() == Codec.H264) {
                                    this.setCodec(3, i);
                                    continue;
                                }
                                if (((VideoProfileHandler)handlers.get(i)).getVideoSourceParameter().getMediaCodec() == Codec.MPEG4) {
                                    this.setCodec(2, i);
                                    continue;
                                }
                                this.setCodec(1, i);
                                continue;
                            }
                            this.logger.info("Siemens CxMW3025 stream " + i + " is disabled!");
                            this.setCodec(0, i);
                        }
                    } else if (this.getBasicVideoProfileHandler().getVideoSourceParameter().getImageSize()[0] == 1920) {
                        this.streams.put(this.getBasicVideoProfileHandler().getDynamicVideoProfileID(), 0);
                    } else if (this.getAdditionalVideoProfileHandler() == null || this.getAdditionalVideoProfileHandler().length == 0) {
                        this.streams.put(this.getBasicVideoProfileHandler().getDynamicVideoProfileID(), 0);
                        this.setCodec(0, 2);
                        this.setCodec(0, 1);
                    } else if (this.getAdditionalVideoProfileHandler() != null && this.getAdditionalVideoProfileHandler().length > 0) {
                        int widthBasicProfile = this.getBasicVideoProfileHandler().getVideoSourceParameter().getImageSize()[0];
                        int heightBasicProfile = this.getBasicVideoProfileHandler().getVideoSourceParameter().getImageSize()[1];
                        int widthAdditionalProfile = this.getAdditionalVideoProfileHandler()[0].getVideoSourceParameter().getImageSize()[0];
                        int heightAdditionalProfile = this.getAdditionalVideoProfileHandler()[0].getVideoSourceParameter().getImageSize()[1];
                        int resolutionCodeBasic = this.siemensDevice.getResolutionCode(widthBasicProfile, heightBasicProfile);
                        int resolutionCodeAdditional = this.siemensDevice.getResolutionCode(widthAdditionalProfile, heightAdditionalProfile);
                        if (widthBasicProfile >= widthAdditionalProfile) {
                            this.streams.put(this.getBasicVideoProfileHandler().getDynamicVideoProfileID(), 0);
                            this.streams.put(this.getAdditionalVideoProfileHandler()[0].getDynamicVideoProfileID(), 1);
                            this.setResolution(resolutionCodeBasic, 0);
                            this.setResolution(resolutionCodeAdditional, 1);
                            if (this.getBasicVideoProfileHandler().getVideoSourceParameter().getMediaCodec() == Codec.H264) {
                                this.setCodec(3, 0);
                            } else {
                                this.setCodec(1, 0);
                            }
                            if (this.getAdditionalVideoProfileHandler()[0].getVideoSourceParameter().getMediaCodec() == Codec.H264) {
                                this.setCodec(3, 1);
                            } else {
                                this.setCodec(1, 1);
                            }
                        } else {
                            this.streams.put(this.getBasicVideoProfileHandler().getDynamicVideoProfileID(), 1);
                            this.streams.put(this.getAdditionalVideoProfileHandler()[0].getDynamicVideoProfileID(), 0);
                            this.setResolution(resolutionCodeBasic, 1);
                            this.setResolution(resolutionCodeAdditional, 0);
                            if (this.getAdditionalVideoProfileHandler()[0].getVideoSourceParameter().getMediaCodec() == Codec.H264) {
                                this.setCodec(3, 0);
                            } else {
                                this.setCodec(1, 0);
                            }
                            if (this.getBasicVideoProfileHandler().getVideoSourceParameter().getMediaCodec() == Codec.H264) {
                                this.setCodec(3, 1);
                            } else {
                                this.setCodec(1, 1);
                            }
                        }
                    }
                }
                catch (ConfigurationException ex) {
                    this.logger.error("Exception while getting camera configuration data for " + this + ": " + ex.getMessage());
                }
            }
            try {
                Codec streamingMode = listener.getVideoSourceParameter().getMediaCodec();
                this.logger.info("StreamingMode for " + this + " is [" + streamingMode + "]");
                videoSourceClient = streamingMode == Codec.MPEG4 ? (entityType == 212203L ? new SiemensMPEGVideoSourceClient() : new SiemensMPEGVideoSourceClient_1345()) : (streamingMode == Codec.H264 ? new SiemensVideoSourceClient() : (entityType == 212203L ? new SiemensJPEGVideoSourceClient() : (entityType == 212200L ? new SiemensJPEGVideoSourceClient_1345() : new SiemensVideoSourceClient())));
                errorCode = videoSourceClient.init(core, this, listener);
                if (errorCode != 0) {
                    videoSourceClient.shutdown();
                    videoSourceClient = null;
                    this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "] :-(");
                    throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
                }
            }
            catch (SeeTecException seetecEx) {
                throw seetecEx;
            }
            catch (Throwable ex) {
                if (videoSourceClient != null) {
                    videoSourceClient.shutdown();
                    videoSourceClient = null;
                }
                this.logger.error((Object)ex, ex);
                this.logger.error("Creating [VideoSourceClient] for " + this + " failed :-(");
                throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
            }
            return videoSourceClient;
        }
    }

    public int getStreamNumber(int id) {
        return this.streams.get(id);
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] nResolution) throws SeeTecException {
        throw new SeeTecException(-20009, "NOT YET IMPLEMENTED :-(");
    }

    public boolean isPal(NetworkParameter networkParameter) {
        block10: {
            try {
                long entityType;
                if (this.siemensDevice == null) {
                    this.siemensDevice = (SiemensDevice)this.getDevice();
                }
                if ((entityType = super.getEntityType().longValue()) == 212203L) {
                    this.result = NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)"/cgi-bin/read?30.0.5", (int)Integer.MAX_VALUE);
                    if (this.result == null) {
                        this.logger.error("Error reading PAL/NTSC configuration for " + this);
                    } else {
                        String videoStandard = this.siemensDevice.readOidValue(new String(this.result), "30.0.5");
                        if (videoStandard == null) {
                            this.logger.error("Could not read video standard. Will asume PAL is used for " + this);
                        } else if (!videoStandard.equals("1")) {
                            return false;
                        }
                    }
                    break block10;
                }
                if (entityType != 212208L) break block10;
                this.result = NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)("/cgi-bin/getvideotype.cgi?rnd=" + new Date().getTime()), (int)Integer.MAX_VALUE);
                if (this.result == null) {
                    this.logger.error("Error reading PAL/NTSC configuration for " + this);
                    break block10;
                }
                String resultStr = new String(this.result);
                return resultStr.toLowerCase().contains("video_type=\"2\"");
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception occured while reading PAL/NTSC configuration for " + this + ": " + (Object)((Object)ex));
            }
        }
        return true;
    }

    public int setVideoSourceParameters(NetworkParameter networkParameter, boolean timeDateEnabled, int rotationAngle, boolean useTitle, String title) {
        if (this.siemensDevice == null) {
            this.siemensDevice = (SiemensDevice)this.getDevice();
        }
        int errorCode = 0;
        if (this.videoSourceParametersSet) {
            return 0;
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append("/cgi-bin/set?");
        try {
            String useDateTimeParameter = this.siemensDevice.getOidValue(networkParameter, "70.99.1", "70.0.1");
            if (useDateTimeParameter != null && useDateTimeParameter.equals("2") && !timeDateEnabled) {
                sb.append("&70.0.1=1");
            } else if (useDateTimeParameter.equals("1") && timeDateEnabled) {
                sb.append("&70.0.1=2");
            }
            if (this.siemensDevice.getCameraTitleMode() == 1) {
                if (useTitle && title != null) {
                    if (title.length() > 24) {
                        title = title.substring(0, 23);
                    }
                    sb.append("&20.0.1=" + title);
                    sb.append("&20.0.2=2");
                } else {
                    sb.append("&20.0.2=1");
                }
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while reading parameters on camera for " + this + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        if (this.siemensDevice.getImageFlipMode() == 2) {
            if (rotationAngle == 180) {
                sb.append("&30.6.26=2");
                sb.append("&30.6.30=2");
            } else {
                sb.append("&30.6.26=1");
                sb.append("&30.6.30=1");
            }
        } else if (rotationAngle == 180) {
            sb.append("&30.2.1=2");
            sb.append("&30.2.2=2");
        } else {
            sb.append("&30.2.1=1");
            sb.append("&30.2.2=1");
        }
        try {
            String parameterUrl = sb.toString();
            if (parameterUrl.indexOf("?&") != -1) {
                parameterUrl = parameterUrl.replace("?&", "?");
                NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)parameterUrl, (int)Integer.MAX_VALUE);
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception occured while setting general camera parameters for " + this + ": " + (Object)((Object)ex));
            return ex.getErrorCode();
        }
        this.videoSourceParametersSet = true;
        return errorCode;
    }

    private void setResolution(int resolutionCode, int streamNumber) throws SeeTecException {
        String parametersOnCamera = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/read?11.99.1", (int)Integer.MAX_VALUE, (boolean)false));
        if (!this.siemensDevice.readOidValue(parametersOnCamera, "11." + streamNumber + ".0.2").equals("" + resolutionCode)) {
            String url = "/cgi-bin/set?11." + streamNumber + ".0.2=" + resolutionCode;
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)false);
        }
    }

    private void setCodec(int codec, int streamNumber) {
        try {
            String parametersOnCamera = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/read?11.99.1", (int)Integer.MAX_VALUE, (boolean)false));
            if (!this.siemensDevice.readOidValue(parametersOnCamera, "11." + streamNumber + ".0.1").equals("" + codec)) {
                String url = "/cgi-bin/set?11." + streamNumber + ".0.1=" + codec;
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)false);
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception in SiemensCameraSrv.setCodec!", (Throwable)ex);
        }
    }
}

