/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.siemens;

import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.video.siemens.SiemensCameraSrv;
import de.seetec.v5.re.cm.device.video.siemens.SiemensDevice;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.net.URLEncoder;
import java.util.Vector;

public class SiemensCameraControl
extends CameraControl {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.siemens.SiemensCameraControl";
    private int errorCode;
    private SiemensDevice siemensDevice;
    private StringBuilder panTiltUrl;
    private StringBuilder zoomUrl;

    private int sendCameraCommand(String url) {
        try {
            this.videoSrv.notifyForCameraControl();
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
            return 0;
        }
        catch (SeeTecException ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            return ex.getErrorCode();
        }
    }

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        if (panSpeed == null && tiltSpeed == null && zoomSpeed == null) {
            return 0;
        }
        if (this.siemensDevice == null) {
            this.siemensDevice = (SiemensDevice)((SiemensCameraSrv)this.videoSrv).getDevice();
        }
        int pan = 0;
        int tilt = 0;
        int zoom = 0;
        this.previousPanSpeed = pan = panSpeed != null ? panSpeed / 1000 : this.previousPanSpeed;
        this.previousTiltSpeed = tilt = tiltSpeed != null ? tiltSpeed / 1000 : this.previousTiltSpeed;
        this.previousZoomSpeed = zoom = zoomSpeed != null ? zoomSpeed / 1000 : this.previousZoomSpeed;
        if (this.siemensDevice.getPtzMode() == 1) {
            this.panTiltUrl = new StringBuilder("/cgi-bin/camctrl/camctrl.cgi?channel=0&camid=1");
            this.panTiltUrl.append("&vx=").append(pan / 10).append("&vy=").append(tilt / 10).append("&vs=0");
            this.zoomUrl = new StringBuilder("/cgi-bin/camctrl/camctrl.cgi?channel=0&camid=1&zoom=");
            if (zoom < 0) {
                this.zoomUrl.append("wide");
            } else if (zoom > 0) {
                this.zoomUrl.append("tele");
            } else {
                this.zoomUrl.append("stop");
            }
        } else if (this.siemensDevice.getPtzMode() == 2) {
            this.panTiltUrl = new StringBuilder("/cgi-bin/remotecon.cgi?Type=");
            if (pan < 0 && tilt == 0) {
                this.panTiltUrl.append("3");
            } else if (pan < 0 && tilt > 0) {
                this.panTiltUrl.append("5");
            } else if (pan == 0 && tilt > 0) {
                this.panTiltUrl.append("1");
            } else if (pan > 0 && tilt > 0) {
                this.panTiltUrl.append("6");
            } else if (pan > 0 && tilt == 0) {
                this.panTiltUrl.append("4");
            } else if (pan > 0 && tilt < 0) {
                this.panTiltUrl.append("8");
            } else if (pan == 0 && tilt < 0) {
                this.panTiltUrl.append("2");
            } else if (pan < 0 && tilt < 0) {
                this.panTiltUrl.append("7");
            } else if (pan == 0 && tilt == 0) {
                this.panTiltUrl.append("9");
            } else {
                this.logger.error("No Pan/Tilt Command specified ");
            }
            if (pan != 0 || tilt != 0) {
                this.panTiltUrl.append("&Pan=").append((int)Math.abs((double)pan / 1.43)).append("&Tilt=").append((int)Math.abs((double)tilt / 1.43));
            }
            this.zoomUrl = new StringBuilder("/cgi-bin/remotecon.cgi?Type=");
            if (zoom > 0) {
                this.zoomUrl.append("10");
            } else if (zoom < 0) {
                this.zoomUrl.append("11");
            } else {
                this.zoomUrl.append("9");
            }
            this.zoomUrl.append("&pan=30&tilt=30");
        } else {
            this.logger.error("No PTZ Type defined for " + this);
            return -20002;
        }
        if ((panSpeed != null || tiltSpeed != null) && (this.errorCode = this.sendCameraCommand(this.panTiltUrl.toString())) != 0) {
            this.logger.error("Error while sending Pan-Tilt Command for " + this + ". Errorcode: " + this.errorCode);
        }
        if (zoomSpeed != null && (this.errorCode = this.sendCameraCommand(this.zoomUrl.toString())) != 0) {
            this.logger.error("Error while sending Zoom Command for " + this + ". Errorcode: " + this.errorCode);
        }
        return 0;
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    @Override
    public int setContinuousIris(Integer value) {
        if (value != null) {
            if (this.siemensDevice == null) {
                this.siemensDevice = (SiemensDevice)((SiemensCameraSrv)this.videoSrv).getDevice();
            }
            if (this.siemensDevice.getPtzMode() == 1) {
                String url = "/cgi-bin/camctrl/camctrl.cgi?channel=0&camid=1&iris=";
                if (value > 0) {
                    this.sendCameraCommand(url + "open");
                } else if (value < 0) {
                    this.sendCameraCommand(url + "close");
                }
            }
        }
        return 0;
    }

    @Override
    public int setAutoIris(Boolean active) {
        StringBuilder url = new StringBuilder("/cgi-bin/camctrl/camctrl.cgi?channel=0&camid=1&iris=");
        if (active.booleanValue()) {
            url.append("auto");
            this.sendCameraCommand(url.toString());
        }
        return 0;
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    @Override
    public int setContinuousFocus(Integer value) {
        if (this.siemensDevice == null) {
            this.siemensDevice = (SiemensDevice)((SiemensCameraSrv)this.videoSrv).getDevice();
        }
        if (this.siemensDevice.getPtzMode() == 1) {
            if (value != null) {
                String url = "/cgi-bin/camctrl/camctrl.cgi?channel=0&camid=1&focus=";
                if (value > 0) {
                    this.sendCameraCommand(url + "far");
                } else if (value < 0) {
                    this.sendCameraCommand(url + "near");
                }
            }
        } else if (this.siemensDevice.getPtzMode() == 2 && value != null) {
            String url = "/cgi-bin/remotecon.cgi?Type=";
            if (value > 0) {
                this.sendCameraCommand(url + "12");
            } else if (value < 0) {
                this.sendCameraCommand(url + "13");
            } else {
                this.sendCameraCommand(url + "9");
            }
        }
        return 0;
    }

    @Override
    public int setAutoFocus(Boolean active) {
        if (this.siemensDevice == null) {
            this.siemensDevice = (SiemensDevice)((SiemensCameraSrv)this.videoSrv).getDevice();
        }
        if (this.siemensDevice.getPtzMode() == 2) {
            this.sendCameraCommand("/cgi-bin/set?30.6.2=" + (active != false ? "2" : "1"));
        }
        return 0;
    }

    @Override
    public int setZeroLux(Boolean active) {
        if (this.siemensDevice == null) {
            this.siemensDevice = (SiemensDevice)((SiemensCameraSrv)this.videoSrv).getDevice();
        }
        if (this.siemensDevice.getPtzMode() == 2) {
            this.sendCameraCommand("/cgi-bin/set?30.6.32=" + (active != false ? "3" : "2"));
        }
        return 0;
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        if (this.siemensDevice == null) {
            this.siemensDevice = (SiemensDevice)((SiemensCameraSrv)this.videoSrv).getDevice();
        }
        if (this.siemensDevice.getPtzMode() == 2) {
            this.sendCameraCommand("/cgi-bin/set?30.6.32=1");
        }
        return 0;
    }

    @Override
    public int setHomePosition() {
        return 0;
    }

    @Override
    public int addPresetPosition(Vector<byte[]> result, Long presetID, String presetName) {
        int presetPosition = -1;
        if (this.siemensDevice == null) {
            this.siemensDevice = (SiemensDevice)((SiemensCameraSrv)this.videoSrv).getDevice();
        }
        try {
            int i;
            byte[] vector = new byte[8];
            if (this.siemensDevice.getPtzMode() == 2) {
                vector = new byte[65];
            }
            for (i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                vector[Integer.parseInt((String)presetCnf.getPresetPosition())] = 1;
            }
            for (i = 1; i <= vector.length; ++i) {
                if (vector[i] != 0) continue;
                presetPosition = i;
                break;
            }
            if (presetPosition < 0) {
                this.logger.error("Cannot add preset [" + presetName + "], 'cause no more free preset positions are available for " + this + " :-(");
                return -21600;
            }
            presetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, "" + presetPosition, presetName);
            this.presetList.addElement(presetCnf);
            result.addElement(presetCnf.getPresetCnf());
            if (this.siemensDevice.getPtzMode() == 1) {
                this.sendCameraCommand("/cgi-bin/operator/preset.cgi?channel=0&addpos=" + presetPosition);
            } else if (this.siemensDevice.getPtzMode() == 2) {
                this.sendCameraCommand("/cgi-bin/remotecon.cgi?Type=" + presetPosition * 256);
            }
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            this.logger.error("Adding preset [" + presetName + "] failed");
            return -21600;
        }
    }

    @Override
    public int setPresetPosition(String presetName) {
        try {
            presetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                if (!presetName.equals(presetCnf.getPresetName())) continue;
                int presetPosition = Integer.parseInt(presetCnf.getPresetPosition());
                if (this.siemensDevice.getPtzMode() == 1) {
                    this.sendCameraCommand("/cgi-bin/camctrl/recall.cgi?channel=0&recall=" + presetCnf.getPresetPosition());
                } else if (this.siemensDevice.getPtzMode() == 2) {
                    this.sendCameraCommand("/cgi-bin/remotecon.cgi?Type=" + presetPosition * 256 * 256);
                }
                return 0;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Setting preset [" + presetName + "] failed");
            return -21600;
        }
        this.logger.error("Preset [" + presetName + "] not available");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }

    @Override
    public int removePresetPosition(String presetName) {
        try {
            String encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = (PresetCnf)this.presetList.elementAt(i);
                if (!encodedPresetName.equals(presetCnf.getPresetName())) continue;
                String presetNumber = presetCnf.getPresetPosition();
                this.presetList.removeElementAt(i);
                this.sendCameraCommand("/cgi-bin/operator/preset.cgi?channel=0&delpos=" + presetNumber);
                return 0;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Removing preset [" + presetName + "] failed");
            return -21600;
        }
        this.logger.error("Preset [" + presetName + "] not available");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }
}

