/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.sanyo.mpeg;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoCameraSrv;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoDevice;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoMotionDetectionHandler;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.util.SeeTecException;

public class SanyoH264VideoSourceClient2
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.sanyo.SanyoVideoSourceClient";
    private int streamNumber = 0;
    private SanyoDevice sanyoDevice = null;
    private boolean isPalFormat = false;
    private int resolution = -1;
    private byte[] result = null;

    private int setHttpParameters(int resolution, int aspectRatio, long frameRate, long iFrameDistance, int pictureQuality) {
        if (resolution < 2) {
            iFrameDistance = iFrameDistance < 1L ? 1L : iFrameDistance;
            iFrameDistance = iFrameDistance > 255L ? 255L : iFrameDistance;
        } else {
            iFrameDistance = iFrameDistance < 15L ? 15L : iFrameDistance;
            iFrameDistance = iFrameDistance > 100L ? 100L : iFrameDistance;
        }
        String sbCreateStream = "/cgi-bin/str_add.cgi?tmp_flag=" + this.streamNumber;
        StringBuffer sbStreamParameters = new StringBuffer(256);
        if (this.getVideoSrv().getEntityType() == 211908L || this.getVideoSrv().getEntityType() == 211917L) {
            sbStreamParameters.append("/cgi-bin/codec_stream.cgi?stream_set=");
            sbStreamParameters.append(this.streamNumber);
            sbStreamParameters.append("&name_stream=STREAM").append(this.streamNumber + 1);
            sbStreamParameters.append("&codec=1");
            sbStreamParameters.append("&aspect_ratio=");
            sbStreamParameters.append(aspectRatio);
            sbStreamParameters.append("&resol=");
            sbStreamParameters.append(resolution);
            sbStreamParameters.append("&frame_rate=");
            sbStreamParameters.append(frameRate);
            sbStreamParameters.append("&gop_interval=");
            sbStreamParameters.append(iFrameDistance);
            if (this.isAudioEnabled) {
                sbStreamParameters.append("&audio_sw=1");
            }
            sbStreamParameters.append("&priority=0");
            sbStreamParameters.append("&picture_quality=").append(pictureQuality);
            sbStreamParameters.append("&status=1");
        } else if (this.getVideoSrv().getEntityType() == 211904L || this.getVideoSrv().getEntityType() == 211913L || this.getVideoSrv().getEntityType() == 211907L || this.getVideoSrv().getEntityType() == 211916L || this.getVideoSrv().getEntityType() == 211909L || this.getVideoSrv().getEntityType() == 211918L || this.getVideoSrv().getEntityType() == 211910L || this.getVideoSrv().getEntityType() == 211919L) {
            sbStreamParameters = new StringBuffer("/cgi-bin/codec_stream.cgi?stream_set=");
            sbStreamParameters.append(this.streamNumber);
            sbStreamParameters.append("&name_stream=STREAM").append(this.streamNumber + 1);
            sbStreamParameters.append("&codec=1");
            sbStreamParameters.append("&aspect_ratio=");
            sbStreamParameters.append(aspectRatio);
            sbStreamParameters.append("&resol=");
            sbStreamParameters.append(resolution);
            sbStreamParameters.append("&frame_rate=");
            sbStreamParameters.append(frameRate);
            sbStreamParameters.append("&gop_interval=");
            sbStreamParameters.append(iFrameDistance);
            sbStreamParameters.append("&priority=0");
            sbStreamParameters.append("&picture_quality=").append(pictureQuality);
        }
        String sbRtspPort = "/cgi-bin/net.cgi?status=1";
        try {
            int endIndex;
            byte[] result = this.sanyoDevice.readGetRequest(this.networkParameter, sbRtspPort, Integer.MAX_VALUE);
            if (result == null) {
                this.logger.error("Error while reading Network Configuration " + this.getVideoSrv());
                return -21601;
            }
            String resultString = new String(result);
            int startIndex = resultString.indexOf("h_stream" + (this.streamNumber + 1)) + 11;
            if (startIndex != -1 && (endIndex = resultString.indexOf(")\r\n", startIndex)) != -1) {
                this.rtspUrl = "/" + resultString.substring(startIndex, endIndex);
            }
            if ((result = this.sanyoDevice.readGetRequest(this.networkParameter, "/cgi-bin/codec_stream.cgi?status=1", Integer.MAX_VALUE)) == null) {
                this.logger.error("Error reading Stream configuration");
            } else {
                String resultString2 = new String(result);
                if (!resultString2.contains("stream" + (this.streamNumber + 1) + "_sw:(1)") && this.sanyoDevice.readGetRequest(this.networkParameter, sbCreateStream, Integer.MAX_VALUE) == null) {
                    this.logger.error("Error while creating stream for " + this.getVideoSrv());
                    return -21601;
                }
            }
            if (this.isAudioEnabled) {
                if (this.sanyoDevice.readGetRequest(this.networkParameter, "/cgi-bin/codec_stream.cgi?audio_sw=1", Integer.MAX_VALUE) == null) {
                    this.logger.error("Error while setting stream parameter for " + this.getVideoSrv());
                    return -21601;
                }
                if (this.audioCodec == Codec.G711U) {
                    this.audioCodec = Codec.G711A;
                }
                this.audioSourceClient = new StreamingVideoSourceClientRTSP.AudioSourceClient(this.audioSourceClient);
            }
            if (this.sanyoDevice.readGetRequest(this.networkParameter, sbStreamParameters.toString(), Integer.MAX_VALUE) == null) {
                this.logger.error("Error while setting stream parameter for " + this.getVideoSrv());
                return -21601;
            }
            if (this.sanyoDevice.readGetRequest(this.networkParameter, "/cgi-bin/codec_stream.cgi?stream_set=" + this.streamNumber + "&submit=1", Integer.MAX_VALUE) == null) {
                this.logger.error("Error while setting stream parameters for " + this.getVideoSrv());
                return -21601;
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Error setting parameters on camera: " + (Object)((Object)ex));
            return -21601;
        }
        return 0;
    }

    @Override
    public void sendStatusService(int statusCode) {
        this.listener.sendStatusService(statusCode);
    }

    @Override
    protected int init() {
        try {
            this.networkParameter.setSoTimeout(5000);
            this.errorCode = super.init();
            if (this.errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
                return this.errorCode;
            }
            this.sanyoDevice = (SanyoDevice)((SanyoCameraSrv)this.getVideoSrv()).getDevice();
            this.sanyoDevice.setStartingStream(true);
            float aspectRatioValue = (float)this.width / (float)this.height;
            int aspectRatio = (double)aspectRatioValue < 1.5 ? 1 : 0;
            this.streamNumber = this.listener.getVideoProfileHandler().getDynamicVideoProfileID();
            this.errorCode = this.sanyoDevice.setGlobalCameraParameters(this.networkParameter, this.rotationAngle, this.getVideoSrv().getEntityType(), this.streamNumber, this.listener.getVideoSourceParameter().getRtspPort());
            if (this.errorCode != 0) {
                return this.errorCode;
            }
            try {
                this.result = this.sanyoDevice.readGetRequest(this.networkParameter, "/cgi-bin/cam_set.cgi?status=1", Integer.MAX_VALUE);
                if (this.result != null) {
                    String resultString = new String(this.result);
                    this.isPalFormat = !resultString.contains("tv_format:(0)");
                }
            }
            catch (SeeTecException ex) {
                this.logger.error("Error checking for tv format: " + (Object)((Object)ex));
            }
            this.iFrameDist = this.fps * (long)this.iFrameDistMS / 1000000L;
            this.quality /= 20000;
            this.quality = this.quality >= 5 ? 4 : this.quality;
            this.fps /= 1000L;
            this.fps = this.isPalFormat ? ((double)this.fps <= 6.5 ? 0L : ((double)this.fps <= 10.25 ? 1L : ((double)this.fps <= 18.75 ? 2L : 3L))) : ((double)this.fps <= 7.5 ? 0L : ((double)this.fps <= 12.5 ? 1L : ((double)this.fps <= 22.5 ? 2L : 3L)));
            if (this.width == 320) {
                this.resolution = 0;
            } else if (this.width == 640) {
                this.resolution = 1;
            } else if (this.width == 1024) {
                this.resolution = 2;
            } else if (this.width == 1280) {
                this.resolution = this.height == 720 ? 2 : 3;
            } else if (this.width == 1600) {
                this.resolution = 4;
            } else if (this.width == 1920) {
                this.resolution = 3;
            }
            this.errorCode = this.setHttpParameters(this.resolution, aspectRatio, this.fps, this.iFrameDist, this.quality);
            if (this.errorCode != 0) {
                this.logger.error("Could not set Video Parameters using http: " + this.errorCode);
                return this.errorCode;
            }
            this.logger.info("Starting stream number " + this.streamNumber);
            this.sanyoDevice.addStream();
            this.rtspUrl = "rtsp://" + this.getHost() + this.rtspUrl;
            this.rtspSettings = new RTSPStreamSettings();
            if (this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled) != 0) {
                this.logger.error("Error while setting RTSP Parameters for " + this);
                return -20001;
            }
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            if (this.rtspHandler.start() != 0) {
                this.logger.error("Error while starting RTSP for " + this);
                return -20001;
            }
            Thread keepAlive = new Thread((Runnable)new KeepAlive(), "KeepAliveThread");
            keepAlive.start();
            this.sanyoDevice.setStartingStream(false);
            this.logger.info("init done for" + this.getVideoSrv());
            return 0;
        }
        catch (Throwable t) {
            this.logger.error("Unexpected exception while initialization for " + this, t);
            return -20000;
        }
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.sanyoDevice != null) {
            this.sanyoDevice.setStartingStream(false);
            this.sanyoDevice.removeStream();
        }
        return super.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public void processData(byte[] data) {
        if (data.length > 24 && this.listener.hasHardwareMotionDetection() && (data[1] & 0x6F) == 111 && (data[23] & 2) == 2 && this.getVideoSrv() != null && this.getVideoSrv().getHardwareMotionDetection() != null) {
            ((SanyoMotionDetectionHandler)((Object)((SanyoHardwareMotionDetection)this.getVideoSrv().getHardwareMotionDetection()).getMotionDetectionHandler())).processMotionDetection();
        }
        this.processRtpData(data);
    }

    public int getFramerateCode(int framerate) {
        if (this.isPalFormat) {
            if (framerate < 150) {
                return 0;
            }
            if (framerate < 350) {
                return 1;
            }
            if (framerate < 750) {
                return 2;
            }
            if (framerate < 1750) {
                return 3;
            }
            if (framerate < 3750) {
                return 4;
            }
            if (framerate < 6500) {
                return 5;
            }
            if (framerate < 10250) {
                return 6;
            }
            if (framerate < 18750) {
                return 7;
            }
            return 8;
        }
        if (framerate < 150) {
            return 0;
        }
        if (framerate < 350) {
            return 1;
        }
        if (framerate < 750) {
            return 2;
        }
        if (framerate < 1750) {
            return 3;
        }
        if (framerate < 3750) {
            return 4;
        }
        if (framerate < 7500) {
            return 5;
        }
        if (framerate < 12500) {
            return 6;
        }
        if (framerate < 22500) {
            return 7;
        }
        return 8;
    }

    private class KeepAlive
    implements Runnable {
        private KeepAlive() {
        }

        @Override
        public void run() {
            long time = System.currentTimeMillis();
            SanyoH264VideoSourceClient2.this.logger.info("Start keep alive for " + SanyoH264VideoSourceClient2.this.getVideoSrv().getDevice());
            try {
                while (!SanyoH264VideoSourceClient2.this.isShutdown()) {
                    if (System.currentTimeMillis() > time + 60000L) {
                        SanyoH264VideoSourceClient2.this.sanyoDevice.readGetRequest(SanyoH264VideoSourceClient2.this.networkParameter, "/cgi-bin/codec_stream.cgi?status=1", Integer.MAX_VALUE);
                        time = System.currentTimeMillis();
                    }
                    Thread.sleep(10000L);
                }
            }
            catch (Exception e) {
                SanyoH264VideoSourceClient2.this.logger.error((Object)e, (Throwable)e);
            }
        }
    }
}

