/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.sanyo.jpeg;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoCameraSrv;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoDevice;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoMotionDetectionHandler;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class SanyoJPEGVideoSourceClient_HD2
extends JPEGVideoSourceClient
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.sanyo.jpeg.SanyoJPEGVideoSourceClient_HD2";
    private final byte[] END_OF_JPEG = new byte[]{-1, -39};
    private KeepAlive keepAliveThread = null;
    private int streamNumber = 0;
    private int aspect_ratio = 2;
    private int resolution = -1;
    private HttpServerPushHandler httpServerPushHandler = null;
    private int errorCode = 0;
    private int httpServerPushHandlerErrorCode = 0;
    private boolean restartingServerPush = false;
    private boolean isPalFormat = false;
    private SanyoDevice sanyoDevice = null;
    private long timeEndRestartServerPush = 0L;
    private int framerateCode;
    private int mfps;

    public long getMilliCompression() {
        return this.compression;
    }

    private int limitFramerate(long framerate, int aspect_ratio, int resolution) {
        if (this.isPalFormat) {
            if (aspect_ratio == 0) {
                if (resolution == 1 && framerate > 12500L) {
                    return 12500;
                }
                if (resolution == 2 && framerate > 8000L) {
                    return 8000;
                }
                if (resolution == 3 && framerate > 5000L) {
                    return 5000;
                }
            } else if (aspect_ratio == 1) {
                if ((resolution == 2 || resolution == 3) && framerate > 12500L) {
                    return 12500;
                }
                if (resolution == 4 && framerate > 8000L) {
                    return 8000;
                }
                if (resolution == 5 && framerate > 5000L) {
                    return 5000;
                }
                if (resolution == 6 && framerate > 2500L) {
                    return 2500;
                }
            }
        } else if (aspect_ratio == 0) {
            if (resolution == 0 && framerate > 30000L) {
                return 30000;
            }
            if (resolution == 1 && framerate > 15000L) {
                return 15000;
            }
            if (resolution == 2 && framerate > 10000L) {
                return 10000;
            }
            if (resolution == 3 && framerate > 5000L) {
                return 5000;
            }
        } else if (aspect_ratio == 1) {
            if ((resolution == 0 || resolution == 1) && framerate > 30000L) {
                return 30000;
            }
            if ((resolution == 2 || resolution == 3) && framerate > 15000L) {
                return 15000;
            }
            if (resolution == 4 && framerate > 10000L) {
                return 10000;
            }
            if (resolution == 5 && framerate > 5000L) {
                return 5000;
            }
            if (resolution == 6 && framerate > 3000L) {
                return 3000;
            }
        }
        return (int)framerate;
    }

    public int getFramerateCode(int framerate) {
        if (this.isPalFormat) {
            if (framerate < 150) {
                return 0;
            }
            if (framerate < 350) {
                return 1;
            }
            if (framerate < 750) {
                return 2;
            }
            if (framerate < 1750) {
                return 3;
            }
            if (framerate < 3750) {
                return 4;
            }
            if (framerate < 6500) {
                return 5;
            }
            if (framerate < 10250) {
                return 6;
            }
            if (framerate < 18750) {
                return 7;
            }
            return 8;
        }
        if (framerate < 150) {
            return 0;
        }
        if (framerate < 350) {
            return 1;
        }
        if (framerate < 750) {
            return 2;
        }
        if (framerate < 1750) {
            return 3;
        }
        if (framerate < 3750) {
            return 4;
        }
        if (framerate < 7500) {
            return 5;
        }
        if (framerate < 12500) {
            return 6;
        }
        if (framerate < 22500) {
            return 7;
        }
        return 8;
    }

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    @Override
    public int init() {
        this.networkParameter.setSoTimeout(5000);
        this.sanyoDevice = (SanyoDevice)((SanyoCameraSrv)this.getVideoSrv()).getDevice();
        int errorCode = super.init(false);
        if (errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + errorCode + " for " + this);
            return errorCode;
        }
        float aspectRatioValue = (float)this.width / (float)this.height;
        int aspectRatio = (double)aspectRatioValue < 1.5 ? 1 : 0;
        this.streamNumber = this.listener.getVideoProfileHandler().getDynamicVideoProfileID();
        this.logger.info("Starting stream number " + this.streamNumber + " for " + this);
        try {
            errorCode = this.sanyoDevice.setGlobalCameraParameters(this.networkParameter, this.rotationAngle, this.getVideoSrv().getEntityType(), this.streamNumber, this.listener.getVideoSourceParameter().getRtspPort());
            if (errorCode != 0) {
                return errorCode;
            }
        }
        catch (ConfigurationException ex) {
            this.logger.warn("RTSP port could not be read", (Throwable)ex);
        }
        try {
            String resultString;
            byte[] result = this.sanyoDevice.readGetRequest(this.networkParameter, "/cgi-bin/codec_stream.cgi?status=1", Integer.MAX_VALUE);
            if (result == null) {
                this.logger.error("Error reading Stream configuration");
            } else {
                String createStream;
                resultString = new String(result);
                if (!resultString.contains("stream" + (this.streamNumber + 1) + "_sw:(1)") && this.sanyoDevice.readGetRequest(this.networkParameter, createStream = "/cgi-bin/str_add.cgi?tmp_flag=" + this.streamNumber + "&submit=1", Integer.MAX_VALUE) == null) {
                    this.logger.error("Could not set Video Parameters");
                }
            }
            this.quality /= 20000;
            this.quality = this.quality > 4 ? 4 : this.quality;
            switch (this.width) {
                case 320: {
                    this.resolution = 0;
                    this.aspect_ratio = 1;
                    break;
                }
                case 640: {
                    if (this.height == 480) {
                        this.resolution = 1;
                        this.aspect_ratio = 1;
                        break;
                    }
                    this.resolution = 0;
                    this.aspect_ratio = 0;
                    break;
                }
                case 800: {
                    this.resolution = 2;
                    this.aspect_ratio = 1;
                    break;
                }
                case 1024: {
                    if (this.height == 768) {
                        this.resolution = 3;
                        this.aspect_ratio = 1;
                        break;
                    }
                    this.resolution = 1;
                    this.aspect_ratio = 0;
                    break;
                }
                case 1280: {
                    if (this.height == 960) {
                        this.resolution = 4;
                        this.aspect_ratio = 1;
                        break;
                    }
                    this.resolution = 2;
                    this.aspect_ratio = 0;
                    break;
                }
                case 1600: {
                    this.resolution = 5;
                    this.aspect_ratio = 1;
                    break;
                }
                case 1920: {
                    this.resolution = 3;
                    this.aspect_ratio = 0;
                    break;
                }
                case 2288: {
                    this.resolution = 6;
                    this.aspect_ratio = 1;
                    break;
                }
            }
            result = this.sanyoDevice.readGetRequest(this.networkParameter, "/cgi-bin/cam_set.cgi?status=1", Integer.MAX_VALUE);
            if (result != null) {
                resultString = new String(result);
                this.isPalFormat = !resultString.contains("tv_format:(0)");
            }
            this.framerateCode = this.getFramerateCode(this.limitFramerate(this.highestFramerate, this.aspect_ratio, this.resolution));
            this.mfps = this.limitFramerate(this.highestFramerate, this.aspect_ratio, this.resolution);
            StringBuilder sb = new StringBuilder();
            sb.append("/cgi-bin/codec_stream.cgi?");
            sb.append("aspect_ratio=");
            sb.append(aspectRatio);
            sb.append("&submit=1");
            if (this.sanyoDevice.readGetRequest(this.networkParameter, sb.toString(), Integer.MAX_VALUE) == null) {
                this.logger.error("Could not set aspect ratio");
            }
            sb = new StringBuilder();
            sb.append("/cgi-bin/codec_stream.cgi?stream_set=").append(this.streamNumber);
            sb.append("&name_stream=STREAM").append(this.streamNumber + 1);
            sb.append("&codec=0");
            sb.append("&resol=");
            sb.append(this.resolution);
            sb.append("&frame_rate=");
            sb.append(this.framerateCode);
            sb.append("&picture_quality=");
            sb.append(this.quality);
            sb.append("&priority=0");
            if (this.sanyoDevice.readGetRequest(this.networkParameter, sb.toString(), Integer.MAX_VALUE) == null) {
                this.logger.error("Could not set Video Parameters");
            }
            long seetecid = System.currentTimeMillis();
            if (this.sanyoDevice.readGetRequest(this.networkParameter, "/cgi-bin/codec_stream.cgi?submit=1&" + seetecid, Integer.MAX_VALUE) == null) {
                this.logger.error("Could not set Video Parameters");
            }
            this.sanyoDevice.addStream();
            this.keepAliveThread = new KeepAlive();
            this.keepAliveThread.init();
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
            return errorCode;
        }
        catch (SeeTecException se) {
            this.logger.error((Object)se, (Throwable)se);
            if (se.getErrorCode() == -21657) {
                return se.getErrorCode();
            }
            this.shutdown();
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            errorCode = -21651;
        }
        return errorCode;
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        this.httpServerPushHandlerErrorCode = this.restartServerPush(this.mfps);
        if (this.httpServerPushHandlerErrorCode != 0) {
            this.logger.error("Error starting server push: " + this.errorCode);
        }
        while (!this.isShutdown()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.isShutdown() || this.httpServerPushHandler != null && !this.httpServerPushHandler.isShutdown() && this.httpServerPushHandlerErrorCode == 0) continue;
            this.logger.info("Found HttpServerPushHandler down. Restarting...");
            this.shutdown();
        }
        super.setRunFinished(CLASS_NAME, true);
    }

    public int restartServerPush(int fps) {
        return this.restartServerPush(fps, 0);
    }

    public int restartServerPush(int fps, int waitingTime) {
        while (this.restartingServerPush) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                this.logger.error("Error waiting for Server Push to start for " + this + ": " + ex);
            }
        }
        this.restartingServerPush = true;
        if (this.httpServerPushHandler != null) {
            this.httpServerPushHandler.shutdown();
            this.httpServerPushHandler = null;
        }
        if (waitingTime > 0) {
            try {
                Thread.sleep(waitingTime);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        if (fps > 0) {
            try {
                StringBuilder sb;
                int tempFps = this.getFramerateCode(this.limitFramerate(this.highestFramerate, this.aspect_ratio, this.resolution));
                if (tempFps > this.framerateCode) {
                    this.framerateCode = tempFps;
                    sb = new StringBuilder(256);
                    sb.append("/cgi-bin/codec_stream.cgi?stream_set=").append(this.streamNumber);
                    sb.append("&frame_rate=");
                    sb.append(this.framerateCode);
                    sb.append("&submit=1");
                    if (this.sanyoDevice.readGetRequest(this.networkParameter, sb.toString(), Integer.MAX_VALUE) == null) {
                        this.logger.error("Could not set Video Parameters");
                    }
                }
                sb = new StringBuilder("/liveimg.cgi?serverpush=1&jpeg=1&stream=" + this.streamNumber);
                sb.append("&framerate=");
                fps = Math.min(fps, this.limitFramerate(fps, this.aspect_ratio, this.resolution));
                sb.append(Math.max(1, fps / 1000));
                this.highestFramerate = fps;
                this.httpServerPushHandler = new HttpServerPushHandler();
                int timeoutValue = 1000000 / fps + 5000;
                this.networkParameter.setSoTimeout(timeoutValue);
                if (this.sanyoDevice == null) {
                    this.sanyoDevice = (SanyoDevice)this.getVideoSrv().getDevice();
                }
                this.networkParameter.setAdditionalData(this.sanyoDevice.getCookie());
                this.errorCode = this.httpServerPushHandler.init(this, this.networkParameter, sb.toString());
                if (this.errorCode != 0) {
                    this.httpServerPushHandlerErrorCode = this.errorCode;
                    this.logger.error("Error [" + this.errorCode + "] with " + this.httpServerPushHandler);
                } else {
                    this.errorCode = this.httpServerPushHandler.startServerPush(true);
                    if (this.errorCode != 0) {
                        this.logger.error("Error [" + this.errorCode + "] while starting serverpush at " + this.httpServerPushHandler);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("Reading configuration from " + this.getVideoSrv().getDevice() + " failed", (Throwable)e);
                this.errorCode = -21601;
            }
        }
        if (this.isShutdown()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.info("Found VideoSourceClient down. Shutting down HttpServerPushHandler for " + this.getVideoSrv().getDevice());
            }
            this.httpServerPushHandler.shutdown();
            this.httpServerPushHandler = null;
        }
        this.timeEndRestartServerPush = System.currentTimeMillis();
        this.restartingServerPush = false;
        return this.errorCode;
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        this.listener.sendStatusService(nStatusCode);
    }

    @Override
    public void notifyForNetworkProblems() {
        long gracePeriod = 100L;
        if (!this.restartingServerPush && System.currentTimeMillis() - this.timeEndRestartServerPush > 100L) {
            this.listener.notifyForNetworkProblems();
            this.shutdown();
        }
    }

    @Override
    public void deliverContent(HttpServerPushContent httpServerPushContent) {
        int endOfJPEG;
        byte[] contentData = httpServerPushContent.getContentBody();
        if (this.listener.hasHardwareMotionDetection() && contentData != null && (endOfJPEG = Basic.indexOfByteArray((byte[])contentData, (byte[])this.END_OF_JPEG, (int)0)) != -1) {
            byte alarmInformation = contentData[endOfJPEG + 34];
            if ((alarmInformation = (byte)(alarmInformation & 2)) != 0 && alarmInformation == 2 && this.getVideoSrv() != null && this.getVideoSrv().getHardwareMotionDetection() != null) {
                ((SanyoMotionDetectionHandler)((Object)((SanyoHardwareMotionDetection)this.getVideoSrv().getHardwareMotionDetection()).getMotionDetectionHandler())).processMotionDetection();
            }
        }
        this.deliverContent(contentData);
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.httpServerPushHandler != null) {
            this.httpServerPushHandler.shutdown();
            this.httpServerPushHandler = null;
        }
        super.shutdown();
        if (this.sanyoDevice != null) {
            this.sanyoDevice.removeStream();
        }
        this.logger.info("shutdown done for " + this.getVideoSrv());
        return 0;
    }

    private class KeepAlive
    implements Runnable {
        private Thread keepAliveThread = null;

        private KeepAlive() {
        }

        public void init() {
            this.keepAliveThread = new Thread((Runnable)this, this.toString());
            this.keepAliveThread.start();
        }

        @Override
        public void run() {
            long time = System.currentTimeMillis();
            SanyoJPEGVideoSourceClient_HD2.this.logger.info("Start keep alive for " + SanyoJPEGVideoSourceClient_HD2.this.getVideoSrv().getDevice());
            try {
                while (!SanyoJPEGVideoSourceClient_HD2.this.isShutdown()) {
                    if (System.currentTimeMillis() > time + 60000L) {
                        SanyoJPEGVideoSourceClient_HD2.this.sanyoDevice.readGetRequest(SanyoJPEGVideoSourceClient_HD2.this.networkParameter, "/cgi-bin/codec_stream.cgi?status=1", Integer.MAX_VALUE);
                        time = System.currentTimeMillis();
                    }
                    Thread.sleep(10000L);
                }
            }
            catch (Exception e) {
                SanyoJPEGVideoSourceClient_HD2.this.logger.error((Object)e, (Throwable)e);
            }
        }
    }
}

