/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.sanyo.jpeg;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoCameraSrv;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoDevice;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoMotionDetectionHandler;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class SanyoJPEGVideoSourceClient_HD1
extends JPEGVideoSourceClient
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.sanyo.jpeg.SanyoJPEGVideoSourceClient_HD1";
    private final byte[] END_OF_JPEG = new byte[]{-1, -39};
    private KeepAlive keepAliveThread = null;
    private int resolution = -1;
    private HttpServerPushHandler httpServerPushHandler = null;
    private int errorCode = 0;
    private boolean restartingServerPush = false;
    private SanyoDevice sanyoDevice = null;
    private boolean isPalFormat = true;
    private int streamNumber = 0;
    private long gracePeriod = 100L;
    private long timeEndRestartServerPush = 0L;
    private int mfps;

    public long getMilliCompression() {
        return this.compression;
    }

    private int getFramerateCode(int fps) {
        if (fps <= 150) {
            return 0;
        }
        if (fps <= 350) {
            return 1;
        }
        if (fps <= 750) {
            return 2;
        }
        if (fps <= 1750 && this.isPalFormat) {
            return 3;
        }
        if (fps <= 2000 && !this.isPalFormat) {
            return 3;
        }
        if (fps <= 3750 && this.isPalFormat) {
            return 4;
        }
        if (fps <= 4000 && !this.isPalFormat) {
            return 4;
        }
        if (fps <= 6500 && this.isPalFormat) {
            return 5;
        }
        if (fps <= 7500 && !this.isPalFormat) {
            return 5;
        }
        if (fps <= 10250 && this.isPalFormat) {
            return 6;
        }
        if (fps <= 12500 && !this.isPalFormat) {
            return 6;
        }
        if (fps <= 18750 && this.isPalFormat) {
            return 7;
        }
        if (fps <= 22500 && !this.isPalFormat) {
            return 7;
        }
        if (fps > 18750 && this.isPalFormat) {
            return 8;
        }
        if (fps > 22500 && !this.isPalFormat) {
            return 8;
        }
        return 1;
    }

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    @Override
    public int init() {
        this.networkParameter.setSoTimeout(5000);
        this.streamNumber = 1;
        this.sanyoDevice = (SanyoDevice)((SanyoCameraSrv)this.getVideoSrv()).getDevice();
        this.errorCode = super.init(false);
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        float aspectRatioValue = (float)this.width / (float)this.height;
        int aspectRatio = (double)aspectRatioValue < 1.5 ? 1 : 0;
        try {
            this.errorCode = this.sanyoDevice.setGlobalCameraParameters(this.networkParameter, this.rotationAngle, this.getVideoSrv().getEntityType(), this.streamNumber, this.listener.getVideoSourceParameter().getRtspPort());
            if (this.errorCode != 0) {
                return this.errorCode;
            }
        }
        catch (ConfigurationException exception) {
            this.logger.warn("RTSP port could not be read", (Throwable)exception);
        }
        this.logger.info("Starting stream number " + this.streamNumber);
        byte[] result = null;
        this.mfps = (int)this.highestFramerate;
        int fpsCode = 0;
        this.quality /= 20000;
        int n = this.quality = this.quality > 4 ? 4 : this.quality;
        if (this.width == 320) {
            this.resolution = 0;
        } else if (this.width == 640) {
            this.resolution = this.height == 480 ? 1 : 0;
        } else if (this.width == 800) {
            this.resolution = 2;
        } else if (this.width == 1024) {
            this.resolution = this.height == 768 ? 3 : 1;
        } else if (this.width == 1280) {
            this.resolution = this.height == 960 ? 4 : 2;
        } else if (this.width == 1600) {
            this.resolution = 5;
        } else if (this.width == 1920) {
            this.resolution = 3;
        } else if (this.width == 2288) {
            this.resolution = 6;
        }
        try {
            result = this.sanyoDevice.readGetRequest(this.networkParameter, "/cgi-bin/cam_set.cgi?status=1", 512);
            if (result != null) {
                String resultString = new String(result);
                this.isPalFormat = resultString.indexOf("tv_format:(0)") == -1;
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while checking camera parameters for " + this + ": " + ex.getMessage());
        }
        fpsCode = this.getFramerateCode(this.mfps);
        StringBuilder sb = new StringBuilder(256);
        sb.append("/cgi-bin/codec_stream.cgi?");
        sb.append("&aspect_ratio=");
        sb.append(aspectRatio);
        sb.append("&submit=1");
        try {
            result = this.sanyoDevice.readGetRequest(this.networkParameter, sb.toString(), Integer.MAX_VALUE);
            if (result == null) {
                this.logger.error("Could not set aspect ratio");
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while setting camera parameters for " + this + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        sb = new StringBuilder(256);
        sb.append("/cgi-bin/codec_stream.cgi?");
        sb.append("jpeg_quality=");
        sb.append(this.quality);
        sb.append("&jpeg_resol=");
        sb.append(this.resolution);
        if (fpsCode < 3) {
            sb.append("&jframe_rate_admin=");
            sb.append(fpsCode);
        }
        try {
            result = this.sanyoDevice.readGetRequest(this.networkParameter, sb.toString(), Integer.MAX_VALUE);
            if (result == null) {
                this.logger.error("Could not set Video Parameters");
            }
            if ((result = this.sanyoDevice.readGetRequest(this.networkParameter, "/cgi-bin/codec_stream.cgi?submit=1", Integer.MAX_VALUE)) == null) {
                this.logger.error("Could not set Video Parameters");
            }
        }
        catch (SeeTecException se) {
            this.logger.error("Exception while setting camera parameters: ", (Throwable)se);
            if (se.getErrorCode() == -21657) {
                return se.getErrorCode();
            }
            this.shutdown();
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21651;
        }
        this.sanyoDevice.addStream();
        this.keepAliveThread = new KeepAlive();
        this.keepAliveThread.init();
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
        return this.errorCode;
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        int httpServerPushHandlerErrorCode = this.restartServerPush(this.mfps, 5000);
        if (httpServerPushHandlerErrorCode != 0) {
            this.logger.error("Error starting server push: " + this.errorCode);
        }
        while (!this.isShutdown()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.isShutdown() || this.httpServerPushHandler != null && !this.httpServerPushHandler.isShutdown() && httpServerPushHandlerErrorCode == 0) continue;
            this.logger.info("Found HttpServerPushHandler down. Restarting...");
            this.shutdown();
        }
        super.setRunFinished(CLASS_NAME, true);
    }

    public int restartServerPush(int fps, int waitingTime) {
        try {
            Thread.sleep(waitingTime);
        }
        catch (InterruptedException ex) {
            this.logger.error("Exception while waiting for camera to set parameters on " + this + ": " + ex);
        }
        return this.restartServerPush(fps);
    }

    public int restartServerPush(int fps) {
        this.restartingServerPush = true;
        this.highestFramerate = fps;
        if (this.httpServerPushHandler != null) {
            this.httpServerPushHandler.shutdown();
            this.httpServerPushHandler = null;
        }
        if (fps > 0) {
            try {
                StringBuilder sb = new StringBuilder("/liveimg.cgi?serverpush=1&jpeg=1");
                if (fps >= 1000) {
                    sb.append("&framerate=");
                    sb.append(fps / 1000);
                } else {
                    sb.append("&lowframerate=");
                    sb.append(fps / 10);
                }
                this.httpServerPushHandler = new HttpServerPushHandler();
                int timeoutValue = 1000000 / fps + 5000;
                this.networkParameter.setSoTimeout(timeoutValue);
                if (this.sanyoDevice == null) {
                    this.sanyoDevice = (SanyoDevice)this.getVideoSrv().getDevice();
                }
                this.networkParameter.setAdditionalData(this.sanyoDevice.getCookie());
                this.errorCode = this.httpServerPushHandler.init(this, this.networkParameter, sb.toString());
                if (this.errorCode != 0) {
                    this.logger.error("Error [" + this.errorCode + "] with " + this.httpServerPushHandler);
                } else {
                    this.errorCode = this.httpServerPushHandler.startServerPush(true);
                    if (this.errorCode != 0) {
                        this.logger.error("Error [" + this.errorCode + "] while starting serverpush at " + this.httpServerPushHandler);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("Reading configuration from " + this.getVideoSrv().getDevice() + " failed :-(", (Throwable)e);
                this.errorCode = -21601;
            }
        }
        if (this.isShutdown()) {
            this.httpServerPushHandler.shutdown();
            this.httpServerPushHandler = null;
        }
        this.timeEndRestartServerPush = System.currentTimeMillis();
        this.restartingServerPush = false;
        return this.errorCode;
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        this.listener.sendStatusService(nStatusCode);
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.httpServerPushHandler != null) {
            this.httpServerPushHandler.shutdown();
            this.httpServerPushHandler = null;
        }
        this.sanyoDevice.removeStream();
        super.shutdown();
        this.logger.info("shutdown done for " + this.getVideoSrv());
        return 0;
    }

    @Override
    public void notifyForNetworkProblems() {
        if (!this.restartingServerPush && System.currentTimeMillis() - this.timeEndRestartServerPush > this.gracePeriod) {
            this.listener.notifyForNetworkProblems();
            super.shutdown();
        }
    }

    @Override
    public void deliverContent(HttpServerPushContent httpServerPushContent) {
        byte[] contentData = httpServerPushContent.getContentBody();
        if (this.listener.hasHardwareMotionDetection() && contentData != null) {
            int endOfJPEG = -1;
            endOfJPEG = Basic.indexOfByteArray((byte[])contentData, (byte[])this.END_OF_JPEG, (int)0);
            if (endOfJPEG != -1) {
                byte alarmInformation = contentData[endOfJPEG + 34];
                if ((alarmInformation = (byte)(alarmInformation & 2)) != 0 && alarmInformation == 2 && this.getVideoSrv() != null && this.getVideoSrv().getHardwareMotionDetection() != null) {
                    ((SanyoMotionDetectionHandler)((Object)((SanyoHardwareMotionDetection)this.getVideoSrv().getHardwareMotionDetection()).getMotionDetectionHandler())).processMotionDetection();
                }
            }
        }
        this.deliverContent(contentData);
    }

    private class KeepAlive
    implements Runnable {
        Thread keepAliveThread = null;

        private KeepAlive() {
        }

        public void init() {
            this.keepAliveThread = new Thread((Runnable)this, this.toString());
            this.keepAliveThread.start();
        }

        @Override
        public void run() {
            long time = System.currentTimeMillis();
            SanyoJPEGVideoSourceClient_HD1.this.logger.info("Start keep alive for " + SanyoJPEGVideoSourceClient_HD1.this.getVideoSrv().getDevice());
            try {
                while (!SanyoJPEGVideoSourceClient_HD1.this.isShutdown()) {
                    if (System.currentTimeMillis() > time + 60000L) {
                        SanyoJPEGVideoSourceClient_HD1.this.sanyoDevice.readGetRequest(SanyoJPEGVideoSourceClient_HD1.this.networkParameter, "/cgi-bin/codec_stream.cgi?status", Integer.MIN_VALUE);
                        time = System.currentTimeMillis();
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                SanyoJPEGVideoSourceClient_HD1.this.logger.error("Exception while doing keep-alive routine for " + this, (Throwable)e);
            }
        }
    }
}

