/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.sanyo;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoCameraControl;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoDevice;
import de.seetec.v5.re.cm.device.video.sanyo.jpeg.SanyoJPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.sanyo.jpeg.SanyoJPEGVideoSourceClient_HD1;
import de.seetec.v5.re.cm.device.video.sanyo.jpeg.SanyoJPEGVideoSourceClient_HD2;
import de.seetec.v5.re.cm.device.video.sanyo.mpeg.SanyoH264VideoSourceClient1;
import de.seetec.v5.re.cm.device.video.sanyo.mpeg.SanyoH264VideoSourceClient2;
import de.seetec.v5.re.cm.device.video.sanyo.mpeg.SanyoMPEGVideoSourceClient;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class SanyoCameraSrv
extends LiveCameraSrv {
    private NetworkParameter networkParameter = null;
    private String cookie = null;
    private SanyoDevice sanyoDevice = null;

    @Override
    public CameraControl createCameraControl(Long nEntityType) {
        return new SanyoCameraControl();
    }

    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        int errorCode = 0;
        if (this.sanyoDevice == null) {
            this.sanyoDevice = (SanyoDevice)this.getDevice();
        }
        VideoSourceClient videoSourceClient = null;
        long nEntityType = super.getEntityType();
        try {
            this.logger.info("StreamingMode for " + this + " is [" + listener.getVideoSourceParameter().getMediaCodec() + "]");
            if (this.networkParameter == null) {
                try {
                    this.networkParameter = this.getDevice().getDeviceCnf().getNetworkParameter();
                    this.networkParameter.setSoTimeout(5000);
                }
                catch (ConfigurationException ex) {
                    this.logger.error("Could not retrieve network parameters: " + (Object)((Object)ex));
                }
            }
            this.cookie = this.sanyoDevice.getCookie();
            if (this.cookie == null && (nEntityType == 211901L || nEntityType == 211920L)) {
                this.cookie = this.sanyoDevice.readCookie(null, "/cgi-bin/lang.cgi");
                if (this.cookie.isEmpty()) {
                    this.logger.error("Error reading cookie from camera");
                } else {
                    this.networkParameter.setAdditionalData(this.cookie);
                    this.sanyoDevice.setCookie(this.cookie);
                }
            } else {
                this.networkParameter.setAdditionalData(this.cookie);
            }
            videoSourceClient = listener.getVideoSourceParameter().getMediaCodec() == Codec.H264 ? (nEntityType == 211902L || nEntityType == 211911L || nEntityType == 211903L || nEntityType == 211912L || nEntityType == 211905L || nEntityType == 211914L || nEntityType == 211906L || nEntityType == 211915L ? new SanyoH264VideoSourceClient1() : (nEntityType == 211904L || nEntityType == 211913L || nEntityType == 211907L || nEntityType == 211916L || nEntityType == 211908L || nEntityType == 211917L || nEntityType == 211909L || nEntityType == 211918L || nEntityType == 211910L || nEntityType == 211919L ? new SanyoH264VideoSourceClient2() : new SanyoMPEGVideoSourceClient())) : (nEntityType == 211902L || nEntityType == 211911L || nEntityType == 211903L || nEntityType == 211912L || nEntityType == 211905L || nEntityType == 211914L || nEntityType == 211906L || nEntityType == 211915L ? new SanyoJPEGVideoSourceClient_HD1() : (nEntityType == 211904L || nEntityType == 211913L || nEntityType == 211907L || nEntityType == 211916L || nEntityType == 211908L || nEntityType == 211917L || nEntityType == 211909L || nEntityType == 211918L || nEntityType == 211910L || nEntityType == 211919L ? new SanyoJPEGVideoSourceClient_HD2() : new SanyoJPEGVideoSourceClient()));
            errorCode = videoSourceClient.init(core, this, listener);
            if (errorCode != 0) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
                this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "] :-(");
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
        }
        catch (SeeTecException seetecEx) {
            throw seetecEx;
        }
        catch (Throwable ex) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            this.logger.error((Object)ex, ex);
            this.logger.error("Creating [VideoSourceClient] for " + this + " failed :-(");
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        return videoSourceClient;
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] nResolution) throws SeeTecException {
        throw new SeeTecException(-20009, "NOT YET IMPLEMENTED :-(");
    }
}

