/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.sanyo;

import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoCameraSrv;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoDevice;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Vector;

public class SanyoCameraControl
extends CameraControl {
    SanyoDevice sanyoDevice = null;
    private int zoomDirection;
    private static final int ZOOM_IN = 1;
    private static final int ZOOM_OUT = -1;
    private int oldZoomDirection = 0;
    private int ZOOM_STOP = 0;
    private String previousPTCommand;

    private byte[] sendCameraCommand(String url) {
        return this.sendCameraCommand(url, false);
    }

    private byte[] sendCameraCommand(String url, boolean readResult) {
        try {
            byte[] result = null;
            if (this.sanyoDevice == null) {
                this.sanyoDevice = (SanyoDevice)((SanyoCameraSrv)this.videoSrv).getDevice();
            }
            this.videoSrv.notifyForCameraControl();
            result = readResult ? this.sanyoDevice.readGetRequest(this.networkParameter, url, Integer.MAX_VALUE) : this.sanyoDevice.readGetRequest(this.networkParameter, url, Integer.MIN_VALUE);
            return result;
        }
        catch (SeeTecException ex) {
            this.logger.info(ex.getMessage());
            return null;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return null;
        }
    }

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        int pan = 0;
        int tilt = 0;
        int zoom = 0;
        if (panSpeed != null) {
            this.previousPanSpeed = pan = panSpeed.intValue();
        } else {
            pan = this.previousPanSpeed;
        }
        if (tiltSpeed != null) {
            this.previousTiltSpeed = tilt = tiltSpeed.intValue();
        } else {
            tilt = this.previousTiltSpeed;
        }
        if (zoomSpeed != null) {
            this.previousZoomSpeed = zoom = zoomSpeed.intValue();
        } else {
            zoom = this.previousZoomSpeed;
        }
        int localPanSpeed = 0;
        int localTiltSpeed = 0;
        try {
            StringBuilder sb;
            if (panSpeed != null || tiltSpeed != null) {
                sb = new StringBuilder(256);
                if (tilt == 0 && pan == 0) {
                    sb.append("/cgi-bin/opecmd.cgi?ope=51&cmd=12");
                    this.previousPTCommand = sb.toString();
                    this.sendCameraCommand(sb.toString(), true);
                    this.sendCameraCommand(sb.toString(), true);
                } else {
                    sb.append("/cgi-bin/opecmd.cgi?ope=51&cmd=");
                    localPanSpeed = Math.abs(pan);
                    if (localPanSpeed != 0) {
                        localPanSpeed = localPanSpeed > 80000 ? 7 : (localPanSpeed > 40000 ? 6 : (localPanSpeed > 20000 ? 5 : (localPanSpeed > 10000 ? 4 : (localPanSpeed > 5000 ? 3 : (localPanSpeed > 2500 ? 2 : 1)))));
                    }
                    if ((localTiltSpeed = Math.abs(tilt)) != 0) {
                        localTiltSpeed = localTiltSpeed > 80000 ? 7 : (localTiltSpeed > 40000 ? 6 : (localTiltSpeed > 20000 ? 5 : (localTiltSpeed > 10000 ? 4 : (localTiltSpeed > 5000 ? 3 : (localTiltSpeed > 2500 ? 2 : 1)))));
                    }
                    if (pan < 0 && tilt < 0) {
                        sb.append("6");
                    } else if (pan < 0 && tilt > 0) {
                        sb.append("1");
                    } else if (pan > 0 && tilt > 0) {
                        sb.append("3");
                    } else if (pan > 0 && tilt < 0) {
                        sb.append("8");
                    } else if (pan == 0 && tilt > 0) {
                        sb.append("2");
                    } else if (pan == 0 && tilt < 0) {
                        sb.append("7");
                    } else if (pan > 0 && tilt == 0) {
                        sb.append("5");
                    } else if (pan < 0 && tilt == 0) {
                        sb.append("4");
                    }
                    sb.append("&p_speed=");
                    sb.append(localPanSpeed);
                    sb.append("&t_speed=");
                    sb.append(localTiltSpeed);
                    if (!sb.toString().equals(this.previousPTCommand)) {
                        this.sendCameraCommand(sb.toString(), true);
                    }
                    this.previousPTCommand = sb.toString();
                }
            }
            if (zoomSpeed != null) {
                this.zoomDirection = zoom < 0 ? -1 : (zoom > 0 ? 1 : this.ZOOM_STOP);
                if (this.oldZoomDirection == this.zoomDirection) {
                    return 0;
                }
                if (this.oldZoomDirection == 1 && this.zoomDirection == -1 || this.oldZoomDirection == -1 && this.zoomDirection == 1 || this.zoomDirection == this.ZOOM_STOP) {
                    sb = new StringBuilder(256);
                    sb.append("/cgi-bin/opecmd.cgi?ope=51&cmd=11");
                    this.sendCameraCommand(sb.toString(), false);
                    this.sendCameraCommand(sb.toString(), false);
                }
                this.oldZoomDirection = this.zoomDirection;
                if (this.zoomDirection != this.ZOOM_STOP) {
                    sb = new StringBuilder(256);
                    sb.append("/cgi-bin/opecmd.cgi?ope=51&cmd=");
                    if (this.zoomDirection == -1) {
                        sb.append("10");
                    } else if (this.zoomDirection == 1) {
                        sb.append("9");
                    }
                    this.sendCameraCommand(sb.toString(), false);
                }
            }
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousIris(Integer value) {
        block9: {
            int entityID;
            if (value == null || value == 0) break block9;
            if (this.sanyoDevice == null) {
                this.sanyoDevice = (SanyoDevice)((SanyoCameraSrv)this.videoSrv).getDevice();
            }
            if ((long)(entityID = this.sanyoDevice.getDeviceEntity().getEntityType().intValue()) == 201900L) {
                if (value > 0) {
                    this.sendCameraCommand("/cgi-bin/opecmd.cgi?ope=50&action=0");
                } else {
                    this.sendCameraCommand("/cgi-bin/opecmd.cgi?ope=50&action=1");
                }
            } else {
                this.sendCameraCommand("/cgi-bin/camera_quality.cgi?iris_sw=1");
                if (value > 0) {
                    for (int i = 0; i < 5; ++i) {
                        this.sendCameraCommand("/cgi-bin/opecmd.cgi?ope=50&action=0");
                    }
                } else {
                    for (int i = 0; i < 5; ++i) {
                        this.sendCameraCommand("/cgi-bin/opecmd.cgi?ope=50&action=1");
                    }
                }
            }
        }
        return 0;
    }

    @Override
    public int setAutoIris(Boolean active) {
        String url = null;
        url = active != false ? "/cgi-bin/camera_quality.cgi?iris_sw=0" : "/cgi-bin/camera_quality.cgi?iris_sw=1";
        if (this.sendCameraCommand(url) == null) {
            return -21653;
        }
        return 0;
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousFocus(Integer value) {
        if (value != null && value != 0) {
            if (value > 0) {
                this.sendCameraCommand("/cgi-bin/opecmd.cgi?ope=49&action=0");
            } else {
                this.sendCameraCommand("/cgi-bin/opecmd.cgi?ope=49&action=1");
            }
        }
        return 0;
    }

    @Override
    public int setAutoFocus(Boolean active) {
        if (active.booleanValue()) {
            this.sendCameraCommand("/cgi-bin/opecmd.cgi?ope=49&action=3");
        }
        return 0;
    }

    @Override
    public int setZeroLux(Boolean active) {
        if (active.booleanValue()) {
            this.sendCameraCommand("/cgi-bin/opecmd.cgi?ope=12&num=2");
        } else {
            this.sendCameraCommand("/cgi-bin/opecmd.cgi?ope=12&num=1");
        }
        return 0;
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        if (active.booleanValue()) {
            this.sendCameraCommand("/cgi-bin/opecmd.cgi?ope=12&num=0");
        }
        return 0;
    }

    @Override
    public int setHomePosition() {
        return 0;
    }

    @Override
    public int addPresetPosition(Vector<byte[]> result, Long presetID, String presetName) {
        int presetPosition = -1;
        try {
            int i;
            byte[] vector = new byte[256];
            for (i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                vector[Integer.parseInt((String)presetCnf.getPresetPosition())] = 1;
            }
            for (i = 1; i < vector.length; ++i) {
                if (vector[i] != 0) continue;
                presetPosition = i;
                break;
            }
            if (presetPosition < 0) {
                this.logger.error("Cannot add preset [" + presetName + "], 'cause no more free preset positions are available for " + this + " :-(");
                return -21600;
            }
            PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, "" + presetPosition, presetName);
            this.presetList.addElement(presetCnf);
            result.addElement(presetCnf.getPresetCnf());
            this.sendCameraCommand("/cgi-bin/opecmd.cgi?ope=8&registration=" + presetPosition);
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            this.logger.error("Adding preset [" + presetName + "] failed :-(");
            return -21600;
        }
    }

    @Override
    public int setPresetPosition(String presetName) {
        try {
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                if (!presetName.equals(presetCnf.getPresetName())) continue;
                this.sendCameraCommand("/cgi-bin/opecmd.cgi?ope=11&execution=" + presetCnf.getPresetPosition());
                return 0;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Setting preset [" + presetName + "] failed :-(");
            return -21600;
        }
        this.logger.error("Preset [" + presetName + "] not available :-(");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }

    @Override
    public int removePresetPosition(String presetName) {
        try {
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = (PresetCnf)this.presetList.elementAt(i);
                if (!presetName.equals(presetCnf.getPresetName())) continue;
                this.presetList.removeElementAt(i);
                return 0;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Removing preset [" + presetName + "] failed :-(");
            return -21600;
        }
        this.logger.error("Preset [" + presetName + "] not available :-(");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }
}

