/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.santec;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.santec.SantecDevice;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;

public class SantecIOHandler
extends IOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.santec.SantecIOHandler";

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            boolean bPreviousLoopWithError = false;
            while (!(this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device.isShutdown())) {
                try {
                    long duration;
                    long ts = System.currentTimeMillis();
                    this.readDigitalInputs();
                    if (bPreviousLoopWithError) {
                        bPreviousLoopWithError = false;
                        this.logger.info("Publishing input stati after error for " + this + " ...");
                        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
                        for (int i = 0; i < iServices.length; ++i) {
                            if (!iServices[i].getEntity().isEnabled().booleanValue()) continue;
                            iServices[i].publishServiceStatus(iServices[i].getInputStatus());
                        }
                    }
                    if ((duration = System.currentTimeMillis() - ts) < 0L || duration >= 190L) continue;
                    try {
                        Thread.sleep(200L - duration);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Throwable ex) {
                    bPreviousLoopWithError = true;
                    if (ex instanceof IOException || ex instanceof UnknownHostException || ex instanceof NoRouteToHostException || ex instanceof ConnectException) {
                        this.logger.warn("Network trouble for " + this);
                    } else {
                        this.logger.warn((Object)ex, ex);
                        if (ex.getMessage().contains("Address already in use")) {
                            this.logger.warn("TCP stack seems to be overloaded, so there are problems for " + this);
                        } else {
                            this.logger.warn("Unknown trouble for " + this);
                        }
                    }
                    try {
                        DigitalInputSrv[] iServices;
                        for (DigitalInputSrv iService : iServices = super.getDigitalInputSrv()) {
                            if (!iService.getEntity().isEnabled().booleanValue()) continue;
                            iService.publishServiceStatus(-21603);
                        }
                    }
                    catch (Throwable t) {
                        this.logger.warn((Object)t, t);
                    }
                    long tsTimeout = System.currentTimeMillis() + 10000L;
                    while (tsTimeout > System.currentTimeMillis() && !this.isShutdown(CLASS_NAME) && !this.device.isShutdown()) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        this.logger.info("Thread of this " + this + " finished :-)");
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    private int readDigitalInputs() throws Exception {
        DigitalInputSrv[] iServices;
        for (DigitalInputSrv iService : iServices = super.getDigitalInputSrv()) {
            String url = "/nvc-cgi/admin/param.fcgi?action=list&group=DIDO.DI.Ch" + (iService.getInputNumber() - 1) + ".trig";
            String sDigitalInput = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)65536));
            if (sDigitalInput.contains("close")) {
                iService.checkInput(1);
                continue;
            }
            iService.checkInput(0);
        }
        return 0;
    }

    @Override
    public int writeDigitalOutput(int nNumber, int value, long holdTime) {
        int errorCode = 0;
        StringBuilder url = new StringBuilder();
        try {
            IOHandler.HoldTimer holdTimer;
            url.append("/nvc-cgi/admin/param.fcgi?action=update&group=DIDO.DO.Ch");
            url.append(nNumber - 1);
            url.append("&trig=");
            if (value == 0) {
                url.append("off");
            } else {
                url.append("on");
            }
            SantecDevice santecDevice = (SantecDevice)this.device;
            if (santecDevice.isIpxIpnDevice()) {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE);
            } else {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString());
            }
            if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(nNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                holdTimer.shutdown();
                this.logger.warn("Creating " + holdTimer + " failed with error [" + errorCode + "] :-(");
            }
            return 0;
        }
        catch (SeeTecException sex) {
            this.logger.error((Object)sex, (Throwable)sex);
            return sex.getErrorCode();
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }
}

