/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.samsung.mpeg;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.samsung.SamsungDevice;
import de.seetec.v5.re.cm.device.video.samsung.SamsungNetworkHelperAdapter;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.net.SeetecHttpClient;
import de.seetec.v5.shared.util.SeeTecException;

public class SamsungH264VideoSourceClient
extends StreamingVideoSourceClientRTSP {
    static final String CONTENTLENGTH = "content-length: ";
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.samsung.mpeg.SamsungH264VideoSourceClient";
    private int resolution = 0;
    private boolean isPal = true;
    private int bitrate = 0;
    private long gopSize = 0L;
    private int framesPerSecond = 0;
    private int compressionOnCamera;
    private SamsungDevice samsungDevice;
    private int h264ConfigurationMode;
    private final SeetecHttpClient samsungHttpClient = new SamsungNetworkHelperAdapter();

    @Override
    public int init() {
        try {
            this.errorCode = super.init();
            if (this.errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
                return this.errorCode;
            }
            this.samsungDevice = (SamsungDevice)this.getVideoSrv().getDevice();
            this.samsungDevice.setModelInformation();
            this.errorCode = this.samsungDevice.handleGlobalParameters(this.rotationAngle, this.useDateTime, this.useTitle, this.title, "");
            if (this.errorCode != 0) {
                if (this.errorCode == -21657) {
                    return this.errorCode;
                }
                this.logger.error("Error while setting global camera parameters: " + this.errorCode + " for " + this);
                return this.errorCode;
            }
            this.h264ConfigurationMode = this.samsungDevice.getH264ConfigurationMode();
            byte[] result = null;
            try {
                String networkConfigurationUrl = "/cgi-bin/basic.cgi?msubmenu=ip&action=view";
                result = this.samsungHttpClient.readGetRequest(this.networkParameter, networkConfigurationUrl, Integer.MAX_VALUE, true);
                String networkString = new String(result);
                int startIndex = networkString.indexOf("rtsp_port:") + 10;
                int endIndex = networkString.indexOf("\r\n", startIndex);
                networkString = networkString.substring(startIndex, endIndex);
                int rtspPort = Integer.parseInt(networkString);
                if (rtspPort != this.listener.getVideoSourceParameter().getRtspPort()) {
                    if ((this.listener.getVideoSourceParameter().getRtspPort() > 65535 || this.listener.getVideoSourceParameter().getRtspPort() < 10000 || this.listener.getVideoSourceParameter().getRtspPort() % 2 == 1) && this.listener.getVideoSourceParameter().getRtspPort() != 554) {
                        this.logger.warn("Invalid RTSP Port value. Valid ports for this camera model are: 554, 10000 - 65535, and they must be even numbers!");
                    }
                    this.samsungHttpClient.readGetRequest(this.networkParameter, "/cgi-bin/basic.cgi?msubmenu=ip&action=apply&rtsp_port=" + this.listener.getVideoSourceParameter().getRtspPort(), Integer.MAX_VALUE, true);
                    this.logger.info("Restarting camera...");
                    this.samsungHttpClient.readGetRequest(this.networkParameter, "/cgi-bin/system.cgi?submenu=reset&action=restart", Integer.MAX_VALUE, true);
                    this.shutdown();
                }
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while trying to read network configuration from camera: " + ex.getMessage() + ", error code: " + ex.getErrorCode());
                if (ex.getErrorCode() == -20001) {
                    return -21656;
                }
                return ex.getErrorCode();
            }
            this.framesPerSecond = this.samsungDevice.getFramerate(this.fps, this.width, this.height, Codec.H264);
            this.resolution = this.samsungDevice.getResolution(this.width, this.height);
            this.isPal = this.samsungDevice.getIsPal();
            if (!this.isPal) {
                if (this.width == 704) {
                    this.height = 480;
                }
                if (this.width == 352) {
                    this.height = 240;
                }
            }
            if (this.isConstantBitrateUsed) {
                this.bitrate = this.getBitRate(this.samsungDevice.getBitRateMode(), this.resolution, this.framesPerSecond, this.bandwidth);
                if (this.samsungDevice.setCompressionAndBitrate()) {
                    if (this.samsungDevice.getCompressionMode() == 1) {
                        this.compression /= 5000;
                        this.compression = this.compression < 1 ? 1 : this.compression;
                        this.compression = this.compression > 20 ? 20 : this.compression;
                        this.compression *= 5;
                    } else if (this.samsungDevice.getCompressionMode() == 2) {
                        this.compression /= 5000;
                        this.compression = this.compression < 1 ? 1 : this.compression;
                        this.compression = this.compression > 20 ? 20 : this.compression;
                    }
                }
            } else if (this.samsungDevice.getCompressionMode() == 1) {
                this.compression /= 5000;
                this.compression = this.compression < 1 ? 1 : this.compression;
                this.compression = this.compression > 20 ? 20 : this.compression;
                this.compression *= 5;
            } else if (this.samsungDevice.getCompressionMode() == 2) {
                this.compression /= 5000;
                this.compression = this.compression < 1 ? 1 : this.compression;
                int n = this.compression = this.compression > 20 ? 20 : this.compression;
            }
            if (this.samsungDevice.getGopSizeMode() == 1) {
                int fps4GopSize = this.isPal ? (this.framesPerSecond == 0 ? 25000 : (this.framesPerSecond == 1 ? 13000 : (this.framesPerSecond == 2 ? 6000 : (this.framesPerSecond == 3 ? 3000 : 1000)))) : (this.framesPerSecond == 0 ? 30000 : (this.framesPerSecond == 1 ? 15000 : (this.framesPerSecond == 2 ? 8000 : (this.framesPerSecond == 3 ? 3000 : 1000))));
                this.gopSize = Tools.convertIFrameDistMStoFrameCount(fps4GopSize, this.iFrameDistMS, 5, 15);
            } else if (this.samsungDevice.getGopSizeMode() == 2) {
                String[] parameters;
                int[] gop = null;
                result = this.samsungHttpClient.readGetRequest(this.networkParameter, "/cgi-bin/about.cgi?msubmenu=capability&action=view", Integer.MAX_VALUE, true);
                for (String parameter : parameters = new String(result).split("\r\n")) {
                    String gopParameters;
                    String[] gopLengthLines;
                    if (!parameter.contains("Video.GOP") || !parameter.contains(",") || (gopLengthLines = (gopParameters = parameter.trim().replace("\r", "").replace("\n", "")).split(":")).length != 2) continue;
                    String[] gopLengths = gopLengthLines[1].split(",");
                    gop = new int[gopLengths.length];
                    for (int j = 0; j < gop.length; ++j) {
                        try {
                            gop[j] = Integer.parseInt(gopLengths[j]);
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            this.logger.warn("Could not parse \"" + gopLengths[j] + "\" to number for " + this);
                        }
                    }
                }
                if (gop != null) {
                    this.gopSize = Tools.convertIFrameDistMStoFrameCount(this.fps, this.iFrameDistMS, 0, Integer.MAX_VALUE);
                    this.gopSize = Tools.convertToCameraValues(gop, (int)this.gopSize);
                } else {
                    this.gopSize = Tools.convertIFrameDistMStoFrameCount(this.fps, this.iFrameDistMS, 1, 15);
                }
            }
            StringBuilder sb = new StringBuilder("/cgi-bin/basic.cgi?msubmenu=video&action=apply");
            if (this.samsungDevice.getCodecSelectMode() == 1) {
                sb.append("&codec_select=1");
            }
            sb.append("&h4_resolution=");
            sb.append(this.resolution);
            sb.append("&h4_frate=");
            sb.append(this.framesPerSecond);
            if (this.isConstantBitrateUsed) {
                sb.append("&h4_bit_control=0");
                sb.append("&h264_bitrate=");
                sb.append(this.bitrate);
                if (this.samsungDevice.setCompressionAndBitrate()) {
                    sb.append("&h4_compression=");
                    sb.append(this.compression);
                }
            } else {
                if (this.samsungDevice.getBitRateMode() == 1) {
                    sb.append("&h264_bitrate=9");
                } else if (this.samsungDevice.getBitRateMode() == 2) {
                    this.bitrate = this.getBitRate(this.samsungDevice.getBitRateMode(), this.resolution, this.framesPerSecond, Integer.MAX_VALUE);
                    sb.append("&h264_bitrate=");
                    sb.append(this.bitrate);
                }
                sb.append("&h4_bit_control=1");
                sb.append("&h4_compression=");
                sb.append(this.compression);
            }
            sb.append("&h4_gopsize=");
            sb.append(this.gopSize);
            if (this.h264ConfigurationMode == 2) {
                sb.append("&profile_no=2");
            }
            try {
                result = this.samsungHttpClient.readGetRequest(this.networkParameter, sb.toString(), Integer.MAX_VALUE, true);
            }
            catch (SeeTecException see) {
                this.logger.error((Object)see, (Throwable)see);
                this.errorCode = see.getErrorCode();
                return this.errorCode;
            }
            catch (Exception e) {
                this.logger.error((Object)e, (Throwable)e);
                return -21601;
            }
            if (this.isAudioEnabled && this.samsungDevice.isHasAudio()) {
                this.logger.info("Audio enabled for " + this.getVideoSrv());
                try {
                    this.samsungHttpClient.readGetRequest(this.networkParameter, "/live_view.cgi?msubmenu=Listen", Integer.MIN_VALUE, true);
                }
                catch (SeeTecException ex) {
                    this.logger.error("Error enabling Audio from Camera: " + (Object)((Object)ex));
                    return ex.getErrorCode();
                }
            }
            String rtspPath = this.samsungDevice.getRtspPath();
            this.rtspUrl = "rtsp://" + this.getHost() + rtspPath;
            int compressionChangeWaitingTime = this.samsungDevice.getCompressionChangeWaitingTime();
            if (compressionChangeWaitingTime > 0) {
                try {
                    String cameraParameters = new String(this.samsungHttpClient.readGetRequest(this.networkParameter, "/cgi-bin/basic.cgi?msubmenu=video&action=view2", Integer.MAX_VALUE, true));
                    this.compressionOnCamera = Integer.parseInt(this.samsungDevice.parseCameraData(cameraParameters, "h4_compression", ":", "\r\n"));
                }
                catch (SeeTecException ex) {
                    this.logger.error("Exception while retrieving camera data for " + this + ": " + ex.getMessage());
                }
                if (this.compressionOnCamera != this.compression) {
                    this.logger.info("Compression changed. Waiting to avoid picture errors for " + this);
                    try {
                        Thread.sleep(compressionChangeWaitingTime);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
            }
            this.rtspSettings = new RTSPStreamSettings();
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 4, "*");
            if (this.errorCode != 0) {
                this.logger.error("Initialization of RTSPSettings failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
            int[] resolutionForTest = new int[]{this.width, this.height};
            this.rtspSettings.setCheckResolution(true, resolutionForTest);
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.errorCode = this.rtspHandler.start();
            if (this.errorCode != 0) {
                this.logger.error("Starting of RTSP Handler failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.logger.info("init done for" + this.getVideoSrv());
            return 0;
        }
        catch (Throwable t) {
            this.logger.error("Unexpected exception while initialization for " + this, t);
            return -20000;
        }
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void sendStatusService(int statusCode) {
        this.listener.sendStatusService(statusCode);
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        this.listener.notifyForNetworkProblems();
        this.shutdown();
    }

    private int getBitRate(int bitRateMode, int resolution, long fps, int bandwidth) {
        int ret = 0;
        if (bitRateMode == 1 || bitRateMode == 3) {
            int i;
            double[] bitrateValues = new double[]{4096.0, 3072.0, 2560.0, 2048.0, 1536.0, 1280.0, 1024.0, 768.0, 512.0, 256.0};
            for (i = 0; i < bitrateValues.length; ++i) {
                if (resolution == 2) {
                    int n = i;
                    bitrateValues[n] = bitrateValues[n] / 4.0;
                }
                if (fps == 1L) {
                    int n = i;
                    bitrateValues[n] = bitrateValues[n] / 2.0;
                }
                if (fps == 2L) {
                    int n = i;
                    bitrateValues[n] = bitrateValues[n] / 4.0;
                }
                if (fps == 3L) {
                    int n = i;
                    bitrateValues[n] = bitrateValues[n] / 8.0;
                }
                if (fps == 4L) {
                    int n = i;
                    bitrateValues[n] = bitrateValues[n] / 25.0;
                }
                bitrateValues[i] = Math.ceil(bitrateValues[i]);
            }
            if ((double)(bandwidth /= 1024) <= bitrateValues[bitrateValues.length - 1]) {
                ret = 0;
            } else if ((double)bandwidth >= bitrateValues[0]) {
                ret = 9;
            } else {
                for (i = 0; i < bitrateValues.length - 1; ++i) {
                    if (!((double)bandwidth <= bitrateValues[i]) || !((double)bandwidth >= bitrateValues[i + 1])) continue;
                    ret = bitrateValues[i] - (double)bandwidth > (double)bandwidth - bitrateValues[i + 1] ? 9 - (i + 1) : 9 - i;
                }
            }
        } else if (bitRateMode == 2) {
            int upperlimit;
            int lowerlimit;
            if (this.width >= 1600) {
                lowerlimit = 2048;
                upperlimit = 15360;
            } else if (this.width >= 1024) {
                lowerlimit = 1024;
                upperlimit = 10240;
            } else if (this.width >= 640) {
                lowerlimit = 512;
                upperlimit = 5120;
            } else {
                lowerlimit = 64;
                upperlimit = 2048;
            }
            ret = bandwidth / 1024;
            ret = ret < lowerlimit ? lowerlimit : ret;
            ret = ret > upperlimit ? upperlimit : ret;
        } else if (bitRateMode == 4) {
            int upperlimit;
            int lowerlimit;
            if (this.width >= 640) {
                lowerlimit = 512;
                upperlimit = 5120;
            } else if (this.width >= 320) {
                lowerlimit = 64;
                upperlimit = 2048;
            } else {
                lowerlimit = 32;
                upperlimit = 1024;
            }
            ret = bandwidth / 1024;
            ret = ret < lowerlimit ? lowerlimit : ret;
            ret = ret > upperlimit ? upperlimit : ret;
        }
        return ret;
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }
}

