/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.samsung.jpeg;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.video.samsung.jpeg.SamsungHttpServerPushHandler;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.TimeHelper;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SamsungHttpServerPushStreamHandler
extends SamsungHttpServerPushHandler
implements Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.video.device.samsung.jpeg.SamsungHttpServerPushHandler";
    private static final String TAG_CONTENT_LENGTH = "content-length:";
    private final byte[] TagBoundary = "boundary=".getBytes();
    private Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private Thread thread = null;
    private HttpServerPushListenerIntf listener = null;
    private NetworkParameter networkParameter = null;
    private Socket socket = null;
    private String url = null;
    private int firstCRLF = 0;
    private int secondCRLF = 0;
    private boolean eoiFound = false;
    private String contentHeader = null;
    private int startPos = -1;
    private int endPos = -1;
    private int contentLength = 0;

    @Override
    public int init(HttpServerPushListenerIntf listener, NetworkParameter networkParameter, String url) {
        this.listener = listener;
        if (this.listener == null) {
            return -20002;
        }
        this.networkParameter = networkParameter;
        if (this.networkParameter == null) {
            return -20002;
        }
        this.url = url;
        if (this.url == null) {
            return -20002;
        }
        return 0;
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Throwable ex) {
                this.logger.info("Unable to close socket for " + this.networkParameter);
            }
            this.socket = null;
        }
        return 0;
    }

    @Override
    public int startServerPush(boolean bAsynchronous) {
        this.logger.info("Starting HttpServerPush with following Parameter:");
        this.logger.info("   Listener        : " + this.listener);
        this.logger.info("   NetworkParameter: " + this.networkParameter);
        this.logger.info("   URL             : [ " + this.url + " ]");
        try {
            this.socket = this.establishServerPushStream(this.networkParameter, this.url);
            this.listener.sendStatusService(0);
        }
        catch (Throwable ex) {
            int errorCode = -20100;
            this.logger.error((Object)ex, ex);
            this.listener.sendStatusService(errorCode);
            return errorCode;
        }
        if (bAsynchronous) {
            this.thread = new Thread((Runnable)this, this.toString());
            this.thread.start();
            return 0;
        }
        return this.readHttpServerPush();
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        int errorCode = 0;
        try {
            errorCode = this.readHttpServerPush();
            if (errorCode != 0) {
                this.listener.sendStatusService(errorCode);
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    protected int readHttpServerPush() {
        int errorCode = 0;
        int len = -1;
        int index = -1;
        byte[] inBuffer = new byte[1024];
        byte[] array = null;
        byte[] extBoundary = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(32768);
        InputStream is = null;
        try {
            if (this.socket == null) {
                this.logger.info("TCP Socket doesn't exist. Creating Socket for " + this);
                this.socket = this.establishServerPushStream(this.networkParameter, this.url);
            }
            is = this.socket.getInputStream();
            baos.reset();
            while (!this.isShutdown()) {
                try {
                    len = is.read(inBuffer, 0, inBuffer.length);
                    if (len < 0) {
                        if (array == null) {
                            errorCode = -20102;
                            break;
                        }
                        String sMSG = new String(array);
                        this.logger.error("Invalid server push for " + this + ":\n\r" + sMSG);
                        if (!sMSG.toLowerCase().contains("unauthorized")) {
                            errorCode = -20102;
                            break;
                        }
                        errorCode = -21657;
                        break;
                    }
                }
                catch (InterruptedIOException soTimeoutException) {
                    if (this.networkParameter.getIgnoreSoTimeout()) continue;
                    throw soTimeoutException;
                }
                catch (NullPointerException npe) {
                    break;
                }
                baos.write(inBuffer, 0, len);
                array = baos.toByteArray();
                if (array.length < 512) {
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException ex) {
                        this.logger.info("Thread sleep interrupted " + ex.getMessage());
                    }
                    continue;
                }
                if (array.length > 0x100000) {
                    this.logger.error("No boundary found within [ " + Basic.longToFormattedString((long)array.length) + " B ] :-( ");
                    errorCode = -20102;
                    break;
                }
                index = SamsungHttpServerPushStreamHandler.indexOfByteArray((byte[])array, (byte[])this.networkParameter.getHttpDoubleLineDelimitter(), (int)0);
                if (index <= 0) continue;
                try {
                    byte[] streamHeader = new byte[index - 4];
                    System.arraycopy(array, 0, streamHeader, 0, index - 4);
                    int nPos1 = SamsungHttpServerPushStreamHandler.indexOfByteArray((byte[])array, (byte[])this.TagBoundary, (int)0);
                    int nPos2 = SamsungHttpServerPushStreamHandler.indexOfByteArray((byte[])array, (byte[])this.networkParameter.getHttpSingleLineDelimitter(), (int)nPos1);
                    byte[] prefix = null;
                    byte[] simpleBoundary = null;
                    byte[] postfix = null;
                    if (array[nPos1] == 34 && array[nPos2 - 3] == 34) {
                        simpleBoundary = new byte[nPos2 - nPos1 - this.networkParameter.getHttpSingleLineDelimitter().length - 2];
                        System.arraycopy(array, nPos1 + 1, simpleBoundary, 0, simpleBoundary.length);
                    } else if (array[nPos1] == 34 && array[nPos2 - 2] == 34) {
                        simpleBoundary = new byte[nPos2 - nPos1 - this.networkParameter.getHttpSingleLineDelimitter().length - 2];
                        System.arraycopy(array, nPos1 + 1, simpleBoundary, 0, simpleBoundary.length);
                    } else {
                        simpleBoundary = new byte[nPos2 - nPos1 - this.networkParameter.getHttpSingleLineDelimitter().length];
                        System.arraycopy(array, nPos1, simpleBoundary, 0, simpleBoundary.length);
                    }
                    if (simpleBoundary[0] == 45 && simpleBoundary[1] == 45) {
                        prefix = new byte[this.networkParameter.getHttpSingleLineDelimitter().length];
                        System.arraycopy(this.networkParameter.getHttpSingleLineDelimitter(), 0, prefix, 0, this.networkParameter.getHttpSingleLineDelimitter().length);
                    } else {
                        prefix = new byte[this.networkParameter.getHttpSingleLineDelimitter().length + 2];
                        System.arraycopy(this.networkParameter.getHttpSingleLineDelimitter(), 0, prefix, 0, this.networkParameter.getHttpSingleLineDelimitter().length);
                        prefix[this.networkParameter.getHttpSingleLineDelimitter().length + 1] = 45;
                        prefix[this.networkParameter.getHttpSingleLineDelimitter().length] = 45;
                    }
                    postfix = new byte[this.networkParameter.getHttpSingleLineDelimitter().length];
                    System.arraycopy(this.networkParameter.getHttpSingleLineDelimitter(), 0, postfix, 0, this.networkParameter.getHttpSingleLineDelimitter().length);
                    extBoundary = new byte[prefix.length + simpleBoundary.length + postfix.length];
                    System.arraycopy(prefix, 0, extBoundary, 0, prefix.length);
                    System.arraycopy(simpleBoundary, 0, extBoundary, prefix.length, simpleBoundary.length);
                    System.arraycopy(postfix, 0, extBoundary, prefix.length + simpleBoundary.length, postfix.length);
                    index = SamsungHttpServerPushStreamHandler.indexOfByteArray((byte[])array, (byte[])extBoundary, (int)0);
                    if (index >= 0) {
                        baos.reset();
                        baos.write(array, index, array.length - index);
                        break;
                    }
                    this.logger.error("No boundary found for " + this.networkParameter + " with URL [ " + this.url + " ] :-( ");
                    if (extBoundary.length > 256) {
                        String sHeader = new String(extBoundary, 0, 256);
                        this.logger.error("   extBoundary=[ " + sHeader + " ... ] :-( ");
                        StringBuilder sbHeader = new StringBuilder("      ");
                        for (int k = 0; k < 256; ++k) {
                            sbHeader.append(extBoundary[k]);
                        }
                        this.logger.error(sbHeader.toString());
                    } else {
                        this.logger.error("   extBoundary=[ " + new String(extBoundary) + " ] :-( ");
                        StringBuilder sbHeader = new StringBuilder("      ");
                        for (int k = 0; k < extBoundary.length; ++k) {
                            sbHeader.append(Integer.toHexString(extBoundary[k])).append("-");
                        }
                        this.logger.error(sbHeader.toString());
                    }
                    this.logger.error("this.networkParameter.getHttpSingleLineDelimitter( ).length=" + this.networkParameter.getHttpSingleLineDelimitter().length);
                    this.logger.error("prefix.length=" + prefix.length);
                    this.logger.error("postfix.length=" + postfix.length);
                    this.logger.error("simpleBoundary.length=" + simpleBoundary.length);
                    this.logger.error("simpleBoundary=" + new String(simpleBoundary));
                    this.logger.error("extBoundary.length=" + extBoundary.length);
                    StringBuilder sb = new StringBuilder("      ");
                    if (array.length > 256) {
                        for (int i = 0; i < 256; ++i) {
                            sb.append(Integer.toHexString(array[i])).append("-");
                        }
                    } else {
                        for (int i = 0; i < array.length; ++i) {
                            sb.append(Integer.toHexString(array[i])).append("-");
                        }
                    }
                    this.logger.error(sb.toString());
                    if (array.length > 256) {
                        this.logger.error("   array=[ " + new String(array, 0, 256) + " ... ] :-( ");
                    } else {
                        this.logger.error("   array=[ " + new String(array) + " ] :-( ");
                    }
                    errorCode = -20102;
                    break;
                }
                catch (Exception ex) {
                    String sWebServerRSP = null;
                    sWebServerRSP = array.length > 256 ? new String(array, 0, 256) : new String(array);
                    this.logger.warn("Reading [ " + this.socket + this.url + " ] failed!\n\r\n\r" + sWebServerRSP + "\n", (Throwable)ex);
                    errorCode = sWebServerRSP.toLowerCase().indexOf("unauthorized") < 0 ? -20102 : -21657;
                    break;
                }
            }
            if (errorCode == 0) {
                len = (array = baos.toByteArray()).length < 256 ? array.length : 256;
                String s = new String(array, 0, len);
                errorCode = !s.toLowerCase().contains(TAG_CONTENT_LENGTH) ? this.readContentStream(is, baos, extBoundary) : this.readOptimizedContentStream(is, baos, extBoundary);
            } else {
                this.listener.sendStatusService(errorCode);
            }
        }
        catch (IOException ex) {
            if (!this.isShutdown()) {
                this.logger.warn("Network problems for " + this, (Throwable)ex);
                this.listener.notifyForNetworkProblems();
            }
        }
        catch (SeeTecException ex) {
            this.logger.warn((Object)ex, (Throwable)ex);
            this.listener.notifyForNetworkProblems();
        }
        catch (Throwable ex) {
            this.logger.warn("Unexpected exception occured for " + this, ex);
            this.listener.notifyForNetworkProblems();
        }
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (IOException ioex) {
            this.logger.warn((Object)ioex, (Throwable)ioex);
        }
        return errorCode;
    }

    protected int readContentStream(InputStream is, ByteArrayOutputStream baos, byte[] extBoundary) throws IOException, SeeTecException {
        int len = 0;
        int nLastSearchPostition = 0;
        boolean bTrim = false;
        byte[] inBuffer = null;
        byte[] contentHeader = null;
        byte[] contentBody = null;
        long tsLastContentRead = System.currentTimeMillis();
        int nBufferOffset = -1;
        byte[] array = baos.toByteArray();
        inBuffer = array.length < 32768 ? new byte[32768] : new byte[(array.length >> 1 << 1) + 16384];
        System.arraycopy(array, 0, inBuffer, 0, array.length);
        nBufferOffset = array.length;
        while (!this.isShutdown() && !this.listener.isShutdown()) {
            try {
                if (nBufferOffset + 4096 > inBuffer.length) {
                    if (inBuffer.length >= 0x100000) {
                        this.logger.info("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
                        String sHeader = new String(extBoundary);
                        this.logger.error("   extBoundary=[ " + sHeader + " ] :-( ");
                        StringBuilder sbHeader = new StringBuilder("      ");
                        for (int k = 0; k < extBoundary.length; ++k) {
                            sbHeader.append(extBoundary[k]);
                        }
                        this.logger.error(sbHeader.toString());
                        this.logger.error("Limitation of content size exceeded for " + this);
                        return -20102;
                    }
                    array = new byte[inBuffer.length + 8192];
                    System.arraycopy(inBuffer, 0, array, 0, nBufferOffset);
                    inBuffer = array;
                }
                try {
                    len = is.read(inBuffer, nBufferOffset, 4096);
                    if (len < 0) {
                        return -20103;
                    }
                    nBufferOffset += len;
                }
                catch (InterruptedIOException soTimeoutException) {
                    if (this.networkParameter.getIgnoreSoTimeout()) continue;
                    throw soTimeoutException;
                }
            }
            catch (NullPointerException npe) {
                this.shutdown();
                return 0;
            }
            int nStartOfHeader = 0;
            int nEndOfHeader = -1;
            int nEndOfBody = -1;
            while ((nEndOfBody = SamsungHttpServerPushStreamHandler.indexOfByteArray((byte[])inBuffer, (byte[])extBoundary, (int)nLastSearchPostition, (int)(nBufferOffset - nLastSearchPostition - 1))) > 0) {
                int nLengthOfContentBody;
                nEndOfHeader = SamsungHttpServerPushStreamHandler.indexOfByteArray((byte[])inBuffer, (byte[])this.networkParameter.getHttpDoubleLineDelimitter(), (int)nStartOfHeader);
                if (nEndOfHeader < 0) {
                    throw new RuntimeException("No [ EndOfHeader ] found within content :-( ");
                }
                contentHeader = new byte[nEndOfHeader - nStartOfHeader - this.networkParameter.getHttpDoubleLineDelimitter().length];
                System.arraycopy(inBuffer, nStartOfHeader, contentHeader, 0, contentHeader.length);
                if (inBuffer[nEndOfHeader] == 10) {
                    ++nEndOfHeader;
                }
                if ((nLengthOfContentBody = nEndOfBody - nEndOfHeader - extBoundary.length) > 0) {
                    contentBody = new byte[nLengthOfContentBody];
                    System.arraycopy(inBuffer, nEndOfHeader, contentBody, 0, contentBody.length);
                } else {
                    contentBody = new byte[]{};
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.info("... " + this + " delivers content of [ " + Basic.longToFormattedString((long)contentBody.length) + " b ] to listener [ " + this.listener + " ] ...");
                }
                String sContentHeader = new String(contentHeader);
                this.listener.deliverContent(new HttpServerPushContent(sContentHeader, contentBody));
                nLastSearchPostition = nStartOfHeader = nEndOfBody;
                bTrim = true;
                if (tsLastContentRead + 60000L < System.currentTimeMillis()) {
                    this.logger.warn("Content read within [ " + TimeHelper.getReadableTimerange((long)(System.currentTimeMillis() - tsLastContentRead)) + " ] via " + this);
                }
                tsLastContentRead = System.currentTimeMillis();
            }
            if (bTrim) {
                array = new byte[inBuffer.length];
                System.arraycopy(inBuffer, nLastSearchPostition, array, 0, nBufferOffset - nLastSearchPostition);
                inBuffer = array;
                nBufferOffset -= nLastSearchPostition;
                nLastSearchPostition = 0;
                bTrim = false;
                continue;
            }
            nLastSearchPostition = nBufferOffset - extBoundary.length;
            if (nLastSearchPostition >= 0) continue;
            nLastSearchPostition = 0;
        }
        return 0;
    }

    private byte[] deleteFromArray(byte[] arr, int firstCRLF, int secondCRLF) {
        byte[] ret = null;
        ret = new byte[arr.length - (secondCRLF - firstCRLF) - 2];
        System.arraycopy(arr, 0, ret, 0, firstCRLF - 2);
        System.arraycopy(arr, secondCRLF, ret, firstCRLF - 2, arr.length - secondCRLF);
        return ret;
    }

    private int readOptimizedContentStream(InputStream is, ByteArrayOutputStream baos, byte[] extBoundary) throws IOException, SeeTecException {
        int len = 0;
        int endOfHeader = -1;
        int startOfHeader = 0;
        byte[] inBuffer = new byte[4096];
        byte[] array = null;
        byte[] contentHeader = null;
        byte[] contentBody = null;
        long tsLastContentRead = System.currentTimeMillis();
        int indexOfTagContentLength = -1;
        while (!this.isShutdown() && !this.listener.isShutdown()) {
            int i;
            char c;
            array = baos.toByteArray();
            while (array.length < 512) {
                try {
                    len = is.read(inBuffer, 0, inBuffer.length);
                    if (len < 0) {
                        return -20103;
                    }
                }
                catch (InterruptedIOException soTimeoutException) {
                    if (this.networkParameter.getIgnoreSoTimeout()) continue;
                    throw soTimeoutException;
                }
                catch (NullPointerException npe) {
                    this.shutdown();
                    return 0;
                }
                baos.write(inBuffer, 0, len);
                array = baos.toByteArray();
            }
            endOfHeader = SamsungHttpServerPushStreamHandler.indexOfByteArray((byte[])array, (byte[])this.networkParameter.getHttpDoubleLineDelimitter(), (int)0);
            if (endOfHeader < 0) {
                this.logger.error("Cannot find content header: 1");
                for (int i2 = 0; i2 < array.length - 8; ++i2) {
                    if (array[i2] != 13 || array[i2 + 1] != 10 || array[i2 + 6] != 13 || array[i2 + 7] != 10) continue;
                    byte[] tmp = new byte[array.length - 8];
                    System.arraycopy(array, 0, tmp, 0, i2);
                    if (array.length > i2 + 7) {
                        System.arraycopy(array, i2 + 8, tmp, i2, tmp.length - i2);
                    }
                    if ((endOfHeader = SamsungHttpServerPushStreamHandler.indexOfByteArray((byte[])(array = tmp), (byte[])this.networkParameter.getHttpDoubleLineDelimitter(), (int)startOfHeader)) >= 0) continue;
                    return -20103;
                }
            }
            contentHeader = new byte[endOfHeader - this.networkParameter.getHttpDoubleLineDelimitter().length];
            System.arraycopy(array, 0, contentHeader, 0, contentHeader.length);
            this.contentHeader = new String(contentHeader);
            indexOfTagContentLength = this.contentHeader.toLowerCase().indexOf(TAG_CONTENT_LENGTH);
            if (indexOfTagContentLength < 0) {
                startOfHeader = endOfHeader;
                endOfHeader = SamsungHttpServerPushStreamHandler.indexOfByteArray((byte[])array, (byte[])this.networkParameter.getHttpDoubleLineDelimitter(), (int)startOfHeader);
                if (endOfHeader < 0) {
                    this.logger.error("Cannot find content header: 2");
                    return -20103;
                }
            }
            contentHeader = new byte[endOfHeader - this.networkParameter.getHttpDoubleLineDelimitter().length - startOfHeader];
            System.arraycopy(array, startOfHeader, contentHeader, 0, contentHeader.length);
            this.contentHeader = new String(contentHeader);
            indexOfTagContentLength = this.contentHeader.toLowerCase().indexOf(TAG_CONTENT_LENGTH);
            this.startPos = indexOfTagContentLength + TAG_CONTENT_LENGTH.length();
            try {
                while (this.contentHeader.charAt(this.startPos) == ' ') {
                    ++this.startPos;
                }
            }
            catch (StringIndexOutOfBoundsException es) {
                this.logger.info("Start position could not be found. Content Header: " + this.contentHeader);
                this.logger.info("Length of Content header: " + this.contentHeader.length());
                this.logger.info("Start position: " + this.startPos);
            }
            this.endPos = this.startPos;
            if (this.startPos < 0) {
                return -1;
            }
            while (this.endPos < this.contentHeader.length() && (c = this.contentHeader.charAt(this.endPos)) >= '0' && c <= '9') {
                ++this.endPos;
            }
            this.contentLength = Integer.parseInt(this.contentHeader.substring(this.startPos, this.endPos));
            baos.reset();
            baos.write(array, endOfHeader, array.length - endOfHeader);
            int nRead = array.length - endOfHeader;
            while (nRead < this.contentLength + 10) {
                try {
                    inBuffer = new byte[4096];
                    len = is.read(inBuffer, 0, inBuffer.length);
                    if (len < 0) {
                        return -20103;
                    }
                }
                catch (InterruptedIOException soTimeoutException) {
                    if (this.networkParameter.getIgnoreSoTimeout()) continue;
                    throw soTimeoutException;
                }
                catch (NullPointerException npe) {
                    this.shutdown();
                    return 0;
                }
                baos.write(inBuffer, 0, len);
                nRead += len;
            }
            array = baos.toByteArray();
            boolean doneErrorCorrection = false;
            this.firstCRLF = SamsungHttpServerPushStreamHandler.indexOfByteArray((byte[])array, (byte[])this.networkParameter.getHttpSingleLineDelimitter(), (int)0);
            while (this.firstCRLF != -1 && !doneErrorCorrection) {
                if (this.firstCRLF + 20 < array.length) {
                    this.secondCRLF = SamsungHttpServerPushStreamHandler.indexOfByteArray((byte[])array, (byte[])this.networkParameter.getHttpSingleLineDelimitter(), (int)this.firstCRLF, (int)20);
                    if (this.secondCRLF != -1) {
                        array = this.deleteFromArray(array, this.firstCRLF, this.secondCRLF);
                        doneErrorCorrection = true;
                    }
                }
                this.firstCRLF = SamsungHttpServerPushStreamHandler.indexOfByteArray((byte[])array, (byte[])this.networkParameter.getHttpSingleLineDelimitter(), (int)this.firstCRLF);
            }
            this.eoiFound = false;
            for (i = array.length - 12; i < array.length; ++i) {
                if ((array[i - 1] & 0xFF) != 255 || (array[i] & 0xFF) != 217) continue;
                this.contentLength = i + 1;
                this.eoiFound = true;
            }
            if (!this.eoiFound) {
                for (i = 1; i < array.length; ++i) {
                    if ((array[i - 1] & 0xFF) != 255 || (array[i] & 0xFF) != 217) continue;
                    this.contentLength = i + 1;
                    this.eoiFound = true;
                }
            }
            if (!this.eoiFound) {
                this.logger.info("Looking for FF D9 - Bytes separated by a few other bytes");
                for (i = array.length - 20; i < array.length; ++i) {
                    if ((array[i - 1] & 0xFF) != 255) continue;
                    for (int j = i; j < array.length; ++j) {
                        if ((array[j] & 0xFF) != 217) continue;
                        this.logger.info(" End of Image finally found ");
                        array[i] = array[j];
                        this.contentLength = i + 1;
                        this.eoiFound = true;
                    }
                }
            }
            if (!this.eoiFound) {
                this.logger.error("Could not find End of Image");
            }
            contentBody = new byte[this.contentLength];
            System.arraycopy(array, 0, contentBody, 0, contentBody.length);
            if (this.logger.isDebugEnabled()) {
                this.logger.info("... " + this + " delivers content of [ " + Basic.longToFormattedString((long)contentBody.length) + " b ] to listener [ " + this.listener + " ] ...");
            }
            this.contentHeader = "Content-Type: image/jpeg\r\nContent-Length: " + this.contentLength;
            this.listener.deliverContent(new HttpServerPushContent(this.contentHeader, contentBody));
            baos.reset();
            baos.write(array, this.contentLength, array.length - this.contentLength);
            if (tsLastContentRead + 60000L < System.currentTimeMillis()) {
                this.logger.warn("Content read within [ " + TimeHelper.getReadableTimerange((long)(System.currentTimeMillis() - tsLastContentRead)) + " ] via " + this);
            }
            tsLastContentRead = System.currentTimeMillis();
        }
        return 0;
    }

    public String toString() {
        String sThis = this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
        return "[ " + sThis.substring(sThis.lastIndexOf(46) + 1) + ", Listener=" + this.listener + ", " + this.networkParameter + ", " + this.socket + ", URL=[ " + this.url + " ] ]";
    }

    private Socket establishServerPushStream(NetworkParameter networkParameter, String url) throws Exception {
        String authentication = "";
        String realm = networkParameter.getRealm();
        String nonce = networkParameter.getNonce();
        String qop = networkParameter.getQop();
        if (realm != null && nonce != null && qop != null) {
            authentication = NetworkHelper.createDigestAuthorization((NetworkParameter)networkParameter, (String)realm, (String)nonce, (String)"GET", (String)url, (String)qop);
        }
        String additionalData = networkParameter.getAdditionalData() != null ? networkParameter.getAdditionalData() : "";
        String sRequest = "GET " + url + " HTTP/1.1\r\n" + additionalData + authentication + "User-Agent: Java/1.4.2\r\nHost: " + networkParameter.getHost() + "\r\nAccept: text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2\r\nConnection: keep-alive\r\n\r\n";
        Socket socket = networkParameter.useHTTPS() ? NetworkHelper.createNetworkConnection((String)networkParameter.getHost(), (int)networkParameter.getSSLport(), (boolean)true) : NetworkHelper.createNetworkConnection((String)networkParameter.getHost(), (int)networkParameter.getHTTPport(), (boolean)false);
        socket.setSoTimeout(networkParameter.getSoTimeout());
        OutputStream os = socket.getOutputStream();
        os.write(sRequest.getBytes());
        os.flush();
        return socket;
    }
}

