/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.samsung;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.samsung.SamsungCameraSrv;
import de.seetec.v5.re.cm.device.video.samsung.SamsungDevice;
import de.seetec.v5.re.cm.device.video.samsung.SamsungHelper;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.net.HttpHandler;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class SamsungVideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.samsung.SamsungVideoSourceClient";
    private int compression = 0;
    private long gopSize = 0L;
    private SamsungDevice samsungDevice;
    private int profileNumber = -1;
    private boolean isMultiChannelDevice = false;
    private String urlPartMultiChannel = "";
    private SamsungCameraSrv samsungCameraSrv;

    public SamsungCameraSrv getSamsungCameraSrv() {
        if (this.samsungCameraSrv == null) {
            this.samsungCameraSrv = (SamsungCameraSrv)this.getVideoSrv();
        }
        return this.samsungCameraSrv;
    }

    private HttpHandler getHttpHandler() {
        return this.getSamsungDevice().getHttpHandler();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int init() {
        try {
            int numberOfVideoSources;
            this.errorCode = super.init();
            if (this.errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
                return this.errorCode;
            }
            this.networkParameter.checkAndSetTimeout(5000);
            this.bandwidth /= 1024;
            this.getSamsungDevice().setModelInformation();
            int widthCorridorMode = this.width;
            int heightCorridorMode = this.height;
            if (this.width > 2000 && (this.rotationAngle == 90 || this.rotationAngle == 270)) {
                int temp = this.height;
                this.height = this.width;
                this.width = temp;
            }
            if ((numberOfVideoSources = this.getSamsungDevice().getNumberOfVideoSourcesFromDevice()) > 1) {
                this.isMultiChannelDevice = true;
                this.urlPartMultiChannel = "&Channel=" + (this.videoSourceNr - 1);
            }
            if (this.videoCodec == Codec.RTSP) {
                this.profileNumber = 2;
            } else {
                String parameter;
                int minGovLength;
                String number;
                int maxBitrate;
                Iterator parameterMax;
                String parameterMin;
                int maxFps;
                this.fps /= 1000L;
                long l = this.fps = this.fps < 1L ? 1L : this.fps;
                if (this.videoCodec == Codec.MJPEG && (maxFps = this.getMaxMjpegFramerate(this.width, this.height)) > 0 && this.fps > (long)maxFps) {
                    this.fps = maxFps;
                }
                this.errorCode = this.getSamsungDevice().handleGlobalParameters(this.rotationAngle, this.useDateTime, this.useTitle, this.title, this.urlPartMultiChannel);
                this.errorCode = this.getSamsungCameraSrv().handleChannelParameters(this.networkParameter, this.rotationAngle, this.useDateTime, this.useTitle, this.title, this.urlPartMultiChannel);
                if (this.errorCode != 0) {
                    if (this.errorCode == -21657) {
                        return this.errorCode;
                    }
                    this.logger.error("Error while setting global camera parameters: " + this.errorCode + "\r\n\t for " + this + "\r\n\t Trying to continue anyways...");
                }
                this.getSamsungDevice().checkAndSetParameter("network", "rtsp", "Port", Integer.toString(this.listener.getVideoSourceParameter().getRtspPort()), "");
                String cameraParameters = "";
                String cameraParametersCodecInfo = "";
                HashMap<String, String> parameters = new HashMap<String, String>();
                if (this.hasAudio()) {
                    if (this.isAudioEnabled) {
                        String parameterString = "/stw-cgi/media.cgi?msubmenu=audioinput&action=set";
                        parameterString = parameterString + "&Channel=" + (this.videoSourceNr - 1);
                        if (this.audioCodec == Codec.G711A || this.audioCodec == Codec.G711U) {
                            parameterString = parameterString + "&EncodingType=G711";
                        }
                        if (this.audioCodec == Codec.G726) {
                            parameterString = parameterString + "&EncodingType=G726";
                        }
                        this.getHttpHandler().readGetRequest(parameterString);
                        parameters.put("AudioInputEnable", "True");
                    } else {
                        parameters.put("AudioInputEnable", "False");
                    }
                }
                parameters.put("Resolution", widthCorridorMode + "x" + heightCorridorMode);
                parameters.put("FrameRate", Long.toString(this.fps));
                this.compression = (100000 - this.quality) / 5000;
                this.compression = this.compression < 1 ? 1 : this.compression;
                this.compression = this.compression > 20 ? 20 : this.compression;
                try {
                    cameraParameters = this.getHttpHandler().readGetRequest("/stw-cgi/media.cgi?msubmenu=videoprofile&action=view" + this.urlPartMultiChannel);
                }
                catch (SeeTecException ex) {
                    this.logger.error("Exception while reading camera parameters for " + this + "\r\n\t" + ex.getMessage() + "\r\n\t Trying to continue anyway");
                }
                try {
                    cameraParametersCodecInfo = this.getHttpHandler().readGetRequest("/stw-cgi/media.cgi?msubmenu=videocodecinfo&action=view" + this.urlPartMultiChannel);
                }
                catch (SeeTecException ex) {
                    this.logger.error("Exception while reading camera parameters for " + this + "\r\n\t" + ex.getMessage() + "\r\n\t Trying to continue anyway");
                }
                if (this.videoCodec == Codec.MJPEG) {
                    this.profileNumber = this.getSamsungCameraSrv().getProfileNumber("MJPEG");
                    if (cameraParameters != null && !cameraParameters.contains("Profile." + this.profileNumber + ".")) {
                        this.logger.warn("Profile " + this.profileNumber + " not set for camera [" + this + "]. Please deactivate/activate the camera in Cayuga.");
                        this.checkAndSetProfiles("MJPEG", this.profileNumber);
                    }
                    this.logger.info(String.format("Use profile number '%d' for MJPEG on %dx%d" + (this.isMultiChannelDevice ? " Channel number: " + this.videoSourceNr : ""), this.profileNumber, this.width, this.height));
                    parameters.put("EncodingType", "MJPEG");
                    String parameter2 = "Channel\\." + (this.videoSourceNr - 1) + "\\.Profile\\." + this.profileNumber + "\\.CompressionLevel";
                    String list = this.getSamsungDevice().readCameraParameters(null, parameter2, cameraParameters);
                    if (list != null && !list.isEmpty()) {
                        parameters.put("CompressionLevel", Integer.toString(this.compression));
                    }
                    if (this.isConstantBitrateUsed) {
                        String string = "MJPEG\\.General\\." + widthCorridorMode + "X" + heightCorridorMode + "\\.MinCBRTargetBitrate";
                        String string2 = "MJPEG\\.General\\." + widthCorridorMode + "X" + heightCorridorMode + "\\.MaxCBRTargetBitrate";
                        String minBitrateCamera2 = this.getSamsungDevice().readCameraParameters(null, string, cameraParametersCodecInfo);
                        int minBitrate = 64;
                        try {
                            minBitrate = Integer.parseInt(minBitrateCamera2);
                        }
                        catch (NumberFormatException ex) {
                            this.logger.warn("Error while converting to number: " + minBitrateCamera2);
                        }
                        String maxBitrateCamera = this.getSamsungDevice().readCameraParameters(null, string2, cameraParametersCodecInfo);
                        int maxBitrate2 = 4096;
                        try {
                            maxBitrate2 = Integer.parseInt(maxBitrateCamera);
                        }
                        catch (NumberFormatException ex) {
                            this.logger.warn("Error while converting to number: " + maxBitrateCamera);
                        }
                        this.bandwidth = this.bandwidth > maxBitrate2 ? maxBitrate2 : this.bandwidth;
                        this.bandwidth = this.bandwidth < minBitrate ? minBitrate : this.bandwidth;
                        parameters.put("Bitrate", Integer.toString(this.bandwidth));
                    }
                } else if (this.videoCodec == Codec.H264) {
                    void var9_17;
                    this.profileNumber = this.getSamsungCameraSrv().getProfileNumber("H264");
                    if (cameraParameters != null && !cameraParameters.contains("Profile." + this.profileNumber + ".")) {
                        this.logger.warn("Profile " + this.profileNumber + " not set for camera [" + this + "]. Please deactivate/activate the camera in Cayuga.");
                        this.checkAndSetProfiles("H264", this.profileNumber);
                    }
                    this.logger.info(String.format("Use profile number '%d' for H.264 on %dx%d" + (this.isMultiChannelDevice ? " Channel number: " + this.videoSourceNr : ""), this.profileNumber, this.width, this.height));
                    parameters.put("EncodingType", "H264");
                    parameterMin = "H264\\.General\\." + widthCorridorMode + "X" + heightCorridorMode + (this.isConstantBitrateUsed ? "\\.MinCBRTargetBitrate" : "\\.MinVBRTargetBitrate");
                    parameterMax = "H264\\.General\\." + widthCorridorMode + "X" + heightCorridorMode + (this.isConstantBitrateUsed ? "\\.MaxCBRTargetBitrate" : "\\.MaxVBRTargetBitrate");
                    if (this.getSamsungDevice().isSunApi_2()) {
                        boolean bl = this.getSamsungDevice().isCanVbrQuality();
                    } else {
                        boolean bl = this.getSamsungDevice().readCameraParametersAsBoolean("/cgi-bin/about.cgi?msubmenu=capability&action=view" + this.urlPartMultiChannel, "Video\\.Compression", null);
                    }
                    String string = this.getSamsungDevice().readCameraParameters(null, parameterMin, cameraParametersCodecInfo);
                    int minBitrate = 64;
                    try {
                        minBitrate = Integer.parseInt(string);
                    }
                    catch (NumberFormatException ex) {
                        this.logger.warn("Error while converting to number: " + string);
                    }
                    String string3 = this.getSamsungDevice().readCameraParameters(null, (String)((Object)parameterMax), cameraParametersCodecInfo);
                    maxBitrate = 4096;
                    try {
                        maxBitrate = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException ex) {
                        this.logger.warn("Error while converting to number: " + string3);
                    }
                    this.bandwidth = this.bandwidth > maxBitrate ? maxBitrate : this.bandwidth;
                    this.bandwidth = this.bandwidth < minBitrate ? minBitrate : this.bandwidth;
                    parameters.put("Bitrate", Integer.toString(this.bandwidth));
                    if (!this.isConstantBitrateUsed && var9_17 != false) {
                        parameters.put("CompressionLevel", Integer.toString(this.compression));
                    }
                    number = "";
                    if (this.profileNumber == -1) {
                        this.logger.error("Profile number not valid for " + this + "\r\n\t Continuing with profile number 1");
                        this.profileNumber = 1;
                    }
                    minGovLength = 1;
                    int maxGovLength = 150;
                    try {
                        parameter = "Channel\\." + (this.videoSourceNr - 1) + "\\.Profile\\." + this.profileNumber + "\\.H264\\.MinGOVLength";
                        number = this.getSamsungDevice().readCameraParameters(null, parameter, cameraParameters);
                        minGovLength = Integer.parseInt(number);
                        parameter = "Channel\\." + (this.videoSourceNr - 1) + "\\.Profile\\." + this.profileNumber + "\\.H264\\.MaxGOVLength";
                        number = this.getSamsungDevice().readCameraParameters(null, parameter, cameraParameters);
                        maxGovLength = Integer.parseInt(number);
                    }
                    catch (NumberFormatException ex) {
                        this.logger.error("Exception while converting the following String to number: " + number);
                    }
                    this.gopSize = Tools.convertIFrameDistMStoFrameCount(this.fps * 1000L, this.iFrameDistMS, minGovLength, maxGovLength);
                    parameters.put("H264.GOVLength", Long.toString(this.gopSize));
                } else {
                    void var9_20;
                    this.profileNumber = this.getSamsungCameraSrv().getProfileNumber("H265");
                    if (cameraParameters != null && !cameraParameters.contains("Profile." + this.profileNumber + ".")) {
                        this.logger.warn("Profile " + this.profileNumber + " not set for camera [" + this + "]. Please deactivate/activate the camera in Cayuga.");
                        this.checkAndSetProfiles("H265", this.profileNumber);
                    }
                    this.logger.info(String.format("Use profile number '%d' for H.265 on %dx%d" + (this.isMultiChannelDevice ? " Channel number: " + this.videoSourceNr : ""), this.profileNumber, this.width, this.height));
                    parameters.put("EncodingType", "H265");
                    parameterMin = "H265\\.General\\." + widthCorridorMode + "X" + heightCorridorMode + (this.isConstantBitrateUsed ? "\\.MinCBRTargetBitrate" : "\\.MinVBRTargetBitrate");
                    parameterMax = "H265\\.General\\." + widthCorridorMode + "X" + heightCorridorMode + (this.isConstantBitrateUsed ? "\\.MaxCBRTargetBitrate" : "\\.MaxVBRTargetBitrate");
                    if (this.getSamsungDevice().isSunApi_2()) {
                        boolean bl = this.getSamsungDevice().isCanVbrQuality();
                    } else {
                        boolean bl = this.getSamsungDevice().readCameraParametersAsBoolean("/cgi-bin/about.cgi?msubmenu=capability&action=view", "Video\\.Compression", null);
                    }
                    String string = this.getSamsungDevice().readCameraParameters(null, parameterMin, cameraParametersCodecInfo);
                    int minBitrate = 64;
                    try {
                        minBitrate = Integer.parseInt(string);
                    }
                    catch (NumberFormatException ex) {
                        this.logger.warn("Error while converting to number: " + string);
                    }
                    String string4 = this.getSamsungDevice().readCameraParameters(null, (String)((Object)parameterMax), cameraParametersCodecInfo);
                    maxBitrate = 4096;
                    try {
                        maxBitrate = Integer.parseInt(string4);
                    }
                    catch (NumberFormatException ex) {
                        this.logger.warn("Error while converting to number: " + string4);
                    }
                    this.bandwidth = this.bandwidth > maxBitrate ? maxBitrate : this.bandwidth;
                    this.bandwidth = this.bandwidth < minBitrate ? minBitrate : this.bandwidth;
                    parameters.put("Bitrate", Integer.toString(this.bandwidth));
                    if (!this.isConstantBitrateUsed && var9_20 != false) {
                        parameters.put("CompressionLevel", Integer.toString(this.compression));
                    }
                    number = "";
                    if (this.profileNumber == -1) {
                        this.logger.error("Profile number not valid for " + this + "\r\n\t Continuing with profile number 1");
                        this.profileNumber = 1;
                    }
                    minGovLength = 1;
                    int maxGovLength = 150;
                    try {
                        parameter = "Channel\\." + (this.videoSourceNr - 1) + "\\.Profile\\." + this.profileNumber + "\\.H265\\.MinGOVLength";
                        number = this.getSamsungDevice().readCameraParameters(null, parameter, cameraParameters);
                        minGovLength = Integer.parseInt(number);
                        parameter = "Channel\\." + (this.videoSourceNr - 1) + "\\.Profile\\." + this.profileNumber + "\\.H265\\.MaxGOVLength";
                        number = this.getSamsungDevice().readCameraParameters(null, parameter, cameraParameters);
                        maxGovLength = Integer.parseInt(number);
                    }
                    catch (NumberFormatException ex) {
                        this.logger.error("Exception while converting the following String to number: " + number);
                    }
                    this.gopSize = Tools.convertIFrameDistMStoFrameCount(this.fps * 1000L, this.iFrameDistMS, minGovLength, maxGovLength);
                    parameters.put("H265.GOVLength", Long.toString(this.gopSize));
                }
                this.checkAndRenameProfiles(this.urlPartMultiChannel);
                Vector parametersToRemove = new Vector();
                for (Map.Entry entry : parameters.entrySet()) {
                    String string = "Channel\\." + (this.videoSourceNr - 1) + "\\.Profile\\." + this.profileNumber + "\\." + (String)entry.getKey();
                    try {
                        if (!this.getSamsungDevice().readCameraParameters(null, string, cameraParameters).equals(entry.getValue())) continue;
                        parametersToRemove.add(entry.getKey());
                    }
                    catch (NullPointerException ex) {
                        this.logger.warn("Nullpointer exception. Will be ignored here for " + this);
                    }
                }
                for (String string : parametersToRemove) {
                    parameters.remove(string);
                }
                if (!parameters.isEmpty()) {
                    StringBuilder url = new StringBuilder("/stw-cgi/media.cgi?msubmenu=videoprofile&action=update&Profile=" + this.profileNumber + this.urlPartMultiChannel);
                    for (Map.Entry entry : parameters.entrySet()) {
                        url.append("&").append((String)entry.getKey()).append("=").append((String)entry.getValue());
                    }
                    try {
                        String string = url.toString();
                        this.getHttpHandler().readGetRequest(string);
                        this.setResolution(this.videoSourceNr, this.profileNumber, widthCorridorMode, heightCorridorMode, this.urlPartMultiChannel);
                    }
                    catch (SeeTecException seeTecException) {
                        if (seeTecException.getErrorCode() == -21657) {
                            this.logger.error("Exception while setting image parameters for " + this + seeTecException.getMessage());
                            return seeTecException.getErrorCode();
                        }
                        this.logger.error("Exception while setting image parameters for " + this + "\r\n\t" + seeTecException.getMessage() + "\r\n\tTrying to continue anyway");
                    }
                }
                this.setConstantBitrate(this.isConstantBitrateUsed, this.videoSourceNr, this.profileNumber, this.urlPartMultiChannel);
                this.setBitrate(this.bandwidth, this.profileNumber, this.urlPartMultiChannel);
            }
            String rtspPath = (this.isMultiChannelDevice ? "/" + (this.videoSourceNr - 1) : "") + "/profile" + this.profileNumber + "/media.smp";
            this.rtspUrl = "rtsp://" + this.getHost() + rtspPath;
            this.rtspSettings = new RTSPStreamSettings();
            String keepAliveUrl = this.isMultiChannelDevice ? this.rtspUrl : "*";
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 4, keepAliveUrl);
            if (this.errorCode != 0) {
                this.logger.error("Initialization of RTSPSettings failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
            if (this.isAudioEnabled) {
                this.rtspSettings.setAudioCodec(this.audioCodec);
            }
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.errorCode = this.rtspHandler.start();
            if (this.errorCode != 0) {
                this.logger.error("Starting of RTSP Handler failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.publishRTSPUrl(this.rtspUrl);
            this.logger.info("init done for" + this.getVideoSrv());
            return 0;
        }
        catch (SeeTecException exception) {
            this.logger.error("Exception while initialization for " + this, (Throwable)exception);
            return exception.getErrorCode();
        }
        catch (Throwable t) {
            this.logger.error("Unexpected exception while initialization for " + this);
            this.logger.error((Object)t, t);
            return -20000;
        }
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.getSamsungDevice() != null) {
            this.getSamsungCameraSrv().removeProfileNumber(this.profileNumber);
        }
        return super.shutdown();
    }

    public int setImageParameters(long framerate) {
        long fps = framerate / 1000L;
        fps = fps < 1L ? 1L : fps;
        int errorCode = 0;
        try {
            this.getHttpHandler().readGetRequest("/stw-cgi/media.cgi?msubmenu=videoprofile&action=update&Profile=" + this.profileNumber + "&FrameRate=" + fps);
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while setting framerate for " + this + " : " + ex.getMessage());
            errorCode = ex.getErrorCode();
        }
        return errorCode;
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public void sendStatusService(int statusCode) {
        this.listener.sendStatusService(statusCode);
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        this.listener.notifyForNetworkProblems();
        this.shutdown();
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    public long getMilliCompression() {
        return this.compression;
    }

    protected boolean hasAudio() throws ConfigurationException {
        int channel = this.getVideoSrv().getVideoSourceCnf().getServerEntryNo() - 1;
        String xPath = "//attributes/group[@name='Media']/category[@name='Limit']/channel[@number='" + channel + "']/attribute[@name='MaxAudioInput']/@value";
        List<String> audioInputNumberList = this.getSamsungDevice().getAttributes(xPath, this.getSamsungDevice().getAttributesDoc());
        Integer audioInputNumber = SamsungHelper.getFirstFromListAsInt(audioInputNumberList);
        return audioInputNumber != null && audioInputNumber > 0;
    }

    public int getMaxMjpegFramerate(int width, int height) {
        try {
            String[] capabilitiesLines;
            String capabilities = this.getHttpHandler().readGetRequest("/stw-cgi/media.cgi?msubmenu=videocodecinfo&action=view");
            if (capabilities != null && (capabilitiesLines = capabilities.split("\r\n")).length > 0) {
                for (String capabilitiesLine : capabilitiesLines) {
                    String[] fpsCap;
                    if (!capabilitiesLine.startsWith("MJPEG.General." + width + "X" + height + ".MaxFPS") && !capabilitiesLine.startsWith("MJPEG.General." + height + "X" + width + ".MaxFPS") || (fpsCap = capabilitiesLine.split("=")).length != 2) continue;
                    return Integer.parseInt(fpsCap[1].trim()) / 1000;
                }
            }
        }
        catch (Exception ex) {
            this.logger.warn("Could not read maximal framerate on device: " + ex.getMessage() + " Using given framerate instead for " + this);
        }
        return -1;
    }

    private void checkAndSetProfiles(String currentCodec, int currentProfile) {
        try {
            String profilesView = this.getHttpHandler().readGetRequest("/stw-cgi/media.cgi?msubmenu=videoprofile&action=view" + this.urlPartMultiChannel);
            if (profilesView != null) {
                for (int i = 3; i <= 10; ++i) {
                    String codec;
                    if (profilesView.contains("Profile." + i + ".")) continue;
                    if (i == currentProfile) {
                        codec = currentCodec;
                    } else {
                        switch (i) {
                            case 4: 
                            case 7: 
                            case 10: {
                                codec = "MJPEG";
                                break;
                            }
                            case 5: 
                            case 8: {
                                codec = "H264";
                                break;
                            }
                            default: {
                                codec = "H265";
                            }
                        }
                    }
                    this.logger.info("Adding profile " + i + " with " + codec);
                    String url = "/stw-cgi/media.cgi?msubmenu=videoprofile&action=add&EncodingType=" + codec + "&Name=VMS" + i + this.urlPartMultiChannel;
                    this.getHttpHandler().readGetRequest(url);
                }
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while setting framerate for " + this + " : " + ex.getMessage());
            this.errorCode = ex.getErrorCode();
        }
    }

    private void checkAndRenameProfiles(String urlPartMultiChannel) {
        String profilesView = "";
        try {
            profilesView = this.getHttpHandler().readGetRequest("/stw-cgi/media.cgi?msubmenu=videoprofile&action=view" + urlPartMultiChannel);
        }
        catch (Exception ex) {
            this.logger.info("Could not read profile information for " + this);
        }
        for (int i = 3; i <= 10; ++i) {
            if (profilesView == null || !profilesView.contains("Profile." + i) || profilesView.contains("Profile." + i + ".Name=VMS") || profilesView.toLowerCase().contains("profile." + i + ".isfixedprofile=true")) continue;
            String url = "/stw-cgi/media.cgi?msubmenu=videoprofile&action=update&Name=VMS" + i + "&Profile=" + i + urlPartMultiChannel;
            try {
                this.getHttpHandler().readGetRequest(url);
                continue;
            }
            catch (Exception ex) {
                this.logger.info("Could not rename Profile " + i + " for " + this);
            }
        }
    }

    private int setConstantBitrate(boolean constantBitrate, int videoSourceNr, int profileNumber, String urlPartMultiChannel) {
        String bitrateControlType;
        int profile = profileNumber;
        if (profile == -1) {
            this.logger.error("Profile number not valid for " + this + "\r\n\t Continuing with profile number 1");
            profile = 1;
        }
        String currentBitrateControlType = this.getSamsungDevice().readCameraParameters("/stw-cgi/media.cgi?msubmenu=videoprofile&action=view" + urlPartMultiChannel, String.format("Channel\\.%d\\.Profile\\.%d\\." + this.videoCodec.name().toUpperCase() + ".\\BitrateControlType", videoSourceNr - 1, profile), null);
        String string = bitrateControlType = constantBitrate ? "CBR" : "VBR";
        if (!this.isBitrateControlTypeSet(currentBitrateControlType, bitrateControlType)) {
            String url = "/stw-cgi/media.cgi?msubmenu=videoprofile&action=update&Profile=" + profile + "&" + this.videoCodec.name().toUpperCase() + ".BitrateControlType=" + bitrateControlType + urlPartMultiChannel;
            try {
                this.getHttpHandler().readGetRequest(url);
            }
            catch (SeeTecException ex) {
                if (ex.getErrorCode() == -21657) {
                    this.logger.error("Exception while setting image parameters for " + this + ex.getMessage());
                    return ex.getErrorCode();
                }
                this.logger.error("Exception while setting image parameters for " + this + "\r\n\t" + ex.getMessage() + "\r\n\tTrying to continue anyway");
            }
        }
        return 0;
    }

    private boolean isBitrateControlTypeSet(String currentBitrateControlType, String bitrateControlType) {
        return currentBitrateControlType != null && currentBitrateControlType.equals(bitrateControlType);
    }

    private void setResolution(int videoSourceNr, int profileNumber, int widthCorridorMode, int heightCorridorMode, String urlPartMultiChannel) throws SeeTecException {
        int profile = profileNumber;
        if (profile == -1) {
            this.logger.error("Profile number not valid for " + this + "\r\n\t Continuing with profile number 1");
            profile = 1;
        }
        String resolutionString = widthCorridorMode + "x" + heightCorridorMode;
        String resolutionOnCamera = this.getSamsungDevice().readCameraParameters("/stw-cgi/media.cgi?msubmenu=videoprofile&action=view", String.format("Channel\\.%d\\.Profile\\.%d\\.Resolution", videoSourceNr - 1, profile), null);
        if (!resolutionOnCamera.equals(resolutionString)) {
            this.logger.info("Resolution was not setting correct. Resolution on camera: " + resolutionOnCamera + ", resolution in SeeTec: " + resolutionString + " for " + this);
            String url = "/stw-cgi/media.cgi?msubmenu=videoprofile&action=update&Profile=" + profile + "&Resolution=" + resolutionString + urlPartMultiChannel;
            this.getHttpHandler().readGetRequest(url);
        }
    }

    private int setBitrate(int bitrate, int profileNumber, String urlPartMultiChannel) {
        int profile = profileNumber;
        if (profile == -1) {
            this.logger.error("Profile number not valid for " + this + "\r\n\t Continuing with profile number 1");
            profile = 1;
        }
        String url = "/stw-cgi/media.cgi?msubmenu=videoprofile&action=update&Profile=" + profile + "&Bitrate=" + bitrate + urlPartMultiChannel;
        try {
            this.getHttpHandler().readGetRequest(url);
        }
        catch (SeeTecException ex) {
            if (ex.getErrorCode() == -21657) {
                this.logger.error("Exception while setting image parameters for " + this + ex.getMessage());
                return ex.getErrorCode();
            }
            this.logger.error("Exception while setting image parameters for " + this + "\r\n\t" + ex.getMessage() + "\r\n\tTrying to continue anyway");
        }
        return 0;
    }

    protected SamsungDevice getSamsungDevice() {
        if (this.samsungDevice == null) {
            this.samsungDevice = (SamsungDevice)this.getVideoSrv().getDevice();
        }
        return this.samsungDevice;
    }
}

