/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.samsung;

import de.seetec.v5.re.cm.device.shared.videosource.PlaybackVideoSourceClient;
import de.seetec.v5.re.cm.device.video.samsung.SamsungDevice;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.util.ConfigurationException;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class SamsungPlaybackVideoSourceClient
extends PlaybackVideoSourceClient {
    private SamsungDevice device = null;
    private boolean isMultiChannelDevice = false;
    private int channelNumber = 0;

    @Override
    public int init() {
        try {
            this.errorCode = super.init();
            if (this.errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
                return this.errorCode;
            }
            this.device = (SamsungDevice)this.getVideoSrv().getDevice();
            try {
                this.setTimeDifference(this.getTimeDifferenceFromDevice());
            }
            catch (Exception ex) {
                this.logger.error("Error getting time from device " + this + ": " + ex.getMessage());
            }
            this.printDebug = false;
            this.setRtspPlaybackSpeed(Double.valueOf(this.getEdgeStorageParameter().getPlaybackSpeed()));
            this.setStartAllTrackIds(false);
            this.setLocalStorageReady(true);
            this.isMultiChannelDevice = this.device.getNumberOfVideoSources() > 1;
            this.channelNumber = this.videoSrv.getVideoSourceCnf().getServerEntryNo() - 1;
            this.setPlaybackCodec(this.getRecordingCodec());
            this.videoCodec = this.getPlaybackCodec();
            this.setFrameParameter("all");
            this.setPlaybackTransmissionID(TransmissionType.RTP_OVER_RTSP_OVER_TCP);
        }
        catch (Throwable ex) {
            this.logger.error("Error while initalizing " + this, ex);
        }
        return 0;
    }

    @Override
    protected Codec getRecordingCodec() {
        try {
            String url = "/stw-cgi/media.cgi?msubmenu=videoprofilepolicy&action=view";
            String result = this.device.getHttpHandler().readGetRequest(url);
            String recordingProfileIndex = this.device.readCameraParameters(url, "Channel\\." + this.channelNumber + "\\.RecordProfile", result);
            url = "/stw-cgi/media.cgi?msubmenu=videoprofile&action=view";
            result = this.device.getHttpHandler().readGetRequest(url);
            String codec = this.device.readCameraParameters(url, "Channel\\." + this.channelNumber + "\\.Profile\\." + recordingProfileIndex + "\\.EncodingType", result);
            Codec res = Codec.valueOf((String)codec);
            return res;
        }
        catch (Exception ex) {
            this.logger.warn("Exception while getting recording profile codec from camera for " + this + " : " + ex.getMessage());
            return null;
        }
    }

    @Override
    protected Long getTimeDifferenceFromDevice() throws Exception {
        return this.device.getTimeDifferenceFromDevice();
    }

    @Override
    protected double getMaxPlaybackSpeed() {
        return this.edgeStorageParameter.getPlaybackSpeed();
    }

    @Override
    protected String getRtspUrl(long startTimestamp, long endTimestamp, String nameOfRecording) throws ConfigurationException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        long newStartTimestamp = this.convertTimestampToCamera(startTimestamp, this.getTimeDifference());
        long newEndTimestamp = this.convertTimestampToCamera(endTimestamp, this.getTimeDifference());
        Date newStartDate = new Date(newStartTimestamp + 1000L);
        Date newEndDate = new Date(newEndTimestamp);
        String channel = this.isMultiChannelDevice ? this.channelNumber + "/" : "";
        String url = String.format("rtsp://%s/%srecording/%s-%s/play.smp", this.getHost(), channel, sdf.format(newStartDate), sdf.format(newEndDate));
        this.logger.info("Playback RTSP URL: " + url + " for " + this);
        return url;
    }

    @Override
    protected String getTimeRange(long startTimestamp, long endTimestamp, String nameOfTimerange) {
        return "";
    }

    protected static long convertCameraTimeToTimestamp(long cameraTimestamp, Long diff) {
        long t = cameraTimestamp - (diff == null ? 0L : diff);
        return t;
    }

    protected long convertTimestampToCamera(long timestamp, Long diff) {
        long t = timestamp + (diff == null ? 0L : diff);
        return t;
    }

    @Override
    protected String getRequireField() {
        return "";
    }
}

