/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.samsung;

import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.video.samsung.SamsungAlarmServerPushHandler;
import de.seetec.v5.re.cm.device.video.samsung.SamsungDevice;
import de.seetec.v5.re.cm.device.video.samsung.SamsungNetworkHelperAdapter;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.SeetecHttpClient;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;

public class SamsungMotionDetectionHandler
extends MotionDetectionHandler
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.samsung.SamsungMotionDetectionHandler";
    private static final int MOTIONDETECTION1 = 1;
    private static final int MOTIONDETECTION2 = 2;
    private static final int ANALYTICS1 = 4;
    private static final int ANALYTICS2 = 8;
    private SamsungAlarmServerPushHandler httpServerPushHandlerMd = null;
    private SamsungAlarmServerPushHandler httpServerPushHandlerVca = null;
    private NetworkParameter networkParameter = null;
    private String enableString = null;
    private String getMotionDataUrl = null;
    private SamsungDevice samsungDevice;
    private int mdVersionAvailable;
    private String getAnalyticsDataUrl;
    private final SeetecHttpClient samsungHttpClient = new SamsungNetworkHelperAdapter();

    public SamsungMotionDetectionHandler() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public int init(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        int errorCode = 0;
        this.listener = hardwareMotionDetection;
        if (this.listener == null) {
            return -20003;
        }
        this.samsungDevice = (SamsungDevice)this.listener.getVideoSrv().getDevice();
        this.samsungDevice.setModelInformation();
        this.mdVersionAvailable = this.samsungDevice.getMdVersion();
        try {
            this.networkParameter = this.listener.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter();
        }
        catch (ConfigurationException ex) {
            this.logger.info("Exception while getting Network Parameters: " + (Object)((Object)ex));
        }
        this.getMotionDataUrl = "/cgi-bin/control.cgi?msubmenu=motion&action=monitor";
        this.getAnalyticsDataUrl = "/cgi-bin/control.cgi?msubmenu=analysis&action=monitor";
        try {
            if ((this.mdVersionAvailable & 1) == 1) {
                String checkString = "/cgi-bin/event.cgi?msubmenu=motion&action=view";
                byte[] result = this.samsungHttpClient.readGetRequest(this.networkParameter, checkString, Integer.MAX_VALUE, true);
                String resultString = new String(result);
                if (!resultString.contains("device:1")) {
                    this.logger.info("Motion detection deactivated. Trying to activate motion detection for " + this);
                    this.enableString = "/cgi-bin/event.cgi?msubmenu=motion&action=apply&device=1";
                    this.samsungHttpClient.readGetRequest(this.networkParameter, this.enableString, Integer.MAX_VALUE, true);
                } else {
                    this.logger.info("Motion detection ist already activated");
                }
            }
            if ((this.mdVersionAvailable & 2) == 2) {
                this.enableString = "/cgi-bin/event.cgi?msubmenu=analysis&action=apply&enabled=1";
                this.samsungHttpClient.readGetRequest(this.networkParameter, this.enableString, Integer.MAX_VALUE, true);
            }
            if ((this.mdVersionAvailable & 4) == 4) {
                this.enableString = "/cgi-bin/event.cgi?submenu=analysis&action=apply&detection=1";
                this.samsungHttpClient.readGetRequest(this.networkParameter, this.enableString, Integer.MAX_VALUE, true);
            }
            if ((this.mdVersionAvailable & 8) == 8) {
                this.enableString = "/cgi-bin/event.cgi?msubmenu=analysis&action=apply&detection=1";
                this.samsungHttpClient.readGetRequest(this.networkParameter, this.enableString, Integer.MAX_VALUE, true);
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while enabling motion detection or analytics for " + this);
            this.notifyForNetworkProblems();
        }
        try {
            this.networkParameter.setSoTimeout(5000);
            if ((this.mdVersionAvailable & 1) == 1 || (this.mdVersionAvailable & 2) == 2) {
                this.logger.info("Starting Motion Detection Serverpush for " + this.listener.getVideoSrv().toString());
                this.httpServerPushHandlerMd = new SamsungAlarmServerPushHandler();
                errorCode = this.httpServerPushHandlerMd.init(this, this.networkParameter, this.getMotionDataUrl);
                if (errorCode != 0) {
                    this.logger.error("Error [" + errorCode + "] with " + this.httpServerPushHandlerMd);
                } else {
                    errorCode = this.httpServerPushHandlerMd.startServerPush(true);
                }
            }
            if ((this.mdVersionAvailable & 4) == 4 || (this.mdVersionAvailable & 8) == 8) {
                this.logger.info("Starting Analytics Serverpush for " + this.listener.getVideoSrv().toString());
                this.httpServerPushHandlerVca = new SamsungAlarmServerPushHandler();
                errorCode = this.httpServerPushHandlerVca.init(this, this.networkParameter, this.getAnalyticsDataUrl);
                if (errorCode != 0) {
                    this.logger.error("Error [" + errorCode + "] with " + this.httpServerPushHandlerVca);
                } else {
                    errorCode = this.httpServerPushHandlerVca.startServerPush(true);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Reading configuration from " + this.listener.getVideoSrv().getDevice() + " failed", (Throwable)e);
            errorCode = -21601;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            errorCode = -21651;
        }
        return errorCode;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.httpServerPushHandlerMd != null) {
            this.httpServerPushHandlerMd.shutdown();
            this.httpServerPushHandlerMd = null;
        }
        if (this.httpServerPushHandlerVca != null) {
            this.httpServerPushHandlerVca.shutdown();
            this.httpServerPushHandlerVca = null;
        }
        super.shutdown();
        return 0;
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void sendStatusService(int statusCode) {
        if (this.isShutdown(CLASS_NAME)) {
            return;
        }
        if (statusCode != 0) {
            this.listener.notifyForNetworkProblems();
        }
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21650);
    }

    @Override
    public void deliverContent(HttpServerPushContent httpServerPushContent) {
        boolean hasDetectedMotion = false;
        boolean hasDetectedAnalytics = false;
        byte[] content = httpServerPushContent.getContentBody();
        if (content != null) {
            StringBuilder mdForErrorPrinting;
            String[] windows;
            String[] analyticsFilters;
            if ((this.mdVersionAvailable & 4) == 4) {
                for (String analyticsFilter : analyticsFilters = new String(content).split("\r\n")) {
                    windows = analyticsFilter.split(":");
                    if (windows.length < 2 || windows[1] == null) continue;
                    if (windows[1].contains("H")) {
                        hasDetectedAnalytics = true;
                        continue;
                    }
                    if (windows[1].contains("L")) continue;
                    this.logger.error("Could not read motion data. ");
                    mdForErrorPrinting = new StringBuilder("");
                    for (String window : windows) {
                        mdForErrorPrinting.append(window);
                    }
                    this.logger.error("Delivered motion data: " + mdForErrorPrinting.toString());
                }
            }
            if ((this.mdVersionAvailable & 8) == 8) {
                for (String analyticsFilter : analyticsFilters = new String(content).split("\r\n")) {
                    windows = analyticsFilter.split(":");
                    if (windows.length < 2 || windows[1] == null) continue;
                    if (windows[1].contains("H")) {
                        hasDetectedAnalytics = true;
                        continue;
                    }
                    if (windows[1].contains("L")) continue;
                    this.logger.error("Could not read motion data. ");
                    mdForErrorPrinting = new StringBuilder();
                    for (String window : windows) {
                        mdForErrorPrinting.append(window);
                    }
                    this.logger.error("Delivered motion data: " + mdForErrorPrinting.toString());
                }
            }
            if ((this.mdVersionAvailable & 1) == 1 || (this.mdVersionAvailable & 2) == 2) {
                Object[] windows2 = new String(content).split(":");
                if (windows2.length != 2) {
                    this.logger.error("Wrong content format. Discarding for " + this.listener.getVideoSrv());
                    return;
                }
                if (windows2[1].contains("H")) {
                    hasDetectedMotion = true;
                } else if (windows2[1].contains("L")) {
                    hasDetectedMotion = false;
                } else {
                    this.logger.error("Could not read motion data. Delivered motion data: " + Arrays.toString(windows2));
                }
            }
            try {
                if ((hasDetectedMotion || hasDetectedAnalytics) && this.listener != null) {
                    this.listener.evaluateWindow(0);
                }
            }
            catch (NumberFormatException nfe) {
                this.logger.error("Error while converting number for " + this.listener.getVideoSrv());
            }
        }
    }
}

