/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.samsung;

import de.seetec.v5.re.cm.configuration.definition.camera.FeaturesType;
import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.ArchiveLimitationsType;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCodecDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCodecsType;
import de.seetec.v5.re.cm.configuration.definition.device.AvailableIOsType;
import de.seetec.v5.re.cm.configuration.definition.device.BitrateSettingsType;
import de.seetec.v5.re.cm.configuration.definition.device.CameraResolutionType;
import de.seetec.v5.re.cm.configuration.definition.device.CaptureModeDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.CodecType;
import de.seetec.v5.re.cm.configuration.definition.device.CommentsType;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceGroupMembershipsType;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceNetworkDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.EdgeStoragePlaybackSpeedType;
import de.seetec.v5.re.cm.configuration.definition.device.GenericEventDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.ImageRotationCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.MiscVideoServerCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.MultiStreamingDefinitionsType;
import de.seetec.v5.re.cm.configuration.definition.device.PtzCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.RtspSettingsType;
import de.seetec.v5.re.cm.configuration.definition.device.StreamDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedApiVersionsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedCameraResolutionsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedCaptureModesType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedEdgeStoragePlaybackSpeedsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedGenericEventsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedMPEGProfileIDs;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedOnvifEventsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedRotationAnglesType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedTransmissionTypeIDsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedVideoSourceEntityTypesType;
import de.seetec.v5.re.cm.configuration.definition.device.VideoSourceType;
import de.seetec.v5.re.cm.configuration.definition.device.VideoSourcesDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.VirtualCameraDefinitionType;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.cameraadministration.CameraAdministration;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.samsung.SamsungCameraAdministration;
import de.seetec.v5.re.cm.device.video.samsung.SamsungEventReader;
import de.seetec.v5.re.cm.device.video.samsung.SamsungHelper;
import de.seetec.v5.re.cm.device.video.samsung.SamsungIOHandler;
import de.seetec.v5.re.cm.device.video.samsung.SamsungPlaybackVideoSourceClient;
import de.seetec.v5.re.cm.shared.AbsolutePTZCapabilities;
import de.seetec.v5.re.cm.shared.timerange.TimeRange;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaID;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.HttpHandler;
import de.seetec.v5.shared.net.HttpHandlerImpl;
import de.seetec.v5.shared.net.NetworkHelperAdapter;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.NetworkParameterFactory;
import de.seetec.v5.shared.net.SeetecHttpClient;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.StringReader;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SamsungDevice
extends VideoServer {
    private static final int MOTIONDETECTION1 = 1;
    private static final int MOTIONDETECTION2 = 2;
    private static final int ANALYTICS1 = 4;
    private static final int ANALYTICS2 = 8;
    private static volatile CameraAdministration CAMERAADMINISTRATION = null;
    private String firmwareVersion = null;
    private boolean globalParametersSet = false;
    private long entityID;
    private int mdVersion;
    private Integer numberOfVideoSources = null;
    private int maxFps;
    private int maxFpsH264Pal;
    private int maxFpsMjpegPal;
    private boolean isPal = true;
    private int outputType;
    private int bitRateMode;
    private String rtspPath;
    private boolean hasOneAudioChannel = false;
    private boolean hasAudio = true;
    private int firstInput = 1;
    private int imageFlipType = 1;
    private boolean multimode = false;
    private int captureMode = 0;
    private int captureModeInSeetec;
    private int codecSelectMode;
    private int resolutionMode;
    private int framerateMode;
    private int compressionMode;
    private int gopSizeMode;
    private int mjpegCompressionMode;
    private boolean autoFocus;
    private int jpegConfigurationMode = 1;
    private int compressionChangeWaitingTime = 0;
    private boolean setCompressionAndBitrate = false;
    private int ptzMode = 1;
    private int h264ConfigurationMode = 1;
    private boolean ptzModeSet = false;
    private Boolean isSunApi2;
    private Map<String, String> deviceInfoMap = null;
    private Document attributesDoc = null;
    private final ReentrantLock reentrantLock = new ReentrantLock(false);
    private SamsungEventReader samsungEventReader;
    private final Semaphore semaphore = new Semaphore(1);
    private HttpHandler httpClient;

    @Override
    public int shutdown() {
        this.shutdownEventReader();
        return super.shutdown();
    }

    protected synchronized HttpHandler getHttpHandler() {
        if (this.httpClient == null) {
            try {
                NetworkParameter networkParameter = this.getDeviceCnf().getNetworkParameter();
                this.httpClient = new HttpHandlerImpl(networkParameter, true);
            }
            catch (Exception ex) {
                this.logger.error("Exception while reading configuration for " + this + ": " + ex.getMessage());
                return null;
            }
        }
        return this.httpClient;
    }

    public boolean getIsPal() {
        return this.isPal;
    }

    public int getBitRateMode() {
        return this.bitRateMode;
    }

    public final int getJpegConfigurationMode() {
        return this.jpegConfigurationMode;
    }

    public final boolean isMultiMode() {
        return this.multimode;
    }

    public final int getCompressionChangeWaitingTime() {
        return this.compressionChangeWaitingTime;
    }

    public final boolean setCompressionAndBitrate() {
        return this.setCompressionAndBitrate;
    }

    public final int getH264ConfigurationMode() {
        return this.h264ConfigurationMode;
    }

    public String getRtspPath() {
        return this.rtspPath;
    }

    public boolean isHasAudio() {
        return this.hasAudio;
    }

    public int getCaptureMode() {
        return this.captureMode;
    }

    public int getCodecSelectMode() {
        return this.codecSelectMode;
    }

    public int getCompressionMode() {
        return this.compressionMode;
    }

    public int getGopSizeMode() {
        return this.gopSizeMode;
    }

    public int getMjpegCompressionMode() {
        return this.mjpegCompressionMode;
    }

    @Override
    public final String getFirmwareVersion() {
        if (this.firmwareVersion != null) {
            return this.firmwareVersion;
        }
        return "<unknown>";
    }

    public void setModelInformation() {
        this.entityID = this.getDeviceType();
        try {
            String[] captureModes = this.getDeviceCnf().getCaptureMode().getDisplayResolution().split("MP");
            if (captureModes.length == 2 && !captureModes[0].isEmpty()) {
                this.captureModeInSeetec = Integer.parseInt(captureModes[0]);
            }
        }
        catch (ConfigurationException ex) {
            this.getLogger().error("Error reading capture mode from Seetec for " + this + ": " + ex.getMessage());
        }
        try {
            if (this.isSunApi_2()) {
                this.imageFlipType = 5;
                this.mdVersion = 5;
                this.maxFps = -1;
                this.maxFpsH264Pal = 30;
                this.maxFpsMjpegPal = 30;
                this.bitRateMode = 2;
                this.rtspPath = "/profile2/media.smp";
                this.firstInput = 1;
                this.codecSelectMode = 2;
                this.resolutionMode = 4;
                this.framerateMode = 5;
                this.compressionMode = 2;
                this.gopSizeMode = 2;
                this.mjpegCompressionMode = 2;
                this.compressionChangeWaitingTime = 0;
                this.setCompressionAndBitrate = true;
                this.jpegConfigurationMode = 5;
                this.autoFocus = true;
                this.ptzMode = 5;
                this.ptzModeSet = true;
            }
        }
        catch (SeeTecException ex) {
            this.getLogger().error("Exception while testing for API Version for " + this);
        }
        if (this.entityID == 201821L) {
            this.mdVersion = 2;
            this.maxFps = -1;
            this.outputType = 2;
            this.bitRateMode = 2;
            this.rtspPath = "/profile2/media.smp";
            this.firstInput = 1;
            this.codecSelectMode = 2;
            this.resolutionMode = 3;
            this.framerateMode = 2;
            this.compressionMode = 2;
            this.gopSizeMode = 2;
            this.mjpegCompressionMode = 2;
            this.autoFocus = false;
            this.setCompressionAndBitrate = true;
            this.compressionChangeWaitingTime = 0;
            this.jpegConfigurationMode = 2;
            this.imageFlipType = 0;
            this.ptzMode = 4;
            this.h264ConfigurationMode = 2;
        } else if (this.entityID == 201841L) {
            this.mdVersion = 2;
            this.maxFps = -1;
            this.bitRateMode = 2;
            this.rtspPath = "/profile2/media.smp";
            this.codecSelectMode = 2;
            this.resolutionMode = 3;
            this.framerateMode = 2;
            this.compressionMode = 2;
            this.gopSizeMode = 2;
            this.mjpegCompressionMode = 2;
            this.setCompressionAndBitrate = true;
            this.compressionChangeWaitingTime = 0;
            this.jpegConfigurationMode = 2;
            this.imageFlipType = 0;
            this.h264ConfigurationMode = 2;
            this.ptzMode = 4;
        } else if (this.entityID == 201822L) {
            this.mdVersion = 2;
            this.maxFps = -1;
            this.maxFpsH264Pal = 25;
            this.maxFpsMjpegPal = 25;
            this.outputType = 2;
            this.bitRateMode = 2;
            this.rtspPath = "/profile2/media.smp";
            this.hasOneAudioChannel = true;
            this.firstInput = 1;
            this.codecSelectMode = 2;
            this.resolutionMode = 3;
            this.framerateMode = 3;
            this.compressionMode = 2;
            this.gopSizeMode = 2;
            this.mjpegCompressionMode = 2;
            this.autoFocus = false;
            this.setCompressionAndBitrate = true;
            this.compressionChangeWaitingTime = 0;
            this.jpegConfigurationMode = 2;
            this.imageFlipType = 0;
            this.ptzMode = 4;
            this.h264ConfigurationMode = 2;
        } else if (this.entityID == 201823L) {
            this.mdVersion = 2;
            this.maxFps = -1;
            this.maxFpsH264Pal = 25;
            this.maxFpsMjpegPal = 25;
            this.outputType = 2;
            this.bitRateMode = 2;
            this.rtspPath = "/profile2/media.smp";
            this.firstInput = 1;
            this.codecSelectMode = 2;
            this.resolutionMode = 3;
            this.framerateMode = 3;
            this.compressionMode = 2;
            this.gopSizeMode = 2;
            this.mjpegCompressionMode = 2;
            this.autoFocus = false;
            this.setCompressionAndBitrate = true;
            this.compressionChangeWaitingTime = 0;
            this.jpegConfigurationMode = 2;
            this.imageFlipType = 0;
            this.ptzMode = 4;
            this.h264ConfigurationMode = 2;
        } else if (this.entityID == 201831L) {
            this.mdVersion = 1;
            this.maxFpsH264Pal = 30;
            this.maxFpsMjpegPal = 30;
            this.bitRateMode = 4;
            this.rtspPath = "/profile2/media.smp";
            this.firstInput = 1;
            this.codecSelectMode = 1;
            this.resolutionMode = 6;
            this.framerateMode = 4;
            this.compressionMode = 2;
            this.gopSizeMode = 2;
            this.imageFlipType = 1;
            this.mjpegCompressionMode = 3;
            this.compressionChangeWaitingTime = 0;
            this.jpegConfigurationMode = 3;
        } else if (this.entityID == 201836L) {
            this.mdVersion = 1;
            this.maxFpsH264Pal = 30;
            this.maxFpsMjpegPal = 30;
            this.bitRateMode = 2;
            this.rtspPath = "/profile2/media.smp";
            this.firstInput = 1;
            this.codecSelectMode = 1;
            this.resolutionMode = 6;
            this.framerateMode = 4;
            this.compressionMode = 2;
            this.gopSizeMode = 2;
            this.imageFlipType = 1;
            this.mjpegCompressionMode = 3;
            this.compressionChangeWaitingTime = 0;
            this.jpegConfigurationMode = 3;
        } else if (this.entityID == 201817L) {
            this.mdVersion = 1;
            this.maxFpsH264Pal = 30;
            this.maxFpsMjpegPal = 30;
            this.outputType = 1;
            this.bitRateMode = 1;
            this.rtspPath = "/h264/media.smp";
            this.firstInput = 0;
            this.codecSelectMode = 1;
            this.resolutionMode = 1;
            this.framerateMode = 1;
            this.compressionMode = 1;
            this.gopSizeMode = 1;
            this.imageFlipType = 1;
            this.mjpegCompressionMode = 1;
            this.compressionChangeWaitingTime = 0;
        } else if (this.entityID == 201813L) {
            this.mdVersion = 4;
            this.maxFps = 30;
            this.outputType = 1;
            this.bitRateMode = 1;
            this.rtspPath = "/h264/media.smp";
            this.firstInput = 0;
            this.codecSelectMode = 1;
            this.resolutionMode = 1;
            this.framerateMode = 1;
            this.compressionMode = 1;
            this.gopSizeMode = 1;
            this.imageFlipType = 2;
            this.mjpegCompressionMode = 1;
            this.compressionChangeWaitingTime = 0;
            this.setCompressionAndBitrate = true;
        } else if (this.entityID == 201830L) {
            this.mdVersion = 1;
            this.maxFps = 30;
            this.outputType = 2;
            this.bitRateMode = 2;
            this.rtspPath = "/profile2/media.smp";
            this.firstInput = 1;
            this.codecSelectMode = 1;
            this.resolutionMode = 3;
            this.framerateMode = 2;
            this.compressionMode = 2;
            this.gopSizeMode = 2;
            this.imageFlipType = 1;
            this.mjpegCompressionMode = 2;
            this.compressionChangeWaitingTime = 0;
            this.jpegConfigurationMode = 2;
        } else if (this.entityID == 201807L) {
            this.mdVersion = 1;
            this.maxFps = 30;
            this.outputType = 1;
            this.bitRateMode = 1;
            this.rtspPath = "/h264/media.smp";
            this.firstInput = 1;
            this.codecSelectMode = 1;
            this.resolutionMode = 1;
            this.framerateMode = 1;
            this.compressionMode = 1;
            this.gopSizeMode = 1;
            this.imageFlipType = 1;
            this.mjpegCompressionMode = 1;
            this.compressionChangeWaitingTime = 0;
        } else if (this.entityID == 201809L) {
            this.mdVersion = 8;
            this.maxFps = 30;
            this.outputType = 1;
            this.bitRateMode = 1;
            this.rtspPath = "/h264/media.smp";
            this.firstInput = 1;
            this.codecSelectMode = 1;
            this.resolutionMode = 1;
            this.framerateMode = 1;
            this.compressionMode = 1;
            this.gopSizeMode = 1;
            this.imageFlipType = 1;
            this.mjpegCompressionMode = 1;
            this.compressionChangeWaitingTime = 0;
        } else if (this.entityID == 201814L) {
            this.mdVersion = 1;
            this.maxFps = -1;
            this.outputType = 2;
            this.bitRateMode = 2;
            this.rtspPath = "/profile2/media.smp";
            this.firstInput = 1;
            this.codecSelectMode = 2;
            this.resolutionMode = 3;
            this.framerateMode = 2;
            this.compressionMode = 2;
            this.gopSizeMode = 2;
            this.mjpegCompressionMode = 2;
            this.autoFocus = false;
            this.compressionChangeWaitingTime = 0;
            this.setCompressionAndBitrate = true;
            this.jpegConfigurationMode = 2;
            this.imageFlipType = 0;
            if (this.firmwareVersion != null && this.firmwareVersion.equals("1.24_111027")) {
                this.getLogger().info("Firmware Version is " + this.firmwareVersion + ", using specialized PTZ commands for " + this);
                this.ptzMode = 4;
            } else if (this.firmwareVersion != null) {
                this.getLogger().info("Firmware Version is " + this.firmwareVersion + ", using standard PTZ commands for " + this);
                this.ptzMode = 3;
            } else {
                this.getLogger().info("Could not read Firmware yet for " + this);
                this.ptzMode = 3;
            }
        } else if (this.entityID == 201819L) {
            this.mdVersion = 1;
            this.maxFps = -1;
            this.outputType = 2;
            this.bitRateMode = 2;
            this.rtspPath = "/profile2/media.smp";
            this.firstInput = 1;
            this.codecSelectMode = 2;
            this.resolutionMode = 3;
            this.framerateMode = 2;
            this.compressionMode = 2;
            this.gopSizeMode = 2;
            this.imageFlipType = 0;
            this.mjpegCompressionMode = 2;
            this.compressionChangeWaitingTime = 0;
            this.setCompressionAndBitrate = true;
            this.jpegConfigurationMode = 2;
        } else if (this.entityID == 201829L) {
            this.mdVersion = 10;
            this.maxFps = -1;
            this.outputType = 2;
            this.bitRateMode = 2;
            this.rtspPath = "/profile2/media.smp";
            this.firstInput = 1;
            this.codecSelectMode = 2;
            this.resolutionMode = 3;
            this.framerateMode = 2;
            this.compressionMode = 2;
            this.gopSizeMode = 2;
            this.mjpegCompressionMode = 3;
            this.autoFocus = true;
            this.compressionChangeWaitingTime = 0;
            this.setCompressionAndBitrate = true;
            this.jpegConfigurationMode = 2;
            this.imageFlipType = 1;
        } else if (this.entityID == 201811L) {
            this.mdVersion = 1;
            this.maxFps = -1;
            this.outputType = 2;
            this.bitRateMode = 2;
            this.rtspPath = "/profile2/media.smp";
            this.firstInput = 0;
            this.codecSelectMode = 2;
            this.resolutionMode = 3;
            this.framerateMode = 2;
            this.compressionMode = 2;
            this.gopSizeMode = 2;
            this.imageFlipType = 3;
            this.mjpegCompressionMode = 2;
            this.autoFocus = false;
            this.compressionChangeWaitingTime = 0;
            this.setCompressionAndBitrate = true;
            this.jpegConfigurationMode = 4;
            this.h264ConfigurationMode = 2;
        } else if (this.entityID == 201812L) {
            this.mdVersion = 1;
            this.maxFps = -1;
            this.maxFpsH264Pal = 30;
            this.maxFpsMjpegPal = 30;
            this.outputType = 2;
            this.bitRateMode = 2;
            this.rtspPath = "/profile2/media.smp";
            this.firstInput = 1;
            this.codecSelectMode = 2;
            this.resolutionMode = 2;
            this.framerateMode = 3;
            this.compressionMode = 2;
            this.gopSizeMode = 2;
            this.imageFlipType = 1;
            this.mjpegCompressionMode = 2;
            this.compressionChangeWaitingTime = 0;
            this.jpegConfigurationMode = 2;
            this.setCompressionAndBitrate = true;
        } else if (this.entityID == 201835L) {
            this.mdVersion = 1;
            this.maxFps = -1;
            this.maxFpsH264Pal = 30;
            this.maxFpsMjpegPal = 30;
            this.bitRateMode = 2;
            this.rtspPath = "/profile2/media.smp";
            this.firstInput = 1;
            this.codecSelectMode = 2;
            this.resolutionMode = 7;
            this.framerateMode = 3;
            this.compressionMode = 2;
            this.gopSizeMode = 2;
            this.imageFlipType = 1;
            this.mjpegCompressionMode = 2;
            this.compressionChangeWaitingTime = 0;
            this.jpegConfigurationMode = 2;
            this.setCompressionAndBitrate = true;
        } else if (this.entityID == 201820L) {
            this.mdVersion = 9;
            this.maxFps = -1;
            this.bitRateMode = 2;
            this.rtspPath = "/profile2/media.smp";
            this.firstInput = 1;
            this.codecSelectMode = 2;
            this.resolutionMode = 2;
            this.framerateMode = 4;
            this.compressionMode = 2;
            this.gopSizeMode = 2;
            this.imageFlipType = 1;
            this.mjpegCompressionMode = 2;
            this.compressionChangeWaitingTime = 0;
            this.jpegConfigurationMode = 2;
            this.setCompressionAndBitrate = true;
        } else if (this.entityID == 201843L) {
            this.mdVersion = 1;
            this.maxFps = -1;
            this.bitRateMode = 2;
            this.rtspPath = "/profile2/media.smp";
            this.firstInput = 1;
            this.codecSelectMode = 2;
            this.resolutionMode = 7;
            this.framerateMode = 4;
            this.compressionMode = 2;
            this.gopSizeMode = 2;
            this.imageFlipType = 1;
            this.mjpegCompressionMode = 2;
            this.compressionChangeWaitingTime = 0;
            this.jpegConfigurationMode = 4;
            this.setCompressionAndBitrate = true;
        } else if (this.entityID == 201808L) {
            this.mdVersion = 5;
            this.maxFps = -1;
            this.outputType = 2;
            this.bitRateMode = 2;
            this.rtspPath = "/profile2/media.smp";
            this.firstInput = 1;
            this.codecSelectMode = 2;
            this.resolutionMode = 2;
            this.framerateMode = 4;
            this.compressionMode = 2;
            this.gopSizeMode = 2;
            this.imageFlipType = 1;
            this.mjpegCompressionMode = 2;
            this.compressionChangeWaitingTime = 0;
            this.setCompressionAndBitrate = true;
            this.jpegConfigurationMode = 2;
        } else if (this.entityID == 201810L) {
            this.mdVersion = 5;
            this.maxFps = 22;
            this.outputType = 2;
            this.bitRateMode = 2;
            this.rtspPath = "/profile2/media.smp";
            this.firstInput = 1;
            this.codecSelectMode = 2;
            this.resolutionMode = 2;
            this.framerateMode = 4;
            this.compressionMode = 2;
            this.gopSizeMode = 2;
            this.imageFlipType = 1;
            this.mjpegCompressionMode = 2;
            this.compressionChangeWaitingTime = 0;
            this.setCompressionAndBitrate = true;
            this.jpegConfigurationMode = 2;
        } else if (this.entityID == 201825L) {
            this.mdVersion = 9;
            this.maxFps = 22;
            this.outputType = 2;
            this.bitRateMode = 2;
            this.rtspPath = "/profile2/media.smp";
            this.firstInput = 1;
            this.codecSelectMode = 2;
            this.resolutionMode = 2;
            this.framerateMode = 4;
            this.compressionMode = 2;
            this.gopSizeMode = 2;
            this.imageFlipType = 1;
            this.mjpegCompressionMode = 2;
            this.compressionChangeWaitingTime = 0;
            this.setCompressionAndBitrate = true;
            this.jpegConfigurationMode = 2;
        } else if (this.entityID == 201815L) {
            this.mdVersion = 5;
            this.maxFps = -1;
            this.maxFpsH264Pal = 30;
            this.maxFpsMjpegPal = 30;
            this.outputType = 2;
            this.bitRateMode = 2;
            this.rtspPath = "/profile2/media.smp";
            this.firstInput = 1;
            this.codecSelectMode = 2;
            this.resolutionMode = 2;
            this.framerateMode = 3;
            this.compressionMode = 2;
            this.gopSizeMode = 2;
            this.imageFlipType = 1;
            this.mjpegCompressionMode = 2;
            this.autoFocus = true;
            this.compressionChangeWaitingTime = 0;
            this.setCompressionAndBitrate = true;
            this.jpegConfigurationMode = 2;
            this.ptzMode = 2;
        } else if (this.entityID == 201827L) {
            this.mdVersion = 5;
            this.maxFps = -1;
            this.maxFpsH264Pal = 30;
            this.maxFpsMjpegPal = 30;
            this.outputType = 2;
            this.bitRateMode = 2;
            this.rtspPath = "/profile2/media.smp";
            this.firstInput = 1;
            this.codecSelectMode = 2;
            this.resolutionMode = 2;
            this.framerateMode = 3;
            this.compressionMode = 2;
            this.gopSizeMode = 2;
            this.imageFlipType = 1;
            this.mjpegCompressionMode = 2;
            this.autoFocus = true;
            this.jpegConfigurationMode = 2;
            this.compressionChangeWaitingTime = 0;
            this.setCompressionAndBitrate = true;
        } else if (this.entityID == 201833L) {
            this.mdVersion = 5;
            this.maxFps = -1;
            this.maxFpsH264Pal = 30;
            this.maxFpsMjpegPal = 30;
            this.outputType = 2;
            this.bitRateMode = 2;
            this.rtspPath = "/profile2/media.smp";
            this.firstInput = 1;
            this.codecSelectMode = 2;
            this.resolutionMode = 4;
            this.framerateMode = 5;
            this.compressionMode = 2;
            this.gopSizeMode = 2;
            this.imageFlipType = 4;
            this.mjpegCompressionMode = 2;
            this.autoFocus = true;
            this.compressionChangeWaitingTime = 0;
            this.setCompressionAndBitrate = true;
            this.jpegConfigurationMode = 5;
            this.ptzMode = 4;
        } else if (this.entityID == 201848L) {
            this.mdVersion = 5;
            this.maxFps = -1;
            this.maxFpsH264Pal = 30;
            this.maxFpsMjpegPal = 15;
            this.outputType = 2;
            this.bitRateMode = 2;
            this.rtspPath = "/profile2/media.smp";
            this.firstInput = 1;
            this.codecSelectMode = 2;
            this.resolutionMode = 4;
            this.framerateMode = 5;
            this.compressionMode = 2;
            this.gopSizeMode = 2;
            this.imageFlipType = 4;
            this.mjpegCompressionMode = 3;
            this.autoFocus = true;
            this.compressionChangeWaitingTime = 0;
            this.setCompressionAndBitrate = true;
            this.jpegConfigurationMode = 5;
            this.ptzMode = 4;
        } else if (this.entityID == 201824L) {
            this.mdVersion = 1;
            this.maxFps = -1;
            this.outputType = 2;
            this.bitRateMode = 2;
            this.rtspPath = "/profile2/media.smp";
            this.firstInput = 1;
            this.multimode = true;
            this.codecSelectMode = 2;
            this.resolutionMode = this.captureModeInSeetec == 2 ? 4 : 5;
            this.compressionMode = 2;
            this.gopSizeMode = 2;
            this.imageFlipType = 1;
            this.mjpegCompressionMode = 2;
            this.compressionChangeWaitingTime = 0;
            this.jpegConfigurationMode = 3;
            this.setCompressionAndBitrate = true;
        } else if (this.entityID == 201838L) {
            this.mdVersion = 1;
            this.maxFps = -1;
            this.outputType = 2;
            this.bitRateMode = 2;
            this.rtspPath = "/profile2/media.smp";
            this.multimode = true;
            this.codecSelectMode = 2;
            this.resolutionMode = this.captureModeInSeetec == 2 ? 4 : 5;
            this.compressionMode = 2;
            this.gopSizeMode = 2;
            this.imageFlipType = 1;
            this.mjpegCompressionMode = 2;
            this.compressionChangeWaitingTime = 0;
            this.jpegConfigurationMode = 3;
            this.setCompressionAndBitrate = true;
        } else if (this.entityID == 201842L) {
            this.mdVersion = 5;
            this.maxFps = -1;
            this.outputType = 2;
            this.bitRateMode = 2;
            this.rtspPath = "/profile2/media.smp";
            this.multimode = true;
            this.codecSelectMode = 2;
            this.resolutionMode = this.captureModeInSeetec == 2 ? 4 : 5;
            this.compressionMode = 2;
            this.gopSizeMode = 2;
            this.imageFlipType = 1;
            this.mjpegCompressionMode = 2;
            this.compressionChangeWaitingTime = 0;
            this.jpegConfigurationMode = 3;
            this.setCompressionAndBitrate = true;
        } else if (this.entityID == 201828L) {
            this.mdVersion = 1;
            this.maxFps = -1;
            this.outputType = 2;
            this.bitRateMode = 2;
            this.rtspPath = "/profile2/media.smp";
            this.firstInput = 1;
            this.multimode = true;
            this.codecSelectMode = 2;
            this.resolutionMode = this.captureModeInSeetec == 2 ? 4 : 5;
            this.compressionMode = 2;
            this.gopSizeMode = 2;
            this.imageFlipType = 1;
            this.mjpegCompressionMode = 2;
            this.compressionChangeWaitingTime = 0;
            this.jpegConfigurationMode = 3;
            this.setCompressionAndBitrate = true;
        } else if (this.entityID == 201826L) {
            this.mdVersion = 1;
            this.maxFps = -1;
            this.outputType = 2;
            this.bitRateMode = 2;
            this.rtspPath = "/profile2/media.smp";
            this.firstInput = 1;
            this.multimode = true;
            this.codecSelectMode = 2;
            this.resolutionMode = this.captureModeInSeetec == 2 ? 4 : 5;
            this.compressionMode = 2;
            this.gopSizeMode = 2;
            this.imageFlipType = 1;
            this.mjpegCompressionMode = 2;
            this.compressionChangeWaitingTime = 0;
            this.jpegConfigurationMode = 3;
            this.setCompressionAndBitrate = true;
        }
        if (!this.ptzModeSet) {
            String url = "/cgi-bin/about.cgi?msubmenu=capability&action=view";
            try {
                String resultString = this.getHttpHandler().readGetRequest(url);
                if (resultString != null) {
                    String[] resultLines;
                    for (String resultLine : resultLines = resultString.split("\r\n")) {
                        if (!resultLine.toLowerCase().contains("fastptz:true")) continue;
                        this.ptzMode = 4;
                    }
                }
                this.getLogger().info("Samsung Fast PTZ mode is " + (this.ptzMode == 4 ? "" : "NOT ") + "used for " + this);
            }
            catch (SeeTecException ex) {
                this.getLogger().error("Exception while reading PTZ capabilities for " + this);
            }
            this.ptzModeSet = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int handleGlobalParameters(int rotationAngle, boolean useDateTime, boolean useTitle, String title, String urlPartMultiChannel) {
        int error = 0;
        try {
            String[] resultStringLines2;
            String resultString;
            block21: {
                this.reentrantLock.lock();
                if (this.globalParametersSet) {
                    int n = 0;
                    return n;
                }
                this.entityID = this.getDeviceType();
                try {
                    if (!this.isSunApi_2()) {
                        this.getLogger().info("Device does NOT handle the SUNAPI commmand. Using old Samsung HTTP API for " + this);
                        String readFirmwareUrl = "/cgi-bin/about.cgi?msubmenu=about&action=view2";
                        try {
                            resultString = this.getHttpHandler().readGetRequest(readFirmwareUrl);
                            if (resultString != null) {
                                for (String resultStringLine : resultStringLines2 = resultString.split("\r\n")) {
                                    int startIndex = resultStringLine.indexOf("version:");
                                    if (startIndex != -1) {
                                        String versionNumber = resultStringLine.substring(startIndex + 8);
                                        this.setFirmwareVersion(versionNumber);
                                        this.getLogger().info("Firmware version on " + this + ": " + this.getFirmwareVersion());
                                    }
                                    if ((startIndex = resultStringLine.indexOf("broadcasting:")) == -1) continue;
                                    this.isPal = !resultStringLine.contains("NTSC");
                                }
                            }
                            break block21;
                        }
                        catch (SeeTecException ex) {
                            this.getLogger().warn("Error setting/reading global camera parameters for " + this + ": " + ex.getMessage());
                            error = ex.getErrorCode();
                            if (error == -21657) {
                                int resultStringLines2 = error;
                                this.reentrantLock.unlock();
                                return resultStringLines2;
                            }
                            break block21;
                        }
                    }
                }
                catch (SeeTecException ex) {
                    this.getLogger().error("Exception while setting global device parameters for " + this + " : " + ex.getMessage());
                    break block21;
                }
                {
                    String url = "/stw-cgi/system.cgi?msubmenu=deviceinfo&action=view";
                    String testResult = this.getHttpHandler().readGetRequest(url);
                    String firmware = this.readCameraParameters(url, "firmwareversion", testResult);
                    firmware = firmware == null ? "<unknown>" : firmware;
                    this.setFirmwareVersion(firmware);
                    this.getLogger().info("Firmware version on " + this + " : " + this.getFirmwareVersion());
                }
            }
            this.setModelInformation();
            if (this.hasOneAudioChannel) {
                String readCapabilities = "/cgi-bin/about.cgi?msubmenu=capability&action=view" + urlPartMultiChannel;
                try {
                    resultString = this.getHttpHandler().readGetRequest(readCapabilities);
                    if (resultString != null) {
                        resultStringLines2 = resultString.split("\r\n");
                        this.hasAudio = false;
                        for (String resultStringLine : resultStringLines2) {
                            if (!resultStringLine.toLowerCase().contains("audioinput")) continue;
                            this.hasAudio = true;
                        }
                    }
                }
                catch (SeeTecException ex) {
                    this.getLogger().error("Exception while reading System capabilities for " + this + ", " + ex.getMessage());
                }
            }
            this.globalParametersSet = true;
            return error;
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    public String parseCameraData(String dataFromCamera, String parameter, String operator, String lineDelimiter) {
        String[] data = dataFromCamera.split(lineDelimiter);
        if (data.length > 0) {
            for (String dataLines : data) {
                String[] dataLine;
                if (!dataLines.toLowerCase().contains(parameter.toLowerCase()) || (dataLine = dataLines.split(operator)).length != 2) continue;
                return dataLine[1].trim();
            }
        }
        return null;
    }

    public int getFramerate(long framerate, int captureMode, Integer width, HashMap<Integer, Integer>[][] framerates, Codec codec) {
        int fps = (int)((framerate + 999L) / 1000L);
        if (captureMode == 2) {
            if (codec == Codec.MJPEG) {
                int f = framerates[0][0].get(width);
                fps = fps > f ? f : fps;
                fps = fps < 1 ? 1 : fps;
            } else {
                int f = framerates[0][1].get(0);
                fps = fps > f ? f : fps;
                fps = fps < 1 ? 1 : fps;
            }
        } else if (codec == Codec.MJPEG) {
            int f = framerates[1][0].get(width);
            fps = fps > f ? f : fps;
            fps = fps < 1 ? 1 : fps;
        } else {
            int f = framerates[1][1].get(0);
            fps = fps > f ? f : fps;
            fps = fps < 1 ? 1 : fps;
        }
        return fps;
    }

    public int getFramerate(long framerate, int width, int height, Codec codec) {
        int fps = (int)((framerate + 999L) / 1000L);
        switch (this.framerateMode) {
            case 1: {
                if (this.isPal) {
                    if (fps >= 19) {
                        fps = 0;
                        break;
                    }
                    if (fps > 9) {
                        fps = 1;
                        break;
                    }
                    if (fps >= 5) {
                        fps = 2;
                        break;
                    }
                    if (fps >= 2) {
                        fps = 3;
                        break;
                    }
                    fps = 4;
                    break;
                }
                if (fps > 22) {
                    fps = 0;
                    break;
                }
                if (fps > 11) {
                    fps = 1;
                    break;
                }
                if (fps > 5) {
                    fps = 2;
                    break;
                }
                if (fps >= 2) {
                    fps = 3;
                    break;
                }
                fps = 4;
                break;
            }
            case 2: {
                fps = width == 1280 && height == 1024 && this.maxFps != -1 ? (fps > this.maxFps ? this.maxFps : fps) : (this.isPal ? (fps > 25 ? 25 : fps) : (fps > 30 ? 30 : fps));
                fps = fps < 1 ? 1 : fps;
                break;
            }
            case 3: {
                fps = codec == Codec.MJPEG ? (fps > this.maxFpsMjpegPal ? this.maxFpsMjpegPal : fps) : (fps > this.maxFpsH264Pal ? this.maxFpsH264Pal : fps);
                fps = fps < 1 ? 1 : fps;
                break;
            }
            case 4: {
                fps = width == 1280 && height == 1024 && this.maxFps != -1 ? (fps > this.maxFps ? this.maxFps : fps) : (fps > 30 ? 30 : fps);
                fps = fps < 1 ? 1 : fps;
                break;
            }
            case 5: {
                fps = codec == Codec.MJPEG && width >= 1024 ? (fps > 15 ? 15 : fps) : (fps > 30 ? 30 : fps);
                fps = fps < 1 ? 1 : fps;
                break;
            }
        }
        return fps;
    }

    public int getResolution(int width, int height) {
        int resolution = 0;
        int mode = this.getResolutionMode();
        switch (mode) {
            case 1: {
                if (width == 704) {
                    resolution = 0;
                    break;
                }
                if (width == 640) {
                    resolution = 1;
                    break;
                }
                if (width != 352) break;
                resolution = 2;
                break;
            }
            case 2: {
                if (width == 1280 && height == 1024) {
                    resolution = 0;
                    break;
                }
                if (width == 1280 && height == 720) {
                    resolution = 1;
                    break;
                }
                if (width == 800) {
                    resolution = 2;
                    break;
                }
                if (width == 640) {
                    resolution = 3;
                    break;
                }
                if (width == 320) {
                    resolution = 4;
                    break;
                }
                if (width != 1024) break;
                resolution = 5;
                break;
            }
            case 3: {
                if (width == 704) {
                    resolution = 0;
                    break;
                }
                if (width == 640) {
                    resolution = 1;
                    break;
                }
                if (width == 352) {
                    resolution = 2;
                    break;
                }
                if (width != 320) break;
                resolution = 3;
                break;
            }
            case 4: {
                if (width == 1920) {
                    resolution = 0;
                    break;
                }
                if (width == 1280 && height == 1024) {
                    resolution = 1;
                    break;
                }
                if (width == 1280 && height == 960) {
                    resolution = 2;
                    break;
                }
                if (width == 1280 && height == 720) {
                    resolution = 3;
                    break;
                }
                if (width == 1024) {
                    resolution = 4;
                    break;
                }
                if (width == 800 && height == 600) {
                    resolution = 5;
                    break;
                }
                if (width == 800 && height == 450) {
                    resolution = 6;
                    break;
                }
                if (width == 640 && height == 480) {
                    resolution = 7;
                    break;
                }
                if (width == 640 && height == 360) {
                    resolution = 8;
                    break;
                }
                if (width == 320 && height == 240) {
                    resolution = 9;
                    break;
                }
                resolution = 10;
                break;
            }
            case 5: {
                if (width == 2048) {
                    resolution = 0;
                    break;
                }
                if (width == 1920) {
                    resolution = 1;
                    break;
                }
                if (width == 1600) {
                    resolution = 2;
                    break;
                }
                if (width == 1280 && height == 1024) {
                    resolution = 3;
                    break;
                }
                if (width == 1280 && height == 960) {
                    resolution = 4;
                    break;
                }
                if (width == 1280 && height == 720) {
                    resolution = 5;
                    break;
                }
                if (width == 1024) {
                    resolution = 6;
                    break;
                }
                if (width == 800 && height == 600) {
                    resolution = 7;
                    break;
                }
                if (width == 800 && height == 450) {
                    resolution = 8;
                    break;
                }
                if (width == 640 && height == 480) {
                    resolution = 9;
                    break;
                }
                if (width == 640 && height == 360) {
                    resolution = 10;
                    break;
                }
                if (width == 320 && height == 240) {
                    resolution = 11;
                    break;
                }
                resolution = 12;
                break;
            }
            case 6: {
                if (width == 640) {
                    resolution = 0;
                    break;
                }
                if (width == 320) {
                    resolution = 1;
                    break;
                }
                if (width != 160) break;
                resolution = 2;
                break;
            }
            case 7: {
                if (width == 1280 && height == 1024) {
                    resolution = 0;
                    break;
                }
                if (width == 1280 && height == 720) {
                    resolution = 1;
                    break;
                }
                if (width == 1024) {
                    resolution = 2;
                    break;
                }
                if (width == 800) {
                    resolution = 3;
                    break;
                }
                if (width == 640) {
                    resolution = 4;
                    break;
                }
                if (width != 320) break;
                resolution = 5;
                break;
            }
        }
        return resolution;
    }

    public final HashMap<Integer, Integer>[][] getGlobalMaxFps() {
        HashMap[][] localMaxFps = new HashMap[2][2];
        localMaxFps[0][0] = new HashMap();
        localMaxFps[0][0].put(320, 30);
        localMaxFps[0][0].put(640, 30);
        localMaxFps[0][0].put(800, 30);
        localMaxFps[0][0].put(1024, 15);
        localMaxFps[0][0].put(1280, 15);
        localMaxFps[0][0].put(1920, 15);
        localMaxFps[0][1] = new HashMap();
        localMaxFps[0][1].put(0, 30);
        localMaxFps[1][0] = new HashMap();
        localMaxFps[1][0].put(320, 20);
        localMaxFps[1][0].put(640, 20);
        localMaxFps[1][0].put(800, 20);
        localMaxFps[1][0].put(1024, 15);
        localMaxFps[1][0].put(1280, 15);
        localMaxFps[1][0].put(1600, 15);
        localMaxFps[1][0].put(1920, 15);
        localMaxFps[1][0].put(2048, 10);
        localMaxFps[1][1] = new HashMap();
        localMaxFps[1][1].put(0, 20);
        return localMaxFps;
    }

    public int[] getBitrateLimits(String codec) {
        String url = "/cgi-bin/about.cgi?msubmenu=capability&action=view";
        try {
            String parameters = this.getHttpHandler().readGetRequest(url);
            if (parameters != null) {
                String[] parameterLines;
                for (String parameter : parameterLines = parameters.split("\r\n")) {
                    String[] bitrates;
                    String[] bitrateString;
                    if (!parameter.contains("Video.VBR.MaximumBitrate." + codec + ":") || (bitrateString = parameter.split(":")).length != 2 || (bitrates = bitrateString[1].split("-")).length != 2) continue;
                    int lower = Integer.parseInt(bitrates[0]);
                    int upper = Integer.parseInt(bitrates[1]);
                    return new int[]{lower, upper};
                }
            }
        }
        catch (Throwable ex) {
            this.getLogger().warn("Could not read firmware limits. We'll use 64 - 5120 kbit as default values for " + this);
        }
        return new int[]{64, 5120};
    }

    public static final int checkDeviceInfos(long type, String host, int port, boolean useAuthorization, String user, String pass, int timeout) {
        String[] stringArray;
        if (useAuthorization) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = user;
            stringArray = stringArray2;
            stringArray2[1] = pass;
        } else {
            stringArray = null;
        }
        NetworkParameter networkParameter = NetworkParameterFactory.createNetworkParameter((String)host, (int)port, (boolean)false, (int)-1, (int)timeout, stringArray);
        try {
            HttpHandlerImpl httpHandler = new HttpHandlerImpl(networkParameter, true);
            String response = httpHandler.readGetRequest("/stw-cgi/system.cgi?msubmenu=deviceinfo&action=view");
            if (response != null && !response.toLowerCase().contains("model=")) {
                return -21697;
            }
            return 0;
        }
        catch (SeeTecException ex1) {
            if (ex1.getNetworkStatus() == HTTPStatusCode.HTTP_NOT_FOUND) {
                try {
                    HttpHandlerImpl httpHandler = new HttpHandlerImpl(networkParameter, true);
                    String response = httpHandler.readGetRequest("/stw-cgi/system.cgi?msubmenu=deviceinfo&action=view");
                    if (response != null && !response.toLowerCase().contains("model:")) {
                        return -21697;
                    }
                    return 0;
                }
                catch (SeeTecException ex2) {
                    if (ex2.getNetworkStatus() == HTTPStatusCode.HTTP_NOT_FOUND) {
                        return -21697;
                    }
                    return -21696;
                }
                catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException ex) {
                    return -21696;
                }
            }
            if (ex1.getNetworkStatus() == HTTPStatusCode.HTTP_UNAUTHORIZED) {
                return -21701;
            }
            return -21696;
        }
        catch (Exception ex) {
            return -21696;
        }
    }

    protected int getImageFlipType() {
        return this.imageFlipType;
    }

    protected int getOutputType() {
        return this.outputType;
    }

    protected int getMdVersion() {
        return this.mdVersion;
    }

    protected boolean isSunApi_2() throws SeeTecException {
        block7: {
            if (this.isSunApi2 != null) {
                return this.isSunApi2 != false && this.isRegisteredForSunAPI();
            }
            String url = "/stw-cgi/system.cgi?msubmenu=deviceinfo&action=view";
            try {
                String testResult = this.getHttpHandler().readGetRequest(url);
                if (testResult != null && !testResult.toLowerCase().contains("model=")) {
                    this.isSunApi2 = false;
                    this.getLogger().info("Device does NOT handle the SUNAPI commmands. Using SUNAPI 1 for " + this);
                } else {
                    this.isSunApi2 = true;
                    this.getLogger().info("Device does handle the SUNAPI 2 commands for " + this);
                }
            }
            catch (SeeTecException ex) {
                if (ex.getNetworkStatus() == HTTPStatusCode.HTTP_UNAUTHORIZED || ex.getNetworkStatus() == HTTPStatusCode.HTTP_ACCOUNT_BLOCKED) {
                    throw new SeeTecException(-21657, "Unauthorized eaccess for " + this);
                }
                if (ex.getErrorCode() != -20100) break block7;
                this.getLogger().error("Exception while testing for SUNAPI 2.0 support for " + this);
            }
        }
        if (this.isSunApi2 == null) {
            throw new SeeTecException(-20100, "Error while testing for SUNAPI 2.0 support for " + this);
        }
        return this.isSunApi2 != false && this.isRegisteredForSunAPI();
    }

    protected final int getPtzMode() {
        return this.ptzMode;
    }

    protected boolean isAutoFocus() {
        return this.autoFocus;
    }

    protected List<String> getAttributesFromEnum(String path, Document attributesDoc) {
        String[] parts = path.split("/");
        StringBuilder buf = new StringBuilder();
        if (parts.length > 0) {
            buf.append(String.format("//cgi[@name='%s']", parts[0]));
        }
        if (parts.length > 1) {
            buf.append(String.format("/submenu[@name='%s']", parts[1]));
        }
        if (parts.length > 2) {
            buf.append(String.format("/action[@name='%s']", parts[2].replace("+", "/")));
        }
        if (parts.length > 3) {
            buf.append(String.format("/parameter[@name='%s']", parts[3]));
            buf.append("/dataType/enum/entry/@value");
        }
        return this.getAttributes(buf.toString(), attributesDoc);
    }

    protected Document getAttributesDoc() {
        if (this.attributesDoc == null) {
            this.attributesDoc = this.readAttributesFromDevice();
            if (this.attributesDoc == null) {
                this.getLogger().error("Could not read attributes from " + this);
                return null;
            }
        }
        return this.attributesDoc;
    }

    protected List<String> getAttributes(String path, Document attributesDoc) {
        ArrayList<String> resultList = new ArrayList<String>();
        if (path == null || path.isEmpty()) {
            return resultList;
        }
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            NodeList nodeList = (NodeList)xPath.compile(path).evaluate(attributesDoc, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String value = nodeList.item(i).getTextContent();
                resultList.add(value);
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not read attributes from " + this);
            this.getLogger().error((Object)ex, (Throwable)ex);
        }
        return resultList;
    }

    protected void setCaptureMode(int captureMode) {
        this.captureMode = captureMode;
    }

    protected boolean hasAttributeEnum(String path, Document attributesDoc) {
        List<String> res;
        String[] parts = path.split("/");
        StringBuilder buf = new StringBuilder();
        if (parts.length > 0) {
            buf.append(String.format("//cgi[@name='%s']", parts[0]));
        }
        if (parts.length > 1) {
            buf.append(String.format("/submenu[@name='%s']", parts[1]));
        }
        if (parts.length > 2) {
            buf.append(String.format("/action[@name='%s']", parts[2]));
        }
        if (parts.length > 3) {
            buf.append(String.format("/parameter[@name='%s']", parts[3]));
        }
        if (parts.length > 4) {
            buf.append(String.format("/dataType/enum/entry[@value='%s']", parts[4]));
        }
        return (res = this.getAttributes(buf.toString(), attributesDoc)).size() > 0;
    }

    protected int getFirstInput() {
        return this.firstInput;
    }

    protected final int checkAndSetParameter(String cgiName, String menu, String name, String value, String urlPartMultiChannel) {
        return this.checkAndSetParameters(cgiName, menu, new String[]{name}, new String[]{value}, urlPartMultiChannel);
    }

    protected int checkAndSetParameters(String cgiName, String menu, String[] names, String[] values, String urlPartMultiChannel) {
        try {
            StringBuilder url = new StringBuilder("/stw-cgi/");
            url.append(cgiName).append(".cgi?msubmenu=").append(menu).append("&action=");
            boolean writeParameterToCamera = false;
            String cameraParameters = this.getHttpHandler().readGetRequest(url.toString() + "view" + urlPartMultiChannel);
            if (cameraParameters != null) {
                String[] resultLines = cameraParameters.split("\r\n");
                url.append("set");
                for (String resultLine : resultLines) {
                    for (int j = 0; j < names.length; ++j) {
                        String[] nameValue;
                        if (!resultLine.contains(names[j]) || (nameValue = resultLine.split("=")).length != 2 || nameValue[1].equalsIgnoreCase(values[j])) continue;
                        writeParameterToCamera = true;
                        url.append("&").append(names[j]).append("=").append(values[j]);
                    }
                }
            }
            if (writeParameterToCamera) {
                this.getHttpHandler().readGetRequest(url.toString() + urlPartMultiChannel);
            }
            return 0;
        }
        catch (SeeTecException ex) {
            this.getLogger().error("Exception while reading camera parameters for " + ex.getMessage());
            return ex.getErrorCode();
        }
    }

    protected String readCameraParameters(String url, String parameter, String data) {
        try {
            String dataFromCamera = data == null ? this.getHttpHandler().readGetRequest(url) : data;
            if (dataFromCamera != null) {
                String[] resultLines;
                for (String resultLine : resultLines = dataFromCamera.split("\r\n")) {
                    if (!resultLine.toLowerCase().matches(".*" + parameter.toLowerCase() + ".*")) continue;
                    String[] nameValue = resultLine.split("=");
                    if (nameValue.length == 2) {
                        return nameValue[1];
                    }
                    nameValue = resultLine.split(":");
                    if (nameValue.length != 2) continue;
                    return nameValue[1];
                }
            }
            return null;
        }
        catch (SeeTecException ex) {
            this.getLogger().error("Exception while reading camera parameters for " + this + ": " + ex.getMessage());
            return null;
        }
    }

    protected boolean readCameraParametersAsBoolean(String url, String parameter, String data) {
        String value = this.readCameraParameters(url, parameter, data);
        return value != null && !value.toLowerCase().equals("false");
    }

    protected int readCameraParametersAsInt(String url, String parameter, String data) {
        String value = this.readCameraParameters(url, parameter, data);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                this.logger.error("Error while trying to parse the following string: " + value + " for " + this);
            }
        }
        return 0;
    }

    protected boolean isFisheyeCamera() {
        return this.getDeviceType() == 201846L;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        try {
            if (!this.isSunApi_2()) {
                this.getLogger().error("Problems while getting definition from device for " + this + " Check Firmware for compatibility");
                throw new SeeTecException(-21693, "Problems while getting definition from device for " + this + " Check Firmware for compatibility");
            }
            String apiVersion = "SUNAPI 2.0";
            String currentManufacturerWisenet = "Wisenet Smart Driver";
            String currentManufacturerQognify = "Qognify";
            String currentComments = "RE_APP_VERSION::7.1.1_23";
            String currentName = this.getDeviceInfoProperty("Model", true);
            String currentSignature = this.getDeviceInfoProperty("FirmwareVersion", true);
            boolean forceReload = false;
            if (!(signature != null && signature.equals(currentSignature) && manufacturer != null && (manufacturer.equals("Wisenet Smart Driver") || manufacturer.equals("Qognify")) && name != null && name.equals(currentName) && comments != null && comments.equals("RE_APP_VERSION::7.1.1_23"))) {
                DeviceDefinition deviceDefinition = new DeviceDefinition();
                deviceDefinition.setCountFirstChannelOnly(true);
                this.setFirmwareVersion(currentSignature);
                this.getLogger().info("Firmware currentSignature on " + this + " : " + this.getFirmwareVersion());
                deviceDefinition.setEntityType(201854L);
                deviceDefinition.setManufacturer("Wisenet Smart Driver");
                deviceDefinition.setName(currentName);
                deviceDefinition.setDefaultApiVersion("SUNAPI 2.0");
                deviceDefinition.setSignature(currentSignature);
                int numberOfCams = this.getNumberOfVideoSourcesFromDevice();
                deviceDefinition.setNoOfCams(numberOfCams);
                deviceDefinition.setDefaultMediaID(MediaID.VIDEO_SOURCE_PTZ.getType());
                SupportedCaptureModesType supportedCaptureModesType = new SupportedCaptureModesType();
                deviceDefinition.setSupportedCaptureModes(supportedCaptureModesType);
                ArchiveLimitationsType archiveLimitationsType = new ArchiveLimitationsType();
                deviceDefinition.setArchiveLimitations(archiveLimitationsType);
                CaptureModeDefinitionType captureModeDefinitionType = this.readCaptureModeCapabilities(0, numberOfCams);
                supportedCaptureModesType.getCaptureModeDefinition().add(captureModeDefinitionType);
                deviceDefinition.setAudioCapabilities(this.getAudioCapabilitiesType(0));
                deviceDefinition.setAvailableIOs(this.getAvailableIOsType());
                CommentsType commentsType = new CommentsType();
                deviceDefinition.setComments(commentsType);
                commentsType.getString().add("RE_APP_VERSION::7.1.1_23");
                DeviceGroupMembershipsType deviceGroupMembershipsType = this.getDeviceGroupMembershipsType(this.getAttributesDoc(), 0);
                deviceDefinition.setDeviceGroupMemberships(deviceGroupMembershipsType);
                deviceDefinition.setDeviceNetworkDefinition(this.getNetworkDefinitionType());
                deviceDefinition.setImageRotationCapabilities(this.getImageRotationCapabilitiesType(0, false));
                MiscVideoServerCapabilitiesType miscVideoServerCapabilitiesType = this.getMiscVideoServerCapabilitiesType(this.getAttributesDoc(), 0, false);
                deviceDefinition.setMiscVideoServerCapabilities(miscVideoServerCapabilitiesType);
                SupportedApiVersionsType supportedApiVersionsType = new SupportedApiVersionsType();
                deviceDefinition.setSupportedApiVersions(supportedApiVersionsType);
                supportedApiVersionsType.getString().add("SUNAPI 2.0");
                SupportedOnvifEventsType supportedOnvifEventsType = new SupportedOnvifEventsType();
                deviceDefinition.setSupportedOnvifEvents(supportedOnvifEventsType);
                SupportedVideoSourceEntityTypesType supportedVideoSourceEntityTypesType = new SupportedVideoSourceEntityTypesType();
                supportedVideoSourceEntityTypesType.getLong().add(211848L);
                deviceDefinition.setSupportedVideoSourceEntityTypes(supportedVideoSourceEntityTypesType);
                VirtualCameraDefinitionType virtualCameraDefinitionType = new VirtualCameraDefinitionType();
                deviceDefinition.setVirtualCameraDefinition(virtualCameraDefinitionType);
                virtualCameraDefinitionType.setCanVirtualCamera(false);
                virtualCameraDefinitionType.setCanVirtualCameraCropping(false);
                virtualCameraDefinitionType.setNoOfVirtualCameras(1);
                deviceDefinition.setSupportedGenericEvents(this.getGenericEventTrigger());
                SupportedEdgeStoragePlaybackSpeedsType supportedEdgeStoragePlaybackSpeedsType = this.getSupportedEdgeStoragePlaybackSpeedsType();
                deviceDefinition.setSupportedEdgeStoragePlaybackSpeeds(supportedEdgeStoragePlaybackSpeedsType);
                return deviceDefinition;
            }
        }
        catch (ConfigurationException ex) {
            throw new SeeTecException(-21600, "Could net read configuration from " + this);
        }
        catch (SeeTecException ex) {
            if (ex.getNetworkStatus() == HTTPStatusCode.HTTP_UNAUTHORIZED) {
                this.getLogger().error("Problems while getting definition from device for " + this + " Unauthorized exception: Please check the credentials.", (Throwable)ex);
                throw new SeeTecException(-20053, "Problems while getting definition from device for " + this + " Unauthorized exception: Please check the credentials.");
            }
            this.getLogger().error("Problems while getting definition from device for " + this + " Check Firmware for compatibility", (Throwable)ex);
            throw ex;
        }
        return null;
    }

    @Override
    protected SupportedGenericEventsType getGenericEventTrigger() throws SeeTecException, ConfigurationException {
        SupportedGenericEventsType supportedGenericEventsType = new SupportedGenericEventsType();
        String url = "/stw-cgi/eventstatus.cgi?msubmenu=eventstatus&action=check";
        String eventStatusCheckResult = this.getHttpHandler().readGetRequest(url);
        if (eventStatusCheckResult != null) {
            String[] resultLines;
            for (String resultLine : resultLines = eventStatusCheckResult.split("\r\n")) {
                Integer source;
                String[] nameValue = resultLine.split("=");
                if (nameValue.length != 2 || nameValue[0].toLowerCase().startsWith("alarminput.") || !nameValue[1].equalsIgnoreCase("true") && !nameValue[1].equalsIgnoreCase("1") && !nameValue[1].equalsIgnoreCase("false") && !nameValue[1].equalsIgnoreCase("0")) continue;
                int sourceNumber = 0;
                int numberOfCams = this.getNumberOfVideoSourcesFromDevice();
                if (numberOfCams > 1 && (source = SamsungHelper.getSourceNumber(nameValue[0])) != null) {
                    sourceNumber = source;
                }
                GenericEventDefinitionType genericEventDefinitionType = new GenericEventDefinitionType();
                genericEventDefinitionType.setEventType(nameValue[0]);
                genericEventDefinitionType.setSourceNumber(sourceNumber);
                supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType);
            }
        }
        return supportedGenericEventsType;
    }

    @Override
    protected final VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        boolean hasZoom;
        Document attributes = this.getAttributesDoc();
        VideoCameraDefinition videoCameraDefinition = new VideoCameraDefinition();
        videoCameraDefinition.setManufacturer("Generic Samsung Driver");
        videoCameraDefinition.setComment("");
        String xPath = "//attributes/group[@name='PTZSupport']/category[@name='Support']/channel[@number='0']/attribute[@name='Continuous.Pan' or @name='Continuous.Tilt']/@value";
        List<String> ptCapabilitiesList = this.getAttributes(xPath, attributes);
        boolean hasPanTilt = ptCapabilitiesList.size() > 0 && ptCapabilitiesList.contains("True");
        xPath = "//attributes/group[@name='PTZSupport']/category[@name='Support']/channel[@number='0']/attribute[@name='Continuous.Zoom']/@value";
        List<String> zoomCapabilitiesList = this.getAttributes(xPath, attributes);
        boolean bl = hasZoom = zoomCapabilitiesList.size() > 0 && zoomCapabilitiesList.contains("True");
        int mediaType = hasPanTilt ? MediaID.VIDEO_SOURCE_PTZ.getType() : (hasZoom ? MediaID.VIDEO_SOURCE_ZOOM.getType() : MediaID.VIDEO_SOURCE_DIGITAL.getType());
        videoCameraDefinition.setDefaultMediaID(mediaType);
        videoCameraDefinition.setName(this.getDeviceInfoProperty("Model", true));
        videoCameraDefinition.setEntityType(211848L);
        videoCameraDefinition.setPreferAbsolutePTZ(false);
        AbsolutePTZCapabilities absolutePTZCapabilities = SamsungHelper.getAbsolutePTZCapabilities(attributes, 0);
        FeaturesType featuresType = this.getFeaturesType(absolutePTZCapabilities, 0);
        videoCameraDefinition.setFeatures(featuresType);
        return videoCameraDefinition;
    }

    @Override
    protected VideoSourcesDefinitionType getVideoSourcesDefinitionFromDevice(int totalSources) throws SeeTecException {
        Document attributes = this.getAttributesDoc();
        VideoSourcesDefinitionType videoSourcesDefinitionType = new VideoSourcesDefinitionType();
        try {
            List<VideoSourceType> sourceDefinitionList = videoSourcesDefinitionType.getVideoSource();
            for (int i = 0; i < totalSources; ++i) {
                VideoSourceType videoSource = new VideoSourceType();
                videoSource.setVideoSourceEnabled(true);
                boolean ptzEnabled = true;
                AbsolutePTZCapabilities absolutePTZCapabilities = SamsungHelper.getAbsolutePTZCapabilities(attributes, i);
                if (ptzEnabled) {
                    videoSource.setPtzCapabilities(this.convertFeatureTypeToPtzCapabilitiesType(this.getFeaturesType(absolutePTZCapabilities, i)));
                }
                videoSource.setAudioCapabilities(this.getAudioCapabilitiesType(i));
                videoSource.setImageRotation(this.getImageRotationCapabilitiesType(i, true));
                videoSource.setMiscVideoServerCapabilities(this.getMiscVideoServerCapabilitiesType(this.getAttributesDoc(), i, true));
                videoSource.setDeviceGroupMemberships(this.getDeviceGroupMembershipsType(attributes, i));
                videoSource.setSupportedEdgeStoragePlaybackSpeeds(this.getSupportedEdgeStoragePlaybackSpeedsType());
                videoSource.setCaptureMode(this.readCaptureModeCapabilities(i, totalSources));
                sourceDefinitionList.add(videoSource);
            }
        }
        catch (Exception ex) {
            this.logger.warn("Couldn't read view capabilities for " + this);
            throw new SeeTecException(-21600, ex.getMessage());
        }
        return videoSourcesDefinitionType;
    }

    @Override
    protected final IOHandler createIOHandler() {
        return new SamsungIOHandler();
    }

    @Override
    protected final boolean isSupportingIO() {
        return true;
    }

    protected AudioCapabilitiesType getAudioCapabilitiesType(int videoSource) {
        AudioCapabilitiesType audioCapabilitiesType = new AudioCapabilitiesType();
        String xPath = "//attributes/group[@name='Media']/category[@name='Limit']/channel[@number='" + videoSource + "']/attribute[@name='MaxAudioInput']/@value";
        List<String> audioInputNumberList = this.getAttributes(xPath, this.getAttributesDoc());
        Integer audioInputNumber = SamsungHelper.getFirstFromListAsInt(audioInputNumberList);
        boolean canAudio = audioInputNumber != null && audioInputNumber > 0;
        audioCapabilitiesType.setCanAudio(canAudio);
        if (canAudio) {
            String[] codecs;
            AudioCodecsType audioCodecsType = new AudioCodecsType();
            xPath = "//attributes/group[@name='Media']/category[@name='Support']/channel[@number='" + videoSource + "']/attribute[@name='AudioEncodingType']/@value";
            List<String> audioCodecList = this.getAttributes(xPath, this.getAttributesDoc());
            for (String audioCodec : codecs = SamsungHelper.getListAsStringArray(audioCodecList)) {
                AudioCodecDefinitionType audioCodecDefinitionType = new AudioCodecDefinitionType();
                CodecType codecType = new CodecType();
                int bitrate = 64000;
                List<String> bitratesList = this.getAttributesFromEnum("media/audioinput/set/Bitrate/value", this.getAttributesDoc());
                if (bitratesList.size() > 0) {
                    int[] bitrates = new int[bitratesList.size()];
                    for (int i = 0; i < bitratesList.size(); ++i) {
                        bitrates[i] = Integer.parseInt(bitratesList.get(i).trim());
                    }
                    if (audioCodec.equalsIgnoreCase("g711")) {
                        codecType.setValue(Codec.G711U.getType());
                        if (bitratesList.size() > 1) {
                            Arrays.sort(bitrates);
                        }
                        bitrate = bitrates[bitrates.length - 1];
                    } else if (audioCodec.equalsIgnoreCase("g726")) {
                        codecType.setValue(Codec.G726.getType());
                        if (bitratesList.size() > 1) {
                            Arrays.sort(bitrates);
                        }
                        bitrate = bitrates[bitrates.length - 1];
                    }
                }
                if (codecType.getValue() == Codec.UNKNOWN.getType()) continue;
                audioCodecDefinitionType.setAudioCodec(codecType);
                audioCodecDefinitionType.setBitrate(bitrate);
                audioCodecsType.getAudioCodecDefinition().add(audioCodecDefinitionType);
            }
            audioCapabilitiesType.setAudioCodecs(audioCodecsType);
        }
        try {
            String audioOut = this.getHttpHandler().readGetRequest("/stw-cgi/media.cgi?msubmenu=audiooutput&action=view");
            if (audioOut != null && audioOut.toLowerCase().contains("channel." + videoSource + ".enable")) {
                audioCapabilitiesType.setCanAudioOut(true);
            }
        }
        catch (SeeTecException ex) {
            this.logger.warn("Could not read Audio Out capabilities for " + this + " : " + ex.getMessage());
        }
        return audioCapabilitiesType;
    }

    protected AvailableIOsType getAvailableIOsType() {
        List<String> alarmOutputsList;
        Integer numberOfOutputs;
        AvailableIOsType availableIOsType = new AvailableIOsType();
        String xPath = "//attributes/group[@name='Eventsource']/category[@name='Limit']/attribute[@name='MaxAlarmInput']/@value";
        List<String> alarmInputsList = this.getAttributes(xPath, this.getAttributesDoc());
        Integer numberOfInputs = SamsungHelper.getFirstFromListAsInt(alarmInputsList);
        if (numberOfInputs != null) {
            for (int i = 0; i < numberOfInputs; ++i) {
                availableIOsType.getInputOutputCapabilities().add(0);
            }
        }
        if ((numberOfOutputs = SamsungHelper.getFirstFromListAsInt(alarmOutputsList = this.getAttributes(xPath = "//attributes/group[@name='IO']/category[@name='Limit']/attribute[@name='MaxAlarmOutput']/@value", this.getAttributesDoc()))) != null) {
            for (int i = 0; i < numberOfOutputs; ++i) {
                availableIOsType.getInputOutputCapabilities().add(1);
            }
        }
        return availableIOsType;
    }

    @SuppressFBWarnings(value={"HARD_CODE_PASSWORD"}, justification="Mentionned hard-coded password is just Samsung default pass which is a proper default setting in this case.")
    protected DeviceNetworkDefinitionType getNetworkDefinitionType() throws SeeTecException {
        DeviceNetworkDefinitionType deviceNetworkDefinitionType = new DeviceNetworkDefinitionType();
        deviceNetworkDefinitionType.setDefaultHttpPort(80);
        deviceNetworkDefinitionType.setCanChangeHttpPort(true);
        deviceNetworkDefinitionType.setCanHttps(true);
        deviceNetworkDefinitionType.setCanChangeHttpsPort(true);
        deviceNetworkDefinitionType.setDefaultHttpsPort(443);
        deviceNetworkDefinitionType.setUseAuthentication(true);
        deviceNetworkDefinitionType.setDefaultUserName("admin");
        deviceNetworkDefinitionType.setDefaultPassword("");
        deviceNetworkDefinitionType.setDefaultVideoStreamNetworkTimeout(5000L);
        deviceNetworkDefinitionType.setMaxVideoStreamNetworkTimeout(20000L);
        deviceNetworkDefinitionType.setMinVideoStreamNetworkTimeout(5000L);
        return deviceNetworkDefinitionType;
    }

    protected ImageRotationCapabilitiesType getImageRotationCapabilitiesType(int videoSource, boolean checkVideoSource) {
        ImageRotationCapabilitiesType imageRotationCapabilitiesType = new ImageRotationCapabilitiesType();
        SupportedRotationAnglesType supportedRotationAnglesType = new SupportedRotationAnglesType();
        String xPath = "//cgis/cgi[@name='image']/submenu[@name='flip']/action[@name='set']/parameter[@name='HorizontalFlipEnable']/dataType/bool/@true";
        List<String> horizontalFlipEnableList = this.getAttributes(xPath, this.getAttributesDoc());
        String[] horizontalFlipCheck = SamsungHelper.getListAsStringArray(horizontalFlipEnableList);
        boolean imageRotationForVideoSourceAvailable = true;
        if (checkVideoSource) {
            xPath = "//cgis/cgi[@name='image']/submenu[@name='flip']/action[@name='set']/parameter[@name='Channel']/dataType/int/@";
            imageRotationForVideoSourceAvailable = this.isVideoSourceSupported(this.getAttributesDoc(), xPath, videoSource);
        }
        boolean can180 = imageRotationForVideoSourceAvailable && horizontalFlipCheck.length > 0;
        boolean can90 = imageRotationForVideoSourceAvailable && this.hasAttributeEnum("image/flip/set/Rotate/90", this.getAttributesDoc());
        boolean can270 = imageRotationForVideoSourceAvailable && this.hasAttributeEnum("image/flip/set/Rotate/270", this.getAttributesDoc());
        imageRotationCapabilitiesType.setCanRotateJPEGImage(can90 || can180 || can270);
        imageRotationCapabilitiesType.setCanRotateMPEGImage(can90 || can180 || can270);
        supportedRotationAnglesType.getInt().add(0);
        if (can90) {
            supportedRotationAnglesType.getInt().add(90000);
        }
        if (can180) {
            supportedRotationAnglesType.getInt().add(180000);
        }
        if (can270) {
            supportedRotationAnglesType.getInt().add(270000);
        }
        imageRotationCapabilitiesType.setSupportedRotationAngles(supportedRotationAnglesType);
        return imageRotationCapabilitiesType;
    }

    protected boolean isCanVbrQuality() {
        boolean canVbrQuality = false;
        String xPath = "//cgis/cgi[@name='video']/submenu[@name='stream']/action[@name='view']/parameter[@name='CompressionLevel']/dataType/int/@max";
        List<String> compressionLevelListMax = this.getAttributes(xPath, this.getAttributesDoc());
        xPath = "//cgis/cgi[@name='video']/submenu[@name='stream']/action[@name='view']/parameter[@name='CompressionLevel']/dataType/int/@min";
        List<String> compressionLevelListMin = this.getAttributes(xPath, this.getAttributesDoc());
        if (compressionLevelListMax.size() > 0 && compressionLevelListMin.size() > 0) {
            int compressionLevelMin;
            int compressionLevelMax = SamsungHelper.getFirstFromListAsInt(compressionLevelListMax);
            canVbrQuality = compressionLevelMax > (compressionLevelMin = SamsungHelper.getFirstFromListAsInt(compressionLevelListMin).intValue());
        }
        return canVbrQuality;
    }

    protected int getNumberOfPresets() throws SeeTecException, ConfigurationException {
        int videoSources = this.getNumberOfVideoSourcesFromDevice();
        int numberOfPresets = 0;
        for (int i = 0; i < videoSources; ++i) {
            int presetsPerVideoSource = this.getNumberOfPresets(i);
            numberOfPresets = presetsPerVideoSource > numberOfPresets ? presetsPerVideoSource : numberOfPresets;
        }
        return numberOfPresets;
    }

    protected int getNumberOfPresets(int channelNumber) throws SeeTecException, ConfigurationException {
        String xPath = "//attributes/group[@name='PTZSupport']/category[@name='Limit']/channel[@number='" + channelNumber + "']/attribute[@name='MaxPreset']/@value";
        List<String> presetsList = this.getAttributes(xPath, this.getAttributesDoc());
        return SamsungHelper.getFirstFromListAsInt(presetsList);
    }

    protected int getNumberOfVideoSourcesFromDevice() throws SeeTecException, ConfigurationException {
        if (this.numberOfVideoSources == null) {
            this.numberOfVideoSources = this.readNumberOfVideoSourcesFromDevice();
        }
        return this.numberOfVideoSources;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    void setImageFlipType(int imageFlipType) {
        this.imageFlipType = imageFlipType;
    }

    void setCaptureModeInSeetec(int captureModeInSeetec) {
        this.captureModeInSeetec = captureModeInSeetec;
    }

    int getCaptureModeInSeetec() {
        return this.captureModeInSeetec;
    }

    private CaptureModeDefinitionType readCaptureModeCapabilities(int videoSource, int numberOfVideoSources) throws SeeTecException {
        CameraResolutionType maxResolution = null;
        int maxFPS = Integer.MIN_VALUE;
        String urlVideoCodecInfo = "/stw-cgi/media.cgi?msubmenu=videocodecinfo&action=view";
        if (numberOfVideoSources > 1) {
            urlVideoCodecInfo = urlVideoCodecInfo + "&Channel=" + videoSource;
        }
        String videoCodecInfo = this.getHttpHandler().readGetRequest(urlVideoCodecInfo);
        String xPath = "//attributes/group[@name='Media']/category[@name='Limit']/channel[@number='" + videoSource + "']/attribute[@name='MaxProfile']/@value";
        List<String> profileNumberList = this.getAttributes(xPath, this.getAttributesDoc());
        int maxNumberOfStreams = SamsungHelper.getFirstFromListAsInt(profileNumberList);
        if (maxNumberOfStreams > 3) {
            maxNumberOfStreams = 3;
        }
        CaptureModeDefinitionType captureModeDefinitionType = new CaptureModeDefinitionType();
        captureModeDefinitionType.setMaxTotalNumberOfStreams(maxNumberOfStreams);
        MultiStreamingDefinitionsType multiStreamingDefinitionsType = new MultiStreamingDefinitionsType();
        captureModeDefinitionType.setMultiStreamingDefinitions(multiStreamingDefinitionsType);
        xPath = "//attributes/group[@name='Media']/category[@name='Support']/channel[@number='" + videoSource + "']/attribute[@name='VideoEncodingType']/@value";
        List<String> codecsList = this.getAttributes(xPath, this.getAttributesDoc());
        if (codecsList.size() == 1) {
            String[] codecs = SamsungHelper.getListAsStringArray(codecsList);
            boolean canH264 = false;
            for (String codec : codecs) {
                if (!codec.equalsIgnoreCase("h264")) continue;
                canH264 = true;
            }
            boolean supportHttpStreaming = this.isHttpStreamingSupported();
            for (String codec : codecs) {
                List<String> canVbrList;
                List<String> resolutions = this.getResolutions(codec, videoCodecInfo);
                int totalMaxBandwidth = Integer.MIN_VALUE;
                int totalMinBandwidth = Integer.MIN_VALUE;
                CodecType codecType = new CodecType();
                SupportedMPEGProfileIDs supportedMPEGProfileIds = new SupportedMPEGProfileIDs();
                StreamDefinitionType streamDefinitionType = new StreamDefinitionType();
                BitrateSettingsType bitrateSettingsType = new BitrateSettingsType();
                SupportedTransmissionTypeIDsType supportedTransmissionTypeIDsType = new SupportedTransmissionTypeIDsType();
                RtspSettingsType rtspSettingsType = new RtspSettingsType();
                streamDefinitionType.setHideFPSField(false);
                streamDefinitionType.setHideIFrameField(false);
                streamDefinitionType.setHideKompressionField(false);
                streamDefinitionType.setHideBandwithField(false);
                String codecLookup = "";
                int numberOfStreams = 2;
                boolean canVbrQuality = this.isCanVbrQuality();
                if (codec.equalsIgnoreCase("h264")) {
                    codecType.setValue(Codec.H264.getType());
                    codecLookup = "H264";
                    supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_UNICAST.getType());
                    supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_TCP.getType());
                    if (supportHttpStreaming) {
                        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST.getType());
                    }
                    boolean canVbr = (canVbrList = this.getAttributes(xPath = "//cgis/cgi[@name='media']/submenu[@name='videoprofile']/action[@name='add/update']/parameter[@name='H264.BitrateControlType']/dataType/enum/entry/@value", this.getAttributesDoc())).size() > 0 && canVbrList.contains("VBR");
                    bitrateSettingsType.setCanVBR(canVbr);
                    bitrateSettingsType.setCanVBRQuality(canVbrQuality);
                    bitrateSettingsType.setCanCBRQuality(false);
                    bitrateSettingsType.setCanVBRBandwidth(true);
                    numberOfStreams = 3;
                } else if (codec.equalsIgnoreCase("mjpeg")) {
                    codecType.setValue(Codec.MJPEG.getType());
                    codecLookup = "MJPEG";
                    supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_UNICAST.getType());
                    supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_TCP.getType());
                    streamDefinitionType.setHideKompressionField(!canVbrQuality);
                    bitrateSettingsType.setCanVBR(canVbrQuality);
                    bitrateSettingsType.setCanVBRQuality(canVbrQuality);
                    bitrateSettingsType.setCanCBRQuality(false);
                    numberOfStreams = 2;
                } else if (codec.equalsIgnoreCase("h265")) {
                    codecType.setValue(Codec.H265.getType());
                    codecLookup = "H265";
                    supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_UNICAST.getType());
                    supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_TCP.getType());
                    if (supportHttpStreaming) {
                        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST.getType());
                    }
                    streamDefinitionType.setHideKompressionField(!canVbrQuality);
                    xPath = "//cgis/cgi[@name='media']/submenu[@name='videoprofile']/action[@name='add/update']/parameter[@name='H265.BitrateControlType']/dataType/enum/entry/@value";
                    canVbrList = this.getAttributes(xPath, this.getAttributesDoc());
                    boolean canVbr = canVbrList.size() > 0 && canVbrList.contains("VBR");
                    bitrateSettingsType.setCanVBR(canVbr);
                    bitrateSettingsType.setCanVBRQuality(canVbrQuality);
                    bitrateSettingsType.setCanCBRQuality(false);
                    numberOfStreams = 3;
                } else {
                    if (!codec.equalsIgnoreCase("mpeg4") || canH264) continue;
                    codecType.setValue(Codec.MPEG4.getType());
                }
                rtspSettingsType.setDefaultRtspPort(554);
                rtspSettingsType.setCanChangeRtspPort(true);
                rtspSettingsType.setCanMultipleRtspPorts(false);
                SupportedCameraResolutionsType supportedCameraResolutionsType = new SupportedCameraResolutionsType();
                String maxCaptureModeResolution = this.getMaxCaptureModeResolution(videoSource);
                if (maxCaptureModeResolution != null && !maxCaptureModeResolution.isEmpty()) {
                    ArrayList<String> originalResolutionList = new ArrayList<String>();
                    for (String resolution : resolutions) {
                        originalResolutionList.add(resolution);
                    }
                    boolean maxCaptureModeResolutionFound = false;
                    Iterator<String> iterator = resolutions.iterator();
                    while (iterator.hasNext()) {
                        if (!iterator.next().equals(maxCaptureModeResolution)) {
                            iterator.remove();
                            continue;
                        }
                        maxCaptureModeResolutionFound = true;
                        break;
                    }
                    if (!maxCaptureModeResolutionFound) {
                        resolutions = originalResolutionList;
                    }
                }
                for (String resolution : resolutions) {
                    String[] resolutionValues = resolution.toLowerCase().split("x");
                    CameraResolutionType cameraResolutionType = new CameraResolutionType();
                    cameraResolutionType.setDisplayResolution(resolution);
                    try {
                        cameraResolutionType.setWidth(Integer.parseInt(resolutionValues[0]));
                        cameraResolutionType.setHeight(Integer.parseInt(resolutionValues[1]));
                    }
                    catch (NumberFormatException ex) {
                        this.getLogger().error((Object)ex);
                    }
                    String param = codecLookup + "\\.General\\..*" + resolution;
                    int fps = this.readCameraParametersAsInt(urlVideoCodecInfo, param + "\\.MaxFPS", videoCodecInfo);
                    cameraResolutionType.setMaxMilliFPS(fps);
                    cameraResolutionType.setMinMilliFPS(1);
                    cameraResolutionType.setSupportedFrameRates(null);
                    supportedCameraResolutionsType.getCameraResolution().add(cameraResolutionType);
                    int maxCbrTargetBitrate = this.readCameraParametersAsInt(urlVideoCodecInfo, param + "\\.MaxCBRTargetBitrate", videoCodecInfo);
                    int minCbrTargetBitrate = this.readCameraParametersAsInt(urlVideoCodecInfo, param + "\\.MinCBRTargetBitrate", videoCodecInfo);
                    bitrateSettingsType.setCanCBR(maxCbrTargetBitrate != minCbrTargetBitrate);
                    if (maxCbrTargetBitrate > totalMaxBandwidth) {
                        totalMaxBandwidth = maxCbrTargetBitrate;
                    }
                    if (minCbrTargetBitrate < totalMinBandwidth) {
                        totalMinBandwidth = minCbrTargetBitrate;
                    }
                    if (maxResolution == null || cameraResolutionType.getHeight() * cameraResolutionType.getWidth() > maxResolution.getHeight() * maxResolution.getWidth()) {
                        maxResolution = cameraResolutionType;
                    }
                    if (fps <= maxFPS) continue;
                    maxFPS = fps;
                }
                bitrateSettingsType.setMaxBandwidth(totalMaxBandwidth * 1024);
                bitrateSettingsType.setMinBandwidth(1024);
                bitrateSettingsType.setSupportedBitrates(null);
                streamDefinitionType.setName(codec.toUpperCase());
                streamDefinitionType.setNoOfHWMDInputs(0);
                streamDefinitionType.setMaxNumberOfStreams(numberOfStreams);
                streamDefinitionType.setDefaultMilliFPS(5000);
                streamDefinitionType.setMinIFrameDistance(1);
                streamDefinitionType.setMaxIFrameDistance(Integer.MAX_VALUE);
                streamDefinitionType.setEncodingIntervalMin(0);
                streamDefinitionType.setEncodingIntervalMax(0);
                streamDefinitionType.setStreamingMode(codecType);
                streamDefinitionType.setBitrateSettings(bitrateSettingsType);
                streamDefinitionType.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
                streamDefinitionType.setRtspSettings(rtspSettingsType);
                streamDefinitionType.setSupportedCameraResolutions(supportedCameraResolutionsType);
                streamDefinitionType.setSupportedMPEGProfileIDs(supportedMPEGProfileIds);
                streamDefinitionType.setDefaultCameraResolutionIndex(0);
                streamDefinitionType.setDefaultTransmissionTypeIndex(0);
                multiStreamingDefinitionsType.getStreamDefinition().add(streamDefinitionType);
            }
        }
        if (maxResolution != null) {
            CameraResolutionType cameraResolutionType = new CameraResolutionType();
            cameraResolutionType.setDisplayResolution(maxResolution.getDisplayResolution());
            cameraResolutionType.setHeight(maxResolution.getHeight());
            cameraResolutionType.setMaxMilliFPS(maxFPS);
            cameraResolutionType.setMinMilliFPS(maxResolution.getMinMilliFPS());
            cameraResolutionType.setSupportedFrameRates(null);
            cameraResolutionType.setWidth(maxResolution.getWidth());
            cameraResolutionType.setResolution(maxResolution.toString());
            captureModeDefinitionType.setResolution(cameraResolutionType);
        }
        return captureModeDefinitionType;
    }

    private String getDeviceInfoProperty(String property, boolean force) throws SeeTecException {
        if (this.deviceInfoMap == null || force) {
            this.deviceInfoMap = this.readDeviceInfo();
        }
        return this.deviceInfoMap.get(property);
    }

    protected Map<String, String> readDeviceInfo() throws SeeTecException {
        Map<String, String> deviceInfo = this.createMapFromDevice("/stw-cgi/system.cgi?msubmenu=deviceinfo&action=view");
        return deviceInfo;
    }

    protected Map<String, String> createMapFromDevice(String url) throws SeeTecException {
        HashMap<String, String> info = new HashMap<String, String>();
        String resultString = this.getHttpHandler().readGetRequest(url);
        if (resultString != null) {
            String[] resultLines;
            for (String resultLine : resultLines = resultString.split("\r\n")) {
                String[] nameValue = resultLine.split("=");
                if (nameValue.length == 2) {
                    info.put(nameValue[0], nameValue[1]);
                    continue;
                }
                nameValue = resultLine.split(":");
                if (nameValue.length != 2) continue;
                info.put(nameValue[0], nameValue[1]);
            }
        }
        return info;
    }

    private Document readAttributesFromDevice() {
        try {
            String response = this.getHttpHandler().readGetRequest("/stw-cgi/attributes.cgi");
            if (response != null) {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document xmlDocument = db.parse(new InputSource(new StringReader(response)));
                return xmlDocument;
            }
        }
        catch (SeeTecException | IOException | ParserConfigurationException | SAXException ex) {
            this.getLogger().error("Could not read attributes from " + this);
            this.getLogger().error((Object)ex, ex);
        }
        return null;
    }

    private boolean isRegisteredForSunAPI() {
        ArrayList<Long> sunApiEntityTypes = new ArrayList<Long>();
        sunApiEntityTypes.add(201800L);
        sunApiEntityTypes.add(201807L);
        sunApiEntityTypes.add(201808L);
        sunApiEntityTypes.add(201809L);
        sunApiEntityTypes.add(201810L);
        sunApiEntityTypes.add(201811L);
        sunApiEntityTypes.add(201812L);
        sunApiEntityTypes.add(201813L);
        sunApiEntityTypes.add(201814L);
        sunApiEntityTypes.add(201815L);
        sunApiEntityTypes.add(201817L);
        sunApiEntityTypes.add(201819L);
        sunApiEntityTypes.add(201820L);
        sunApiEntityTypes.add(201821L);
        sunApiEntityTypes.add(201822L);
        sunApiEntityTypes.add(201823L);
        sunApiEntityTypes.add(201824L);
        sunApiEntityTypes.add(201825L);
        sunApiEntityTypes.add(201826L);
        sunApiEntityTypes.add(201827L);
        sunApiEntityTypes.add(201828L);
        sunApiEntityTypes.add(201829L);
        sunApiEntityTypes.add(201830L);
        sunApiEntityTypes.add(201831L);
        sunApiEntityTypes.add(201832L);
        sunApiEntityTypes.add(201833L);
        sunApiEntityTypes.add(201834L);
        sunApiEntityTypes.add(201835L);
        sunApiEntityTypes.add(201836L);
        sunApiEntityTypes.add(201837L);
        sunApiEntityTypes.add(201838L);
        sunApiEntityTypes.add(201839L);
        sunApiEntityTypes.add(201841L);
        sunApiEntityTypes.add(201843L);
        this.entityID = this.getDeviceType();
        return !sunApiEntityTypes.contains(this.entityID);
    }

    protected String getMaxCaptureModeResolution(int videoSource) {
        String xPath = "//attributes/group[@name='Media']/category[@name='Limit']/channel[@number='" + videoSource + "']/attribute[@name='MaxResolution']/@value";
        List<String> maxResolutionList = this.getAttributes(xPath, this.getAttributesDoc());
        if (maxResolutionList.size() < 1) {
            return null;
        }
        return maxResolutionList.get(0).trim();
    }

    protected int readNumberOfVideoSourcesFromDevice() throws ConfigurationException {
        try {
            String url = "/stw-cgi/media.cgi?msubmenu=videosource&action=view";
            String channelParameters = this.getHttpHandler().readGetRequest(url);
            if (channelParameters != null) {
                if (!channelParameters.toLowerCase().contains("channel.")) {
                    this.getLogger().warn("Unexpected answer from camera while reading out number of channels. Assuming 1 for " + this);
                } else {
                    for (int i = 0; i < 64; ++i) {
                        if (channelParameters.toLowerCase().contains("channel." + i)) continue;
                        return i;
                    }
                }
            }
        }
        catch (SeeTecException seeTecException) {
            this.getLogger().warn("Problem while reading out number of channels. " + seeTecException.getMessage() + " Assuming 1 for " + this);
        }
        return 1;
    }

    private void setFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    protected SamsungEventReader getEventReader() {
        try {
            this.semaphore.acquire();
            if (this.samsungEventReader == null) {
                this.samsungEventReader = new SamsungEventReader();
                this.samsungEventReader.init(this);
            }
        }
        catch (Exception ex) {
            this.logger.error("Exception while starting event reader: " + ex.getMessage() + " for " + this);
        }
        finally {
            this.semaphore.release();
        }
        return this.samsungEventReader;
    }

    protected void shutdownEventReader() {
        try {
            this.semaphore.acquire();
            if (this.samsungEventReader != null) {
                this.samsungEventReader.shutdown();
                this.samsungEventReader = null;
            }
        }
        catch (Exception ex) {
            this.logger.error("Exception while shutting down event reader: " + ex.getMessage() + " for " + this);
        }
        finally {
            this.semaphore.release();
        }
    }

    public int getResolutionMode() {
        return this.resolutionMode;
    }

    protected boolean isHttpStreamingSupported() {
        String xPath = "//attributes/group[@name='Media']/category[@name='Support']/channel[@number='0']/attribute[@name='Stream.RTSPOverHTTP']/@value";
        List<String> httpSupported = this.getAttributes(xPath, this.getAttributesDoc());
        xPath = "//attributes/group[@name='Media']/category[@name='Support']/channel[@number='0']/attribute[@name='Stream.RTSPOverHTTPS']/@value";
        List<String> httpsSupported = this.getAttributes(xPath, this.getAttributesDoc());
        return httpSupported.size() > 0 && httpSupported.get(0).equalsIgnoreCase("true") && httpsSupported.size() > 0 && httpsSupported.get(0).equalsIgnoreCase("true");
    }

    @Override
    public List<TimeRange> getRecordingInfosFromDevice(long startTimestamp, long endTimestamp, int channelNumber) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(startTimestamp);
        Date startSearch = calendar.getTime();
        calendar.setTimeInMillis(endTimestamp);
        Date endSearch = calendar.getTime();
        String url = "/stw-cgi/recording.cgi?msubmenu=timeline&action=view&Type=All";
        url = url + "&FromDate=" + sdf.format(startSearch);
        url = url + "&ToDate=" + sdf.format(endSearch);
        ArrayList<TimeRange> returnList = new ArrayList<TimeRange>();
        try {
            String recordingDataFromCamera = this.getHttpHandler().readGetRequest(url);
            int count = this.readCameraParametersAsInt(url, "TotalCount", recordingDataFromCamera);
            for (int i = 0; i <= count; ++i) {
                String startParam = "Channel\\." + (channelNumber - 1) + "\\.Result\\." + i + "\\.StartTime";
                String endParam = "Channel\\." + (channelNumber - 1) + "\\.Result\\." + i + "\\.EndTime";
                String startString = this.readCameraParameters(url, startParam, recordingDataFromCamera);
                String endString = this.readCameraParameters(url, endParam, recordingDataFromCamera);
                if (startString == null || endString == null) continue;
                Date startRange = sdf.parse(startString);
                Date endRange = sdf.parse(endString);
                this.getLogger().debug(String.format("Found Timerange [%s]-[%s] for %s", sdf.format(startRange), sdf.format(endRange), this));
                long camStartTimestamp = startRange.getTime();
                long camEndTimestamp = endRange.getTime();
                long timeDifference = this.getTimeDifferenceFromDevice();
                long newStartTimestamp = SamsungPlaybackVideoSourceClient.convertCameraTimeToTimestamp(camStartTimestamp, timeDifference);
                long newEndTimestamp = SamsungPlaybackVideoSourceClient.convertCameraTimeToTimestamp(camEndTimestamp, timeDifference);
                TimeRange range = new TimeRange(newStartTimestamp, newEndTimestamp);
                returnList.add(range);
            }
        }
        catch (Throwable throwable) {
            this.getLogger().error("Error getting timerange for device " + this + ": " + throwable.getMessage());
        }
        return returnList;
    }

    protected Long getTimeDifferenceFromDevice() throws Exception {
        String url = "/stw-cgi/system.cgi?msubmenu=date&action=view";
        String cameraTimeData = this.getHttpHandler().readGetRequest(url);
        String sDeviceTimeLocal = this.readCameraParameters(url, "LocalTime", cameraTimeData);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date deviceTimeLocal = sdf.parse(sDeviceTimeLocal);
        Date now = new Date();
        long diff = deviceTimeLocal.getTime() - now.getTime();
        return diff;
    }

    protected String checkEdgeStorageReady(int channelNumber) {
        List<TimeRange> lastRecordings = this.getRecordingInfosFromDevice(System.currentTimeMillis() - 60000L, System.currentTimeMillis(), channelNumber);
        ArrayList<String> multiLineLog = new ArrayList<String>();
        multiLineLog.add("Edge Storage Information for " + this);
        multiLineLog.add("Channel: " + channelNumber);
        if (lastRecordings.isEmpty()) {
            multiLineLog.add("Edge Storage is not ready, because there are no recordings available from the last 60 seconds");
        } else {
            multiLineLog.add("Edge Storage is ready on the camera.");
            try {
                String url = "/stw-cgi/system.cgi?msubmenu=storageinfo&action=view";
                String storageInfo = this.getHttpHandler().readGetRequest(url);
                if (storageInfo != null) {
                    String[] configurationLines = storageInfo.split("\r\n");
                    multiLineLog.add("");
                    multiLineLog.add("Additional Information from camera:");
                    for (String configurationLine : configurationLines) {
                        multiLineLog.add("\t" + configurationLine);
                    }
                }
            }
            catch (Exception ex) {
                multiLineLog.add("Could not gather additional edge storage information from camera");
            }
        }
        return Basic.generateIndentedMultiLineLog(multiLineLog);
    }

    public static CameraAdministration getCameraAdministration() throws SeeTecException {
        if (CAMERAADMINISTRATION == null) {
            CAMERAADMINISTRATION = new SamsungCameraAdministration((SeetecHttpClient)new NetworkHelperAdapter());
        }
        return CAMERAADMINISTRATION;
    }

    private FeaturesType getFeaturesType(AbsolutePTZCapabilities absolutePTZCapabilities, int videoSource) throws SeeTecException {
        FeaturesType featuresType = new FeaturesType();
        featuresType.setCanAbsolutePan(absolutePTZCapabilities.isSupportsAbsolutePan());
        if (absolutePTZCapabilities.isSupportsAbsolutePan()) {
            Integer minPan = absolutePTZCapabilities.getAbsolutePanMin();
            Integer maxPan = absolutePTZCapabilities.getAbsolutePanMax();
            featuresType.setMinPan(minPan == null ? 0 : minPan);
            featuresType.setMaxPan(maxPan == null ? 0 : maxPan);
        }
        featuresType.setCanAbsoluteTilt(absolutePTZCapabilities.isSupportsAbsoluteTilt());
        if (absolutePTZCapabilities.isSupportsAbsoluteTilt()) {
            Integer minTilt = absolutePTZCapabilities.getAbsoluteTiltMin();
            Integer maxTilt = absolutePTZCapabilities.getAbsoluteTiltMax();
            featuresType.setMinTilt(minTilt == null ? 0 : minTilt);
            featuresType.setMaxTilt(maxTilt == null ? 0 : maxTilt);
        }
        featuresType.setCanAbsoluteZoom(absolutePTZCapabilities.isSupportsAbsoluteZoom());
        if (absolutePTZCapabilities.isSupportsAbsoluteZoom()) {
            Integer minAbsoluteZoom = absolutePTZCapabilities.getAbsoluteZoomMin();
            Integer maxAbsoluteZoom = absolutePTZCapabilities.getAbsoluteZoomMax();
            featuresType.setMinAbsoluteZoom(minAbsoluteZoom == null ? 0 : minAbsoluteZoom);
            featuresType.setMaxAbsoluteZoom(maxAbsoluteZoom == null ? 0 : maxAbsoluteZoom);
        }
        featuresType.setMaxZoom(100000);
        featuresType.setMinZoom(0);
        featuresType.setCanRelativePan(false);
        featuresType.setCanRelativeTilt(false);
        featuresType.setCanRelativeZoom(false);
        featuresType.setCanContinuousPan(true);
        featuresType.setCanContinuousTilt(true);
        featuresType.setCanContinuousZoom(true);
        featuresType.setCanFocus(this.isFocusSupported(this.getAttributesDoc(), videoSource));
        featuresType.setCanAutoFocus(this.isAutoFocusSupported(this.getAttributesDoc(), videoSource));
        featuresType.setCanIris(this.isIrisSupported(this.getAttributesDoc(), videoSource));
        featuresType.setCanAutoIris(this.isAutoIrisSupported(this.getAttributesDoc(), videoSource));
        featuresType.setCanNullLux(this.isNullLuxSupported(this.getAttributesDoc(), videoSource));
        featuresType.setCanAutoNullLux(this.isAutoNullLuxSupported(this.getAttributesDoc(), videoSource));
        int numberOfPresets = 0;
        try {
            numberOfPresets = this.getNumberOfPresets(videoSource);
        }
        catch (ConfigurationException ex) {
            this.getLogger().warn("Could not read number of presets for " + this + " Assuming Presets are not supported.");
        }
        featuresType.setCanPreset(numberOfPresets > 0);
        featuresType.setCanCenterPT(true);
        featuresType.setMaxSpeed(100000);
        featuresType.setMinSpeed(0);
        featuresType.setPTZContinuousSpeedFactor(250);
        featuresType.setPTZMaxContinuousLevel(90000);
        featuresType.setPTZMinContinuousLevel(5000);
        return featuresType;
    }

    protected boolean isFocusSupported(Document attributesDoc, int videoSource) {
        boolean focusSupport = this.hasAttributeEnum("ptzcontrol/continuous/control/Focus", attributesDoc);
        String xPath = "//cgis/cgi[@name='image']/submenu[@name='focus']/action[@name='control']/parameter[@name='Channel']/dataType/int/@";
        boolean focusSupportForVideoSource = this.isVideoSourceSupported(attributesDoc, xPath, videoSource);
        return focusSupport && focusSupportForVideoSource;
    }

    protected boolean isVideoSourceSupported(Document attributesDoc, String xPath, int videoSource) {
        List<String> max = this.getAttributes(xPath + "max", attributesDoc);
        List<String> min = this.getAttributes(xPath + "min", attributesDoc);
        if (max.isEmpty() || min.isEmpty()) {
            return false;
        }
        int lowestChannel = Integer.parseInt(min.get(0));
        int highestChannel = Integer.parseInt(max.get(0));
        return videoSource >= lowestChannel && videoSource <= highestChannel;
    }

    protected boolean isAutoFocusSupported(Document attributesDoc, int videoSource) {
        boolean autoFocusSupport = this.hasAttributeEnum("image/focus/control/Mode/AutoFocus", attributesDoc);
        String xPath = "//cgis/cgi[@name='image']/submenu[@name='focus']/action[@name='control']/parameter[@name='Channel']/dataType/int/@";
        boolean autoFocusSupportForVideoSource = this.isVideoSourceSupported(attributesDoc, xPath, videoSource);
        return autoFocusSupport && autoFocusSupportForVideoSource;
    }

    protected boolean isIrisSupported(Document attributesDoc, int videoSource) {
        boolean irisSupport = this.hasAttributeEnum("image/camera/set/IrisFno", attributesDoc);
        String xPath = "//cgis/cgi[@name='image']/submenu[@name='camera']/action[@name='set']/parameter[@name='Channel']/dataType/int/@";
        boolean irisSupportForVideoSource = this.isVideoSourceSupported(attributesDoc, xPath, videoSource);
        return irisSupport && irisSupportForVideoSource;
    }

    protected boolean isAutoIrisSupported(Document attributesDoc, int videoSource) {
        boolean autoIrisSupport = this.hasAttributeEnum("image/camera/set/IrisMode/Auto", attributesDoc);
        String xPath = "//cgis/cgi[@name='image']/submenu[@name='camera']/action[@name='set']/parameter[@name='Channel']/dataType/int/@";
        boolean autoIrisSupportForVideoSource = this.isVideoSourceSupported(attributesDoc, xPath, videoSource);
        return autoIrisSupport && autoIrisSupportForVideoSource;
    }

    protected boolean isNullLuxSupported(Document attributesDoc, int videoSource) {
        boolean nullLuxSupport = this.hasAttributeEnum("image/camera/set/DayNightMode/BW", attributesDoc);
        String xPath = "//cgis/cgi[@name='image']/submenu[@name='camera']/action[@name='set']/parameter[@name='Channel']/dataType/int/@";
        boolean nullLuxSupportForVideoSource = this.isVideoSourceSupported(attributesDoc, xPath, videoSource);
        return nullLuxSupport && nullLuxSupportForVideoSource;
    }

    protected boolean isAutoNullLuxSupported(Document attributesDoc, int videoSource) {
        boolean autoNullLuxSupport = this.hasAttributeEnum("image/camera/set/DayNightMode/Auto", attributesDoc);
        String xPath = "//cgis/cgi[@name='image']/submenu[@name='camera']/action[@name='set']/parameter[@name='Channel']/dataType/int/@";
        boolean autoNullLuxSupportForVideoSource = this.isVideoSourceSupported(attributesDoc, xPath, videoSource);
        return autoNullLuxSupport && autoNullLuxSupportForVideoSource;
    }

    @Override
    protected PtzCapabilitiesType convertFeatureTypeToPtzCapabilitiesType(FeaturesType featuresType) {
        PtzCapabilitiesType ptzCapabilitiesType = null;
        if (featuresType != null) {
            ptzCapabilitiesType = new PtzCapabilitiesType();
            ptzCapabilitiesType.setCanAbsolutePan(featuresType.isCanAbsolutePan());
            ptzCapabilitiesType.setCanAbsoluteTilt(featuresType.isCanAbsoluteTilt());
            ptzCapabilitiesType.setCanAbsoluteZoom(featuresType.isCanAbsoluteZoom());
            ptzCapabilitiesType.setCanAutoFocus(featuresType.isCanAutoFocus());
            ptzCapabilitiesType.setCanAutoIris(featuresType.isCanAutoIris());
            ptzCapabilitiesType.setCanAutoNullLux(featuresType.isCanAutoNullLux());
            ptzCapabilitiesType.setCanCenterPT(featuresType.isCanCenterPT());
            ptzCapabilitiesType.setCanContinuousPan(featuresType.isCanContinuousPan());
            ptzCapabilitiesType.setCanContinuousTilt(featuresType.isCanContinuousTilt());
            ptzCapabilitiesType.setCanContinuousZoom(featuresType.isCanContinuousZoom());
            ptzCapabilitiesType.setCanFocus(featuresType.isCanFocus());
            ptzCapabilitiesType.setCanIris(featuresType.isCanIris());
            ptzCapabilitiesType.setCanNullLux(featuresType.isCanNullLux());
            ptzCapabilitiesType.setCanPreset(featuresType.isCanPreset());
            ptzCapabilitiesType.setCanRelativePan(featuresType.isCanRelativePan());
            ptzCapabilitiesType.setCanRelativeTilt(featuresType.isCanRelativeTilt());
            ptzCapabilitiesType.setCanRelativeZoom(featuresType.isCanRelativeZoom());
            ptzCapabilitiesType.setMaxAbsoluteZoom(featuresType.getMaxAbsoluteZoom());
            ptzCapabilitiesType.setMaxPan(featuresType.getMaxPan());
            ptzCapabilitiesType.setMaxSpeed(featuresType.getMaxSpeed());
            ptzCapabilitiesType.setMaxTilt(featuresType.getMaxTilt());
            ptzCapabilitiesType.setMaxZoom(featuresType.getMaxZoom());
            ptzCapabilitiesType.setMinAbsoluteZoom(featuresType.getMinAbsoluteZoom());
            ptzCapabilitiesType.setMinPan(featuresType.getMinPan());
            ptzCapabilitiesType.setMinSpeed(featuresType.getMinSpeed());
            ptzCapabilitiesType.setMinTilt(featuresType.getMinTilt());
            ptzCapabilitiesType.setMinZoom(featuresType.getMinZoom());
            ptzCapabilitiesType.setPTZContinuousSpeedFactor(featuresType.getPTZContinuousSpeedFactor());
            ptzCapabilitiesType.setPTZMaxContinuousLevel(featuresType.getPTZMaxContinuousLevel());
            ptzCapabilitiesType.setPTZMinContinuousLevel(featuresType.getPTZMinContinuousLevel());
        }
        return ptzCapabilitiesType;
    }

    protected MiscVideoServerCapabilitiesType getMiscVideoServerCapabilitiesType(Document attributesDoc, int videoSource, boolean checkVideoSource) throws SeeTecException {
        MiscVideoServerCapabilitiesType miscVideoServerCapabilitiesType = new MiscVideoServerCapabilitiesType();
        miscVideoServerCapabilitiesType.setCanDetectTampering(false);
        miscVideoServerCapabilitiesType.setCanDetectVideoloss(false);
        miscVideoServerCapabilitiesType.setCanPTZ(true);
        miscVideoServerCapabilitiesType.setCanTimeshift(false);
        boolean canTimeDate = false;
        boolean canTitle = false;
        if (this.readDeviceInfo().get("DeviceType").equals("NWC")) {
            canTimeDate = this.hasAttributeEnum("image/overlay/set/TimeEnable", this.getAttributesDoc());
            canTitle = this.hasAttributeEnum("image/overlay/set/TitleEnable", this.getAttributesDoc());
            if (checkVideoSource) {
                String xPath = "//cgis/cgi[@name='image']/submenu[@name='overlay']/action[@name='set']/parameter[@name='Channel']/dataType/int/@";
                canTimeDate &= this.isVideoSourceSupported(attributesDoc, xPath, videoSource);
                canTitle &= this.isVideoSourceSupported(attributesDoc, xPath, videoSource);
            }
        } else {
            String xPath = "//cgis/cgi[@name='image']/submenu[@name='multilineosd']/action[@name='add/update']/parameter[@name='OSDType']/dataType/enum/entry[@value='Date']";
            canTimeDate = this.getAttributes(xPath, this.getAttributesDoc()).size() > 0;
            xPath = "//cgis/cgi[@name='image']/submenu[@name='multilineosd']/action[@name='add/update']/parameter[@name='OSDType']/dataType/enum/entry[@value='Title']";
            boolean bl = canTitle = this.getAttributes(xPath, this.getAttributesDoc()).size() > 0;
            if (checkVideoSource) {
                xPath = "//cgis/cgi[@name='image']/submenu[@name='multilineosd']/action[@name='add/update']/parameter[@name='Channel']/dataType/int/@";
                canTimeDate &= this.isVideoSourceSupported(attributesDoc, xPath, videoSource);
                canTitle &= this.isVideoSourceSupported(attributesDoc, xPath, videoSource);
            }
        }
        miscVideoServerCapabilitiesType.setCanTimeDate(canTimeDate);
        miscVideoServerCapabilitiesType.setCanTitle(canTitle);
        return miscVideoServerCapabilitiesType;
    }

    protected DeviceGroupMembershipsType getDeviceGroupMembershipsType(Document attributesDoc, int videoSource) {
        boolean hasAreaZoom;
        DeviceGroupMembershipsType deviceGroupMembershipsType = new DeviceGroupMembershipsType();
        deviceGroupMembershipsType.getDeviceGroups().add("GenericDriver");
        deviceGroupMembershipsType.getDeviceGroups().add("GenericEventTrigger");
        deviceGroupMembershipsType.getDeviceGroups().add("CheckDeviceInfos");
        deviceGroupMembershipsType.getDeviceGroups().add("EdgeStorage");
        deviceGroupMembershipsType.getDeviceGroups().add("EdgeStorageVideoImport");
        deviceGroupMembershipsType.getDeviceGroups().add("PresetsImportable");
        deviceGroupMembershipsType.getDeviceGroups().add("ConfigurableVideoStreamNetworkTimeout");
        deviceGroupMembershipsType.getDeviceGroups().add("CameraAdministrationModifyPassword");
        String xPath = "//attributes/group[@name='PTZSupport']/category[@name='Support']/channel[@number='" + videoSource + "']/attribute[@name='AreaZoom']/@value";
        List<String> areaZoomCapabilitiesList = this.getAttributes(xPath, attributesDoc);
        boolean bl = hasAreaZoom = areaZoomCapabilitiesList.size() > 0 && areaZoomCapabilitiesList.contains("True");
        if (hasAreaZoom) {
            deviceGroupMembershipsType.getDeviceGroups().add("OpticalZoomAreaSupported");
        }
        return deviceGroupMembershipsType;
    }

    private SupportedEdgeStoragePlaybackSpeedsType getSupportedEdgeStoragePlaybackSpeedsType() {
        SupportedEdgeStoragePlaybackSpeedsType supportedEdgeStoragePlaybackSpeedsType = new SupportedEdgeStoragePlaybackSpeedsType();
        EdgeStoragePlaybackSpeedType edgeStoragePlaybackSpeedType = new EdgeStoragePlaybackSpeedType();
        edgeStoragePlaybackSpeedType.setSpeedName("1");
        edgeStoragePlaybackSpeedType.setSpeedValue(1);
        supportedEdgeStoragePlaybackSpeedsType.getEdgeStoragePlaybackSpeed().add(edgeStoragePlaybackSpeedType);
        return supportedEdgeStoragePlaybackSpeedsType;
    }

    protected List<String> getResolutions(String codec, String resolutionData) {
        String[] resolutionLines = resolutionData.split("\r\n");
        ArrayList<String> resolutions = new ArrayList<String>();
        block0: for (String resolutionLine : resolutionLines) {
            String[] resolutionSegments;
            if (!resolutionLine.toLowerCase().startsWith(codec.toLowerCase()) || !resolutionLine.toLowerCase().contains(".width=")) continue;
            for (String resolutionSegment : resolutionSegments = resolutionLine.split("\\.")) {
                String resolution;
                if (!this.isValidResolution(resolutionSegment) || resolutions.contains(resolution = resolutionSegment.replace("X", "x"))) continue;
                resolutions.add(resolution);
                continue block0;
            }
        }
        return resolutions;
    }

    protected boolean isValidResolution(String input) {
        if (input == null) {
            return false;
        }
        String[] inputLines = input.toLowerCase().split("x");
        return inputLines.length == 2 && inputLines[0].trim().matches("\\d+") && inputLines[1].trim().matches("\\d+");
    }
}

