/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.samsung;

import de.seetec.v5.re.cm.device.shared.cameraadministration.CameraAdministration;
import de.seetec.v5.re.cm.device.shared.cameraadministration.CameraAdministrationBase;
import de.seetec.v5.shared.net.HttpHandler;
import de.seetec.v5.shared.net.HttpHandlerImpl;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.SeetecHttpClient;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hc.core5.http.ContentType;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SamsungCameraAdministration
extends CameraAdministrationBase
implements CameraAdministration {
    private static final int SEQUENCE = 48;
    private static final int BIT_STRING = 3;
    private static final byte[] ZERO_BIT = new byte[]{0};
    private static final byte[] RSA_SEQUENCE_OBJECT_IDENTIFIER_NULL = new byte[]{48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0};
    private static final String CIPHER = "RSA/ECB/PKCS1Padding";
    private static final String ERROR = "error";

    public SamsungCameraAdministration(SeetecHttpClient httpClient) throws SeeTecException {
        super(httpClient);
    }

    public HttpHandler getHttpHandler(NetworkParameter networkParameter) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        return new HttpHandlerImpl(networkParameter);
    }

    @Override
    protected void modifyPasswordOnDevice(String passwordToSet, NetworkParameter networkParameter) throws SeeTecException {
        try {
            String response;
            String userList = this.getHttpHandler(networkParameter).readGetRequest("/stw-cgi/security.cgi?msubmenu=users&action=view");
            int userIndex = this.getUserIndex(userList, networkParameter.getUserPWD()[0]);
            String rsaKeyFromCamera = this.getHttpHandler(networkParameter).readGetRequest("/stw-cgi/security.cgi?msubmenu=rsa&action=view");
            String url = "/stw-cgi/security.cgi?msubmenu=users&action=update&Index=" + userIndex + "&UserID=" + networkParameter.getUserPWD()[0];
            if (rsaKeyFromCamera.toLowerCase().contains(ERROR)) {
                response = this.getHttpHandler(networkParameter).readGetRequest(url + "&Password=" + passwordToSet);
            } else {
                rsaKeyFromCamera = rsaKeyFromCamera.replace("PublicKey=", "");
                RSAPublicKey publicKey = this.getPublicKeyFromPem(rsaKeyFromCamera);
                String base64EncodedPassword = this.encryptPassword(passwordToSet, publicKey);
                response = this.getHttpHandler(networkParameter).readPostRequest(url + "&IsPasswordEncrypted=True", base64EncodedPassword);
            }
            this.checkResponseBodyForError(response);
        }
        catch (SeeTecException seeTecException) {
            throw new SeeTecException(seeTecException.getErrorCode(), "Error while setting password. Status: " + seeTecException.getNetworkStatus() + ". Message: " + seeTecException.getMessage());
        }
        catch (Exception exception) {
            throw new SeeTecException(-20001, "Error while setting password: " + exception.getMessage());
        }
    }

    protected String encryptPassword(String password, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance(CIPHER);
        cipher.init(1, publicKey);
        byte[] encryptedPassword = cipher.doFinal(password.getBytes());
        return Base64.getEncoder().encodeToString(encryptedPassword);
    }

    @Override
    protected void upgradeFirmwareOnDevice(byte[] firmwareData, NetworkParameter networkParameter) throws SeeTecException {
        networkParameter.setSoTimeout((int)TimeUnit.MINUTES.toMillis(15L));
        try {
            HttpHandler httpHandler = this.getHttpHandler(networkParameter);
            String response = httpHandler.readGetRequest("/stw-cgi/attributes.cgi");
            if (response != null) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document xmlDocument = documentBuilder.parse(new InputSource(new StringReader(response)));
                String xPathString = "//attributes/group[@name='System']/category[@name='Support']/attribute[@name='FWUpdate']/@value";
                XPath xPath = XPathFactory.newInstance().newXPath();
                ArrayList<String> resultList = new ArrayList<String>();
                try {
                    NodeList nodeList = (NodeList)xPath.compile(xPathString).evaluate(xmlDocument, XPathConstants.NODESET);
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        String value = nodeList.item(i).getTextContent();
                        resultList.add(value);
                    }
                }
                catch (Exception ex) {
                    this.getLogger().error("Could not read attributes from " + this + " : " + ex.getMessage());
                }
                if (resultList.isEmpty() || ((String)resultList.get(0)).equalsIgnoreCase("false")) {
                    this.logger.warn("Firmware upgrade not supported for for " + this);
                    return;
                }
            }
            String responseBody = httpHandler.readPostRequestMultipart("/stw-cgi/system.cgi?msubmenu=firmwareupdate&action=control&Type=Normal", "firmware.bin", firmwareData, ContentType.APPLICATION_OCTET_STREAM, "firmware.bin");
            this.checkResponseBodyForError(responseBody);
            this.checkResponseBodyForAlreadyInProgress(responseBody);
            this.checkResponseBodyForUpgradeSuccessful(responseBody);
        }
        catch (SeeTecException seeTecException) {
            throw new SeeTecException(seeTecException.getErrorCode(), "Error while upgrading firmware on device. Status: " + seeTecException.getNetworkStatus() + ". Message: " + seeTecException.getMessage());
        }
        catch (Exception exception) {
            throw new SeeTecException(-20001, "Error while upgrading firmware on device. Message: " + exception.getMessage());
        }
    }

    private void checkResponseBodyForError(String responseBody) throws SeeTecException {
        if (responseBody.toLowerCase().contains(ERROR)) {
            throw new SeeTecException(-20002, responseBody);
        }
    }

    private void checkResponseBodyForAlreadyInProgress(String responseBody) throws SeeTecException {
        if (responseBody.contains("Already in Progress")) {
            throw new SeeTecException(-20002, responseBody);
        }
    }

    private void checkResponseBodyForUpgradeSuccessful(String responseBody) throws SeeTecException {
        if (!responseBody.toLowerCase().contains("ok")) {
            throw new SeeTecException(-20002, responseBody);
        }
    }

    protected RSAPublicKey getPublicKeyFromPem(String rsaKeyFromCamera) throws Exception {
        String publicKeyPem = rsaKeyFromCamera.replace("-----BEGIN RSA PUBLIC KEY-----", "").replace("-----END RSA PUBLIC KEY-----", "").replace("\n", "").replace("\r", "").trim();
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] decoded = decoder.decode(publicKeyPem);
        byte[] subjectPublicKeyInfo = this.getSubjectPublicKeyInfo(decoded);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(subjectPublicKeyInfo);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return (RSAPublicKey)keyFactory.generatePublic(spec);
    }

    public byte[] getSubjectPublicKeyInfo(byte[] publicKey) throws IOException {
        byte[] publicKeyAsBitstring = this.getDerEncoding(3, ArrayUtils.addAll((byte[])ZERO_BIT, (byte[])publicKey));
        byte[] objectIdentifierAndPublicKey = ArrayUtils.addAll((byte[])RSA_SEQUENCE_OBJECT_IDENTIFIER_NULL, (byte[])publicKeyAsBitstring);
        return this.getDerEncoding(48, objectIdentifierAndPublicKey);
    }

    protected byte[] getDerEncoding(int tag, byte[] derSegment) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(tag);
        byteArrayOutputStream.write(new byte[]{-126, (byte)(derSegment.length >> 8), (byte)derSegment.length});
        byteArrayOutputStream.write(derSegment);
        return byteArrayOutputStream.toByteArray();
    }

    protected int getUserIndex(String userList, String userId) throws SeeTecException {
        if (userList != null) {
            String[] userListLines;
            for (String userLine : userListLines = userList.split("\r\n")) {
                String[] userParameters;
                String[] userLineParts = userLine.split("=");
                if (userLineParts.length != 2 || (userParameters = userLineParts[1].split("/")).length <= 0 || !userParameters[0].equals(userId)) continue;
                return Integer.parseInt(userLineParts[0].replace("Users.", ""));
            }
        }
        throw new SeeTecException(-20001, "User not found");
    }
}

