/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.samsung;

import de.seetec.v5.re.cm.device.shared.AudioOutServer;
import de.seetec.v5.re.cm.device.shared.net.rtp.RtpSenderPacket;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerIntf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerSuper;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPResponse;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SamsungAudioOutServer
extends AudioOutServer
implements Runnable,
RTSPHandlerIntf {
    private final NetworkParameter networkParameter;
    private final Logger logger;
    private volatile boolean isShutdown = false;
    private Thread thread;
    private int rtspPort;
    private TransmissionType transmissionID;
    private RTSPHandlerSuper rtspHandler;
    private Integer ssrc;
    private Integer sequenceNumber;
    private Integer timeStamp;
    private final int channelNumber;

    public SamsungAudioOutServer(NetworkParameter networkParameter, int rtspPort, TransmissionType transmissionID, int channelNumber) {
        this.channelNumber = channelNumber;
        if (networkParameter == null) {
            throw new IllegalArgumentException("NetworkParameter is null for HikvisionAudioOutServer");
        }
        this.networkParameter = networkParameter;
        this.logger = LogManager.getLogger(this.getClass());
        this.rtspPort = rtspPort;
        this.transmissionID = transmissionID;
    }

    public int init() {
        this.thread = new Thread((Runnable)this, this.getClass().getName());
        this.thread.start();
        this.logger.info(this + " initialized");
        return 0;
    }

    @Override
    public void sendDescribeResponse(RTSPResponse response) {
    }

    private void sendAudio(byte[] audioData) throws Exception {
        int pointer = 0;
        int previousPointer = 0;
        do {
            byte[] dataToSend;
            if ((pointer += 512) > audioData.length) {
                dataToSend = new byte[audioData.length - previousPointer];
                System.arraycopy(audioData, previousPointer, dataToSend, 0, audioData.length - previousPointer);
            } else {
                dataToSend = new byte[512];
                System.arraycopy(audioData, previousPointer, dataToSend, 0, 512);
                previousPointer = pointer;
                pointer += 512;
            }
            RtpSenderPacket rtpSenderPacket = new RtpSenderPacket(audioData, this.getSequenceNumber(), this.getTimeStamp(), this.getSSRC());
            int errorCode = this.rtspHandler.sendRTPPacket(rtpSenderPacket);
            if (errorCode != 0) {
                throw new SeeTecException(errorCode, "Samsung Camera not reachable for audio packet");
            }
        } while (pointer < audioData.length);
    }

    @Override
    public void run() {
        while (!this.isShutdown) {
            try {
                String rtspPath = "/" + this.channelNumber + "/profile1/media.smp";
                String rtspUrl = "rtsp://" + this.networkParameter.getHost() + rtspPath;
                RTSPStreamSettings rtspSettings = new RTSPStreamSettings();
                int errorCode = rtspSettings.init(this, this, this.networkParameter, this.rtspPort, rtspUrl, false, this.transmissionID, 5000, true, 1, rtspUrl);
                if (errorCode != 0) {
                    this.logger.error("Initialization of RTSPSettings failed with errorCode: " + errorCode + " for " + this);
                }
                rtspSettings.setIsVideoEnabled(false);
                rtspSettings.setEnableBackchannel(true);
                rtspSettings.setBackChannelCallback(this);
                this.rtspHandler = rtspSettings.getRTSPHandler();
                if (this.rtspHandler.start() != 0) {
                    this.logger.error("Audio Out Stream could not be started yet. Waiting 15 seconds before restarting. Device address: " + this.networkParameter.getHost());
                    Thread.sleep(15000L);
                    continue;
                }
                while (!this.isShutdown) {
                    try {
                        MediaFrame mediaFrameToSend = this.take();
                        for (byte[] singlePayLoad : mediaFrameToSend.getPayload()) {
                            this.sendAudio(singlePayLoad);
                        }
                    }
                    catch (Exception exception) {
                        this.logger.info("Error while sending audio packet for " + this + " : " + exception.getMessage());
                        break;
                    }
                }
                this.logger.info("Shutting down " + this);
            }
            catch (Exception ex) {
                this.logger.warn("Exception while starting RTSP handling for " + this);
            }
        }
        this.logger.info("Shutting down " + this);
    }

    @Override
    public int shutdown() {
        this.thread.interrupt();
        if (this.rtspHandler != null) {
            this.rtspHandler.shutdown();
        }
        return super.shutdown();
    }

    @Override
    public void processData(byte[] data) {
    }

    @Override
    public void onNetworkError(int errorCode) {
    }

    @Override
    public void sendStatusService(int errorCode) {
    }

    private int getSSRC() {
        if (this.ssrc == null) {
            Random r = new Random();
            this.ssrc = r.nextInt(Integer.MAX_VALUE);
        }
        return this.ssrc;
    }

    private int getSequenceNumber() {
        if (this.sequenceNumber == null) {
            Random r = new Random();
            this.sequenceNumber = r.nextInt(Short.MAX_VALUE);
        } else {
            SamsungAudioOutServer samsungAudioOutServer = this;
            Integer n = samsungAudioOutServer.sequenceNumber;
            Integer n2 = samsungAudioOutServer.sequenceNumber = Integer.valueOf(samsungAudioOutServer.sequenceNumber + 1);
        }
        return this.sequenceNumber;
    }

    private int getTimeStamp() {
        if (this.timeStamp == null) {
            Random r = new Random();
            this.timeStamp = r.nextInt(Short.MAX_VALUE);
        }
        SamsungAudioOutServer samsungAudioOutServer = this;
        samsungAudioOutServer.timeStamp = samsungAudioOutServer.timeStamp + 800;
        return this.timeStamp;
    }

    @Override
    public void setSSRCfromRTSP(String ssrc) {
    }
}

