/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.pelco.webservice;

import com.pelco.schemas.service.alarmarrayconfiguration._1.AlarmArrayConfigurationPortType;
import com.pelco.schemas.service.cameraconfiguration._1.CameraConfigurationPortType;
import com.pelco.schemas.service.lenscontrol._1.LensControlPortType;
import com.pelco.schemas.service.positioningcontrol._1.PositioningControlPortType;
import com.pelco.schemas.service.relayarrayconfiguration._1.RelayArrayConfigurationPortType;
import com.pelco.schemas.service.scriptcontrol._1.ScriptControlPortType;
import com.pelco.schemas.service.streamconfiguration._1.StreamConfigurationPortType;
import com.pelco.schemas.service.streamdiscovery._1.StreamDiscoveryPortType;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class PelcoWebServiceDevice {
    private Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private String ip = null;
    private int port = 0;
    private String deviceNumber = null;
    private JaxWsProxyFactoryBean factory = null;
    private AlarmArrayConfigurationPortType alarmArrayConfigurationService = null;
    private CameraConfigurationPortType cameraConfigurationService = null;
    private LensControlPortType lensControlService = null;
    private PositioningControlPortType positioningControlService = null;
    private RelayArrayConfigurationPortType relayArrayConfigurationService = null;
    private ScriptControlPortType scriptControlService = null;
    private StreamConfigurationPortType streamConfigurationService = null;
    private StreamDiscoveryPortType streamDiscoveryService = null;

    public final void init(String ip, int port, String deviceNumber, boolean logging) {
        this.ip = ip;
        this.port = port;
        this.deviceNumber = deviceNumber;
        this.factory = new JaxWsProxyFactoryBean();
        this.factory.setBindingId("http://schemas.xmlsoap.org/wsdl/soap12/");
        if (logging) {
            LoggingOutInterceptor loggingOutInterceptor = new LoggingOutInterceptor();
            LoggingInInterceptor loggingInInterceptor = new LoggingInInterceptor();
            loggingOutInterceptor.setPrettyLogging(true);
            loggingInInterceptor.setPrettyLogging(true);
            this.factory.getOutInterceptors().add(loggingOutInterceptor);
            this.factory.getInInterceptors().add(loggingInInterceptor);
        }
    }

    public final AlarmArrayConfigurationPortType getAlarmArrayConfigurationService() {
        if (this.alarmArrayConfigurationService == null) {
            this.factory.setServiceClass(AlarmArrayConfigurationPortType.class);
            this.factory.setAddress("http://" + this.ip + ":" + this.port + "/control/AlarmArrayConfiguration-" + this.deviceNumber);
            this.alarmArrayConfigurationService = (AlarmArrayConfigurationPortType)this.factory.create(AlarmArrayConfigurationPortType.class);
            this.logger.info("AlarmArrayConfigurationService initialized");
        }
        return this.alarmArrayConfigurationService;
    }

    public final CameraConfigurationPortType getCameraConfigurationService() {
        if (this.cameraConfigurationService == null) {
            this.factory.setServiceClass(CameraConfigurationPortType.class);
            this.factory.setAddress("http://" + this.ip + ":" + this.port + "/control/CameraConfiguration-" + this.deviceNumber);
            this.cameraConfigurationService = (CameraConfigurationPortType)this.factory.create(CameraConfigurationPortType.class);
            this.logger.info("CameraConfigurationService initialized");
        }
        return this.cameraConfigurationService;
    }

    public final LensControlPortType getLensControlService() {
        if (this.lensControlService == null) {
            this.factory.setServiceClass(LensControlPortType.class);
            this.factory.setAddress("http://" + this.ip + ":" + this.port + "/control/LensControl-" + this.deviceNumber);
            this.lensControlService = (LensControlPortType)this.factory.create(LensControlPortType.class);
            this.logger.info("LensControlService initialized");
        }
        return this.lensControlService;
    }

    public final PositioningControlPortType getPositioningControlService() {
        if (this.positioningControlService == null) {
            this.factory.setServiceClass(PositioningControlPortType.class);
            this.factory.setAddress("http://" + this.ip + ":" + this.port + "/control/PositioningControl-" + this.deviceNumber);
            this.positioningControlService = (PositioningControlPortType)this.factory.create(PositioningControlPortType.class);
            this.logger.info("PositioningControlService initialized");
        }
        return this.positioningControlService;
    }

    public final RelayArrayConfigurationPortType getRelayArrayConfigurationService() {
        if (this.relayArrayConfigurationService == null) {
            this.factory.setServiceClass(RelayArrayConfigurationPortType.class);
            this.factory.setAddress("http://" + this.ip + ":" + this.port + "/control/RelayArrayConfiguration-" + this.deviceNumber);
            this.relayArrayConfigurationService = (RelayArrayConfigurationPortType)this.factory.create(RelayArrayConfigurationPortType.class);
            this.logger.info("RelayArrayConfigurationService initialized");
        }
        return this.relayArrayConfigurationService;
    }

    public final ScriptControlPortType getScriptControlService() {
        if (this.scriptControlService == null) {
            this.factory.setServiceClass(ScriptControlPortType.class);
            this.factory.setAddress("http://" + this.ip + ":" + this.port + "/control/ScriptControl-" + this.deviceNumber);
            this.scriptControlService = (ScriptControlPortType)this.factory.create(ScriptControlPortType.class);
            this.logger.info("ScriptControlService initialized");
        }
        return this.scriptControlService;
    }

    public final StreamConfigurationPortType getStreamConfigurationService() {
        if (this.streamConfigurationService == null) {
            this.factory.setServiceClass(StreamConfigurationPortType.class);
            this.factory.setAddress("http://" + this.ip + ":" + this.port + "/control/StreamConfiguration-" + this.deviceNumber);
            this.streamConfigurationService = (StreamConfigurationPortType)this.factory.create(StreamConfigurationPortType.class);
            this.logger.info("StreamConfigurationService initialized");
        }
        return this.streamConfigurationService;
    }

    public final StreamDiscoveryPortType getStreamDiscoveryService() {
        if (this.streamDiscoveryService == null) {
            this.factory.setServiceClass(StreamDiscoveryPortType.class);
            this.factory.setAddress("http://" + this.ip + ":" + this.port + "/control/StreamDiscovery-" + this.deviceNumber);
            this.streamDiscoveryService = (StreamDiscoveryPortType)this.factory.create(StreamDiscoveryPortType.class);
            this.logger.info("StreamDiscoveryService initialized");
        }
        return this.streamDiscoveryService;
    }
}

