/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.pelco.mpeg;

import com.pelco.schemas.service.streamconfiguration._1.IntRange;
import com.pelco.schemas.service.streamconfiguration._1.Resolution;
import com.pelco.schemas.service.streamconfiguration._1.Setting;
import com.pelco.schemas.service.streamconfiguration._1.SettingOptions;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videoprofile.AdditionalVideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videoprofile.BasicVideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.pelco.PelcoCameraSrv;
import de.seetec.v5.re.cm.device.video.pelco.webservice.PelcoWebServiceCameraConfiguration;
import de.seetec.v5.re.cm.device.video.pelco.webservice.PelcoWebServiceDevice;
import de.seetec.v5.re.cm.device.video.pelco.webservice.PelcoWebServiceStreamConfiguration;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.VideoSourceParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class PelcoH264VideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.pelco.mpeg.PelcoH264VideoSourceClient";

    @Override
    public int init() {
        int streamId;
        block20: {
            this.errorCode = super.init();
            if (this.errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
                return this.errorCode;
            }
            this.networkParameter.setSoTimeout(5000);
            this.fps = this.fps < 1000L ? 1000L : this.fps;
            this.iFrameDist = Tools.convertIFrameDistMStoFrameCount(this.fps, this.iFrameDistMS, 1, 30);
            this.fps /= 1000L;
            PelcoWebServiceDevice pelcoWebServiceDevice = new PelcoWebServiceDevice();
            pelcoWebServiceDevice.init(this.getHost(), this.getPort(), "1", false);
            streamId = 0;
            if (this.listener instanceof BasicVideoProfileHandler) {
                streamId = 0;
                this.logger.info("BasicVideoProfileHandler");
            } else if (this.listener instanceof AdditionalVideoProfileHandler) {
                streamId = 1;
                this.logger.info("AdditionalVideoProfileHandler");
            }
            boolean multistreamingActivated = false;
            try {
                PelcoCameraSrv pelcoCameraSrv = (PelcoCameraSrv)this.getVideoSrv();
                multistreamingActivated = VideoSourceParameter.getAdditionalVideoProfiles((byte[])pelcoCameraSrv.getEntity().getConfiguration()).length != 0;
            }
            catch (ConfigurationException exception) {
                this.logger.info((Object)exception);
            }
            try {
                if (streamId != 0) break block20;
                PelcoWebServiceStreamConfiguration pelcoStreamConfigurationService = new PelcoWebServiceStreamConfiguration(pelcoWebServiceDevice);
                ArrayList<Setting> changedSettings = new ArrayList<Setting>();
                Setting encodingSetting = new Setting();
                encodingSetting.setName("encoding");
                encodingSetting.setStringValue("H264");
                changedSettings.add(encodingSetting);
                Resolution resolution = new Resolution();
                resolution.setWidth(this.width);
                resolution.setHeight(this.height);
                Setting resolutionSetting = new Setting();
                resolutionSetting.setName("resolution");
                resolutionSetting.setResolutionValue(resolution);
                changedSettings.add(resolutionSetting);
                List<SettingOptions> settingOptions1 = pelcoStreamConfigurationService.queryAllOptions(streamId, "video", changedSettings);
                float[] availableFramerateList = pelcoStreamConfigurationService.getPossibleDecimalValues("framerate", settingOptions1);
                float convertedFPS = Tools.convertToCameraValues(availableFramerateList, (float)this.fps);
                Setting framerateSetting = new Setting();
                framerateSetting.setName("framerate");
                framerateSetting.setDecimalValue(new BigDecimal(convertedFPS));
                changedSettings.add(framerateSetting);
                List<SettingOptions> settingOptions2 = pelcoStreamConfigurationService.queryAllOptions(streamId, "video", changedSettings);
                IntRange bitrateRange = pelcoStreamConfigurationService.getPossibleIntRangeValues("bitrate", settingOptions2);
                int bitrate = this.bandwidth;
                if (this.bandwidth <= bitrateRange.getMinValue()) {
                    bitrate = bitrateRange.getMinValue();
                } else if (this.bandwidth >= bitrateRange.getMaxValue()) {
                    bitrate = bitrateRange.getMaxValue();
                }
                Setting bitrateSetting = new Setting();
                bitrateSetting.setName("bitrate");
                bitrateSetting.setIntValue(Integer.valueOf(bitrate));
                changedSettings.add(bitrateSetting);
                List<SettingOptions> settingOptions3 = pelcoStreamConfigurationService.queryAllOptions(streamId, "video", changedSettings);
                IntRange gopRange = pelcoStreamConfigurationService.getPossibleIntRangeValues("gop", settingOptions3);
                this.fps *= 1000L;
                this.iFrameDist = Tools.convertIFrameDistMStoFrameCount(this.fps, this.iFrameDistMS, gopRange.getMinValue(), gopRange.getMaxValue());
                this.fps /= 1000L;
                int gop = (int)this.iFrameDist;
                Setting gopSetting = new Setting();
                gopSetting.setName("gop");
                gopSetting.setIntValue(Integer.valueOf(gop));
                changedSettings.add(gopSetting);
                String streamType = "video";
                pelcoStreamConfigurationService.changeSettings(streamId, "video", changedSettings, multistreamingActivated);
                try {
                    PelcoWebServiceCameraConfiguration pelcoCameraConfigurationService = new PelcoWebServiceCameraConfiguration(pelcoWebServiceDevice);
                    if (this.isAudioEnabled) {
                        pelcoCameraConfigurationService.setAudioEnabled(true);
                        break block20;
                    }
                    pelcoCameraConfigurationService.setAudioEnabled(false);
                }
                catch (Exception exception) {
                    this.logger.info("Audio can not be activated with the current parameter settings!");
                    this.logger.info((Object)exception);
                    this.isAudioEnabled = false;
                }
            }
            catch (Exception exception) {
                this.logger.info(exception.getMessage() + this);
            }
        }
        this.rtspUrl = "rtsp://" + this.getHost() + "/stream" + (streamId + 1);
        this.rtspSettings = new RTSPStreamSettings();
        try {
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 2, "*");
            if (this.errorCode != 0) {
                this.logger.error("Initialization of RTSPSettings failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Could not initialize rtspSettings for " + this);
            this.logger.warn((Object)ex, (Throwable)ex);
        }
        this.rtspSettings.setKeepAliveInterval(60000);
        try {
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
        }
        catch (SeeTecException ex) {
            this.logger.error("Start of RTSP handling failed: " + ex.getMessage() + " for " + this.getVideoSrv());
            return ex.getErrorCode();
        }
        this.errorCode = this.rtspHandler.start();
        if (this.errorCode != 0) {
            this.logger.error(" Start of RTSPHandler failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
            return this.errorCode;
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public void sendStatusService(int errorCode) {
        this.listener.sendStatusService(errorCode);
    }
}

