/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.pelco.jpeg;

import com.pelco.schemas.service.streamconfiguration._1.IntRange;
import com.pelco.schemas.service.streamconfiguration._1.Resolution;
import com.pelco.schemas.service.streamconfiguration._1.Setting;
import com.pelco.schemas.service.streamconfiguration._1.SettingOptions;
import de.seetec.v5.re.cm.device.shared.videoprofile.AdditionalVideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videoprofile.BasicVideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.pelco.PelcoCameraSrv;
import de.seetec.v5.re.cm.device.video.pelco.webservice.PelcoWebServiceDevice;
import de.seetec.v5.re.cm.device.video.pelco.webservice.PelcoWebServiceStreamConfiguration;
import de.seetec.v5.re.shared.VideoSourceParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class PelcoJPEGVideoSourceClient
extends JPEGVideoSourceClient {
    private static final String CLASS = "de.seetec.v5.re.cm.device.video.pelco.jpeg.PelcoJPEGVideoSourceClient";
    private int streamId;

    @Override
    protected final boolean isRunFinished() {
        return super.isRunFinished(CLASS);
    }

    @Override
    public int init() {
        int errorCode = super.init(false);
        if (errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + errorCode + " for " + this);
            return errorCode;
        }
        this.networkParameter.setSoTimeout(5000);
        this.streamId = 0;
        if (this.listener instanceof BasicVideoProfileHandler) {
            this.streamId = 0;
        } else if (this.listener instanceof AdditionalVideoProfileHandler) {
            this.streamId = 1;
        }
        boolean multistreamingActivated = false;
        try {
            PelcoCameraSrv pelcoCameraSrv = (PelcoCameraSrv)this.getVideoSrv();
            multistreamingActivated = VideoSourceParameter.getAdditionalVideoProfiles((byte[])pelcoCameraSrv.getEntity().getConfiguration()).length != 0;
        }
        catch (ConfigurationException exception) {
            this.logger.info("Exception for " + this + ": " + exception.getMessage());
            errorCode = -20030;
        }
        try {
            if (this.streamId == 0) {
                PelcoWebServiceDevice pelcoWebServiceDevice = new PelcoWebServiceDevice();
                pelcoWebServiceDevice.init(this.getHost(), this.getPort(), "1", false);
                PelcoWebServiceStreamConfiguration pelcoStreamConfigurationService = new PelcoWebServiceStreamConfiguration(pelcoWebServiceDevice);
                ArrayList<Setting> changedSettings = new ArrayList<Setting>();
                Setting encodingSetting = new Setting();
                encodingSetting.setName("encoding");
                encodingSetting.setStringValue("JPEG");
                changedSettings.add(encodingSetting);
                Resolution resolution = new Resolution();
                resolution.setWidth(this.width);
                resolution.setHeight(this.height);
                Setting resolutionSetting = new Setting();
                resolutionSetting.setName("resolution");
                resolutionSetting.setResolutionValue(resolution);
                changedSettings.add(resolutionSetting);
                List<SettingOptions> settingOptions1 = pelcoStreamConfigurationService.queryAllOptions(0, "video", changedSettings);
                float[] availableFramerateList = pelcoStreamConfigurationService.getPossibleDecimalValues("framerate", settingOptions1);
                float maxFPS = 1.0f;
                for (float value : availableFramerateList) {
                    if (!(value > maxFPS)) continue;
                    maxFPS = value;
                }
                Setting framerateSetting = new Setting();
                framerateSetting.setName("framerate");
                framerateSetting.setDecimalValue(new BigDecimal(maxFPS));
                changedSettings.add(framerateSetting);
                List<SettingOptions> settingOptions2 = pelcoStreamConfigurationService.queryAllOptions(0, "video", changedSettings);
                IntRange bitrateRange = pelcoStreamConfigurationService.getPossibleIntRangeValues("bitrate", settingOptions2);
                int bitrate = 0;
                int bitrateDistance = bitrateRange.getMaxValue() - bitrateRange.getMinValue();
                double factor = (double)(100000 - this.quality) / 100000.0;
                bitrate = bitrateRange.getMaxValue() - (int)((double)bitrateDistance * factor);
                Setting bitrateSetting = new Setting();
                bitrateSetting.setName("bitrate");
                bitrateSetting.setIntValue(Integer.valueOf(bitrate));
                changedSettings.add(bitrateSetting);
                String streamType = "video";
                pelcoStreamConfigurationService.changeSettings(this.streamId, "video", changedSettings, multistreamingActivated);
                Thread.sleep(5000L);
            }
        }
        catch (Exception exception) {
            this.logger.info(exception.getMessage() + this);
            return -20037;
        }
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
        return errorCode;
    }

    @Override
    public final void run() {
        this.networkParameter.setSoTimeout(5000);
        super.setRunFinished(CLASS, false);
        try {
            this.readSingleImages("http://" + this.getHost() + "/jpeg?id=" + this.streamId);
        }
        catch (IOException ex) {
            this.logger.error("Exception while reading single JPEG images for " + this + ": " + ex.getMessage());
            return;
        }
        if (!this.isShutdown()) {
            this.sendStatusService(-21651);
        }
        super.setRunFinished(CLASS, true);
        this.shutdown();
    }

    public final void sendStatusService(int nStatusCode) {
        this.listener.sendStatusService(nStatusCode);
    }

    public final void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        this.listener.notifyForNetworkProblems();
        this.shutdown();
    }

    public final int setImageParameter(long highestFPS) {
        this.highestFramerate = highestFPS;
        return 0;
    }
}

