/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.pelco;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.pelco.webservice.PelcoWebServiceAlarmArrayConfiguration;
import de.seetec.v5.re.cm.device.video.pelco.webservice.PelcoWebServiceDevice;
import de.seetec.v5.re.cm.device.video.pelco.webservice.PelcoWebServiceRelayArrayConfiguration;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;

public class PelcoIOHandler
extends IOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.pelco.PelcoIOHandler";
    private PelcoWebServiceDevice pelcoWebServiceDevice = null;
    private int errorCode = 0;

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        if (this.pelcoWebServiceDevice == null) {
            this.pelcoWebServiceDevice = new PelcoWebServiceDevice();
            this.pelcoWebServiceDevice.init(this.networkParameter.getHost(), this.networkParameter.getHTTPport(), "1", false);
        }
        PelcoWebServiceAlarmArrayConfiguration pelcoWebServiceAlarmArrayConfiguration = new PelcoWebServiceAlarmArrayConfiguration(this.pelcoWebServiceDevice);
        try {
            boolean previousLoopWithError = false;
            while (!(this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device.isShutdown())) {
                try {
                    long duration;
                    long ts = System.currentTimeMillis();
                    this.readDigitalInputs(pelcoWebServiceAlarmArrayConfiguration);
                    if (previousLoopWithError) {
                        DigitalInputSrv[] iServices;
                        previousLoopWithError = false;
                        this.logger.info("Publishing input stati after error for " + this);
                        DigitalInputSrv[] digitalInputSrvArray = iServices = super.getDigitalInputSrv();
                        int n = digitalInputSrvArray.length;
                        for (int i = 0; i < n; ++i) {
                            DigitalInputSrv iService = digitalInputSrvArray[i];
                            if (!iService.getEntity().isEnabled().booleanValue()) continue;
                            iService.publishServiceStatus(iService.getInputStatus());
                        }
                    }
                    if ((duration = System.currentTimeMillis() - ts) < 0L || duration >= 190L) continue;
                    try {
                        Thread.sleep(200L - duration);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Throwable ex) {
                    previousLoopWithError = true;
                    if (ex instanceof IOException || ex instanceof UnknownHostException || ex instanceof NoRouteToHostException || ex instanceof ConnectException) {
                        this.logger.warn("Network trouble for " + this);
                    } else {
                        this.logger.warn((Object)ex, ex);
                        if (ex.getMessage().contains("Address already in use")) {
                            this.logger.warn("TCP stack seems to be overloaded, so there are problems for " + this);
                        } else {
                            this.logger.warn("Unknown trouble for " + this);
                        }
                    }
                    try {
                        DigitalInputSrv[] iServices;
                        for (DigitalInputSrv iService : iServices = super.getDigitalInputSrv()) {
                            if (!iService.getEntity().isEnabled().booleanValue()) continue;
                            iService.publishServiceStatus(-21603);
                        }
                    }
                    catch (Throwable t) {
                        this.logger.warn((Object)t, t);
                    }
                    long tsTimeout = System.currentTimeMillis() + 10000L;
                    while (tsTimeout > System.currentTimeMillis() && !this.isShutdown(CLASS_NAME) && !this.device.isShutdown()) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        this.logger.info("Thread of this " + this + " finished :-)");
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    private int readDigitalInputs(PelcoWebServiceAlarmArrayConfiguration pelcoWebServiceAlarmArrayConfiguration) throws Exception {
        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
        boolean state = pelcoWebServiceAlarmArrayConfiguration.getAlarmStates();
        if (state) {
            iServices[0].checkInput(1);
            iServices[1].checkInput(1);
        } else {
            iServices[0].checkInput(0);
            iServices[1].checkInput(0);
        }
        return 0;
    }

    @Override
    public int writeDigitalOutput(int outputNumber, int value, long holdTime) {
        DigitalOutputSrv service = super.getDigitalOutputSrv(outputNumber);
        if (service == null) {
            this.errorCode = -21601;
            return this.errorCode;
        }
        if (value < 0) {
            this.logger.error("Value [" + value + "] is not valid for " + this);
            this.errorCode = -21601;
            return this.errorCode;
        }
        try {
            IOHandler.HoldTimer holdTimer;
            if (this.pelcoWebServiceDevice == null) {
                this.pelcoWebServiceDevice = new PelcoWebServiceDevice();
                this.pelcoWebServiceDevice.init(this.networkParameter.getHost(), this.networkParameter.getHTTPport(), "1", false);
            }
            PelcoWebServiceRelayArrayConfiguration pelcoRelayArrayConfigurationService = new PelcoWebServiceRelayArrayConfiguration(this.pelcoWebServiceDevice);
            pelcoRelayArrayConfigurationService.triggerRelay(outputNumber - 1, value, null);
            if (holdTime > 0L && (this.errorCode = (holdTimer = new IOHandler.HoldTimer()).init(outputNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                holdTimer.shutdown();
                this.logger.warn("Creating " + holdTimer + " failed with error [" + this.errorCode);
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
            this.logger.warn("Problems setting output [" + outputNumber + "] of " + this);
        }
        return this.errorCode;
    }
}

