/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.pelco;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.videoprofile.AdditionalVideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videoprofile.BasicVideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.pelco.PelcoCameraControl;
import de.seetec.v5.re.cm.device.video.pelco.jpeg.PelcoJPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.pelco.mpeg.PelcoH264VideoSourceClient;
import de.seetec.v5.re.cm.device.video.pelco.webservice.PelcoWebServiceDevice;
import de.seetec.v5.re.cm.device.video.pelco.webservice.PelcoWebServiceStreamDiscovery;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.util.SeeTecException;

public class PelcoCameraSrv
extends LiveCameraSrv {
    private PelcoWebServiceDevice pelcoWebServiceDevice = null;
    private PelcoWebServiceStreamDiscovery pelcoWebServiceStreamDiscovery = null;

    @Override
    public CameraControl createCameraControl(Long nEntityType) {
        return new PelcoCameraControl();
    }

    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        int errorCode = 0;
        VideoSourceClient videoSourceClient = null;
        this.logger.info("Creating new [VideoSourceClient] with VideoProfileHandler=" + listener + " ...");
        try {
            Codec streamingMode = listener.getVideoSourceParameter().getMediaCodec();
            boolean noStreamAvailable = false;
            if (listener instanceof BasicVideoProfileHandler) {
                this.logger.info("BasicVideoProfileHandler");
                videoSourceClient = streamingMode == Codec.H264 ? new PelcoH264VideoSourceClient() : new PelcoJPEGVideoSourceClient();
            } else if (listener instanceof AdditionalVideoProfileHandler) {
                this.logger.info("AdditionalVideoProfileHandler");
                if (this.pelcoWebServiceDevice == null) {
                    this.pelcoWebServiceDevice = new PelcoWebServiceDevice();
                    this.pelcoWebServiceDevice.init(this.getDevice().getDeviceCnf().getNetworkParameter().getHost(), this.getDevice().getDeviceCnf().getNetworkParameter().getHTTPport(), "1", false);
                }
                if (this.pelcoWebServiceStreamDiscovery == null) {
                    this.pelcoWebServiceStreamDiscovery = new PelcoWebServiceStreamDiscovery(this.pelcoWebServiceDevice);
                }
                if (this.pelcoWebServiceStreamDiscovery.isStreamH264(1)) {
                    this.logger.info("2nd stream is H264");
                    videoSourceClient = new PelcoH264VideoSourceClient();
                } else if (this.pelcoWebServiceStreamDiscovery.isStreamJPEG(1)) {
                    this.logger.info("2nd stream is JPEG");
                    videoSourceClient = new PelcoJPEGVideoSourceClient();
                } else {
                    noStreamAvailable = true;
                    this.logger.info("2nd stream is activated in the client but not activated on the device");
                    listener.sendStatusService(-21600);
                }
            }
            if (!noStreamAvailable && (errorCode = videoSourceClient.init(core, this, listener)) != 0) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
                this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "] :-(");
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
        }
        catch (SeeTecException seetecEx) {
            throw seetecEx;
        }
        catch (Throwable ex) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            this.logger.error((Object)ex, ex);
            this.logger.error("Creating [VideoSourceClient] for " + this + " failed :-(");
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        return videoSourceClient;
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] nResolution) throws SeeTecException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

