/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic2.mpeg;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2CameraSrv;
import de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2Device;
import de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2Helper;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MpegProfile;
import de.seetec.v5.shared.EntityType;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Panasonic2H26xVideoSourceClient
extends StreamingVideoSourceClientRTSP
implements EntityType {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.panasonic2.mpeg.Panasonic2H26xVideoSourceClient";
    private Panasonic2Device panasonic2Device;
    private String videoSourceNumber = "";
    private int streamNumber = 1;
    private boolean streamModeAvbr = false;
    private boolean streamModeVbr = false;

    @Override
    public final int init() {
        int rotationOnCamera;
        String capabilities2;
        String capabilities;
        String uid;
        String data;
        String configuration;
        String codecAndStreamH264;
        String codecAndStreamConfiguration;
        String codecAndStream;
        String codec;
        block87: {
            this.errorCode = super.init();
            if (this.errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
                return this.errorCode;
            }
            this.streamNumber = 1;
            codecAndStream = codec = "h264";
            codecAndStreamConfiguration = "h264";
            codecAndStreamH264 = "h264";
            configuration = null;
            data = null;
            uid = "";
            String capabilityUrl = "/cgi-bin/get_capability";
            String capability2Url = "/cgi-bin/get_capability2";
            capabilities = null;
            capabilities2 = null;
            try {
                capabilities = this.panasonic2Device.getHttpHandler().readGetRequest(capabilityUrl);
                capabilities2 = this.panasonic2Device.getHttpHandler().readGetRequest(capability2Url);
            }
            catch (SeeTecException ex) {
                this.logger.warn("Exception while trying to get parameters for " + this + " : " + ex.getMessage(), (Throwable)ex);
                this.logger.warn("Trying to start stream anyway...");
            }
            if (this.isSmartDriver()) {
                try {
                    String[] streamNames = this.listener.getVideoSourceParameter().getStreamName().split(" ");
                    if (streamNames.length == 2) {
                        try {
                            this.streamNumber = Integer.parseInt(streamNames[1].trim());
                        }
                        catch (NumberFormatException ex) {
                            this.logger.warn("Exception while trying to parse stream number " + streamNames[1].trim());
                            this.logger.warn("Continuing with stream number 0 instead");
                        }
                        break block87;
                    }
                    this.logger.warn("Error while getting stream number. Using stream number 0 as default");
                }
                catch (ConfigurationException configurationException) {
                    this.logger.warn("Could not read stream name from configuration for " + this + ": " + configurationException.getMessage());
                }
            } else {
                this.streamNumber = this.panasonic2Device.getStreamNumber(this.fps, this.listener.getDynamicVideoProfileID());
            }
        }
        if (Panasonic2Helper.getNumberOfVideoSourcesFromDevice(capabilities) > 1) {
            this.videoSourceNumber = "&ch=" + this.videoSourceNr;
        }
        if (this.videoCodec == Codec.H265) {
            codecAndStream = "h265";
        }
        codecAndStreamConfiguration = codecAndStream;
        if (this.streamNumber > 1) {
            codecAndStreamConfiguration = codecAndStreamConfiguration + "_" + this.streamNumber;
            codecAndStream = codecAndStream + "-" + this.streamNumber;
            codecAndStreamH264 = codecAndStreamH264 + "-" + this.streamNumber;
        }
        try {
            String configurationUrl = "/cgi-bin/getuid?vcodec=" + codecAndStreamConfiguration + "&FILE=2&Page=2765&reply=info" + this.videoSourceNumber;
            configuration = this.panasonic2Device.getHttpHandler().readGetRequest(configurationUrl);
            uid = Panasonic2Helper.getFirstValueAsString(configuration, "UID");
            if (uid.equals("-1")) {
                this.logger.error("Too many users active on " + this);
            }
            if (uid.equals("-2")) {
                this.setCodec(this.videoCodec, this.streamNumber);
                configuration = this.panasonic2Device.getHttpHandler().readGetRequest(configurationUrl);
                uid = Panasonic2Helper.getFirstValueAsString(configuration, "UID");
            }
            if (uid.equals("-3")) {
                this.panasonic2Device.getHttpHandler().readGetRequest("/cgi-bin/set_h264" + (this.streamNumber > 1 ? "_" + this.streamNumber : "") + "?h264_transmit=1" + this.videoSourceNumber);
                configuration = this.panasonic2Device.getHttpHandler().readGetRequest(configurationUrl);
                uid = Panasonic2Helper.getFirstValueAsString(configuration, "UID");
            }
            String dataUrl = "/cgi-bin/getdata";
            data = this.panasonic2Device.getHttpHandler().readGetRequest(dataUrl);
        }
        catch (SeeTecException ex) {
            this.logger.warn("Could not read configuration from " + this + " : " + ex.getMessage() + " trying to start stream anyway...");
        }
        String parameterName = "video_server.image." + codec + ".bandwidth.min_max." + this.width + "x" + this.height;
        int minBandwidth = 64;
        int maxBandwidth = 4096;
        int[] minMaxBandwidth = null;
        int[] allowedBandWidthList = null;
        try {
            allowedBandWidthList = Panasonic2Helper.getValuesAsInt(capabilities, "video_server.image." + codec + ".bandwidth");
            minMaxBandwidth = Panasonic2Helper.getValuesAsInt(capabilities2, parameterName);
        }
        catch (Exception e) {
            this.logger.warn("Exception while reading bandwidth capabilities for " + this);
        }
        if (minMaxBandwidth != null && minMaxBandwidth.length == 2) {
            minBandwidth = minMaxBandwidth[0];
            maxBandwidth = minMaxBandwidth[1];
        } else if (allowedBandWidthList != null && allowedBandWidthList.length > 0) {
            maxBandwidth = allowedBandWidthList[allowedBandWidthList.length - 1];
        }
        if (capabilities != null) {
            double[] allowedIFrameValues;
            HashMap<String, String> cameraParameters = new HashMap<String, String>();
            Tools.parseParameters(cameraParameters, capabilities);
            this.useResolutionFromConfiguration = true;
            if (this.isAudioEnabled) {
                this.logger.info("Audio enabled. Audio Parameter: " + this.audioBitrate + "kbit for " + this.getVideoSrv().getDevice());
            }
            this.fps /= 1000L;
            this.bandwidth /= 1024;
            try {
                this.readStreamModes(capabilities, codecAndStream);
            }
            catch (SeeTecException ex) {
                this.logger.warn("Exception while reading streaming modes for " + this + " : " + ex.getMessage());
                this.logger.warn("Will try to start stream anyway. Probably quality/bitrate parameters won't be set");
            }
            ArrayList<Integer> allowedBandwidthList = new ArrayList<Integer>();
            if (allowedBandWidthList != null) {
                for (int allowedBandWidth : allowedBandWidthList) {
                    if (allowedBandWidth < minBandwidth || allowedBandWidth > maxBandwidth) continue;
                    allowedBandwidthList.add(allowedBandWidth);
                }
            }
            float[] allowedFramerates = null;
            try {
                double[] framerates = Panasonic2Helper.getValuesAsDouble(capabilities, "video_server.image." + codecAndStream + ".framerate");
                if (framerates.length == 0) {
                    framerates = Panasonic2Helper.getValuesAsDouble(capabilities, "video_server.image." + codecAndStreamH264 + ".framerate");
                }
                allowedFramerates = new float[framerates.length];
                for (int i = 0; i < framerates.length; ++i) {
                    allowedFramerates[i] = (float)framerates[i];
                }
            }
            catch (Exception ex) {
                this.logger.warn("Could not read available framerates for " + this + " : " + ex.getMessage());
                this.logger.warn("Using default framerates instead");
            }
            if (allowedFramerates == null) {
                allowedFramerates = new float[]{1.0f, 3.0f, 5.0f, 7.5f, 10.0f, 15.0f, 20.0f, 30.0f, 60.0f};
            }
            String fpsRate = "" + Tools.convertToCameraValues(allowedFramerates, (float)this.fps);
            fpsRate = fpsRate.replace(".0", "");
            try {
                allowedIFrameValues = Panasonic2Helper.getValuesAsDouble(capabilities, "video_server.image." + codecAndStream + ".i_interval");
            }
            catch (Exception ex) {
                this.logger.warn("Could not read available I-Frame distances for " + this + " : " + ex.getMessage());
                this.logger.warn("Using default I-Frame distances instead");
                allowedIFrameValues = new double[]{0.2, 0.25, 0.33, 0.5, 1.0, 2.0, 3.0, 4.0, 5.0};
            }
            int[] allowedValuesIFrame = new int[allowedIFrameValues.length];
            for (int i = 0; i < allowedValuesIFrame.length; ++i) {
                allowedValuesIFrame[i] = (int)(1000.0 * allowedIFrameValues[i]);
            }
            this.iFrameDistMS = Tools.convertToCameraValues(allowedValuesIFrame, this.iFrameDistMS);
            boolean allVideoParametersSet = true;
            StringBuilder url = new StringBuilder("/cgi-bin/set_").append(codec);
            int bitrateOnCamera = 64;
            try {
                bitrateOnCamera = Panasonic2Helper.getFirstValueAsInt(configuration, "iBitrate");
            }
            catch (Exception ex) {
                this.logger.warn("Exception while reading bitrate from camera for " + this + " : " + ex.getMessage());
            }
            if (!(bitrateOnCamera >= minBandwidth && bitrateOnCamera <= maxBandwidth || Panasonic2H26xVideoSourceClient.isBitrateSet(configuration, 4096, this.streamNumber, this.videoSourceNr))) {
                this.setBitrate(4096, codec, codecAndStream, allowedBandwidthList, uid);
            }
            if (this.streamNumber > 1) {
                url.append("_").append(this.streamNumber);
            }
            url.append("?");
            if (!Panasonic2H26xVideoSourceClient.isRTSPModeSet(configuration, codecAndStreamConfiguration)) {
                allVideoParametersSet = false;
                url.append(codec).append("_rtsp_mode");
                if (this.streamNumber > 1) {
                    url.append(this.streamNumber);
                }
                url.append("=1");
            }
            if (!this.isConstantBitrateUsed) {
                String qualityValue;
                if (this.streamModeVbr) {
                    if (!Panasonic2H26xVideoSourceClient.isTransmitModeSet(configuration, this.streamNumber, 4, this.videoSourceNr)) {
                        allVideoParametersSet = false;
                        url.append("&f_priority=4");
                    }
                    if (!Panasonic2H26xVideoSourceClient.isQualitySet(configuration, qualityValue = Integer.toString((99999 - this.quality) / 10000))) {
                        allVideoParametersSet = false;
                        url.append("&").append(codec).append("_quality=").append(qualityValue);
                    }
                } else if (this.streamModeAvbr) {
                    if (!Panasonic2H26xVideoSourceClient.isTransmitModeSet(configuration, this.streamNumber, 3, this.videoSourceNr)) {
                        allVideoParametersSet = false;
                        url.append("&f_priority=3");
                    }
                    if (!Panasonic2H26xVideoSourceClient.isQualitySet(configuration, qualityValue = this.quality < 33333 ? "low" : (this.quality < 66666 ? "normal" : "fine"))) {
                        allVideoParametersSet = false;
                        url.append("&").append(codec).append("_quality=").append(qualityValue);
                    }
                }
            } else if (!Panasonic2H26xVideoSourceClient.isTransmitModeSet(configuration, this.streamNumber, 0, this.videoSourceNr)) {
                allVideoParametersSet = false;
                url.append("&f_priority=0");
            }
            if (!Panasonic2H26xVideoSourceClient.isResolutionSet(configuration, this.width)) {
                allVideoParametersSet = false;
                url.append("&nr_").append(codec).append("_resolution=").append(this.width);
            }
            String iFrameDistance = Integer.toString(this.iFrameDistMS / 1000);
            if (this.iFrameDistMS < 1000) {
                iFrameDistance = Float.toString((float)((double)this.iFrameDistMS / 1000.0));
            }
            if (!Panasonic2H26xVideoSourceClient.isIFrameDistanceSet(data, iFrameDistance, this.streamNumber, this.videoSourceNr)) {
                allVideoParametersSet = false;
                url.append("&").append(codec).append("_Ivop=").append(iFrameDistance);
            }
            Panasonic2CameraSrv panasonic2CameraSrv = (Panasonic2CameraSrv)this.getVideoSrv();
            try {
                panasonic2CameraSrv.setVideoSourceParameters(data, capabilities, this.useDateTime, this.useTitle, this.title, this.rotationAngle, this.videoSourceNr);
            }
            catch (ConfigurationException | SeeTecException ex) {
                this.logger.warn("Exception while setting date/time, camera name or image rotation for " + this + ": " + ex.getMessage());
                this.logger.warn("Trying to start stream anyway...");
            }
            if (!allVideoParametersSet) {
                try {
                    url.append(this.videoSourceNumber);
                    this.panasonic2Device.getHttpHandler().readGetRequest(url.toString().replace("?&", "?") + "&UID=" + uid);
                }
                catch (SeeTecException ex) {
                    this.logger.warn("Exception while setting parameters on camera.\r\nURL sent: " + url.toString() + "\r\nException: " + ex.getMessage() + "\r\nTrying to get an " + codec + " stream anyway...");
                }
            }
            if (!Panasonic2H26xVideoSourceClient.isFramerateSet(data, fpsRate, this.streamNumber, this.videoSourceNr)) {
                String command = this.createFramerateUrl(codec, fpsRate, this.streamNumber, this.videoSourceNumber, uid);
                try {
                    this.panasonic2Device.getHttpHandler().readGetRequest(command);
                }
                catch (SeeTecException ex) {
                    this.logger.warn("Exception while setting framerate on camera.\r\nURL sent: " + url.toString() + "\r\nException: " + ex.getMessage() + "\r\nTrying to get an " + codec + " stream anyway...");
                }
            }
            if (this.videoCodec == Codec.H264) {
                try {
                    url = new StringBuilder();
                    url.append("/cgi-bin/set_stream?h264_profile=");
                    if (this.listener.getVideoSourceParameter().getMpegProfile() == MpegProfile.BASELINE) {
                        url.append("1");
                    } else {
                        url.append("0");
                    }
                    url.append(this.videoSourceNumber);
                    this.panasonic2Device.getHttpHandler().readGetRequest(url.toString() + "&UID=" + uid);
                }
                catch (Exception ex) {
                    this.logger.warn("Exception while setting H.264 Profile on camera.\r\nURL sent: " + url.toString() + "\r\nException: " + ex.getMessage() + "\r\nTrying to get an " + codec + " stream anyway...");
                }
            }
            try {
                configuration = this.panasonic2Device.getHttpHandler().readGetRequest("/cgi-bin/getinfo?FILE=1");
            }
            catch (SeeTecException ex) {
                this.logger.warn("Could not read configuration from " + this + " : " + ex.getMessage() + " trying to start stream anyway...");
            }
            int nearestBitrate = Panasonic2Helper.getNearestValue(allowedBandwidthList, this.bandwidth);
            if (!Panasonic2H26xVideoSourceClient.isBitrateSet(configuration, nearestBitrate, this.streamNumber, this.videoSourceNr) || !Panasonic2H26xVideoSourceClient.isTransmitModeSet(configuration, this.streamNumber, 0, this.videoSourceNr)) {
                this.setBitrate(nearestBitrate, codec, codecAndStream, allowedBandwidthList, uid);
            }
            if (this.isAudioEnabled && !Panasonic2H26xVideoSourceClient.isAudioSet(configuration)) {
                try {
                    this.panasonic2Device.getHttpHandler().readGetRequest("/cgi-bin/set_audio?audio=in&audio_encoder=g711&UID=" + uid);
                }
                catch (SeeTecException see) {
                    this.logger.error("Exception while trying to set audio parameters for " + this + " : " + see.getMessage(), (Throwable)see);
                    this.logger.warn("Trying to stream video anyway...");
                }
            }
        }
        if ((rotationOnCamera = this.getRotationOnCamera(uid)) == 90 || rotationOnCamera == 270) {
            int temp = this.width;
            this.width = this.height;
            this.height = temp;
        }
        this.rtspUrl = "rtsp://" + this.getHost() + "/MediaInput/h264/stream_" + this.streamNumber;
        if (this.videoCodec == Codec.H265) {
            this.rtspUrl = "rtsp://" + this.getHost() + "/MediaInput/stream_" + this.streamNumber;
        }
        if (this.videoSourceNr > 1) {
            this.rtspUrl = this.rtspUrl + "/ch_" + this.videoSourceNr;
        }
        this.rtspSettings = new RTSPStreamSettings();
        try {
            int keepaliveMethod = 2;
            if (this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, 5000, this.isAudioEnabled, keepaliveMethod, this.rtspUrl) != 0) {
                this.logger.error("Error while initializing RTSP settings for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.rtspHandler.setAuthenticationMethod(100);
            long sleepTime = 30000L;
            do {
                if ((this.errorCode = this.rtspHandler.start()) == 0) continue;
                try {
                    this.logger.warn("Not able to start video stream for " + this);
                    this.logger.warn("Waiting for " + sleepTime / 1000L + " seconds before making new attempt.");
                    Thread.sleep(sleepTime);
                    sleepTime *= 2L;
                }
                catch (Exception ex) {
                    this.logger.warn("Exception while sleeping for " + this + " : " + ex.getMessage());
                }
            } while (sleepTime < 120001L && this.errorCode != 0);
            if (this.errorCode != 0) {
                this.logger.error("Error while starting RTSP Handler for " + this.getVideoSrv());
                return this.errorCode;
            }
        }
        catch (ConfigurationException ex) {
            this.logger.error("Exception while starting RTSP stream for " + this + " : " + ex.getMessage(), (Throwable)ex);
            return -20001;
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while starting RTSP stream for " + this + " : " + ex.getMessage(), (Throwable)ex);
            return ex.getErrorCode();
        }
        catch (Exception ex) {
            this.logger.error("Exception while starting RTSP stream for " + this + " : " + ex.getMessage(), (Throwable)ex);
            return -20001;
        }
        this.logger.info("Init done for" + this.getVideoSrv());
        return 0;
    }

    private void setBitrate(int bandwidth, String codec, String codecAndStream, List<Integer> allowedValues, String uid) {
        ArrayList<Integer> bitrateValues = new ArrayList<Integer>();
        for (Integer i : allowedValues) {
            bitrateValues.add(i);
        }
        while (bitrateValues.size() > 0) {
            Integer nearestValue = Panasonic2Helper.getNearestValue(bitrateValues, bandwidth);
            StringBuilder url = new StringBuilder();
            url.append("/cgi-bin/set_").append(codec);
            if (this.streamNumber > 1) {
                url.append("_").append(this.streamNumber);
            }
            url.append("?");
            url.append(codec).append("_bandwidth=");
            url.append(nearestValue);
            url.append("&UID=");
            url.append(uid);
            url.append(this.videoSourceNumber);
            try {
                this.panasonic2Device.getHttpHandler().readGetRequest(url.toString());
                String cameraConfig = this.panasonic2Device.getHttpHandler().readGetRequest("/cgi-bin/getinfo?FILE=1");
                if (Panasonic2H26xVideoSourceClient.isBitrateSet(cameraConfig, nearestValue, this.streamNumber, this.videoSourceNr)) {
                    return;
                }
                bitrateValues.remove(nearestValue);
            }
            catch (Exception ex) {
                this.logger.warn("Exception while setting bitrate on camera.\r\nURL sent: " + url.toString() + "\r\nException: " + ex.getMessage() + "\r\nTrying to get an " + codec + " stream anyway...");
                break;
            }
        }
        this.logger.warn("Could not set correct bitrate.");
    }

    public void setDevice(Panasonic2Device panasonic2Device) {
        this.panasonic2Device = panasonic2Device;
    }

    @Override
    public final int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        this.panasonic2Device.unsetH264Stream(this.streamNumber);
        return super.shutdown();
    }

    @Override
    public final void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public final void notifyForNetworkProblems() {
        this.logger.error("Network problem signalied. Shutting down.");
        this.sendStatusService(-21603);
        this.shutdown();
    }

    @Override
    public final void sendStatusService(int statusCode) {
        if (this.listener != null) {
            this.listener.sendStatusService(statusCode);
        } else {
            this.logger.error("Listener null for " + this);
        }
    }

    @Override
    public final void processData(byte[] data) {
        this.processRtpData(data);
    }

    private boolean isSmartDriver() {
        return this.videoSrv.getDevice().getDeviceEntity().getEntityType() == 200555L;
    }

    private void readStreamModes(String capability, String codec) throws SeeTecException {
        String[] streamModes;
        String url = "video_server.image." + codec + ".stream_mode";
        String[] stringArray = streamModes = Panasonic2Helper.getValuesAsString(capability, url);
        int n = stringArray.length;
        block8: for (int i = 0; i < n; ++i) {
            String mode;
            switch (mode = stringArray[i]) {
                case "avbr": {
                    this.streamModeAvbr = true;
                    continue block8;
                }
                case "vbr": {
                    this.streamModeVbr = true;
                    continue block8;
                }
            }
        }
    }

    private int getRotationOnCamera(String uid) {
        try {
            String configurationOnCamera = this.panasonic2Device.getHttpHandler().readGetRequest("/cgi-bin/getinfo?FILE=1&UID=" + uid);
            int rotationAngleOnCamera = Panasonic2Helper.getFirstValueAsInt(configurationOnCamera, "Rotation");
            return rotationAngleOnCamera;
        }
        catch (Exception ex) {
            this.logger.warn("Could not read image rotation value from device. Asuming 0 degrees...");
            return 0;
        }
    }

    protected static boolean isRTSPModeSet(String configuration, String codecAndStreamConfiguration) {
        if (configuration == null || codecAndStreamConfiguration == null) {
            return false;
        }
        return configuration.toLowerCase().contains("srtspmode_" + codecAndStreamConfiguration.toLowerCase() + "=0");
    }

    protected static boolean isTransmitModeSet(String configuration, int streamNumber, int mode, int channel) {
        if (configuration == null) {
            return false;
        }
        String camera = "";
        if (channel > 1) {
            camera = "_cam" + channel;
        }
        return configuration.toLowerCase().contains("itransmit_mode" + (streamNumber > 1 ? "_" + streamNumber : "") + camera + "=" + mode);
    }

    protected static boolean isQualitySet(String configuration, String qualityValue) {
        if (configuration == null || qualityValue == null) {
            return false;
        }
        return configuration.toLowerCase().contains("iquality=" + qualityValue.toLowerCase());
    }

    protected static boolean isResolutionSet(String configuration, int width) {
        if (configuration == null) {
            return false;
        }
        return configuration.toLowerCase().contains("iresolution=" + width);
    }

    protected static boolean isAudioSet(String configuration) {
        if (configuration == null) {
            return false;
        }
        return configuration.toLowerCase().contains("aenable=in") && configuration.toLowerCase().contains("aenc=1");
    }

    protected static boolean isFramerateSet(String data, String fps, int streamNumber, int channel) {
        if (data == null) {
            return false;
        }
        return data.toLowerCase().contains("h264nrframerate" + (streamNumber > 1 ? "_" + streamNumber : "") + (channel > 1 ? "_ch" + channel : "") + ",\"" + fps + "\"");
    }

    protected static boolean isIFrameDistanceSet(String data, String iFrameDistance, int streamNumber, int channel) {
        if (data == null) {
            return false;
        }
        return data.toLowerCase().contains("h264rint" + (streamNumber > 1 ? "_" + streamNumber : "") + (channel > 1 ? "_ch" + channel : "") + ",\"" + iFrameDistance + "\"");
    }

    protected static boolean isBitrateSet(String configuration, int bitrate, int streamNumber, int sourceNumber) {
        if (configuration == null) {
            return false;
        }
        String source = sourceNumber > 1 ? "_cam" + sourceNumber : "";
        boolean result = configuration.toLowerCase().contains("ibitrate_h264" + (streamNumber > 1 ? "_" + streamNumber : "") + source + "=" + bitrate);
        return result |= configuration.toLowerCase().contains("ibitrate=" + bitrate);
    }

    private void setCodec(Codec videoCodec, int streamNumber) {
        StringBuilder url = new StringBuilder("/cgi-bin/setdata?ENCODE_TYPE");
        if (streamNumber > 1) {
            url.append("_").append(streamNumber);
        }
        url.append("=").append(videoCodec == Codec.H264 ? "1" : "2");
        url.append(this.videoSourceNumber);
        try {
            this.panasonic2Device.getHttpHandler().readGetRequest(url.toString());
        }
        catch (SeeTecException ex) {
            this.logger.warn("Exception while trying to set codec for " + this + ": " + ex.getMessage(), (Throwable)ex);
            this.logger.warn("Trying to start stream anyway...");
        }
    }

    protected String createFramerateUrl(String codec, String fpsRate, int streamNumber, String videoSourceNr, String uid) {
        if (codec == null || codec.isEmpty() || fpsRate == null || fpsRate.isEmpty() || uid == null || uid.isEmpty() || videoSourceNr == null) {
            return "";
        }
        StringBuilder url = new StringBuilder("/cgi-bin/set_").append(codec);
        if (streamNumber > 1) {
            url.append("_").append(streamNumber);
        }
        url.append("?nr_framerate=").append(fpsRate);
        url.append(videoSourceNr);
        url.append("&UID=").append(uid);
        return url.toString();
    }
}

