/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic2.jpeg;

import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2CameraSrv;
import de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2Device;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.shared.EntityType;
import de.seetec.v5.shared.net.HttpHandlerImpl;
import de.seetec.v5.shared.net.HttpHandlerIntf;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class Panasonic2JPEGVideoSourceClient
extends JPEGVideoSourceClient
implements EntityType,
HttpHandlerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.panasonic2.jpeg.Panasonic2JPEGVideoSourceClient";
    private HttpHandlerImpl httpHandlerImpl;
    private int UID = 0;
    private float framerate;
    private String fpsRate;
    private Panasonic2Device panasonic2Device;
    private String videoSourceNumber = "";

    @Override
    public int init() {
        String data = "";
        String capabilityUrl = "/cgi-bin/get_capability";
        String capabilities = "";
        this.fpsRate = "";
        int errorCode = super.init(false);
        if (errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + errorCode + " for " + this);
            return errorCode;
        }
        if (this.videoSourceNr > 1) {
            this.videoSourceNumber = "&ch=" + this.videoSourceNr;
        }
        try {
            String dataUrl = "/cgi-bin/getdata";
            if (this.panasonic2Device != null) {
                data = this.panasonic2Device.getHttpHandler().readGetRequest(dataUrl);
                capabilities = this.panasonic2Device.getHttpHandler().readGetRequest(capabilityUrl);
            }
        }
        catch (SeeTecException ex) {
            this.logger.warn("Could not read configuration from " + this + " : " + ex.getMessage() + " trying to start stream anyway...");
        }
        try {
            this.compression = (this.compression + 999) / 1000;
            Panasonic2CameraSrv panasonic2CameraSrv = (Panasonic2CameraSrv)this.getVideoSrv();
            panasonic2CameraSrv.setVideoSourceParameters(data, capabilities, this.useDateTime, this.useTitle, this.title, this.rotationAngle, this.videoSourceNr);
            this.framerate = (float)this.highestFramerate / 1000.0f;
            float[] allowedValues = new float[]{0.1f, 0.2f, 0.33f, 0.5f, 1.0f, 2.0f, 3.0f, 5.0f, 7.5f, 10.0f, 15.0f, 30.0f};
            this.fpsRate = "" + Tools.convertToCameraValues(allowedValues, this.framerate);
            this.fpsRate = this.fpsRate.replace(".0", "");
            StringBuilder url = new StringBuilder("/cgi-bin/set_jpeg?jpeg_quality=");
            this.compression /= 10;
            this.compression = this.compression > 9 ? 9 : this.compression;
            url.append(this.compression);
            url.append(this.videoSourceNumber);
            try {
                this.getPanasonic2Device().getHttpHandler().readGetRequest(url.toString());
            }
            catch (SeeTecException see) {
                this.logger.error((Object)see, (Throwable)see);
                return see.getErrorCode();
            }
            catch (Exception e) {
                this.logger.error((Object)e, (Throwable)e);
                return -21601;
            }
            try {
                url = new StringBuilder("/cgi-bin/setdata?LIVESIZE=" + this.resolution[0]);
                url.append(this.videoSourceNumber);
                this.getPanasonic2Device().getHttpHandler().readGetRequest(url.toString());
            }
            catch (SeeTecException see) {
                this.logger.error((Object)see, (Throwable)see);
                return see.getErrorCode();
            }
            catch (Exception e) {
                this.logger.error((Object)e, (Throwable)e);
                return -21601;
            }
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
            return errorCode;
        }
        catch (ConfigurationException | SeeTecException ex) {
            this.logger.error((Object)ex, ex);
            return -21651;
        }
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            this.UID = ((Panasonic2Device)this.getVideoSrv().getDevice()).createUID();
            if (this.UID < 0) {
                this.logger.error("Error retrieving UID for " + this);
                this.UID = 0;
            }
            String url = "/cgi-bin/jpeg?connect=start&UID=" + this.UID + "&framerate=" + this.fpsRate + "&resolution=" + this.width + this.videoSourceNumber;
            this.networkParameter.setSoTimeout(5000);
            this.httpHandlerImpl = new HttpHandlerImpl(this.networkParameter);
            this.httpHandlerImpl.readServerPushRequest(url, (HttpHandlerIntf)this);
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            this.listener.sendStatusService(-21656);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    public void sendStatusService(int statusCode) {
        this.listener.sendStatusService(statusCode);
    }

    public void setDevice(Panasonic2Device device) {
        this.panasonic2Device = device;
    }

    @Override
    public int shutdown() {
        if (this.httpHandlerImpl != null) {
            this.httpHandlerImpl.shutdown();
            this.httpHandlerImpl = null;
        }
        return super.shutdown();
    }

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    private Panasonic2Device getPanasonic2Device() {
        return this.panasonic2Device;
    }
}

