/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic2;

import de.seetec.v5.re.cm.device.shared.MotionRecording;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerCnf;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerHandler;
import de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2Device;
import de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2Events;
import de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2Helper;
import de.seetec.v5.shared.net.HttpHandlerImpl;
import de.seetec.v5.shared.net.HttpHandlerIntf;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.List;
import java.util.concurrent.Semaphore;

class Panasonic2TriggerHandler
extends GenericEventTriggerHandler
implements HttpHandlerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2TriggerHandler";
    private HttpHandlerImpl httpHandler = null;
    private NetworkParameter networkParameter = null;
    private final Semaphore semaphore = new Semaphore(1);
    private boolean httpServerPushIsRunning = false;
    private boolean genericEventsSupported;

    @Override
    public final void run() {
        this.initializeServerPush();
    }

    public Panasonic2TriggerHandler(MotionRecording motionRecording) {
        super(motionRecording);
    }

    public void deliverContent(byte[] httpServerPushContent) {
        String data = new String(httpServerPushContent);
        try {
            List triggerEvents = this.genericEventTriggerCnfs;
            for (GenericEventTriggerCnf event : triggerEvents) {
                if (event == null || !event.isEnabled()) continue;
                if (this.genericEventsSupported) {
                    String[] dataLines;
                    for (String dataLine : dataLines = data.split("\r\n")) {
                        if (!dataLine.contains("=")) continue;
                        String channel = "";
                        String trigger = dataLine.substring(0, dataLine.indexOf(61));
                        String triggerName = Panasonic2Events.getEventName(trigger, channel);
                        if (event.getSourceNumber() > 1) {
                            channel = "_ch" + event.getSourceNumber();
                            triggerName = Panasonic2Events.getEventName(trigger, channel);
                        }
                        if (!event.getGenericEventTriggerType().toLowerCase().equals(triggerName.toLowerCase()) || !dataLine.toLowerCase().contains("true")) continue;
                        this.forwardTrigger(event);
                    }
                    continue;
                }
                if (!event.getGenericEventTriggerType().equals("vmd") || !data.toLowerCase().contains("motiondetect=true")) continue;
                this.forwardTrigger(event);
            }
        }
        catch (Exception ex) {
            this.logger.warn("Exception while reading trigger data for " + this + " : " + ex.getMessage());
        }
    }

    public void sendStatusService(int statusCode) {
        if (this.isShutdown()) {
            return;
        }
        if (statusCode != 0) {
            this.reinitialize();
        }
    }

    private void reinitialize() {
        if (this.isShutdown()) {
            return;
        }
        if (!this.semaphore.tryAcquire()) {
            this.logger.info("Cannot aquire [semaphore] for " + this);
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Panasonic2TriggerHandler.this.semaphore.release();
                if (Panasonic2TriggerHandler.this.httpHandler.isShutdown() || !Panasonic2TriggerHandler.this.httpServerPushIsRunning) {
                    Panasonic2TriggerHandler.this.initializeServerPush();
                }
            }
        }, "PanasonicTriggerReinitialize@" + this.hashCode()).start();
    }

    protected void setVideoSourceNumber(int serverEntryNo) throws SeeTecException {
        if (serverEntryNo <= 0) {
            throw new SeeTecException(-21601, "Video Source number " + serverEntryNo + " invalid.");
        }
    }

    private void initializeServerPush() {
        this.httpServerPushIsRunning = true;
        try {
            String capabilities = ((Panasonic2Device)this.device).getHttpHandler().readGetRequest("/cgi-bin/get_capability?");
            int[] formats = Panasonic2Helper.getValuesAsInt(capabilities, "video_server.alarm.get_io2.format");
            int format = 2;
            if (formats.length == 3 && formats[2] == 3) {
                this.genericEventsSupported = true;
                format = 3;
            }
            String url = "/cgi-bin/get_io2?mode=monitor&format=" + format + "&interval=1&vmdarea=on";
            this.networkParameter = this.device.getDeviceCnf().getNetworkParameter();
            this.networkParameter.setSoTimeout(10000);
            this.httpHandler = new HttpHandlerImpl(this.networkParameter);
            this.httpHandler.readServerPushRequest(url, (HttpHandlerIntf)this);
        }
        catch (Throwable ex) {
            this.httpServerPushIsRunning = false;
            this.logger.error((Object)ex, ex);
            this.reinitialize();
        }
    }

    @Override
    public int shutdown() {
        if (this.httpHandler != null) {
            this.httpHandler.shutdown();
        }
        return super.shutdown();
    }
}

