/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic2;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2Device;
import de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2Helper;
import de.seetec.v5.shared.EntityType;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.HashMap;
import org.apache.logging.log4j.Logger;

public class Panasonic2IOHandler
extends IOHandler
implements EntityType {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2IOHandler";
    private Panasonic2Device panasonic2Device;
    private final HashMap<Integer, Integer> inputMapping = new HashMap();

    @Override
    public int init(Core core, Device device, Entity[] srvEnities) {
        try {
            String capabilities = this.getPanasonic2Device().getHttpHandler().readGetRequest("/cgi-bin/get_capability?");
            String setup = this.getPanasonic2Device().getHttpHandler().readGetRequest("/cgi-bin/setdata");
            int ports = Panasonic2Helper.getFirstValueAsInt(capabilities, "video_server.peripheral.io.number");
            if (ports > 0) {
                int inputCounter = 1;
                for (int i = 0; i < ports; ++i) {
                    String parameter = "atrmin" + (i > 0 ? Integer.valueOf(i + 1) : "");
                    String setValue = Panasonic2Helper.readConfiguredValue(setup, parameter);
                    if (!setValue.equals("1")) continue;
                    this.inputMapping.put(inputCounter, i + 1);
                    ++inputCounter;
                }
            }
        }
        catch (SeeTecException ex) {
            this.logger.warn("Exception while starting IO Handler for " + this + " : " + ex.getMessage());
            if (ex.getErrorCode() != -21657) {
                return ex.getErrorCode();
            }
            this.logger.error("Unauthorized acces for " + this);
        }
        catch (Exception ex) {
            this.logger.warn("Exception while mapping IOs to physical IOs on device for " + this + " : " + ex.getMessage());
            return -21601;
        }
        return super.init(core, device, srvEnities);
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            while (!(this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device.isShutdown())) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.checkDigitalInputs();
            }
        }
        catch (Throwable ex) {
            this.getLogger().error((Object)ex, ex);
        }
        this.getLogger().info("Thread of this " + this + " finished :-)");
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    private void checkDigitalInputs() throws SeeTecException {
        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
        String digitalInput = this.getPanasonic2Device().getHttpHandler().readGetRequest("/cgi-bin/get_io?command=all");
        for (DigitalInputSrv iService : iServices) {
            int inputNumber = iService.getInputNumber();
            Integer inputNumberOnDevice = this.inputMapping.get(inputNumber);
            if (inputNumberOnDevice == null) continue;
            if (digitalInput.toLowerCase().contains("terminal " + inputNumberOnDevice + ": high")) {
                iService.checkInput(0);
                continue;
            }
            iService.checkInput(1);
        }
    }

    @Override
    public DigitalOutputSrv getDigitalOutputSrv(int outputNumber) {
        return super.getDigitalOutputSrv(outputNumber);
    }

    @Override
    public int writeDigitalOutput(int outputNumber, int value, long holdTime) {
        DigitalOutputSrv service = this.getDigitalOutputSrv(outputNumber);
        if (service == null) {
            this.getLogger().error(this + " has no digital output service configured for [" + outputNumber + "]");
            return -21601;
        }
        if (value < 0) {
            this.getLogger().error("Value [" + value + "] is not valid for " + this);
            return -21601;
        }
        try {
            IOHandler.HoldTimer holdTimer;
            int errorCode;
            String url = value != 0 ? "/cgi-bin/pioctrl?almtrm=nc" : "/cgi-bin/pioctrl?almtrm=no";
            this.getPanasonic2Device().getHttpHandler().readGetRequest(url);
            if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(outputNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                holdTimer.shutdown();
                this.getLogger().warn("Creating " + holdTimer + " failed with error [" + errorCode + "]");
            }
        }
        catch (Throwable ex) {
            this.getLogger().warn((Object)ex, ex);
            this.getLogger().warn("Problems setting output [" + outputNumber + "] of " + this);
        }
        return 0;
    }

    public Panasonic2Device getPanasonic2Device() {
        return this.panasonic2Device;
    }

    void setDevice(Panasonic2Device panasonic2Device) {
        this.panasonic2Device = panasonic2Device;
    }

    public Logger getLogger() {
        return this.logger;
    }
}

