/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic.mpeg.http;

import de.seetec.v5.shared.SSLConstantsIntf;
import java.util.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Packet
implements SSLConstantsIntf {
    protected Logger logger = null;
    protected String data = null;
    protected int errorCode = Integer.MIN_VALUE;

    public Packet() {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    public Packet(int code) {
        this.errorCode = code;
    }

    public byte[] serialize() {
        if (this.data != null) {
            this.data = this.data + "\r\n";
            byte[] body = this.data.getBytes();
            return body;
        }
        return null;
    }

    public Packet deserialize(byte[] data) {
        if (data != null) {
            String[] headerAndBody = new String(data).split("\r\n\r\n");
            this.deserializeHeader(headerAndBody[0]);
            if (headerAndBody.length >= 2) {
                this.deserializeBody(headerAndBody[1].getBytes());
            }
            return this;
        }
        return new Packet(-21601);
    }

    protected void deserializeHeader(String data) {
        if (data != null) {
            String[] lines = data.split("\r\n");
            if (lines.length >= 1) {
                String[] firstLineSplit = lines[0].split(" ");
                if (firstLineSplit.length >= 3) {
                    try {
                        this.errorCode = Integer.parseInt(firstLineSplit[1]);
                    }
                    catch (NumberFormatException e) {
                        this.logger.error("Error when converting ErrorCode '" + firstLineSplit[1] + "' to number.");
                    }
                } else {
                    this.logger.warn("Non-conform first line of response.");
                    this.logger.warn("Splitted line: " + lines[0]);
                    this.logger.warn("Received data: " + data);
                }
            } else {
                this.logger.warn("The reponse header has 0 lines.");
            }
        }
    }

    protected void deserializeBody(byte[] data) {
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String addBasicAuthentication(String passphrase) {
        if (passphrase != null) {
            return "Authorization: Basic " + Base64.getEncoder().encodeToString(passphrase.getBytes()) + "\r\n";
        }
        return "";
    }
}

