/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic.mpeg;

import de.seetec.v5.re.cm.device.shared.net.NetworkCallback;
import de.seetec.v5.re.cm.device.shared.net.udp.UdpReaderUnicast;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClient;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.panasonic.mpeg.HTTPHandler;
import de.seetec.v5.re.cm.device.video.panasonic.mpeg.http.AudioSetReq;
import de.seetec.v5.re.cm.device.video.panasonic.mpeg.http.GetUIDReq;
import de.seetec.v5.re.cm.device.video.panasonic.mpeg.http.KeepAliveReq;
import de.seetec.v5.re.cm.device.video.panasonic.mpeg.http.MPEGSetReq;
import de.seetec.v5.re.cm.device.video.panasonic.mpeg.http.Packet;
import de.seetec.v5.re.cm.device.video.panasonic.mpeg.http.StartReq;
import de.seetec.v5.re.cm.device.video.panasonic.mpeg.http.StopReq;
import de.seetec.v5.shared.net.HTTPStatusCode;
import java.io.ByteArrayOutputStream;

public class PanasonicMPEGVideoSourceClient_Nx
extends StreamingVideoSourceClientRTSP
implements NetworkCallback,
Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.panasonic.mpeg.PanasonicMPEGVideoSourceClient";
    private static final String MPEG_MODE = "mpeg4";
    private static final String AUDIO_MODE = "audio";
    private Thread myThread = null;
    private long UID = Long.MIN_VALUE;
    private UdpReaderUnicast udpReader = null;
    private UdpReaderUnicast udpReaderAudio = null;
    private String passphrase = null;
    private String audioEnabledValue = null;
    private String qualityString = null;

    @Override
    public int init() {
        this.completeFrame = new ByteArrayOutputStream();
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        this.passphrase = this.networkParameter.getUserPWD() == null || this.networkParameter.getUserPWD().length != 2 ? ":" : this.networkParameter.getUserPWD()[0] + ":" + this.networkParameter.getUserPWD()[1];
        this.bandwidth /= 1024;
        int[] allowedValues = new int[]{0, 64, 128, 256, 512, 1024, 1536, 2048, 3072, 4096};
        if (this.bandwidth == 0) {
            this.bandwidth = allowedValues[allowedValues.length - 1];
        } else {
            for (int i = 0; i < allowedValues.length; ++i) {
                int n;
                if (allowedValues[i] > this.bandwidth) {
                    int middle = (allowedValues[i] + allowedValues[i - 1]) / 2;
                    this.bandwidth = this.bandwidth > middle ? allowedValues[i] : allowedValues[i - 1];
                    break;
                }
                if (i == allowedValues.length - 1) {
                    n = allowedValues[allowedValues.length - 1];
                    this.bandwidth = this.bandwidth;
                } else {
                    n = this.bandwidth;
                }
                this.bandwidth = n;
            }
        }
        this.iFrameDist /= 1000L;
        this.iFrameDist = this.iFrameDist > 5L ? 5L : this.iFrameDist;
        this.quality = 100000 - this.quality;
        this.quality /= 1000;
        this.qualityString = this.quality <= 33 ? "fine" : (this.quality > 33 && this.quality <= 66 ? "normal" : "low");
        if (this.isAudioEnabled) {
            try {
                this.audioEnabledValue = this.getVideoSrv().getDevice().getDeviceType() == 200515L || this.getVideoSrv().getDevice().getDeviceType() == 200517L || this.getVideoSrv().getDevice().getDeviceType() == 200523L ? "in" : "1";
                this.logger.info("Audio Parameter: " + this.audioBitrate + " bit. EnableValue: " + this.audioEnabledValue);
            }
            catch (Exception e) {
                this.logger.error("Reading audio configuration from " + this.getVideoSrv().getDevice() + " failed", (Throwable)e);
                return -21601;
            }
        }
        this.logger.info("Requested resolution: " + this.width + "x" + this.height + " (Bandwidth: " + this.bandwidth + ") for " + this.getVideoSrv());
        this.udpReader = new UdpReaderUnicast(this);
        this.udpReader.init(524288, 5000, true, true);
        this.logger.info("UDP port is " + this.udpReader.getPort() + " for " + this.getVideoSrv());
        if (this.isAudioEnabled) {
            this.logger.info("Audio enabled for " + this.getVideoSrv());
            this.setLegacyAudioSourceClient(new StreamingVideoSourceClient.LegacyAudioSourceClient(this));
            this.udpReaderAudio = new UdpReaderUnicast(this.getLegacyAudioSourceClient());
            this.udpReaderAudio.init(524288, 5000, true, true);
            this.logger.info("UDP audio port '" + this.udpReaderAudio.getPort() + "' opened for " + this.getVideoSrv());
            AudioSetReq audioSetReq = new AudioSetReq();
            audioSetReq.init(this.audioEnabledValue, this.audioBitrate / 1000, this.passphrase);
            audioSetReq = (AudioSetReq)this.sendHTTPDataPacket(audioSetReq);
            if (audioSetReq.getErrorCode() != HTTPStatusCode.HTTP_OK.getStatusCode()) {
                this.logger.info("Error while setting up audio parameters: " + audioSetReq.getErrorCode() + " for " + this.getVideoSrv());
                if (audioSetReq.getErrorCode() == HTTPStatusCode.HTTP_UNAUTHORIZED.getStatusCode()) {
                    return -21657;
                }
                return -21654;
            }
        }
        MPEGSetReq mpegSetReq = new MPEGSetReq();
        mpegSetReq.init(this.bandwidth, this.width, this.qualityString, this.iFrameDist, this.passphrase, this.videoSourceNr);
        mpegSetReq = (MPEGSetReq)this.sendHTTPDataPacket(mpegSetReq);
        if (mpegSetReq.getErrorCode() != HTTPStatusCode.HTTP_OK.getStatusCode()) {
            this.logger.info("Error while setting up stream: " + mpegSetReq.getErrorCode() + " for " + this.getVideoSrv());
            if (mpegSetReq.getErrorCode() == HTTPStatusCode.HTTP_UNAUTHORIZED.getStatusCode()) {
                return -21657;
            }
            return -21654;
        }
        GetUIDReq getuidReq = new GetUIDReq();
        getuidReq.init(this.passphrase, this.videoSourceNr);
        getuidReq = (GetUIDReq)this.sendHTTPDataPacket(getuidReq);
        if (getuidReq.getErrorCode() != HTTPStatusCode.HTTP_OK.getStatusCode()) {
            this.logger.info("Error while requesting UID: " + mpegSetReq.getErrorCode() + " for " + this.getVideoSrv());
            return -21654;
        }
        this.UID = getuidReq.getUID();
        StartReq startReq = new StartReq();
        startReq.init(MPEG_MODE, this.udpReader.getPort(), getuidReq.getUID(), this.passphrase, this.videoSourceNr);
        startReq = (StartReq)this.sendHTTPDataPacket(startReq);
        if (startReq.getErrorCode() != HTTPStatusCode.HTTP_NO_CONTENT.getStatusCode() && startReq.getErrorCode() != HTTPStatusCode.HTTP_OK.getStatusCode()) {
            this.logger.info("Error while starting stream: " + startReq.getErrorCode() + " for " + this.getVideoSrv());
            return -21654;
        }
        if (this.isAudioEnabled) {
            StartReq startAudioReq = new StartReq();
            if (this.getVideoSrv().getDevice().getDeviceType() == 200523L || this.getVideoSrv().getDevice().getDeviceType() == 200524L || this.getVideoSrv().getDevice().getDeviceType() == 200525L || this.getVideoSrv().getDevice().getDeviceType() == 200515L) {
                startAudioReq.init(AUDIO_MODE, this.udpReaderAudio.getPort(), getuidReq.getUID(), this.passphrase, this.videoSourceNr, "&mode=in");
            } else {
                startAudioReq.init(AUDIO_MODE, this.udpReaderAudio.getPort(), getuidReq.getUID(), this.passphrase, this.videoSourceNr);
            }
            startAudioReq = (StartReq)this.sendHTTPDataPacket(startAudioReq);
            if (startAudioReq.getErrorCode() != HTTPStatusCode.HTTP_NO_CONTENT.getStatusCode() && startAudioReq.getErrorCode() != HTTPStatusCode.HTTP_OK.getStatusCode()) {
                this.logger.info("Error while starting audio stream: " + startAudioReq.getErrorCode() + " for " + this.getVideoSrv());
                return -21654;
            }
        }
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
        this.logger.info("Init done for " + this.getVideoSrv());
        return 0;
    }

    @Override
    public void run() {
        long time = System.currentTimeMillis();
        while (!this.isShutdown()) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                this.logger.fatal("Error while sleep. " + e.getMessage());
            }
            if (System.currentTimeMillis() <= time + 30000L) continue;
            time = System.currentTimeMillis();
            KeepAliveReq keepAliveReq = new KeepAliveReq();
            keepAliveReq.init(MPEG_MODE, this.UID, this.passphrase, this.videoSourceNr);
            keepAliveReq = (KeepAliveReq)this.sendHTTPDataPacket(keepAliveReq);
            if (keepAliveReq.getErrorCode() != HTTPStatusCode.HTTP_NO_CONTENT.getStatusCode()) {
                this.logger.info("Received errorCode: " + keepAliveReq.getErrorCode() + " when doing keep-alive for " + this.getVideoSrv());
            }
            if (!this.isAudioEnabled) continue;
            KeepAliveReq keepAliveAudioReq = new KeepAliveReq();
            keepAliveAudioReq.init(AUDIO_MODE, this.UID, this.passphrase, this.videoSourceNr);
            if ((keepAliveAudioReq = (KeepAliveReq)this.sendHTTPDataPacket(keepAliveAudioReq)).getErrorCode() == HTTPStatusCode.HTTP_NO_CONTENT.getStatusCode()) continue;
            this.logger.info("Received errorCode: " + keepAliveAudioReq.getErrorCode() + " when doing keep-alive (audi) for " + this.getVideoSrv());
        }
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.UID != Long.MIN_VALUE) {
            StopReq stopReq = new StopReq();
            stopReq.init(MPEG_MODE, this.udpReader.getPort(), this.UID, this.passphrase, this.videoSourceNr);
            Packet response = this.sendHTTPDataPacket(stopReq);
            if (response.getErrorCode() == HTTPStatusCode.HTTP_NO_CONTENT.getStatusCode()) {
                this.logger.info("Received errorCode: " + response.getErrorCode());
            }
            if (this.isAudioEnabled) {
                StopReq stopAudioReq = new StopReq();
                stopAudioReq.init(AUDIO_MODE, this.udpReaderAudio.getPort(), this.UID, this.passphrase, this.videoSourceNr);
                response = this.sendHTTPDataPacket(stopAudioReq);
                if (response.getErrorCode() == HTTPStatusCode.HTTP_NO_CONTENT.getStatusCode()) {
                    this.logger.info("Received errorCode: " + response.getErrorCode());
                }
            }
        }
        if (this.udpReaderAudio != null) {
            this.udpReaderAudio.shutdown();
        }
        this.udpReaderAudio = null;
        if (this.udpReader != null) {
            this.udpReader.shutdown();
        }
        this.udpReader = null;
        super.shutdown();
        this.passphrase = null;
        this.completeFrame = null;
        return 0;
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error + " for " + this.getVideoSrv());
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    private Packet sendHTTPDataPacket(Packet p) {
        Packet response = null;
        HTTPHandler httpHandler = new HTTPHandler();
        this.errorCode = httpHandler.init(this.getHost(), this.getPort());
        if (this.errorCode != 0) {
            this.logger.error("httpHandler.init failed with errorCode: " + this.errorCode);
            return new Packet(this.errorCode);
        }
        response = httpHandler.send(p);
        if (response != null) {
            httpHandler.shutdown();
            return response;
        }
        this.logger.warn("response is null");
        this.listener.sendStatusService(-21656);
        httpHandler.shutdown();
        this.shutdown();
        return new Packet(-21656);
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public void sendStatusService(int errorCode) {
    }

    @Override
    public void onUdpData(byte[] data) {
        this.processData(data);
    }
}

