/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic.mpeg;

import de.seetec.v5.re.cm.device.shared.net.NetworkCallback;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;

public class PanasonicMPEGVideoSourceClient_Hx
extends StreamingVideoSourceClientRTSP
implements NetworkCallback {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.panasonic.mpeg.PanasonicMPEGVideoSourceClient_Hx";
    private int rtspPort = 554;
    private StringBuffer videoParameterURL = null;
    private String audioParameterURL = null;

    @Override
    public int init() {
        this.completeFrame = new ByteArrayOutputStream();
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        long entityType = this.getVideoSrv().getEntityType();
        if (entityType == 210639L || entityType == 210637L) {
            try {
                byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/Get?Func=VDelivery&Kind=1", (int)Integer.MAX_VALUE);
                if (result == null) {
                    this.logger.error("Error while resetting video settings for " + this.getVideoSrv());
                    return -21601;
                }
                String resultAsString = new String(result);
                if (!resultAsString.contains("Format:MPEG-4") && NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/Set?Func=VDelivery&Kind=1&Format=MPEG-4", (int)Integer.MAX_VALUE) == null) {
                    this.logger.error("Error while resetting video settings for " + this.getVideoSrv());
                    return -21601;
                }
            }
            catch (SeeTecException e) {
                this.logger.error("Exception while setting video settings for " + this.getVideoSrv());
                this.logger.error((Object)e, (Throwable)e);
                return e.getErrorCode();
            }
        }
        this.bandwidth /= 1024;
        int[] allowedValues = new int[]{0, 32, 64, 128, 192, 256, 384, 512, 768, 1024, 1536, 2048};
        if (this.bandwidth == 0) {
            this.bandwidth = allowedValues[allowedValues.length - 1];
        } else {
            for (int i = 0; i < allowedValues.length; ++i) {
                int n;
                if (allowedValues[i] > this.bandwidth) {
                    int middle = (allowedValues[i] + allowedValues[i - 1]) / 2;
                    this.bandwidth = this.bandwidth > middle ? allowedValues[i] : allowedValues[i - 1];
                    break;
                }
                if (i == allowedValues.length - 1) {
                    n = allowedValues[allowedValues.length - 1];
                    this.bandwidth = this.bandwidth;
                } else {
                    n = this.bandwidth;
                }
                this.bandwidth = n;
            }
        }
        this.fps /= 1000L;
        this.videoParameterURL = new StringBuffer("/Set?Func=VDelivery&Kind=1&");
        this.videoParameterURL.append(this.width);
        this.videoParameterURL.append("framerate=");
        this.videoParameterURL.append(this.fps);
        this.videoParameterURL.append("&");
        this.videoParameterURL.append(this.width);
        this.videoParameterURL.append("bitrateL=");
        this.videoParameterURL.append(this.bandwidth);
        this.videoParameterURL.append("&");
        this.videoParameterURL.append(this.width);
        this.videoParameterURL.append("bitrateH=");
        this.videoParameterURL.append(this.bandwidth);
        try {
            if (this.listener.getVideoSourceParameter().getRtspPort() > 0) {
                if (this.listener.getVideoSourceParameter().getRtspPort() != 554 && this.listener.getVideoSourceParameter().getRtspPort() < 1024) {
                    this.logger.error("Invalid customized RTSP port: " + this.listener.getVideoSourceParameter().getRtspPort() + ". Valid values 554,1024..65535");
                    return -21601;
                }
                this.rtspPort = this.listener.getVideoSourceParameter().getRtspPort();
                this.logger.info("Using RTSP port: " + this.rtspPort);
                this.videoParameterURL.append("&RTSPPortNo=");
                this.videoParameterURL.append(this.listener.getVideoSourceParameter().getRtspPort());
            }
        }
        catch (ConfigurationException ex) {
            this.logger.warn("RTSP port could not be read", (Throwable)ex);
        }
        try {
            if (NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)this.videoParameterURL.toString(), (int)Integer.MAX_VALUE) == null) {
                this.logger.error("Error while resetting video settings for " + this.getVideoSrv());
                return -21601;
            }
        }
        catch (SeeTecException e) {
            this.logger.error("Exception while setting video settings for " + this.getVideoSrv(), (Throwable)e);
            return e.getErrorCode();
        }
        this.logger.info("Requested resolution: " + this.width + "x" + this.height + " (Bandwidth: " + this.bandwidth + ") at " + this.fps + "fps for " + this.getVideoSrv());
        this.rtspUrl = "rtsp://" + this.getHost() + "/nphMpeg4/";
        if (this.isAudioEnabled) {
            try {
                if (this.audioCodec != Codec.G726) {
                    this.logger.error("Unknown audio encoding type: " + this.audioCodec + " for " + this.getVideoSrv().getDevice());
                    return -21601;
                }
                this.rtspUrl = this.rtspUrl + "g726-";
                this.audioParameterURL = "/Set?Func=AudioSetup&Kind=1&InputEnable=1";
            }
            catch (Exception e) {
                this.logger.error("Reading audio configuration from " + this.getVideoSrv().getDevice() + " failed :-(", (Throwable)e);
                return -21601;
            }
        } else {
            this.rtspUrl = this.rtspUrl + "nil-";
            this.audioParameterURL = "/Set?Func=AudioSetup&Kind=1&InputEnable=0";
        }
        this.logger.info("audioParameterURL: " + this.audioParameterURL);
        try {
            if (NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)this.audioParameterURL, (int)Integer.MAX_VALUE) == null) {
                this.logger.error("Error while resetting audio settings for " + this.getVideoSrv());
                return -21601;
            }
        }
        catch (SeeTecException e) {
            this.logger.error("Exception while setting audio settings for " + this.getVideoSrv(), (Throwable)e);
            return e.getErrorCode();
        }
        this.rtspUrl = this.rtspUrl + this.width + "x" + this.height;
        this.rtspSettings = new RTSPStreamSettings();
        this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.rtspPort, this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 4, this.rtspUrl);
        if (this.errorCode != 0) {
            this.logger.error("Initialization of RTSPSettings failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
            return this.errorCode;
        }
        try {
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while initializing RTSP-Handler for " + this);
            return ex.getErrorCode();
        }
        this.errorCode = this.rtspHandler.start();
        if (this.errorCode != 0) {
            this.logger.error("RTSPHandler.init failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
            return this.errorCode;
        }
        this.logger.info("Init done for " + this.getVideoSrv());
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        super.shutdown();
        this.completeFrame = null;
        return 0;
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error + " for " + this.getVideoSrv());
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public synchronized void onUdpData(byte[] data) {
        this.processData(data);
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void sendStatusService(int statusCode) {
        if (statusCode != 0) {
            this.onNetworkError(statusCode);
        }
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }
}

