/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic.mpeg;

import de.seetec.v5.re.cm.device.shared.net.HttpChunkReader;
import de.seetec.v5.re.cm.device.shared.net.NetworkCallback;
import de.seetec.v5.re.cm.device.shared.net.RTPoverHTTPCallback;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelper;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelperH264;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClient;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class PanasonicH264VideoSourceClient_BB
extends StreamingVideoSourceClient
implements NetworkCallback,
RTPoverHTTPCallback {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.panasonic.mpeg.PanasonicH264VideoSourceClient_BB";
    private byte[] parameterSet = null;
    private StringBuffer videoParameterURL = null;
    private byte[] parameterSetPart = null;
    private byte[] pictureSet = null;
    private HttpChunkReader rtpOverHTTPHandlerVideo;
    private ByteArrayOutputStream baos = null;
    private TransmissionType transmissionId = TransmissionType.UNKNOWN;

    @Override
    public int init() {
        this.completeFrame = new ByteArrayOutputStream();
        this.baos = new ByteArrayOutputStream();
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        try {
            this.transmissionId = this.listener.getVideoSourceParameter().getTransmissionID();
        }
        catch (ConfigurationException ex) {
            this.logger.error("Exception while getting streaming configuration for " + this + ": " + ex.getMessage());
        }
        try {
            byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/Get?Func=VDelivery&Kind=1", (int)Integer.MAX_VALUE);
            if (result == null) {
                this.logger.error("Error while resetting video settings for " + this.getVideoSrv());
                return -21601;
            }
            String resultAsString = new String(result);
            if (!resultAsString.contains("Format:H.264") && NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/Set?Func=VDelivery&Kind=1&Format=H.264", (int)Integer.MAX_VALUE) == null) {
                this.logger.error("Error while resetting video settings for " + this.getVideoSrv());
                return -21601;
            }
        }
        catch (SeeTecException e) {
            this.logger.error("Exception while setting video settings for " + this.getVideoSrv());
            this.logger.error((Object)e, (Throwable)e);
            return e.getErrorCode();
        }
        this.bandwidth /= 1024;
        int[] allowedValues = new int[]{0, 32, 64, 128, 192, 256, 384, 512, 768, 1024, 1536, 2048};
        if (this.bandwidth == 0) {
            this.bandwidth = allowedValues[allowedValues.length - 3];
        } else {
            int startBitrateIndex = 0;
            int endBitrateIndex = 0;
            if (this.width == 640) {
                startBitrateIndex = 7;
                endBitrateIndex = allowedValues.length - 1;
            } else if (this.width == 320) {
                startBitrateIndex = 2;
                endBitrateIndex = allowedValues.length - 1 - 2;
            }
            int[] availableValues = new int[endBitrateIndex - startBitrateIndex];
            System.arraycopy(allowedValues, startBitrateIndex, availableValues, 0, availableValues.length);
            this.bandwidth = Tools.convertToCameraValues(availableValues, this.bandwidth);
        }
        if (this.fps < 5000L) {
            this.fps = 5000L;
        } else if (this.fps > 30000L) {
            this.fps = 30000L;
        }
        this.fps /= 1000L;
        this.videoParameterURL = new StringBuffer("/Set?Func=VDelivery&Kind=1&");
        this.videoParameterURL.append(this.width);
        this.videoParameterURL.append("x");
        this.videoParameterURL.append(this.height);
        this.videoParameterURL.append("H264framerate=");
        this.videoParameterURL.append(this.fps);
        this.videoParameterURL.append("&");
        this.videoParameterURL.append(this.width);
        this.videoParameterURL.append("H264framerate=");
        this.videoParameterURL.append(this.fps);
        this.videoParameterURL.append("&");
        this.videoParameterURL.append(this.width);
        this.videoParameterURL.append("H264bitrateL=");
        this.videoParameterURL.append(this.bandwidth);
        this.videoParameterURL.append("&");
        this.videoParameterURL.append(this.width);
        this.videoParameterURL.append("H264bitrateH=");
        this.videoParameterURL.append(this.bandwidth);
        this.videoParameterURL.append("&");
        this.videoParameterURL.append(this.width);
        this.videoParameterURL.append("x");
        this.videoParameterURL.append(this.height);
        this.videoParameterURL.append("H264bitrateL=");
        this.videoParameterURL.append(this.bandwidth);
        this.videoParameterURL.append("&");
        this.videoParameterURL.append(this.width);
        this.videoParameterURL.append("x");
        this.videoParameterURL.append(this.height);
        this.videoParameterURL.append("H264bitrateH=");
        this.videoParameterURL.append(this.bandwidth);
        this.logger.info("videoParameterURL: " + this.videoParameterURL.toString());
        try {
            if (NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)this.videoParameterURL.toString(), (int)Integer.MAX_VALUE) == null) {
                this.logger.error("Error while resetting video settings for " + this.getVideoSrv());
                return -21601;
            }
        }
        catch (SeeTecException e) {
            this.logger.error("Exception while setting video settings for " + this.getVideoSrv());
            this.logger.error((Object)e, (Throwable)e);
            return e.getErrorCode();
        }
        this.logger.info("Requested resolution: " + this.width + "x" + this.height + " (Bandwidth: " + this.bandwidth + ") at " + this.fps + "fps for " + this.getVideoSrv());
        if (this.transmissionId == TransmissionType.TTS_OVER_HTTP) {
            String streamingUrlVideo = "http://" + this.getHost() + "/nphH264AACauth?Resolution=" + this.width + "x" + this.height;
            this.rtpOverHTTPHandlerVideo = new HttpChunkReader();
            this.errorCode = this.rtpOverHTTPHandlerVideo.init(this, this.networkParameter, streamingUrlVideo);
            if (this.errorCode != 0) {
                return this.errorCode;
            }
            this.rtpOverHTTPHandlerVideo.startStreaming();
            return 0;
        }
        this.logger.error("Error while init stream for " + this.getVideoSrv());
        return -21600;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.rtpOverHTTPHandlerVideo != null) {
            this.rtpOverHTTPHandlerVideo.shutdown();
            this.rtpOverHTTPHandlerVideo = null;
        }
        super.shutdown();
        this.completeFrame = null;
        return 0;
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error + " for " + this.getVideoSrv());
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public synchronized void onUdpData(byte[] data) {
        this.processData(data);
    }

    private synchronized void processData(byte[] data) {
        if (this.isShutdown()) {
            return;
        }
        if (data == null) {
            this.logger.error("Incoming data is null for " + this.getVideoSrv());
            return;
        }
        try {
            int mediaType;
            if ((data.length < 2 || data[0] != -128 || data[1] != -56) && (mediaType = StreamingHelperH264.checkForH264MediaType(this.getVideoSrv().getDevice(), data, 0)) >= 0 && mediaType != 9) {
                if (mediaType == 33) {
                    if (this.parameterSetPart != null && this.pictureSet != null) {
                        this.parameterSet = new byte[this.parameterSetPart.length + this.pictureSet.length];
                        System.arraycopy(this.parameterSetPart, 0, this.parameterSet, 0, this.parameterSetPart.length);
                        System.arraycopy(this.pictureSet, 0, this.parameterSet, this.parameterSetPart.length, this.pictureSet.length);
                        int[] resolutionFromStream = StreamingHelperH264.extractH264Resolution(this.parameterSet, 0);
                        if (resolutionFromStream != null) {
                            this.width = resolutionFromStream[0];
                            this.height = resolutionFromStream[1];
                        }
                        try {
                            MediaFrame mediaFrame = StreamingHelper.createSeeTecVideoFrameHeader(Codec.H264, this.width, this.height, data, this.parameterSet);
                            this.deliverFrameCreateServerTimestamp(mediaType, mediaFrame);
                        }
                        catch (SeeTecException ex) {
                            this.logger.error("Exception while creating I-Frame for " + this + ": " + ex.getMessage());
                        }
                    }
                } else if (mediaType == 35) {
                    try {
                        MediaFrame mediaFrame = StreamingHelper.createSeeTecVideoFrameHeader(Codec.H264, this.width, this.height, data);
                        this.deliverFrameCreateServerTimestamp(mediaType, mediaFrame);
                    }
                    catch (SeeTecException ex) {
                        this.logger.error("Exception while creating P-Frame for " + this + ": " + ex.getMessage());
                    }
                } else if (mediaType == 7) {
                    this.parameterSetPart = new byte[data.length];
                    System.arraycopy(data, 0, this.parameterSetPart, 0, data.length);
                } else if (mediaType == 8) {
                    this.pictureSet = new byte[data.length];
                    System.arraycopy(data, 0, this.pictureSet, 0, data.length);
                }
            }
        }
        catch (Throwable t) {
            this.logger.error("Ignoring packet due to unexpected error: " + t.getMessage());
            this.logger.error((Object)t, t);
        }
    }

    @Override
    public synchronized void onHttpData(byte[] data) {
        this.baos.reset();
        try {
            int counter = 0;
            if (data.length % 192 != 0) {
                this.logger.info("Data is not a multiple of 192");
            }
            while (counter * 192 < data.length) {
                byte[] transportPacketHeader = new byte[4];
                System.arraycopy(data, 192 * counter + 4, transportPacketHeader, 0, transportPacketHeader.length);
                byte[] payload = new byte[184];
                System.arraycopy(data, 192 * counter + 8, payload, 0, payload.length);
                ++counter;
                if (transportPacketHeader[0] != 71) {
                    this.logger.info("first byte is not synch byte");
                    continue;
                }
                byte[] pidAsByteArray = new byte[]{transportPacketHeader[1], transportPacketHeader[2]};
                BigInteger pidAsBigInteger = new BigInteger(pidAsByteArray);
                String pidAsBinary = pidAsBigInteger.toString(2);
                String pidAsBinaryNew = pidAsBinary.substring(pidAsBinary.length() - 13, pidAsBinary.length());
                if (pidAsBinaryNew.startsWith("000000000") || pidAsBinaryNew.equals("1111111111111") || pidAsBinaryNew.equals("0000100000000") || (transportPacketHeader[3] & 0x30) == 32 || (transportPacketHeader[3] & 0x30) == 0) continue;
                if ((transportPacketHeader[3] & 0x30) == 48) {
                    byte[] adaptionFieldLengthAsByteArray = new byte[]{0, payload[0]};
                    int adaptionFieldLength = PanasonicH264VideoSourceClient_BB.byteArrayToInt4((byte[])adaptionFieldLengthAsByteArray);
                    this.baos.write(payload, adaptionFieldLength + 1, payload.length - adaptionFieldLength - 1);
                } else if ((transportPacketHeader[3] & 0x30) == 16) {
                    this.baos.write(payload);
                }
                int nextIndex = PanasonicH264VideoSourceClient_BB.indexOfByteArray((byte[])this.baos.toByteArray(), (byte[])StreamingHelper.START_SEQUENCE, (int)StreamingHelper.START_SEQUENCE.length, (boolean)true);
                if (counter * 192 >= data.length) {
                    nextIndex = this.baos.toByteArray().length;
                }
                if (nextIndex <= 0) continue;
                byte[] completeByteArray = this.baos.toByteArray();
                this.baos.reset();
                byte[] completeFrameAsByteArray = new byte[nextIndex];
                System.arraycopy(completeByteArray, 0, completeFrameAsByteArray, 0, completeFrameAsByteArray.length);
                this.processData(completeFrameAsByteArray);
                if (completeByteArray.length <= nextIndex) continue;
                this.baos.write(completeByteArray, nextIndex, completeByteArray.length - nextIndex);
            }
        }
        catch (IOException ex) {
            this.logger.info("Error while reading http data from " + this);
            this.logger.info((Object)ex.getStackTrace());
        }
    }

    @Override
    public void sendStatusService(int statusCode) {
        if (statusCode != 0) {
            this.onNetworkError(statusCode);
        }
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }
}

