/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic.mpeg;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videoprofile.BasicVideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.panasonic.PanasonicCameraSrv;
import de.seetec.v5.re.cm.device.video.panasonic.PanasonicDevice;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class PanasonicH264VideoSourceClientRTP
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.panasonic.mpeg.PanasonicH264VideoSourceClientRTP";
    private PanasonicDevice panasonicDevice;
    private int streamNumber = 1;
    private static final int STREAM_NOT_SET = 0;
    private static final int STREAM_1_SET = 1;
    private static final int STREAM_2_SET = 2;
    private static final int STREAM_1_2_SET = 3;
    private int maxResolutionOnSeetec;
    private PanasonicCameraSrv panasonicCameraSrv;

    private int getMaximalResolutionOnCamera() {
        long entityType = super.getVideoSrv().getEntityType();
        if (this.panasonicDevice == null) {
            this.panasonicDevice = (PanasonicDevice)this.getVideoSrv().getDevice();
        }
        if (this.panasonicDevice.isIsHDResolution()) {
            return 1920;
        }
        if (entityType == 210630L) {
            return 800;
        }
        return 1280;
    }

    private int getMaximalResolutionOnSeetec() {
        int ret = 0;
        if (this.listener.getVideoProfileHandler().getVideoProfileName().equals("Basic")) {
            try {
                String widthString;
                int standardResolution = 0;
                int alarmResolution = 0;
                String resolutionString = ((BasicVideoProfileHandler)this.listener.getVideoProfileHandler()).getVideoSourceParameter("standard").getDisplayResolution();
                int index = resolutionString.indexOf("x");
                if (index != -1) {
                    widthString = resolutionString.substring(0, index);
                    standardResolution = Integer.parseInt(widthString);
                }
                if ((index = (resolutionString = ((BasicVideoProfileHandler)this.listener.getVideoProfileHandler()).getVideoSourceParameter("alarm").getDisplayResolution()).indexOf("x")) != -1) {
                    widthString = resolutionString.substring(0, index);
                    alarmResolution = Integer.parseInt(widthString);
                }
                ret = Math.max(standardResolution, alarmResolution);
            }
            catch (ConfigurationException ex) {
                this.logger.error("Exception while reading configuration for " + this + ": " + ex.getMessage());
            }
        } else {
            ret = this.width;
        }
        return ret;
    }

    @Override
    public int init() {
        int[] allowedValues;
        float[] allowedFloatValues;
        String fpsRate;
        float[] allowedFloatValues2;
        int[] allowedValuesSP;
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        this.panasonicCameraSrv = (PanasonicCameraSrv)this.getVideoSrv();
        this.panasonicDevice = (PanasonicDevice)this.panasonicCameraSrv.getDevice();
        int streamSet = this.panasonicDevice.getH264Status();
        int maxResolution = this.getMaximalResolutionOnCamera();
        if (super.getVideoSrv().getEntityType() == 210641L || super.getVideoSrv().getEntityType() == 210640L) {
            this.maxResolutionOnSeetec = this.getMaximalResolutionOnSeetec();
        }
        if (this.panasonicCameraSrv.getNumberOfH264Streams() == 1) {
            this.streamNumber = 1;
        } else if (streamSet == 0) {
            this.streamNumber = this.maxResolutionOnSeetec == maxResolution ? 1 : 2;
        } else if (streamSet == 1) {
            if (this.maxResolutionOnSeetec == maxResolution) {
                this.logger.error("Resolution requires setting h264 stream 1, but stream 1 is already in use for " + this);
                this.shutdown();
            } else {
                this.streamNumber = 2;
            }
        } else if (streamSet == 2) {
            this.streamNumber = 1;
        } else if (streamSet == 3) {
            this.logger.error("Both h264 streams are already in use for " + this);
            this.shutdown();
        } else {
            this.logger.error("Stream configuration not readable for " + this);
            this.shutdown();
        }
        this.panasonicDevice.setH264Stream(this.streamNumber);
        this.bandwidth /= 1024;
        this.fps /= 1000L;
        if (this.isAudioEnabled) {
            try {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/set_audio?audio=in", (int)Integer.MAX_VALUE);
            }
            catch (SeeTecException seeTecException) {
                this.logger.warn("Audio could not be activated for " + this);
            }
            this.logger.info("Audio enabled. Audio Parameter: " + this.audioBitrate + " bit for " + this.getVideoSrv().getDevice());
        } else {
            try {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/set_audio?audio=off", (int)Integer.MAX_VALUE);
            }
            catch (SeeTecException seeTecException) {
                this.logger.warn("Audio could not be deactivated for " + this);
            }
        }
        if (super.getVideoSrv().getEntityType() == 210632L || super.getVideoSrv().getEntityType() == 210630L) {
            if (this.width == 800) {
                allowedValuesSP = new int[]{256, 384, 512, 768, 1024, 1536, 2048, 3072, 4096};
                this.bandwidth = Tools.convertToCameraValues(allowedValuesSP, this.bandwidth);
            } else {
                allowedValuesSP = new int[]{64, 128, 256, 384, 512, 768, 1024, 1536, 2048, 3072, 4096};
                this.bandwidth = Tools.convertToCameraValues(allowedValuesSP, this.bandwidth);
            }
            allowedFloatValues2 = new float[]{1.0f, 3.0f, 5.0f, 7.5f, 10.0f, 15.0f, 20.0f, 30.0f};
            fpsRate = "" + Tools.convertToCameraValues(allowedFloatValues2, (float)this.fps);
            fpsRate = fpsRate.endsWith(".0") ? fpsRate.substring(0, fpsRate.length() - ".0".length()) : fpsRate;
        } else if (super.getVideoSrv().getEntityType() == 210633L || super.getVideoSrv().getEntityType() == 210631L) {
            if (this.width == 800) {
                allowedValuesSP = new int[]{256, 384, 512, 768, 1024, 1536, 2048, 3072, 4096};
                this.bandwidth = Tools.convertToCameraValues(allowedValuesSP, this.bandwidth);
            } else {
                allowedValuesSP = new int[]{64, 128, 256, 384, 512, 768, 1024, 1536, 2048, 3072, 4096};
                this.bandwidth = Tools.convertToCameraValues(allowedValuesSP, this.bandwidth);
            }
            allowedFloatValues2 = new float[]{1.0f, 3.0f, 5.0f, 7.5f, 10.0f, 15.0f, 20.0f, 30.0f};
            fpsRate = "" + Tools.convertToCameraValues(allowedFloatValues2, (float)this.fps);
            fpsRate = fpsRate.endsWith(".0") ? fpsRate.substring(0, fpsRate.length() - ".0".length()) : fpsRate;
        } else if (super.getVideoSrv().getEntityType() == 210634L) {
            switch (this.width) {
                case 800: {
                    allowedValuesSP = new int[]{128, 256, 384, 512, 768, 1024, 1536, 2048, 3072, 4096};
                    this.bandwidth = Tools.convertToCameraValues(allowedValuesSP, this.bandwidth);
                    break;
                }
                case 1280: {
                    allowedValuesSP = new int[]{256, 384, 512, 768, 1024, 1536, 2048, 3072, 4096};
                    this.bandwidth = Tools.convertToCameraValues(allowedValuesSP, this.bandwidth);
                    break;
                }
                default: {
                    allowedValuesSP = new int[]{64, 128, 256, 384, 512, 768, 1024, 1536, 2048, 3072, 4096};
                    this.bandwidth = Tools.convertToCameraValues(allowedValuesSP, this.bandwidth);
                    break;
                }
            }
            allowedFloatValues2 = new float[]{1.0f, 3.0f, 5.0f, 7.5f, 10.0f, 12.0f, 15.0f, 20.0f, 30.0f};
            fpsRate = "" + Tools.convertToCameraValues(allowedFloatValues2, (float)this.fps);
            fpsRate = fpsRate.endsWith(".0") ? fpsRate.substring(0, fpsRate.length() - ".0".length()) : fpsRate;
        } else if (super.getVideoSrv().getEntityType() == 210646L) {
            if (this.width <= 640) {
                this.bandwidth = this.bandwidth > 4096 ? 4096 : this.bandwidth;
            } else if (this.width <= 1280) {
                this.bandwidth = this.bandwidth > 8192 ? 8192 : this.bandwidth;
                this.bandwidth = this.bandwidth < 256 ? 256 : this.bandwidth;
            } else if (this.width == 1920) {
                this.bandwidth = this.bandwidth < 512 ? 512 : this.bandwidth;
            }
            allowedValuesSP = new int[]{64, 128, 256, 384, 512, 768, 1024, 1536, 2048, 3072, 4096, 6144, 8192, 10240, 12288, 14336};
            this.bandwidth = Tools.convertToCameraValues(allowedValuesSP, this.bandwidth);
            allowedFloatValues = new float[]{1.0f, 3.0f, 5.0f, 7.5f, 10.0f, 12.0f, 15.0f, 20.0f, 30.0f};
            fpsRate = "" + Tools.convertToCameraValues(allowedFloatValues, (float)this.fps);
            fpsRate = fpsRate.endsWith(".0") ? fpsRate.substring(0, fpsRate.length() - ".0".length()) : fpsRate;
        } else {
            allowedValues = new int[]{64, 128, 256, 384, 512, 768, 1024, 1536, 2048, 3072, 4096};
            this.bandwidth = Tools.convertToCameraValues(allowedValues, this.bandwidth);
            allowedFloatValues = new float[]{1.0f, 3.0f, 5.0f, 7.5f, 10.0f, 12.0f, 15.0f, 20.0f, 30.0f};
            fpsRate = "" + Tools.convertToCameraValues(allowedFloatValues, (float)this.fps);
            fpsRate = fpsRate.replace(".0", "");
        }
        allowedValues = new int[]{200, 330, 500, 1000, 2000, 3000, 4000, 5000};
        this.iFrameDistMS = Tools.convertToCameraValues(allowedValues, this.iFrameDistMS);
        try {
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/set_stream?stream_mode=1", (int)Integer.MAX_VALUE);
        }
        catch (SeeTecException e) {
            if (e.getNetworkStatus() != HTTPStatusCode.HTTP_NOT_FOUND) {
                if (e.getMessage().toLowerCase().contains("unauthorized")) {
                    return -21657;
                }
                this.logger.error("Error while setting streaming type to H.264.", (Throwable)e);
                return -21601;
            }
        }
        catch (Exception e) {
            this.logger.error("Error while setting streaming type to H.264.", (Throwable)e);
            return -21601;
        }
        StringBuilder url = new StringBuilder(256);
        if (this.streamNumber == 1) {
            url.append("/cgi-bin/set_h264?");
        } else {
            url.append("/cgi-bin/set_h264_2?");
        }
        url.append("h264_rtsp_mode=1&h264_transmit=1");
        String resolution = ((PanasonicDevice)this.getVideoSrv().getDevice()).getResolution();
        if (resolution != null) {
            switch (resolution) {
                case "640": {
                    this.width = 640;
                    this.height = 480;
                    break;
                }
                case "720": {
                    this.width = 720;
                    this.height = 576;
                    break;
                }
                case "320": {
                    this.width = 320;
                    this.height = 240;
                    break;
                }
            }
        }
        url.append("&h264_resolution=");
        url.append(this.width);
        url.append("&h264_unimulti=uni&nr_framerate=");
        url.append(fpsRate);
        url.append("&h264_Ivop=");
        if (this.iFrameDistMS < 1000) {
            float iFrameDistCamValue = (float)((double)this.iFrameDistMS / 1000.0);
            url.append(iFrameDistCamValue);
        } else {
            url.append(this.iFrameDistMS / 1000);
        }
        url.append("&f_priority=1&h264_bandwidth=");
        url.append(this.bandwidth);
        try {
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE);
        }
        catch (SeeTecException see) {
            this.logger.error((Object)see, (Throwable)see);
            return see.getErrorCode();
        }
        catch (Exception e) {
            this.logger.error((Object)e, (Throwable)e);
            return -21601;
        }
        url = new StringBuilder("/cgi-bin/set_basic?display_place=ul&");
        if (this.useDateTime) {
            url.append("time_display=24");
        } else {
            url.append("time_display=off");
        }
        if (this.useTitle) {
            url.append("&camid_display=1");
            url.append("&camid");
            if (this.videoSourceNr > 1) {
                url.append(this.videoSourceNr);
            }
            url.append("=");
            url.append(this.title.toUpperCase());
        } else {
            url.append("&camid_display=0");
        }
        try {
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE);
        }
        catch (SeeTecException see) {
            this.logger.error((Object)see, (Throwable)see);
            return see.getErrorCode();
        }
        catch (Exception e) {
            this.logger.error((Object)e, (Throwable)e);
            return -21601;
        }
        this.rtspUrl = "rtsp://" + this.getHost() + "/MediaInput/h264/stream_" + this.streamNumber;
        if (this.videoSourceNr > 1) {
            this.rtspUrl = this.rtspUrl + "/ch_";
            this.rtspUrl = this.rtspUrl + this.videoSourceNr;
        }
        if (this.isAudioEnabled && this.audioCodec != null) {
            url = new StringBuilder("/cgi-bin/set_audio?audio=in&audio_bitrate=" + this.audioBitrate / 1000);
            switch (this.audioCodec) {
                case G711U: {
                    url.append("&audio_encoder=g711");
                    break;
                }
                case G726: {
                    url.append("&audio_encoder=g726");
                    break;
                }
            }
            try {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE);
            }
            catch (SeeTecException see) {
                this.logger.error("Error while setting audio codec: " + see.getMessage());
                return see.getErrorCode();
            }
            catch (Exception e) {
                this.logger.error("Error while setting audio codec: " + e.getMessage());
                return -21601;
            }
        }
        this.rtspSettings = new RTSPStreamSettings();
        try {
            this.networkParameter.setSoTimeout(5000);
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 4, this.rtspUrl);
            if (this.errorCode != 0) {
                this.logger.error("Initialization of RTSPSettings failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Could not initialize rtspSettings for " + this);
            this.logger.warn((Object)ex, (Throwable)ex);
        }
        try {
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while initializing RTSP-Handler for " + this);
            return ex.getErrorCode();
        }
        this.errorCode = this.rtspHandler.start();
        if (this.errorCode != 0) {
            return this.errorCode;
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.panasonicDevice == null) {
            this.panasonicDevice = (PanasonicDevice)this.getVideoSrv().getDevice();
        }
        this.panasonicDevice.unsetH264Stream(this.streamNumber);
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public void notifyForNetworkProblems() {
        this.logger.error("Network problem from HTTPStreamHandler signalied. Shutting down.");
        this.sendStatusService(-21603);
        this.shutdown();
    }

    @Override
    public void sendStatusService(int statusCode) {
        if (this.listener != null) {
            this.listener.sendStatusService(statusCode);
        } else {
            this.logger.error("Listener null for " + this);
        }
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }
}

