/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic.jpeg;

import de.seetec.v5.re.cm.device.video.panasonic.PanasonicDevice;
import de.seetec.v5.re.cm.device.video.panasonic.jpeg.PanasonicVideoSourceClient;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.shared.EntityType;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;

public class PanasonicVideoSourceClient_NP1000
extends PanasonicVideoSourceClient
implements EntityType {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.panasonic.jpeg.PanasonicVideoSourceClient_NP1000";
    private float framerate;
    private String fpsRate;

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    @Override
    public int init() {
        this.fpsRate = "";
        int errorCode = super.init(false);
        if (errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + errorCode + " for " + this);
            return errorCode;
        }
        try {
            float[] allowedValues;
            long fps = (this.highestFramerate + 999L) / 1000L;
            this.compression = (this.compression + 999) / 1000;
            if (super.getVideoSrv().getDevice().getDeviceType() == 200531L) {
                allowedValues = new float[]{0.08f, 0.17f, 0.28f, 0.42f, 2.1f, 3.1f, 4.2f, 8.3f, 12.5f, 25.0f};
                this.fpsRate = "" + Tools.convertToCameraValues(allowedValues, (float)fps);
            } else if (super.getVideoSrv().getEntityID() == 210610L) {
                if (fps > 15L) {
                    this.logger.info("Framerate of [" + fps + "] not valid for " + this + ", so using [15 fps]!");
                    fps = 15L;
                }
                this.fpsRate = "" + fps;
            } else if (super.getVideoSrv().getEntityType() == 210627L || super.getVideoSrv().getEntityType() == 210628L || super.getVideoSrv().getEntityType() == 210634L || super.getVideoSrv().getEntityType() == 210646L || super.getVideoSrv().getDevice().getDeviceType() == 200534L || super.getVideoSrv().getDevice().getDeviceType() == 200535L || super.getVideoSrv().getDevice().getDeviceType() == 200532L || super.getVideoSrv().getDevice().getDeviceType() == 200533L) {
                this.UID = ((PanasonicDevice)this.getVideoSrv().getDevice()).createUID(this.networkParameter);
                if (this.UID < 0) {
                    this.logger.error("Error retrieving UID for " + this);
                    this.UID = 0;
                }
                this.framerate = (float)this.highestFramerate / 1000.0f;
                allowedValues = new float[]{0.1f, 0.2f, 0.33f, 0.5f, 1.0f, 2.0f, 3.0f, 5.0f, 7.5f, 10.0f, 15.0f, 30.0f};
                this.fpsRate = "" + Tools.convertToCameraValues(allowedValues, this.framerate);
                this.fpsRate = this.fpsRate.endsWith(".0") ? this.fpsRate.substring(0, this.fpsRate.length() - ".0".length()) : this.fpsRate;
            } else {
                this.fpsRate = "" + fps;
            }
            PanasonicDevice panasonicDevice = (PanasonicDevice)this.getVideoSrv().getDevice();
            if (panasonicDevice.getH264Status() == 0) {
                try {
                    this.disableH264Streams();
                }
                catch (SeeTecException see) {
                    this.logger.error((Object)see, (Throwable)see);
                    this.logger.error("Error while disabling h.264 Stream for" + this);
                }
            }
            StringBuffer url = new StringBuffer("/cgi-bin/set_jpeg?jpeg_quality=");
            this.compression /= 10;
            this.compression = this.compression > 9 ? 9 : this.compression;
            url.append(this.compression);
            try {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MIN_VALUE);
            }
            catch (SeeTecException see) {
                this.logger.error((Object)see, (Throwable)see);
                return see.getErrorCode();
            }
            catch (Exception e) {
                this.logger.error((Object)e, (Throwable)e);
                return -21601;
            }
            if (super.getVideoSrv().getEntityType() == 210627L || super.getVideoSrv().getEntityType() == 210628L || super.getVideoSrv().getDevice().getDeviceType() == 200531L || super.getVideoSrv().getEntityType() == 210630L || super.getVideoSrv().getEntityType() == 210631L || super.getVideoSrv().getEntityType() == 210632L || super.getVideoSrv().getEntityType() == 210633L || super.getVideoSrv().getEntityType() == 210634L) {
                url = new StringBuffer("/cgi-bin/set_basic?display_place=ul&");
                if (this.useDateTime) {
                    url.append("time_display=24");
                } else {
                    url.append("time_display=off");
                }
                if (this.useTitle) {
                    url.append("&camid_display=1&camid");
                    if (this.videoSourceNr > 1) {
                        url.append(this.videoSourceNr);
                    }
                    url.append("=");
                    url.append(this.title.toUpperCase());
                } else {
                    url.append("&camid_display=0");
                }
                try {
                    NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MIN_VALUE);
                }
                catch (Exception e) {
                    this.logger.error((Object)e, (Throwable)e);
                    return -21601;
                }
            }
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
            return errorCode;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21651;
        }
    }

    @Override
    public void run() {
        block2: {
            super.setRunFinished(CLASS_NAME, false);
            try {
                this.handleServerPush("/cgi-bin/jpeg?CH=" + this.videoSourceNr + "&UID=" + this.UID + "&connect=start&framerate=" + this.fpsRate + "&resolution=" + this.width + "&PAGE=" + System.currentTimeMillis(), true);
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/cgi-bin/jpeg?UID=" + this.UID + "&connect=stop&PAGE=" + System.currentTimeMillis()), (int)Integer.MIN_VALUE);
            }
            catch (SeeTecException ex) {
                if (ex.getNetworkStatus() == HTTPStatusCode.HTTP_INTERNAL_SERVER_ERROR) break block2;
                this.logger.error((Object)ex, (Throwable)ex);
                this.listener.sendStatusService(-21656);
            }
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    private void disableH264Streams() throws SeeTecException {
        StringBuffer url = new StringBuffer("/cgi-bin/set_h264?h264_transmit=0");
        NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MIN_VALUE);
        url = new StringBuffer("/cgi-bin/set_h264_2?h264_transmit=0");
        NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MIN_VALUE);
    }
}

