/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic.jpeg;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.video.panasonic.jpeg.PanasonicVideoSourceClient;

public class PanasonicVideoSourceClient_Hx
extends PanasonicVideoSourceClient
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.panasonic.jpeg.PanasonicVideoSourceClient_Hx";
    private HttpServerPushHandler httpServerPushHandler = null;

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            String seeTecID = Long.toHexString(System.currentTimeMillis() & 0xFFFFFFFFL);
            StringBuilder sb = new StringBuilder(256);
            sb.append("/nphMotionJpeg?sid=");
            sb.append(seeTecID);
            sb.append("&Resolution=");
            sb.append(this.width);
            sb.append("x");
            sb.append(this.height);
            if (this.quality < 33333) {
                sb.append("&Quality=Clarity");
            } else if (this.quality < 66666) {
                sb.append("&Quality=Standard");
            } else {
                sb.append("&Quality=Motion");
            }
            try {
                boolean asynchronous = false;
                this.httpServerPushHandler = new HttpServerPushHandler();
                this.networkParameter.setSoTimeout(5000);
                int errorCode = this.httpServerPushHandler.init(this, this.networkParameter, sb.toString());
                if (errorCode != 0) {
                    this.logger.error("Error [" + errorCode + "] with " + this.httpServerPushHandler);
                } else {
                    errorCode = this.httpServerPushHandler.startServerPush(asynchronous);
                    if (errorCode != 0) {
                        errorCode = errorCode == -21657 ? -21657 : errorCode;
                        this.listener.sendStatusService(errorCode);
                    }
                }
                if (this.httpServerPushHandler != null) {
                    this.httpServerPushHandler.shutdown();
                }
            }
            catch (Exception e) {
                this.logger.error("Reading configuration from " + this.getVideoSrv().getDevice() + " failed", (Throwable)e);
                int errorCode = -21601;
                this.listener.sendStatusService(errorCode);
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    @Override
    public void sendStatusService(int statusCode) {
        this.listener.sendStatusService(statusCode);
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        this.listener.notifyForNetworkProblems();
        this.shutdown();
    }
}

