/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic.jpeg;

import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

abstract class PanasonicVideoSourceClient
extends JPEGVideoSourceClient {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.panasonic.jpeg.PanasonicVideoSourceClient";
    protected int UID = 0;

    PanasonicVideoSourceClient() {
    }

    protected void handleServerPush(String url, boolean useTimeout) {
        block24: {
            int errorCode = 0;
            byte[] inBuffer = new byte[4096];
            ByteArrayOutputStream baos = new ByteArrayOutputStream(32768);
            boolean streamHeaderRead = false;
            long tsLastKeepAlive = System.currentTimeMillis();
            try {
                if (this.serverPushSocket != null) {
                    this.logger.error("Internal Error: [serverPushSocket] is not null!");
                    throw new RuntimeException("Internal Error");
                }
                this.serverPushSocket = super.establishStream(url);
                if (this.serverPushSocket == null) {
                    this.logger.error("Cannot establish stream to [" + this.host + ":" + this.port + "] with url [" + url + "]");
                    return;
                }
                int timeOut = 5000 + 1000000 / (int)this.listener.getFramerate();
                this.serverPushSocket.setSoTimeout(timeOut);
                InputStream is = this.serverPushSocket.getInputStream();
                this.logger.info(this + " uses [" + url + "] to " + this.serverPushSocket);
                baos.reset();
                baos.write(13);
                baos.write(10);
                baos.write("--myboundary".getBytes());
                baos.write(13);
                baos.write(10);
                byte[] startOfContentHeader = baos.toByteArray();
                byte[] startOfJpegHeader = new byte[]{-1, -40, -1};
                baos.reset();
                while (!super.isShutdown() && errorCode == 0) {
                    int index;
                    if (useTimeout && System.currentTimeMillis() - tsLastKeepAlive > 9999L) {
                        tsLastKeepAlive = System.currentTimeMillis();
                        try {
                            String keepAliveURL = "/cgi-bin/keep_alive?mode=jpeg&protocol=http&UID=" + this.UID + "&page=" + System.currentTimeMillis();
                            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)keepAliveURL, (int)Integer.MIN_VALUE);
                        }
                        catch (SeeTecException ex) {
                            if (ex.getNetworkStatus() == HTTPStatusCode.HTTP_INTERNAL_SERVER_ERROR) {
                                continue;
                            }
                        }
                        catch (Throwable ex) {
                            this.logger.warn((Object)ex, ex);
                        }
                    }
                    try {
                        int len = is.read(inBuffer, 0, inBuffer.length);
                        if (len < 0) {
                            this.logger.warn("EndOfStream reached for " + this);
                            break;
                        }
                        baos.write(inBuffer, 0, len);
                    }
                    catch (NullPointerException npe) {
                        break;
                    }
                    byte[] array = baos.toByteArray();
                    if (array.length > 0x100000) {
                        errorCode = -21650;
                        break;
                    }
                    if (!streamHeaderRead) {
                        String sMSG = new String(array);
                        if (sMSG.toLowerCase().contains("unauthorized")) {
                            errorCode = -21657;
                            break;
                        }
                        if (array.length < 512) continue;
                        if (sMSG.toLowerCase().contains("multipart/x-mixed-replace;")) {
                            index = Basic.indexOfByteArray((byte[])array, (byte[])startOfJpegHeader, (int)0);
                            if (index < 0) {
                                errorCode = -21650;
                                break;
                            }
                            baos.reset();
                            baos.write(array, index - startOfJpegHeader.length, array.length - index + startOfJpegHeader.length);
                            streamHeaderRead = true;
                            continue;
                        }
                        if (array.length <= 1024) continue;
                        errorCode = -21650;
                        break;
                    }
                    index = Basic.indexOfByteArray((byte[])array, (byte[])startOfContentHeader, (int)0);
                    if (index <= 0) continue;
                    baos.reset();
                    if (index > array.length - 512) {
                        baos.write(array);
                        continue;
                    }
                    byte[] contentData = new byte[index - startOfContentHeader.length];
                    System.arraycopy(array, 0, contentData, 0, contentData.length);
                    super.deliverContent(contentData);
                    index = Basic.indexOfByteArray((byte[])array, (byte[])startOfJpegHeader, (int)index);
                    if (index < 0) {
                        errorCode = -21650;
                        break;
                    }
                    int nStartOfContentData = index - startOfJpegHeader.length;
                    baos.write(array, nStartOfContentData, array.length - nStartOfContentData);
                }
                if (errorCode != 0) {
                    this.listener.sendStatusService(errorCode);
                }
            }
            catch (Throwable ex) {
                this.logger.warn("Network problems for " + this + ":");
                this.logger.warn((Object)ex, ex);
                if (super.isShutdown() || this.listener == null) break block24;
                this.listener.sendStatusService(-21603);
            }
        }
        try {
            if (this.serverPushSocket != null) {
                this.serverPushSocket.close();
                this.serverPushSocket = null;
            }
        }
        catch (IOException ioex) {
            this.logger.warn((Object)ioex, (Throwable)ioex);
        }
    }
}

