/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.panasonic.PanasonicIOHandler;
import de.seetec.v5.re.shared.LteHostResolver;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;

public class PanasonicIOHandler_Cxxx_HCM5xx
extends PanasonicIOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.panasonic.PanasonicIOHandler_Cxxx_HCM5xx";

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            boolean previousLoopWithError = false;
            DigitalInputSrv[] iServices = super.getDigitalInputSrv();
            while (!(this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device.isShutdown())) {
                try {
                    long duration;
                    DigitalInputSrv iService;
                    int n;
                    long ts = System.currentTimeMillis();
                    DigitalInputSrv[] digitalInputSrvArray = iServices;
                    int n2 = digitalInputSrvArray.length;
                    for (n = 0; n < n2; ++n) {
                        iService = digitalInputSrvArray[n];
                        this.readDigitalInputs(iService);
                        try {
                            Thread.sleep(250L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (previousLoopWithError) {
                        previousLoopWithError = false;
                        this.logger.info("Publishing input stati after error for " + this + " ...");
                        digitalInputSrvArray = iServices;
                        n2 = digitalInputSrvArray.length;
                        for (n = 0; n < n2; ++n) {
                            iService = digitalInputSrvArray[n];
                            if (!iService.getEntity().isEnabled().booleanValue()) continue;
                            iService.publishServiceStatus(iService.getInputStatus());
                        }
                    }
                    if ((duration = System.currentTimeMillis() - ts) < 0L || duration >= 190L) continue;
                    try {
                        Thread.sleep(200L - duration);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Throwable ex) {
                    previousLoopWithError = true;
                    if (ex instanceof IOException || ex instanceof UnknownHostException || ex instanceof NoRouteToHostException || ex instanceof ConnectException) {
                        this.logger.warn("Network trouble for " + this);
                    } else {
                        this.logger.warn((Object)ex, ex);
                        this.logger.warn("Unknown trouble for " + this);
                    }
                    try {
                        for (DigitalInputSrv iService : iServices) {
                            if (!iService.getEntity().isEnabled().booleanValue()) continue;
                            iService.publishServiceStatus(-21603);
                        }
                    }
                    catch (Throwable t) {
                        this.logger.warn((Object)t, t);
                    }
                    long tsTimeout = System.currentTimeMillis() + 10000L;
                    while (tsTimeout > System.currentTimeMillis() && !this.isShutdown(CLASS_NAME) && !this.device.isShutdown()) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        this.logger.info("Thread of this " + this + " finished");
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    @Override
    public int writeDigitalOutput(int outputNumber, int value, long holdTime) {
        DigitalOutputSrv service = super.getDigitalOutputSrv(outputNumber);
        if (service == null) {
            this.logger.error(this + " has no digital output service configured for [" + outputNumber);
            return -21601;
        }
        if (value < 0) {
            this.logger.error("Value [" + value + "] is not valid for " + this);
            return -21601;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Writing value [" + value + "] to output [" + outputNumber + "] with HoldTime [" + holdTime + "] for " + this + " ...");
        }
        try {
            IOHandler.HoldTimer holdTimer;
            int errorCode;
            String[] stringArray;
            if (this.authorization) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = this.usr;
                stringArray = stringArray2;
                stringArray2[1] = this.pwd;
            } else {
                stringArray = null;
            }
            String[] userPWD = stringArray;
            String url = value == 0 ? "/Set?Func=Doutput&Kind=1&Data=1" : "/Set?Func=Doutput&Kind=1&Data=0";
            String resolvedHost = new LteHostResolver(this.getCore().getLTESupportConfiguration()).resolve(this.host);
            NetworkHelper.readGetRequest((String)resolvedHost, (int)this.port, (String[])userPWD, (String)url);
            if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(outputNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                holdTimer.shutdown();
                this.logger.warn("Creating " + holdTimer + " failed with error [" + errorCode);
            }
        }
        catch (Throwable ex) {
            this.logger.warn("Problems setting output [" + outputNumber + "] of " + this, ex);
        }
        return 0;
    }

    private int readDigitalInputs(DigitalInputSrv digitalInputSrv) throws Exception {
        String key;
        int index;
        String seeTecID = Long.toHexString(System.currentTimeMillis() & 0xFFFFFFFFL);
        int inputNumber = digitalInputSrv.getInputNumber();
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Reading digital inputs of " + (Object)((Object)digitalInputSrv) + " ...");
        }
        String url = "/Get?Func=Sensor&Kind=" + inputNumber + "&sid=" + seeTecID;
        String digitalInput = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)65536));
        if (this.logger.isDebugEnabled()) {
            this.logger.info("DigitalInput [" + digitalInput + "] for " + this);
        }
        if ((index = digitalInput.indexOf(key = "Data:")) >= 0) {
            int value;
            digitalInputSrv.checkInput((value = Integer.parseInt(digitalInput.substring(index += key.length(), index + 1))) > 0 ? 0 : 1);
        } else {
            this.logger.warn("Requesting digital input via [" + url + "] from " + this.networkParameter + " gas invalid result [" + digitalInput);
            long tsTimeout = System.currentTimeMillis() + 10000L;
            while (tsTimeout > System.currentTimeMillis() && !this.isShutdown(CLASS_NAME) && !this.device.isShutdown()) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return 0;
    }
}

