/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic;

import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.panasonic.PanasonicIOHandler_Cxxx_HCM5xx;
import de.seetec.v5.re.cm.device.video.panasonic.PanasonicIOHandler_Default;
import de.seetec.v5.re.shared.CnfDeviceCaptureMode;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.NetworkParameterFactory;
import de.seetec.v5.shared.util.SeeTecException;

public class PanasonicDevice
extends VideoServer {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.panasonic.PanasonicDevice";
    private static final int STREAM_NOT_SET = 0;
    private static final int STREAM_1_2_SET = 3;
    private int streamSet = 0;
    private boolean isHDResolution;
    private String resolution = null;

    @Override
    public int initializeDevice(long srvType) {
        block87: {
            super.initializeDevice(srvType);
            if (srvType >= 210600L && srvType <= 210699L || srvType == 210500L || srvType == 210501L || srvType == 210600L || srvType == 210700L || srvType == 210800L || srvType == 219900L || srvType == 219901L) {
                try {
                    String CAPTURE_MODE_STRING = "ImageCaptureMode=";
                    String FIRMWARE = "VERSION=";
                    String RATIO = "ratio=";
                    String FUNNY_800_600_MODE = "800_600=";
                    String RESOLUTION = "iResolution_h264=";
                    String API_3M_TAG = "3m";
                    String API_2M_TAG = "2m";
                    String API_1_3M_TAG = "1.3m";
                    String API_16_9_TAG = "16_9";
                    String API_4_3_TAG = "4_3";
                    String API_D1_TAG = "d1";
                    String API_VGA_TAG = "vga";
                    String captureMode = null;
                    String firmware = null;
                    String ratio = null;
                    String funny800x600Mode = null;
                    CnfDeviceCaptureMode cnfDeviceCaptureMode = this.getDeviceCnf().getCaptureMode();
                    if (cnfDeviceCaptureMode == null || !cnfDeviceCaptureMode.isEnabled()) break block87;
                    byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.getDeviceCnf().getNetworkParameter(), (String)("/cgi-bin/getinfo?FILE=1&page=" + System.currentTimeMillis()), (int)Integer.MAX_VALUE, (boolean)true);
                    if (result == null) {
                        this.logger.error("Error while requesting capture mode for " + this);
                        return -20001;
                    }
                    String reply = new String(result);
                    if (reply.contains("ImageCaptureMode=")) {
                        String[] parts;
                        for (String part : parts = reply.split("\r\n")) {
                            if (part.contains("ImageCaptureMode=")) {
                                captureMode = part.substring("ImageCaptureMode=".length());
                                this.logger.info("Current capture mode is '" + captureMode + "' for " + this);
                                continue;
                            }
                            if (part.contains("VERSION=")) {
                                firmware = part.substring("VERSION=".length());
                                this.logger.info("Firmware is '" + firmware + "' for " + this);
                                continue;
                            }
                            if (part.contains("ratio=")) {
                                ratio = part.substring("ratio=".length());
                                continue;
                            }
                            if (part.contains("800_600=")) {
                                funny800x600Mode = part.substring("800_600=".length());
                                continue;
                            }
                            if (this.getDeviceType() != 200531L || !part.contains("iResolution_h264=")) continue;
                            this.resolution = part.substring("iResolution_h264=".length());
                        }
                        if (captureMode == null) {
                            this.logger.error("Error while extracting capture mode from reply for " + this);
                            return -20000;
                        }
                        if (firmware == null) {
                            this.logger.error("Error while extracting firmware from reply for " + this);
                            return -20000;
                        }
                        String newModeValue = null;
                        String newRatioValue = null;
                        String newFunnyModeValue = null;
                        boolean is3MPWanted = cnfDeviceCaptureMode.getDisplayResolution().contains("1.3M");
                        boolean is4_3_Wanted = cnfDeviceCaptureMode.getDisplayResolution().contains("[4:3]");
                        boolean is800_600_Wanted = cnfDeviceCaptureMode.getDisplayResolution().contains("800x600");
                        boolean isD1Wanted = cnfDeviceCaptureMode.getDisplayResolution().contains("D1");
                        boolean is2MPWanted = cnfDeviceCaptureMode.getDisplayResolution().contains("2MP");
                        if (is3MPWanted && !is4_3_Wanted && (srvType == 210628L || srvType == 210627L) || is2MPWanted && (srvType == 210640L || srvType == 210641L || srvType == 210646L)) {
                            this.isHDResolution = true;
                        }
                        if (this.getDeviceType() == 200531L) {
                            if (captureMode.equalsIgnoreCase("d1")) {
                                this.resolution = "720";
                            }
                            if (captureMode.equalsIgnoreCase("d1") && !isD1Wanted) {
                                this.logger.info("D1 is set, but VGA is wanted for " + this);
                                newModeValue = "vga";
                            } else if (captureMode.equalsIgnoreCase("vga") && isD1Wanted) {
                                this.logger.info("VGA is set, but D1 is wanted for " + this);
                                newModeValue = "d1";
                            }
                            if (newModeValue != null) {
                                this.logger.info("-----------------------------------------------");
                                this.logger.info("New capture mode is: " + newModeValue);
                                this.logger.info("Capture mode has to be set. Reboot is required for " + this);
                                this.logger.info("-----------------------------------------------");
                                if (NetworkHelper.readGetRequest((NetworkParameter)this.getDeviceCnf().getNetworkParameter(), (String)("/cgi-bin/set_imgmode?img_mode=" + newModeValue), (int)Integer.MAX_VALUE) == null) {
                                    this.logger.error("Error while setting capture mode " + this);
                                    return -20001;
                                }
                            }
                        } else if (this.getDeviceType() == 200536L) {
                            if (ratio != null && ratio.equalsIgnoreCase("4_3") && !is4_3_Wanted) {
                                this.logger.info("4:3 is set, but 16:9 is wanted for " + this);
                                newRatioValue = "16_9";
                            } else if (ratio != null && ratio.equalsIgnoreCase("16_9") && is4_3_Wanted) {
                                this.logger.info("16:9 is set, but 4:3 is wanted for " + this);
                                newRatioValue = "4_3";
                            } else if (funny800x600Mode.equalsIgnoreCase("0") && is800_600_Wanted) {
                                this.logger.info("800x600 mode off, but wanted for " + this);
                                newFunnyModeValue = "1";
                            } else if (funny800x600Mode.equalsIgnoreCase("1") && !is800_600_Wanted) {
                                this.logger.info("800x600 mode on, but NOT wanted for " + this);
                                newFunnyModeValue = "0";
                            }
                            String parameters = "";
                            if (newRatioValue != null) {
                                parameters = parameters + "imgratio=" + newRatioValue;
                            } else if (newFunnyModeValue != null) {
                                parameters = parameters + "img_svga=" + newFunnyModeValue;
                            }
                            if (parameters.length() > 0) {
                                this.logger.info("-----------------------------------------------");
                                this.logger.info("New capture mode is: " + parameters);
                                this.logger.info("Capture mode has to be set. Reboot is required for " + this);
                                this.logger.info("-----------------------------------------------");
                                if (NetworkHelper.readGetRequest((NetworkParameter)this.getDeviceCnf().getNetworkParameter(), (String)("/cgi-bin/set_imgmode?" + parameters), (int)Integer.MAX_VALUE) == null) {
                                    this.logger.error("Error while setting capture mode " + this);
                                    return -20001;
                                }
                            }
                        } else if (this.getDeviceType() == 200542L || this.getDeviceType() == 200543L) {
                            this.resolution = "0";
                            String captureModeInSeetec = cnfDeviceCaptureMode.getDisplayResolution();
                            StringBuilder parameters = new StringBuilder();
                            if (captureModeInSeetec.contains("2MP") && !captureMode.equals("2m")) {
                                parameters.append("&img_mode=2m");
                            } else if (captureModeInSeetec.contains("3MP") && !captureModeInSeetec.contains("1.3MP") && !captureMode.equals("3m")) {
                                parameters.append("&img_mode=3m");
                            } else if (captureModeInSeetec.contains("1.3MP") && !captureMode.equals("1.3m")) {
                                parameters.append("&img_mode=1.3m");
                            }
                            if (captureModeInSeetec.contains("[4:3]") && !ratio.equals("4_3")) {
                                parameters.append("&imgratio=4_3");
                            } else if (captureModeInSeetec.contains("[16:9]") && !ratio.equals("16_9")) {
                                parameters.append("&imgratio=16_9");
                            }
                            if (parameters.length() > 0) {
                                this.logger.info("-----------------------------------------------");
                                this.logger.info("Capture mode on camera is: " + captureMode + " " + ratio);
                                this.logger.info("New capture mode is: " + captureModeInSeetec);
                                this.logger.info("-----------------------------------------------");
                                String url = ("/cgi-bin/set_imgmode?" + parameters.toString()).replace("?&", "?");
                                if (NetworkHelper.readGetRequest((NetworkParameter)this.getDeviceCnf().getNetworkParameter(), (String)url, (int)Integer.MAX_VALUE) == null) {
                                    this.logger.error("Error while setting capture mode " + this);
                                    return -20001;
                                }
                            }
                        } else if (this.getDeviceType() == 200544L) {
                            String captureModeInSeetec = cnfDeviceCaptureMode.getDisplayResolution();
                            StringBuilder parameters = new StringBuilder();
                            if (ratio != null && captureModeInSeetec.contains("[4:3]") && !ratio.equals("4_3")) {
                                parameters.append("&imgratio=4_3");
                            } else if (ratio != null && captureModeInSeetec.contains("[16:9]") && !ratio.equals("16_9")) {
                                parameters.append("&imgratio=16_9");
                            }
                            if (parameters.length() > 0) {
                                this.logger.info("-----------------------------------------------");
                                this.logger.info("Capture mode on camera is: " + captureMode + " " + ratio);
                                this.logger.info("New capture mode is: " + captureModeInSeetec);
                                this.logger.info("-----------------------------------------------");
                                String url = ("/cgi-bin/set_imgmode?" + parameters.toString()).replace("?&", "?");
                                if (NetworkHelper.readGetRequest((NetworkParameter)this.getDeviceCnf().getNetworkParameter(), (String)url, (int)Integer.MAX_VALUE) == null) {
                                    this.logger.error("Error while setting capture mode " + this);
                                    return -20001;
                                }
                            }
                        } else if (this.getDeviceType() == 200548L) {
                            this.resolution = "";
                            String parameters = "";
                            if (is2MPWanted) {
                                if (!captureMode.equals("2m")) {
                                    parameters = parameters + "img_mode=2m&imgratio=16_9";
                                }
                            } else {
                                if (captureMode.equals("2m")) {
                                    parameters = parameters + "img_mode=1.3m";
                                }
                                if (is4_3_Wanted) {
                                    if (ratio != null && ratio.equalsIgnoreCase("16_9")) {
                                        parameters = parameters + "imgratio=4_3";
                                    }
                                } else if (ratio != null && ratio.equalsIgnoreCase("4_3")) {
                                    parameters = parameters + "imgratio=16_9";
                                }
                            }
                            if (!parameters.isEmpty()) {
                                this.logger.info("-----------------------------------------------");
                                this.logger.info("New capture mode is: " + parameters);
                                this.logger.info("Capture mode has to be set. Reboot is required for " + this);
                                this.logger.info("-----------------------------------------------");
                                if (NetworkHelper.readGetRequest((NetworkParameter)this.getDeviceCnf().getNetworkParameter(), (String)("/cgi-bin/set_imgmode?" + parameters), (int)Integer.MAX_VALUE) == null) {
                                    this.logger.error("Error while setting capture mode " + this);
                                    return -20001;
                                }
                            }
                        } else {
                            this.logger.info("1.3m is set, but 3m is wanted for " + this);
                            if (captureMode.equalsIgnoreCase("3m") && !is3MPWanted) {
                                this.logger.info("3m is set, but 1.3m is wanted for " + this);
                                newModeValue = "1.3m";
                            } else if (captureMode.equalsIgnoreCase("1.3m") && is3MPWanted && srvType != 210632L && srvType != 210633L && srvType != 210630L && srvType != 210631L && srvType != 210643L && srvType != 210644L) {
                                this.logger.info("1.3m is set, but 3m is wanted for " + this);
                                newModeValue = "3m";
                            }
                            if (this.isVersionNewerThan(firmware, "1.10") && srvType != 210632L && srvType != 210633L && srvType != 210630L && srvType != 210631L && srvType != 210642L && srvType != 210643L && srvType != 210644L) {
                                this.logger.info("Firmware < 1.10 is used for " + this);
                                if (newModeValue != null) {
                                    this.logger.info("-----------------------------------------------");
                                    this.logger.info("New capture mode is: " + newModeValue);
                                    this.logger.info("Capture mode has to be set. Reboot is required for " + this);
                                    this.logger.info("-----------------------------------------------");
                                    if (NetworkHelper.readGetRequest((NetworkParameter)this.getDeviceCnf().getNetworkParameter(), (String)("/cgi-bin/set_imgmode?img_mode=" + newModeValue), (int)Integer.MAX_VALUE) == null) {
                                        this.logger.error("Error while setting capture mode " + this);
                                        return -20001;
                                    }
                                }
                            } else {
                                this.logger.info("Firmware >= 1.10 is used for " + this + " OR camera belongs to the SP or SF series.");
                                if (ratio != null && ratio.equalsIgnoreCase("4_3") && !is4_3_Wanted) {
                                    this.logger.info("4:3 is set, but 16:9 is wanted for " + this);
                                    newRatioValue = "16_9";
                                } else if (ratio != null && ratio.equalsIgnoreCase("16_9") && is4_3_Wanted) {
                                    this.logger.info("16:9 is set, but 4:3 is wanted for " + this);
                                    newRatioValue = "4_3";
                                }
                                if (funny800x600Mode.equalsIgnoreCase("0") && is800_600_Wanted) {
                                    this.logger.info("800x600 mode off, but wanted for " + this);
                                    newFunnyModeValue = "1";
                                } else if (funny800x600Mode.equalsIgnoreCase("1") && !is800_600_Wanted) {
                                    this.logger.info("800x600 mode on, but NOT wanted for " + this);
                                    newFunnyModeValue = "0";
                                }
                                String parameters = "";
                                if (newModeValue != null) {
                                    parameters = parameters + "img_mode=" + newModeValue;
                                }
                                if (newRatioValue != null) {
                                    String string = parameters = parameters.length() == 0 ? "imgratio=" + newRatioValue : parameters + "&imgratio=" + newRatioValue;
                                }
                                if (newFunnyModeValue != null) {
                                    String string = parameters = parameters.length() == 0 ? "img_svga=" + newFunnyModeValue : parameters + "&img_svga=" + newFunnyModeValue;
                                }
                                if (parameters.length() > 0) {
                                    this.logger.info("-----------------------------------------------");
                                    this.logger.info("New capture mode is: " + parameters);
                                    this.logger.info("Capture mode has to be set. Reboot is required for " + this);
                                    this.logger.info("-----------------------------------------------");
                                    if (NetworkHelper.readGetRequest((NetworkParameter)this.getDeviceCnf().getNetworkParameter(), (String)("/cgi-bin/set_imgmode?" + parameters), (int)Integer.MAX_VALUE) == null) {
                                        this.logger.error("Error while setting capture mode " + this);
                                        return -20001;
                                    }
                                }
                            }
                        }
                        break block87;
                    }
                    this.logger.error("Capture modes not supported for " + this);
                    this.logger.error("Client like to set.");
                    return -20000;
                }
                catch (SeeTecException e) {
                    if (e.getErrorCode() == -20001) {
                        return -21656;
                    }
                    if (e.getMessage().toLowerCase().contains("unauthorized")) {
                        this.logger.error("Unauthorized access for " + this);
                        return -21657;
                    }
                    this.logger.error("Error while evaluating/setting capture mode settings for " + this, (Throwable)e);
                    return -20000;
                }
                catch (Exception e) {
                    this.logger.error("Error while evaluating/setting capture mode settings for " + this, (Throwable)e);
                    return -20000;
                }
            }
        }
        return 0;
    }

    public int getH264Status() {
        return this.streamSet;
    }

    public void setH264Stream(int streamNumber) {
        this.streamSet += streamNumber;
        this.streamSet = this.streamSet > 3 ? 3 : this.streamSet;
    }

    public void unsetH264Stream(int streamNumber) {
        this.streamSet -= streamNumber;
        this.streamSet = this.streamSet < 0 ? 0 : this.streamSet;
    }

    public boolean isIsHDResolution() {
        return this.isHDResolution;
    }

    public String getResolution() {
        return this.resolution;
    }

    public int createUID(NetworkParameter networkParameter, int channel) {
        if (networkParameter == null) {
            return -20002;
        }
        try {
            char c;
            String url = channel < 0 ? "/cgi-bin/getuid?PAGE=" + System.currentTimeMillis() + "&FILE=2" : "/cgi-bin/getuid?CH=" + channel + "&PAGE=" + System.currentTimeMillis() + "&FILE=2";
            byte[] result = NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)url, (int)Integer.MAX_VALUE);
            String key = "UID=";
            String sResult = new String(result);
            int position = sResult.indexOf(key);
            if (position < 0) {
                return Integer.MIN_VALUE;
            }
            StringBuilder sb = new StringBuilder();
            position += key.length();
            while ((c = sResult.charAt(position)) >= '0' && c <= '9') {
                sb.append(c);
                ++position;
            }
            return Integer.parseInt(sb.toString());
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
            return Integer.MIN_VALUE;
        }
    }

    public int createUID(NetworkParameter networkParameter) {
        return this.createUID(networkParameter, Integer.MIN_VALUE);
    }

    public static final int checkDeviceInfos(long type, String host, int port, boolean useAuthorization, String user, String pass, int timeout) {
        String[] stringArray;
        if (useAuthorization) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = user;
            stringArray = stringArray2;
            stringArray2[1] = pass;
        } else {
            stringArray = null;
        }
        NetworkParameter networkParameter = NetworkParameterFactory.createNetworkParameter((String)host, (int)port, (boolean)false, (int)-1, (int)timeout, stringArray);
        try {
            String url = "/cgi-bin/setdata";
            String response = new String(NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)"/cgi-bin/setdata", (int)Integer.MAX_VALUE, (boolean)true));
            if (!response.toLowerCase().contains("camtitle")) {
                return -21697;
            }
        }
        catch (SeeTecException e) {
            switch (e.getNetworkStatus()) {
                case HTTP_UNAUTHORIZED: {
                    return -21701;
                }
            }
            return -21697;
        }
        return 0;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        return null;
    }

    @Override
    protected IOHandler createIOHandler() {
        if (this.isShutdown(CLASS_NAME)) {
            this.logger.error(this + " is already shutting down");
            return null;
        }
        long deviceType = this.getDeviceType();
        if (deviceType == 200522L || deviceType == 200520L || deviceType == 200518L || deviceType == 200512L || deviceType == 200513L || deviceType == 200514L || deviceType == 200521L || deviceType == 200519L || deviceType == 200527L || deviceType == 200530L || deviceType == 200540L || deviceType == 200537L || deviceType == 200538L || deviceType == 200541L || deviceType == 200539L) {
            return new PanasonicIOHandler_Cxxx_HCM5xx();
        }
        return new PanasonicIOHandler_Default();
    }

    @Override
    protected boolean isSupportingIO() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isVersionNewerThan(String version, String versionToCompare) {
        if (version == null) {
            return true;
        }
        String[] splittedGivenVersion = version.split("\\.");
        if (splittedGivenVersion.length != 2) {
            return true;
        }
        String[] splittedCompareVersion = versionToCompare.split("\\.");
        if (splittedCompareVersion.length != 2) {
            return true;
        }
        try {
            if (Integer.parseInt(splittedCompareVersion[0]) < Integer.parseInt(splittedGivenVersion[0])) return false;
            if (Integer.parseInt(splittedCompareVersion[0]) != Integer.parseInt(splittedGivenVersion[0])) return true;
            if (Integer.parseInt(splittedCompareVersion[1]) < Integer.parseInt(splittedGivenVersion[1])) return false;
            if (Integer.parseInt(splittedCompareVersion[1]) != Integer.parseInt(splittedGivenVersion[1])) return true;
            return false;
        }
        catch (NumberFormatException nfe) {
            this.logger.error("Error while converting character to a number.");
            return true;
        }
    }
}

