/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic;

import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.video.panasonic.PanasonicHelper;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Vector;
import java.util.regex.Pattern;

public class PanasonicCameraControl_direct
extends CameraControl {
    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        return -21611;
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        int zoom;
        int tilt;
        int pan;
        if (panSpeed != null) {
            this.previousPanSpeed = pan = panSpeed.intValue();
        } else {
            pan = this.previousPanSpeed;
        }
        if (tiltSpeed != null) {
            this.previousTiltSpeed = tilt = tiltSpeed.intValue();
        } else {
            tilt = this.previousTiltSpeed;
        }
        if (zoomSpeed != null) {
            this.previousZoomSpeed = zoom = zoomSpeed.intValue();
        } else {
            zoom = this.previousZoomSpeed;
        }
        StringBuilder sb = new StringBuilder(256);
        if (this.logger.isDebugEnabled()) {
            this.logger.info("PanSpeed=[" + panSpeed + "], TiltSpeed=[" + tiltSpeed + "], ZoomSpeed=[" + zoomSpeed + "]");
        }
        try {
            String url;
            if (panSpeed != null || tiltSpeed != null) {
                sb.append("&dpan=").append(pan / 390);
                sb.append("&dtilt=").append(tilt / -390);
            }
            if (zoomSpeed != null) {
                if (zoom != 0) {
                    sb.append(zoom < 0 ? "&zoom=-4" : "&zoom=4");
                } else {
                    sb.append("&zoom=0");
                }
            }
            if ((url = sb.toString()).isEmpty()) {
                return 0;
            }
            return this.sendCameraCommand(url, true);
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        try {
            PanasonicHelper.CameraPosition camPos = PanasonicHelper.calculateZoomAreaPoints(xPosition, yPosition, 0, 0, resolution);
            return this.sendCameraCommand("center_x=" + camPos.getAbsoluteStartX() + "&center_y=" + camPos.getAbsoluteStartY() + "&resolution=" + resolution[0], false);
        }
        catch (Exception ex) {
            this.logger.error("Exception while reading PTZ configuration for: " + this, (Throwable)ex);
            return 0;
        }
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolutionForZoomArea) {
        try {
            PanasonicHelper.CameraPosition camPos = PanasonicHelper.calculateZoomAreaPoints(xPosition, yPosition, width, height, resolutionForZoomArea);
            return this.sendCameraCommand("&sposition_x=" + camPos.getAbsoluteStartX() + "&sposition_y=" + camPos.getAbsoluteStartY() + "&eposition_x=" + camPos.getAbsoluteEndX() + "&eposition_y=" + camPos.getAbsoluteEndY() + "&resolution=" + camPos.getResolution(), false);
        }
        catch (Exception ex) {
            this.logger.error("Exception while reading PTZ configuration for: " + this, (Throwable)ex);
            return 0;
        }
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        return -21611;
    }

    @Override
    public int setContinuousIris(Integer irisSpeed) {
        try {
            if (irisSpeed == null || irisSpeed == 0) {
                return 0;
            }
            if (irisSpeed < 0) {
                return this.sendCameraCommand("&iris=-2", false);
            }
            return this.sendCameraCommand("&iris=2", false);
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int setAutoIris(Boolean active) {
        return -21611;
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        return -21611;
    }

    @Override
    public int setContinuousFocus(Integer focusSpeed) {
        if (this.logger.isDebugEnabled()) {
            this.logger.info("FocusSpeed=[" + focusSpeed + "]");
        }
        try {
            if (focusSpeed == null || focusSpeed == 0) {
                return 0;
            }
            if (focusSpeed < 0) {
                return this.sendCameraCommand("&focus=-3", true);
            }
            return this.sendCameraCommand("&focus=3", true);
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int setAutoFocus(Boolean active) {
        if (active.booleanValue()) {
            return this.sendCameraCommand("&AF=ON", false);
        }
        return this.sendCameraCommand("&AF=OFF", false);
    }

    @Override
    public int setZeroLux(Boolean active) {
        return -21611;
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        return -21611;
    }

    @Override
    public int setHomePosition() {
        return 0;
    }

    @Override
    public int addPresetPosition(Vector<byte[]> result, Long presetID, String presetName) {
        int numberOfPresets = 256;
        try {
            this.logger.info("There are " + numberOfPresets + " presets available on " + this);
            byte[] vector = new byte[numberOfPresets];
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                vector[Integer.parseInt((String)presetCnf.getPresetPosition())] = 1;
            }
            int presetPosition = -1;
            for (int i = 1; i < vector.length; ++i) {
                if (vector[i] != 0) continue;
                presetPosition = i;
                break;
            }
            if (presetPosition < 0) {
                this.logger.error("Cannot add preset [" + presetName + "], 'cause no more free preset positions are available for " + this);
                return -21600;
            }
            presetName = PanasonicCameraControl_direct.getPanasonicPresetName(presetName);
            PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, "" + presetPosition, presetName);
            this.presetList.addElement(presetCnf);
            result.addElement(presetCnf.getPresetCnf());
            String url = "/cgi-bin/set_preposi?preno=" + presetCnf.getPresetPosition();
            url = url + "&preposiid=" + presetName;
            url = url + "&stoptime=30";
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)true);
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            this.logger.error("Adding preset [" + presetName + "] failed");
            return -21600;
        }
    }

    @Override
    public int setPresetPosition(String presetName) {
        try {
            presetName = PanasonicCameraControl_direct.getPanasonicPresetName(presetName);
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                if (!presetName.equals(presetCnf.getPresetName())) continue;
                this.sendCameraCommand("&preset=" + presetCnf.getPresetPosition(), false);
                return 0;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Setting preset [" + presetName + "] failed");
            return -21600;
        }
        this.logger.error("Preset [" + presetName + "] not available");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }

    @Override
    public int removePresetPosition(String presetName) {
        try {
            String encodedPresetName = PanasonicCameraControl_direct.getPanasonicPresetName(presetName);
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = (PresetCnf)this.presetList.elementAt(i);
                if (!encodedPresetName.equals(presetCnf.getPresetName())) continue;
                this.logger.info("Removing preset: " + new String(presetCnf.getPresetCnf()));
                this.presetList.removeElementAt(i);
                String url = "/cgi-bin/del_preposi?preno=" + presetCnf.getPresetPosition();
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)true);
                return 0;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Removing preset [" + presetName + "] failed");
            return -21600;
        }
        this.logger.error("Preset [" + presetName + "] not available");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }

    public static String getPanasonicPresetName(String position) {
        if (position == null) {
            return null;
        }
        String regex = "[0-9A-Z]";
        String input = position.toUpperCase();
        input = input.length() > 20 ? input.substring(0, 20) : input;
        if (Pattern.matches(regex, input)) {
            return input;
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            String s = "" + input.charAt(i);
            if (Pattern.matches(regex, s)) {
                ret.append(s);
                continue;
            }
            ret.append("+");
        }
        return ret.toString();
    }

    private int sendCameraCommand(String url, boolean direct) {
        String completeURL = null;
        try {
            this.videoSrv.notifyForCameraControl();
            completeURL = direct ? "/cgi-bin/directctrl?" + url : "/cgi-bin/camctrl?" + url;
            completeURL = completeURL.replace("?&", "?");
            if (this.logger.isDebugEnabled()) {
                this.logger.info("CameraCommand=[" + completeURL + "]");
            }
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)completeURL, (int)Integer.MIN_VALUE);
            return 0;
        }
        catch (SeeTecException ex) {
            this.logger.error("Sending HTTP request [" + completeURL + "] failed with error [" + ex.getErrorCode() + "]");
            return ex.getErrorCode();
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }
}

