/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic;

import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.video.panasonic.PanasonicHelper;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import java.net.URLEncoder;
import java.util.Vector;

public class PanasonicCameraControl_NS202
extends CameraControl {
    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        return -21611;
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        int zoom;
        int tilt;
        int pan;
        int STEP_SIZE = 390;
        int MAX = 256;
        int suggestedMIN = 80;
        if (panSpeed != null) {
            pan = panSpeed != 0 ? (panSpeed + STEP_SIZE * (panSpeed / Math.abs(panSpeed))) / STEP_SIZE : 0;
            int n = pan = pan > MAX ? MAX : pan;
            if (pan != 0 && (pan > 7 || pan < -15)) {
                pan = Math.abs(pan) < suggestedMIN ? (pan < 0 ? -suggestedMIN : suggestedMIN) : pan;
            }
            this.previousPanSpeed = pan;
        } else {
            pan = this.previousPanSpeed;
        }
        if (tiltSpeed != null) {
            tilt = tiltSpeed != 0 ? (tiltSpeed + STEP_SIZE * (tiltSpeed / Math.abs(tiltSpeed))) / -STEP_SIZE : 0;
            int n = tilt = tilt > MAX ? MAX : tilt;
            if (tilt != 0 && (tilt > 4 || tilt < -15)) {
                tilt = Math.abs(tilt) < suggestedMIN ? (tilt < 0 ? -suggestedMIN : suggestedMIN) : tilt;
            }
            this.previousTiltSpeed = tilt;
        } else {
            tilt = this.previousTiltSpeed;
        }
        if (zoomSpeed != null) {
            zoom = zoomSpeed / 25000;
            if (zoomSpeed > 5000 && zoom == 0) {
                zoom = 1;
            }
            this.previousZoomSpeed = zoom;
        } else {
            zoom = this.previousZoomSpeed;
        }
        StringBuilder sb = new StringBuilder(256);
        if (this.logger.isDebugEnabled()) {
            this.logger.info("PanSpeed=[" + panSpeed + "], TiltSpeed=[" + tiltSpeed + "], ZoomSpeed=[" + zoomSpeed + "]");
        }
        try {
            String url;
            if (panSpeed != null || tiltSpeed != null || zoomSpeed != null) {
                sb.append("&rpan=");
                sb.append(pan);
                sb.append("&rtilt=");
                sb.append(tilt);
                sb.append("&rzoom=");
                sb.append(zoom);
            }
            if ((url = sb.toString()).length() <= 0) {
                return 0;
            }
            return this.sendCameraCommand("directctrl", url);
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        try {
            PanasonicHelper.CameraPosition camPos = PanasonicHelper.calculateZoomAreaPoints(xPosition, yPosition, 0, 0, resolution);
            return this.sendCameraCommand("camctrl", "center_x=" + camPos.getAbsoluteStartX() + "&center_y=" + camPos.getAbsoluteStartY() + "&resolution=" + camPos.getResolution());
        }
        catch (Exception ex) {
            this.logger.error("Exception while reading PTZ configuration for: " + this, (Throwable)ex);
            return 0;
        }
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolutionForZoomArea) {
        try {
            PanasonicHelper.CameraPosition camPos = PanasonicHelper.calculateZoomAreaPoints(xPosition, yPosition, width, height, resolutionForZoomArea);
            if (this.videoSrv.getDevice().getDeviceType() == 200536L) {
                return this.sendCameraCommand("camctrl", "sposition_x=" + camPos.getAbsoluteStartX() + "&sposition_y=" + camPos.getAbsoluteStartY() + "&eposition_x=" + camPos.getAbsoluteEndX() + "&eposition_y=" + camPos.getAbsoluteEndY() + "&resolution=" + camPos.getResolution());
            }
        }
        catch (Exception ex) {
            this.logger.error("Exception while reading PTZ configuration for: " + this, (Throwable)ex);
        }
        return 0;
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        return -21611;
    }

    @Override
    public int setContinuousIris(Integer irisSpeed) {
        if (this.logger.isDebugEnabled()) {
            this.logger.info("IrisSpeed=[" + irisSpeed + "]");
        }
        long entityType = this.videoSrv.getEntityType();
        try {
            if (entityType == 210634L) {
                if (irisSpeed == null) {
                    return 0;
                }
                if (irisSpeed < 0) {
                    return this.sendCameraCommand("camctrl", "&bright=down&Language=0");
                }
                if (irisSpeed > 0) {
                    return this.sendCameraCommand("camctrl", "&bright=up&Language=0");
                }
                return 0;
            }
            if (irisSpeed == null) {
                return 0;
            }
            if (irisSpeed > 0) {
                return this.sendCameraCommand("camctrl", "&iris=-2");
            }
            if (irisSpeed < 0) {
                return this.sendCameraCommand("camctrl", "&iris=2");
            }
            if (entityType == 210645L) {
                return 0;
            }
            return this.sendCameraCommand("camctrl", "&iris=0");
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int setAutoIris(Boolean active) {
        long entityType = this.videoSrv.getEntityType();
        if (entityType == 210634L) {
            return this.sendCameraCommand("camctrl", "&bright=1&Language=0");
        }
        return -21611;
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        return -21611;
    }

    @Override
    public int setContinuousFocus(Integer focusSpeed) {
        if (this.logger.isDebugEnabled()) {
            this.logger.info("FocusSpeed=[" + focusSpeed + "]");
        }
        try {
            if (focusSpeed == null) {
                return 0;
            }
            if (focusSpeed > 0) {
                return this.sendCameraCommand("directctrl", "&focus=-1");
            }
            if (focusSpeed < 0) {
                return this.sendCameraCommand("directctrl", "&focus=1");
            }
            return this.sendCameraCommand("directctrl", "&focus=0");
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int setAutoFocus(Boolean active) {
        return this.sendCameraCommand("camctrl", "&af=" + (active != false ? "on" : "off"));
    }

    @Override
    public int setZeroLux(Boolean active) {
        return -21611;
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        return -21611;
    }

    @Override
    public int setHomePosition() {
        return 0;
    }

    @Override
    public int addPresetPosition(Vector<byte[]> result, Long presetID, String presetName) {
        String encodedPresetName = null;
        int presetPosition = -1;
        try {
            int i;
            int bitVector = 0;
            for (i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                bitVector |= 1 << Integer.parseInt(presetCnf.getPresetPosition());
            }
            for (i = 1; i <= 30; ++i) {
                if ((bitVector & 1 << i) != 0) continue;
                presetPosition = i;
                break;
            }
            if (presetPosition < 0) {
                this.logger.error("Cannot add preset [" + presetName + "], 'cause no more free preset positions are available for " + this);
                return -21600;
            }
            this.sendCameraCommand("camposiset", "&UID=0&presetset=" + presetPosition);
            encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, "" + presetPosition, encodedPresetName);
            this.presetList.addElement(presetCnf);
            result.addElement(presetCnf.getPresetCnf());
            if (this.logger.isDebugEnabled()) {
                this.logger.info("super.presetList=" + this.presetList);
            }
            return 0;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    @Override
    public int setPresetPosition(String presetName) {
        try {
            String encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                if (!encodedPresetName.toLowerCase().equals(presetCnf.getPresetName().toLowerCase())) continue;
                return this.sendCameraCommand("camctrl", "&UID=0&PRESET=" + presetCnf.getPresetPosition());
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            this.logger.error("Setting preset [" + presetName + "] failed");
            return -21600;
        }
        this.logger.error("Preset [" + presetName + "] not available");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }

    @Override
    public int removePresetPosition(String presetName) {
        try {
            String encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = (PresetCnf)this.presetList.elementAt(i);
                if (!encodedPresetName.equals(presetCnf.getPresetName())) continue;
                this.logger.info("Removing preset: " + new String(presetCnf.getPresetCnf()));
                this.presetList.removeElementAt(i);
                return this.sendCameraCommand("camposiset", "&UID=0&presetdel=" + presetCnf.getPresetPosition());
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Removing preset [" + presetName + "] failed");
            return -21600;
        }
        this.logger.error("Preset [" + presetName + "] not available");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }

    private int sendCameraCommand(String cmd, String url) {
        try {
            String completeURL = "/cgi-bin/" + cmd + "?" + url;
            completeURL = completeURL.replace("?&", "?");
            long entityType = this.videoSrv.getEntityType();
            if (entityType == 219900L || entityType == 219901L) {
                completeURL = completeURL + "&CH=" + this.videoSrv.getVideoSourceCnf().getServerEntryNo();
            }
            this.videoSrv.notifyForCameraControl();
            if (this.logger.isDebugEnabled()) {
                this.logger.info("CameraCommand=[" + completeURL + "]");
            }
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)completeURL);
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }
}

