/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic;

import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.video.panasonic.PanasonicHelper;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import java.net.URLEncoder;
import java.util.Vector;

public class PanasonicCameraControl_Hx
extends CameraControl {
    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        StringBuilder sb = new StringBuilder(256);
        try {
            int errorCode;
            if (pan != null) {
                sb.append("&pan=").append((double)pan.intValue() / 1000.0);
            }
            if (tilt != null) {
                sb.append("&tilt=").append((double)tilt.intValue() / 1000.0);
            }
            if (zoom != null) {
                sb.append("&zoom=").append((zoom - 1) / 10);
            }
            if ((errorCode = this.sendCameraCommand(sb.toString())) != 0) {
                return errorCode;
            }
            errorCode = this.videoSrv.sendStatusAbsolutePTZ(sender, pan, tilt, zoom);
            if (errorCode != 0) {
                this.logger.error("Send HTTP request failed with error [" + errorCode + "]");
                return errorCode;
            }
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        int zoom;
        int tilt;
        int pan;
        int errorCode = 0;
        if (panSpeed != null) {
            this.previousPanSpeed = pan = panSpeed.intValue();
        } else {
            pan = this.previousPanSpeed;
        }
        if (tiltSpeed != null) {
            this.previousTiltSpeed = tilt = tiltSpeed.intValue();
        } else {
            tilt = this.previousTiltSpeed;
        }
        if (zoomSpeed != null) {
            this.previousZoomSpeed = zoom = zoomSpeed.intValue();
        } else {
            zoom = this.previousZoomSpeed;
        }
        try {
            if (pan < 0) {
                errorCode = this.sendCameraCommand("&Direction=PanLeft");
            } else if (pan > 0) {
                errorCode = this.sendCameraCommand("&Direction=PanRight");
            }
            if (tilt < 0) {
                errorCode = this.sendCameraCommand("&Direction=TiltDown");
            } else if (tilt > 0) {
                errorCode = this.sendCameraCommand("&Direction=TiltUp");
            }
            if (zoom < 0) {
                errorCode = this.sendCameraCommand("&Direction=ZoomWide");
            } else if (zoom > 0) {
                errorCode = this.sendCameraCommand("&Direction=ZoomTele");
            }
            return errorCode;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        try {
            PanasonicHelper.CameraPosition camPos = PanasonicHelper.calculateZoomAreaPoints(xPosition, yPosition, 0, 0, resolution);
            return this.sendCameraCommand("&Width=" + resolution[0] + "&Height=" + resolution[1] + "&Language=0&Direction=Direct&NewPosition.x=" + camPos.getAbsoluteStartX() + "&NewPosition.y=" + camPos.getAbsoluteStartY());
        }
        catch (Exception ex) {
            this.logger.error("Exception while reading PTZ configuration for: " + this, (Throwable)ex);
            return 0;
        }
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolution) {
        return -21611;
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        return this.sendCameraCommand("&iris=" + value / 1000);
    }

    @Override
    public int setContinuousIris(Integer value) {
        return this.sendContinuousCommand("iris", value);
    }

    @Override
    public int setAutoIris(Boolean active) {
        if (active.booleanValue()) {
            return this.sendCameraCommand("&autoiris=on");
        }
        return this.sendCameraCommand("&autoiris=off");
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        return this.sendCameraCommand("&focus=" + value / 1000);
    }

    @Override
    public int setContinuousFocus(Integer value) {
        return this.sendContinuousCommand("focus", value);
    }

    @Override
    public int setAutoFocus(Boolean active) {
        if (active.booleanValue()) {
            return this.sendCameraCommand("&autofocus=on");
        }
        return this.sendCameraCommand("&autofocus=off");
    }

    @Override
    public int setZeroLux(Boolean active) {
        return -21611;
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        return -21611;
    }

    @Override
    public int setHomePosition() {
        return -21611;
    }

    @Override
    public int addPresetPosition(Vector<byte[]> result, Long presetID, String presetName) {
        int presetPosition = -1;
        try {
            int i;
            int bitVector = 0;
            for (i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                bitVector |= 1 << Integer.parseInt(presetCnf.getPresetPosition());
            }
            for (i = 1; i <= 30; ++i) {
                if ((bitVector & 1 << i) != 0) continue;
                presetPosition = i;
                break;
            }
            if (presetPosition < 0) {
                this.logger.error("Cannot add preset [" + presetName + "], 'cause no more free preset positions are available for " + this + " :-(");
                return -21600;
            }
            String encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            this.logger.info("Creating Preset [" + presetPosition + "]/[" + encodedPresetName + "] ...");
            this.sendGenericCommand("/Set?Func=PresetNamePos&Kind=" + presetPosition + "&Data=" + encodedPresetName);
            PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, "" + presetPosition, encodedPresetName);
            this.presetList.addElement(presetCnf);
            result.addElement(presetCnf.getPresetCnf());
            this.logger.info("super.presetList=" + this.presetList);
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            this.logger.error("Adding preset [" + presetName + "] failed");
            return -21600;
        }
    }

    @Override
    public int setPresetPosition(String presetName) {
        try {
            String encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                if (!encodedPresetName.equals(presetCnf.getPresetName())) continue;
                return this.sendCameraCommand("&Direction=Preset&PresetOperation=Move&Data=" + (i + 1));
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Setting preset [" + presetName + "] failed");
            return -21600;
        }
        this.logger.error("Preset [" + presetName + "] not available");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }

    @Override
    public int removePresetPosition(String presetName) {
        try {
            String encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = (PresetCnf)this.presetList.elementAt(i);
                if (!encodedPresetName.equals(presetCnf.getPresetName())) continue;
                this.logger.info("Removing preset: " + new String(presetCnf.getPresetCnf()));
                this.presetList.removeElementAt(i);
                return 0;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Removing preset [" + presetName + "] failed");
            return -21600;
        }
        this.logger.error("Preset [" + presetName + "] not available");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }

    private int sendGenericCommand(String url) {
        try {
            this.logger.info("CompleteURL=[" + url + "]");
            this.videoSrv.notifyForCameraControl();
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url);
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    private int sendCameraCommand(String url) {
        try {
            String seeTecID = Long.toHexString(System.currentTimeMillis() & 0xFFFFFFFFL);
            String completeURL = "/nphControlCamera?suid=" + seeTecID + url;
            if (this.logger.isDebugEnabled()) {
                this.logger.info("CompleteURL=[" + completeURL + "]");
            }
            this.videoSrv.notifyForCameraControl();
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)completeURL);
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    private int sendContinuousCommand(String cmd, Integer value) {
        if (value != null) {
            return this.sendCameraCommand("&continuous" + cmd + "move=" + value / 1000);
        }
        return this.sendCameraCommand("&continuous" + cmd + "move=0");
    }
}

