/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.onvif.sistore;

import de.seetec.v5.re.cm.configuration.definition.camera.FeaturesType;
import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCodecDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCodecsType;
import de.seetec.v5.re.cm.configuration.definition.device.AvailableIOsType;
import de.seetec.v5.re.cm.configuration.definition.device.BitrateSettingsType;
import de.seetec.v5.re.cm.configuration.definition.device.CameraResolutionType;
import de.seetec.v5.re.cm.configuration.definition.device.CaptureModeDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.CodecType;
import de.seetec.v5.re.cm.configuration.definition.device.CommentsType;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceGroupMembershipsType;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceNetworkDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.ImageRotationCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.MiscVideoServerCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.MultiStreamingDefinitionsType;
import de.seetec.v5.re.cm.configuration.definition.device.OnvifEventDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.RtspSettingsType;
import de.seetec.v5.re.cm.configuration.definition.device.StreamDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedApiVersionsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedCameraResolutionsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedCaptureModesType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedMPEGProfileIDs;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedOnvifEventsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedRotationAnglesType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedTransmissionTypeIDsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedVideoSourceEntityTypesType;
import de.seetec.v5.re.cm.configuration.definition.device.VirtualCameraDefinitionType;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.shared.onvif.EventMessageDescription;
import de.seetec.v5.re.cm.device.shared.onvif.MultiStreamingInformation;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifDevice;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifException;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifHelper;
import de.seetec.v5.re.cm.device.shared.onvif.WebServicePasswordHandler;
import de.seetec.v5.re.cm.device.video.onvif.sistore.SistoreOnvifEventHandler;
import de.seetec.v5.re.cm.device.video.onvif.sistore.SistoreOnvifIoHandler;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaID;
import de.seetec.v5.re.shared.MpegProfile;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.onvif.ver10.device.wsdl.Device;
import org.onvif.ver10.media.wsdl.Media;
import org.onvif.ver10.media.wsdl.VideoSourceMode;
import org.onvif.ver10.schema.AudioEncoderConfigurationOption;
import org.onvif.ver10.schema.AudioEncoding;
import org.onvif.ver10.schema.Capabilities;
import org.onvif.ver10.schema.CapabilityCategory;
import org.onvif.ver10.schema.H264Profile;
import org.onvif.ver10.schema.IntRange;
import org.onvif.ver10.schema.Mpeg4Profile;
import org.onvif.ver10.schema.NetworkProtocolType;
import org.onvif.ver10.schema.PTZNode;
import org.onvif.ver10.schema.PTZSpaces;
import org.onvif.ver10.schema.Profile;
import org.onvif.ver10.schema.RealTimeStreamingCapabilities;
import org.onvif.ver10.schema.VideoEncoderConfiguration;
import org.onvif.ver10.schema.VideoEncoderConfigurationOptions;
import org.onvif.ver10.schema.VideoResolution;
import org.onvif.ver10.schema.VideoSource;
import org.onvif.ver10.schema.VideoSourceConfiguration;
import org.onvif.ver20.ptz.wsdl.PTZ;

public final class SistoreOnvifDevice
extends VideoServer {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.onvif.sistore.SistoreOnvifDevice";
    private OnvifCore onvifCore = null;
    private SistoreOnvifEventHandler genericOnvifEventHandler = null;
    private final Object SEMAPHORE = new Object();
    private Map<String, EventMessageDescription> eventTypesMap = null;
    public static final String DEFAULT_CAPTURE_MODE_TOKEN = "SeeTecDefaultCaptureMode";
    public static final String DEFAULT_PROFILE_TOKEN = "VMS default";
    public static final String PROFILE_TOKEN_SEPARATOR = "||";
    private static final int VIDEO_SOURCE_INDEX = 0;

    @Override
    protected IOHandler createIOHandler() {
        if (this.isSupportingIO()) {
            return new SistoreOnvifIoHandler();
        }
        return null;
    }

    @Override
    protected boolean isSupportingIO() {
        try {
            if (this.getOnvifCore().getDeviceIoService() != null && (this.getOnvifCore().getEventService() != null && this.getOnvifCore().getDeviceService().getNumberOfInputs() > 0 || this.getOnvifCore().getDeviceService().getNumberOfRelays() > 0)) {
                return true;
            }
        }
        catch (SeeTecException exception) {
            this.logger.warn("Could not read IOs for " + this);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final OnvifCore getOnvifCore() throws SeeTecException {
        if (this.onvifCore != null) {
            return this.onvifCore;
        }
        Object object = this.SEMAPHORE;
        synchronized (object) {
            try {
                if (this.onvifCore == null) {
                    NetworkParameter networkParameter = this.getDeviceCnf().getNetworkParameter();
                    if (networkParameter != null) {
                        boolean useAuthorization = this.getDeviceCnf().getUseAuthorization();
                        String user = null;
                        if (networkParameter.getUserPWD() != null && networkParameter.getUserPWD()[0] != null) {
                            user = networkParameter.getUserPWD()[0];
                        }
                        String password = null;
                        if (networkParameter.getUserPWD() != null && networkParameter.getUserPWD()[1] != null) {
                            password = networkParameter.getUserPWD()[1];
                        }
                        String passwordType = "PasswordDigest";
                        if (useAuthorization) {
                            try {
                                int authenticationCheckTimeout = 7000;
                                if (SistoreOnvifDevice.checkAuthenticationType(networkParameter.getHost(), networkParameter.getHTTPport(), user, password, authenticationCheckTimeout, "PasswordDigest")) {
                                    passwordType = "PasswordDigest";
                                } else if (SistoreOnvifDevice.checkAuthenticationType(networkParameter.getHost(), networkParameter.getHTTPport(), user, password, authenticationCheckTimeout, "PasswordText")) {
                                    passwordType = "PasswordText";
                                }
                            }
                            catch (Exception exception) {
                                passwordType = "PasswordDigest";
                            }
                        }
                        OnvifDevice onvifDevice = new OnvifDevice(this.getDeviceEntity().getEntityName(), networkParameter, user, password, passwordType, useAuthorization);
                        try {
                            this.onvifCore = new OnvifCore();
                            this.onvifCore.init(onvifDevice, this.logger.isDebugEnabled());
                            return this.onvifCore;
                        }
                        catch (OnvifException onvifException) {
                            this.onvifCore.shutdown();
                            this.onvifCore = null;
                            throw new SeeTecException(onvifException.getErrorCode(), onvifException.getCause().getMessage());
                        }
                    }
                    return this.onvifCore;
                }
                throw new SeeTecException(-21601, "NetworkParameters are null");
            }
            catch (ConfigurationException exception) {
                this.logger.error("Problems while initializing ONVIF Core", (Throwable)exception);
                return null;
            }
        }
    }

    public final SistoreOnvifEventHandler getGenericOnvifEventHandler() {
        if (this.genericOnvifEventHandler == null) {
            try {
                this.genericOnvifEventHandler = new SistoreOnvifEventHandler();
                this.genericOnvifEventHandler.init(this.getOnvifCore(), this);
            }
            catch (SeeTecException exception) {
                this.logger.warn("GenericOnvifEventHandler could not be initialized", (Throwable)exception);
            }
        }
        return this.genericOnvifEventHandler;
    }

    @Override
    public int shutdown() {
        if (this.genericOnvifEventHandler != null) {
            this.genericOnvifEventHandler.shutdown();
            this.genericOnvifEventHandler = null;
        }
        return super.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"HARD_CODE_PASSWORD"}, justification="Mentionned hard-coded password is just empty default pass which is a proper default setting in this case.")
    protected final DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        try {
            String currentSignature = this.getOnvifCore().getDeviceService().getDeviceInformation().getFirmwareVersion();
            String currentManufacturer = this.getOnvifCore().getDeviceService().getDeviceInformation().getManufacturer();
            String currentName = this.getOnvifCore().getDeviceService().getDeviceInformation().getDeviceModel();
            String currentComments = "RE_APP_VERSION::7.1.1_23";
            long deviceType = this.getDeviceType();
            long sourceType = 212207L;
            if (!(signature != null && signature.equals(currentSignature) && manufacturer != null && manufacturer.equals(currentManufacturer) && name != null && name.equals(currentName) && comments != null && comments.equals("RE_APP_VERSION::7.1.1_23"))) {
                Map<String, EventMessageDescription> localEventTypesMap;
                List<Integer> httpPorts = this.getOnvifCore().getDeviceService().getPorts(NetworkProtocolType.HTTP);
                List<Integer> httpsPorts = this.getOnvifCore().getDeviceService().getPorts(NetworkProtocolType.HTTPS);
                DeviceDefinition deviceDefinition = new DeviceDefinition();
                deviceDefinition.setCountFirstChannelOnly(true);
                deviceDefinition.setSignature(currentSignature);
                deviceDefinition.setManufacturer(currentManufacturer);
                CommentsType commentsType = new CommentsType();
                commentsType.getString().add("RE_APP_VERSION::7.1.1_23");
                deviceDefinition.setComments(commentsType);
                deviceDefinition.setDefaultMediaID(MediaID.VIDEO_SERVER_DIGITAL.getType());
                String apiVersion = "Core Specification 2.5";
                SupportedApiVersionsType supportedApiVersionsType = new SupportedApiVersionsType();
                supportedApiVersionsType.getString().add("Core Specification 2.5");
                deviceDefinition.setSupportedApiVersions(supportedApiVersionsType);
                deviceDefinition.setDefaultApiVersion("Core Specification 2.5");
                List videoSources = this.getOnvifCore().getMediaService().getOnvifMediaService().getVideoSources();
                deviceDefinition.setNoOfCams(videoSources.size());
                VirtualCameraDefinitionType virtualCameraDefinitionType = new VirtualCameraDefinitionType();
                virtualCameraDefinitionType.setCanVirtualCamera(false);
                virtualCameraDefinitionType.setCanVirtualCameraCropping(false);
                virtualCameraDefinitionType.setNoOfVirtualCameras(0);
                deviceDefinition.setVirtualCameraDefinition(virtualCameraDefinitionType);
                SupportedVideoSourceEntityTypesType supportedVideoSourceEntityTypesType = new SupportedVideoSourceEntityTypesType();
                supportedVideoSourceEntityTypesType.getLong().add(sourceType);
                if (this.getOnvifCore().getPtzService() != null) {
                    supportedVideoSourceEntityTypesType.getLong().add(219901L);
                }
                deviceDefinition.setSupportedVideoSourceEntityTypes(supportedVideoSourceEntityTypesType);
                DeviceNetworkDefinitionType deviceNetworkDefinitionType = new DeviceNetworkDefinitionType();
                deviceNetworkDefinitionType.setCanChangeHttpPort(true);
                deviceNetworkDefinitionType.setCanChangeHttpsPort(httpsPorts.size() > 0);
                deviceNetworkDefinitionType.setCanHttps(httpsPorts.size() > 0);
                deviceNetworkDefinitionType.setDefaultHttpPort(httpPorts.size() > 0 ? httpPorts.get(0) : 80);
                deviceNetworkDefinitionType.setDefaultHttpsPort(httpsPorts.size() > 0 ? httpsPorts.get(0) : 443);
                deviceNetworkDefinitionType.setDefaultPassword("");
                deviceNetworkDefinitionType.setDefaultUserName("");
                deviceNetworkDefinitionType.setUseAuthentication(false);
                deviceDefinition.setDeviceNetworkDefinition(deviceNetworkDefinitionType);
                SupportedCaptureModesType supportedCaptureModesType = new SupportedCaptureModesType();
                try {
                    this.logger.info("Trying to get CaptureModes for " + this.getOnvifCore().getOnvifDevice());
                    List videoSourceModes = this.getOnvifCore().getMediaService().getOnvifMediaService().getVideoSourceModes(((VideoSource)videoSources.get(0)).getToken());
                    this.logger.info(videoSourceModes.size() + " CaptureModes supported by " + this.getOnvifCore().getOnvifDevice());
                    for (VideoSourceMode videoSourceMode : videoSourceModes) {
                        this.logger.info("Setting CaptureMode \"" + videoSourceMode.getToken() + "\" for " + this.getOnvifCore().getOnvifDevice());
                        boolean reboot = this.getOnvifCore().getMediaService().getOnvifMediaService().setVideoSourceMode(((VideoSource)videoSources.get(0)).getToken(), videoSourceMode.getToken());
                        if (reboot) {
                            this.logger.info("Waiting for " + this.getOnvifCore().getOnvifDevice() + " to reboot and set the CaptureMode \"" + videoSourceMode.getToken() + "\"");
                        } else {
                            this.logger.info("Waiting for " + this.getOnvifCore().getOnvifDevice() + " to set the CaptureMode \"" + videoSourceMode.getToken() + "\"");
                        }
                        this.getOnvifCore().getMediaService().waitForCaptureMode(((VideoSource)videoSources.get(0)).getToken(), videoSourceMode.getToken());
                        CaptureModeDefinitionType captureModeDefinitionType = this.createCaptureModeDefinitionType(videoSourceMode);
                        supportedCaptureModesType.getCaptureModeDefinition().add(captureModeDefinitionType);
                    }
                }
                catch (SeeTecException seetecException) {
                    throw seetecException;
                }
                catch (Throwable throwable) {
                    this.logger.info("CaptureModes not supported by " + this.getOnvifCore().getOnvifDevice());
                    supportedCaptureModesType.getCaptureModeDefinition().clear();
                }
                finally {
                    if (supportedCaptureModesType.getCaptureModeDefinition().isEmpty()) {
                        CaptureModeDefinitionType captureModeDefinitionType = this.createCaptureModeDefinitionType(null);
                        supportedCaptureModesType.getCaptureModeDefinition().add(captureModeDefinitionType);
                    }
                }
                deviceDefinition.setSupportedCaptureModes(supportedCaptureModesType);
                deviceDefinition.setDefaultCaptureModeIndex(0);
                ImageRotationCapabilitiesType imageRotationCapabilitiesType = new ImageRotationCapabilitiesType();
                imageRotationCapabilitiesType.setCanRotateJPEGImage(false);
                imageRotationCapabilitiesType.setCanRotateMPEGImage(false);
                SupportedRotationAnglesType supportedRotationAnglesType = new SupportedRotationAnglesType();
                supportedRotationAnglesType.getInt().add(0);
                supportedRotationAnglesType.getInt().add(180000);
                imageRotationCapabilitiesType.setSupportedRotationAngles(supportedRotationAnglesType);
                deviceDefinition.setImageRotationCapabilities(imageRotationCapabilitiesType);
                try {
                    AudioCapabilitiesType audioCapabilitiesType = new AudioCapabilitiesType();
                    audioCapabilitiesType.setCanAudio(this.getOnvifCore().getMediaService().getOnvifMediaService().getAudioSources().size() > 0);
                    audioCapabilitiesType.setNumberOfPossibleAudioStreams(this.getOnvifCore().getMediaService().getOnvifMediaService().getAudioSources().size());
                    audioCapabilitiesType.setDefaultAudioCodecIndex(0);
                    if (audioCapabilitiesType.isCanAudio()) {
                        AudioCodecsType audioCodecsType = new AudioCodecsType();
                        for (AudioEncoderConfigurationOption audioEncoderConfigurationOption : this.getOnvifCore().getMediaService().getOnvifMediaService().getAudioEncoderConfigurationOptions(null, null).getOptions()) {
                            AudioCodecDefinitionType audioCodecDefinitionType = new AudioCodecDefinitionType();
                            AudioEncoding audioEncoding = audioEncoderConfigurationOption.getEncoding();
                            CodecType codecType = new CodecType();
                            if (audioEncoding == AudioEncoding.G_711) {
                                codecType.setValue(Codec.G711U.getType());
                            } else if (audioEncoding == AudioEncoding.G_726) {
                                codecType.setValue(Codec.G726.getType());
                            }
                            audioCodecDefinitionType.setAudioCodec(codecType);
                            int bitrate = OnvifHelper.getBiggestIntValueAndConvert(audioEncoderConfigurationOption.getBitrateList(), true);
                            audioCodecDefinitionType.setBitrate(bitrate);
                            audioCodecsType.getAudioCodecDefinition().add(audioCodecDefinitionType);
                        }
                        audioCapabilitiesType.setAudioCodecs(audioCodecsType);
                    } else {
                        audioCapabilitiesType.setAudioCodecs(null);
                    }
                    deviceDefinition.setAudioCapabilities(audioCapabilitiesType);
                }
                catch (Throwable throwable) {
                    this.logger.warn(throwable.getMessage());
                    this.logger.warn("No audio available or problems while reading auto for " + this);
                    AudioCapabilitiesType audioCapabilitiesType = new AudioCapabilitiesType();
                    audioCapabilitiesType.setCanAudio(false);
                    audioCapabilitiesType.setAudioCodecs(null);
                    audioCapabilitiesType.setDefaultAudioCodecIndex(0);
                    audioCapabilitiesType.setNumberOfPossibleAudioStreams(0);
                    deviceDefinition.setAudioCapabilities(audioCapabilitiesType);
                }
                AvailableIOsType availableIOsType = new AvailableIOsType();
                if (this.getOnvifCore().getDeviceIoService() != null && this.getOnvifCore().getEventService() != null) {
                    for (int i = 0; i < this.getOnvifCore().getDeviceService().getNumberOfInputs(); ++i) {
                        availableIOsType.getInputOutputCapabilities().add(0);
                    }
                }
                if (this.getOnvifCore().getDeviceIoService() != null) {
                    for (int i = 0; i < this.getOnvifCore().getDeviceService().getNumberOfRelays(); ++i) {
                        availableIOsType.getInputOutputCapabilities().add(1);
                    }
                }
                deviceDefinition.setAvailableIOs(availableIOsType);
                MiscVideoServerCapabilitiesType miscVideoServerCapabilitiesType = new MiscVideoServerCapabilitiesType();
                miscVideoServerCapabilitiesType.setCanTimeDate(false);
                miscVideoServerCapabilitiesType.setCanTitle(false);
                miscVideoServerCapabilitiesType.setCanDetectTampering(false);
                miscVideoServerCapabilitiesType.setCanDetectVideoloss(false);
                miscVideoServerCapabilitiesType.setNoOfRS232S(0);
                miscVideoServerCapabilitiesType.setCanTimeshift(false);
                miscVideoServerCapabilitiesType.setPTZSpeedMultiplier(100);
                miscVideoServerCapabilitiesType.setCanPTZ(this.getOnvifCore().getPtzService() != null);
                deviceDefinition.setMiscVideoServerCapabilities(miscVideoServerCapabilitiesType);
                DeviceGroupMembershipsType deviceGroupMembershipsType = new DeviceGroupMembershipsType();
                deviceGroupMembershipsType.getDeviceGroups().add("OnvifLimitation");
                deviceGroupMembershipsType.getDeviceGroups().add("GenericDriver");
                if (deviceType == 209601L || deviceType == 205501L || deviceType == 206500L || deviceType == 206600L) {
                    deviceGroupMembershipsType.getDeviceGroups().add("DeviceMulticastConfiguration");
                    deviceGroupMembershipsType.getDeviceGroups().add("CheckDeviceInfos");
                }
                deviceDefinition.setDeviceGroupMemberships(deviceGroupMembershipsType);
                deviceDefinition.setEntityType(deviceType);
                deviceDefinition.setName(currentName);
                SupportedOnvifEventsType supportedOnvifEventsType = new SupportedOnvifEventsType();
                if (this.getOnvifCore().getEventService() != null && (localEventTypesMap = this.getEventTypesMap()) != null) {
                    for (Map.Entry<String, EventMessageDescription> entry : localEventTypesMap.entrySet()) {
                        OnvifEventDefinitionType onvifEventDefinition = new OnvifEventDefinitionType();
                        onvifEventDefinition.setEventType(entry.getKey());
                        onvifEventDefinition.setMaxNumber(entry.getValue().getDataType().length > 0 && entry.getValue().getDataType().equals("xsd:boolean") ? 1 : Integer.MAX_VALUE);
                        supportedOnvifEventsType.getOnvifEventDefinition().add(onvifEventDefinition);
                    }
                }
                deviceDefinition.setSupportedOnvifEvents(supportedOnvifEventsType);
                return deviceDefinition;
            }
            this.logger.info("Return null for definition for " + this);
            return null;
        }
        catch (SeeTecException exception) {
            this.logger.warn("Error while reading information from " + this, (Throwable)exception);
            throw exception;
        }
        catch (Exception exception) {
            this.logger.warn("Error while reading information from " + this, (Throwable)exception);
            throw new SeeTecException(-21600, exception.getMessage());
        }
    }

    private CaptureModeDefinitionType createCaptureModeDefinitionType(VideoSourceMode videoSourceMode) throws SeeTecException {
        CaptureModeDefinitionType captureModeDefinitionType = new CaptureModeDefinitionType();
        captureModeDefinitionType.setRebootRequired(videoSourceMode != null ? videoSourceMode.isReboot() : false);
        captureModeDefinitionType.setModeSuffix("");
        String videoSourceConfigurationToken = ((VideoSourceConfiguration)this.getOnvifCore().getMediaService().getOnvifMediaService().getVideoSourceConfigurations().get(0)).getToken();
        MultiStreamingInformation multiStreamingInformation = this.getOnvifCore().getMediaService().getMultiStreamingInformation(videoSourceConfigurationToken);
        captureModeDefinitionType.setMaxTotalNumberOfStreams(multiStreamingInformation.getTotalNumber());
        VideoEncoderConfigurationOptions veco = this.getOnvifCore().getMediaService().getOnvifMediaService().getVideoEncoderConfigurationOptions(null, null);
        List videoResolutions = null;
        IntRange frameRateRange = null;
        if (veco.getH264() != null) {
            videoResolutions = veco.getH264().getResolutionsAvailable();
            frameRateRange = veco.getH264().getFrameRateRange();
        } else if (veco.getJPEG() != null) {
            videoResolutions = veco.getJPEG().getResolutionsAvailable();
            frameRateRange = veco.getJPEG().getFrameRateRange();
        } else if (veco.getMPEG4() != null) {
            videoResolutions = veco.getMPEG4().getResolutionsAvailable();
            frameRateRange = veco.getMPEG4().getFrameRateRange();
        }
        VideoResolution biggestResolution = OnvifHelper.getBiggestResolution(videoResolutions);
        String token = videoSourceMode != null ? videoSourceMode.getToken() : DEFAULT_CAPTURE_MODE_TOKEN;
        int width = videoSourceMode != null ? videoSourceMode.getMaxResolution().getWidth() : biggestResolution.getWidth();
        int height = videoSourceMode != null ? videoSourceMode.getMaxResolution().getHeight() : biggestResolution.getHeight();
        int minFrameRate = frameRateRange.getMin();
        int maxFrameRate = videoSourceMode != null ? (int)videoSourceMode.getMaxFramerate() : frameRateRange.getMax();
        CameraResolutionType captureModeCameraResolutionType = new CameraResolutionType();
        captureModeCameraResolutionType.setDisplayResolution(width + "x" + height + "@" + maxFrameRate + " [" + token + "]");
        captureModeCameraResolutionType.setWidth(width);
        captureModeCameraResolutionType.setHeight(height);
        captureModeCameraResolutionType.setMinMilliFPS(minFrameRate * 1000);
        captureModeCameraResolutionType.setMaxMilliFPS(maxFrameRate * 1000);
        captureModeCameraResolutionType.setResolution(width + "x" + height);
        captureModeCameraResolutionType.setSupportedFrameRates(null);
        captureModeDefinitionType.setResolution(captureModeCameraResolutionType);
        MultiStreamingDefinitionsType multiStreamingDefinitionsType = this.createMultiStreamingDefinitionsType(multiStreamingInformation, frameRateRange);
        captureModeDefinitionType.setMultiStreamingDefinitions(multiStreamingDefinitionsType);
        captureModeDefinitionType.setDefaultStreamDefinitionIndex(0);
        return captureModeDefinitionType;
    }

    private MultiStreamingDefinitionsType createMultiStreamingDefinitionsType(MultiStreamingInformation multiStreamingInformation, IntRange frameRateRangeForBiggestResolution) throws SeeTecException {
        MultiStreamingDefinitionsType multiStreamingDefinitionsType = new MultiStreamingDefinitionsType();
        List videoEncoderConfigurations = this.getOnvifCore().getMediaService().getOnvifMediaService().getVideoEncoderConfigurations();
        ArrayList<String> onvifProfiles = new ArrayList<String>();
        onvifProfiles.add(DEFAULT_PROFILE_TOKEN);
        for (Profile profile : this.getOnvifCore().getMediaService().getOnvifMediaService().getProfiles()) {
            if (profile.getToken().contains("seetec")) continue;
            onvifProfiles.add(profile.getToken());
        }
        for (String onvifProfile : onvifProfiles) {
            for (VideoEncoderConfiguration videoEncoderConfiguration : videoEncoderConfigurations) {
                SupportedMPEGProfileIDs supportedMPEGProfileIds;
                IntRange govLengthIntervalRange;
                IntRange encodingIntervalRange;
                IntRange frameRateRange;
                List videoResolutions;
                Integer numberOfStreams;
                CodecType codecType;
                VideoEncoderConfigurationOptions videoEncoderConfigurationOptions = null;
                try {
                    videoEncoderConfigurationOptions = this.getOnvifCore().getMediaService().getOnvifMediaService().getVideoEncoderConfigurationOptions(videoEncoderConfiguration.getToken(), !onvifProfile.equals(DEFAULT_PROFILE_TOKEN) ? onvifProfile : null);
                }
                catch (SeeTecException exception) {
                    throw exception;
                }
                catch (Exception exception) {
                    if (!onvifProfile.equals(DEFAULT_PROFILE_TOKEN)) {
                        this.logger.warn("GetVideoEncoderConfigurationOptions failed, VideoEncoderConfiguration=" + videoEncoderConfiguration.getToken() + " and ProfileToken=" + onvifProfile + " seem to be incompatible " + this.getOnvifCore().getOnvifDevice(), (Throwable)exception);
                        continue;
                    }
                    throw new SeeTecException(-21600, "GetVideoEncoderConfigurationOptions failed for VideoEncoderConfiguration=" + videoEncoderConfiguration.getToken() + " " + this.getOnvifCore().getOnvifDevice());
                }
                String streamName = (!onvifProfile.equals(DEFAULT_PROFILE_TOKEN) ? onvifProfile + PROFILE_TOKEN_SEPARATOR : "") + videoEncoderConfiguration.getToken();
                if (videoEncoderConfigurationOptions.getH264() != null) {
                    codecType = new CodecType();
                    codecType.setValue(Codec.H264.getType());
                    numberOfStreams = multiStreamingInformation.getNumberOfH264Streams() != null ? multiStreamingInformation.getNumberOfH264Streams() : multiStreamingInformation.getTotalNumber();
                    videoResolutions = videoEncoderConfigurationOptions.getH264().getResolutionsAvailable();
                    frameRateRange = videoEncoderConfigurationOptions.getH264().getFrameRateRange();
                    encodingIntervalRange = videoEncoderConfigurationOptions.getH264().getEncodingIntervalRange();
                    govLengthIntervalRange = videoEncoderConfigurationOptions.getH264().getGovLengthRange();
                    supportedMPEGProfileIds = new SupportedMPEGProfileIDs();
                    List h264Profiles = videoEncoderConfigurationOptions.getH264().getH264ProfilesSupported();
                    if (h264Profiles != null) {
                        for (H264Profile h264Profile : h264Profiles) {
                            if (h264Profile == H264Profile.BASELINE) {
                                supportedMPEGProfileIds.getInt().add(MpegProfile.BASELINE.getType());
                                continue;
                            }
                            if (h264Profile == H264Profile.EXTENDED) {
                                supportedMPEGProfileIds.getInt().add(MpegProfile.EXTENDED.getType());
                                continue;
                            }
                            if (h264Profile == H264Profile.HIGH) {
                                supportedMPEGProfileIds.getInt().add(MpegProfile.HIGH.getType());
                                continue;
                            }
                            if (h264Profile != H264Profile.MAIN) continue;
                            supportedMPEGProfileIds.getInt().add(MpegProfile.MAIN.getType());
                        }
                    }
                    multiStreamingDefinitionsType.getStreamDefinition().add(this.createOnvifStreamDefinitionType(numberOfStreams, frameRateRangeForBiggestResolution, encodingIntervalRange, govLengthIntervalRange, codecType, streamName, videoResolutions, frameRateRange, supportedMPEGProfileIds));
                }
                if (videoEncoderConfigurationOptions.getJPEG() != null) {
                    codecType = new CodecType();
                    codecType.setValue(Codec.MJPEG.getType());
                    numberOfStreams = multiStreamingInformation.getNumberOfJpegStreams() != null ? multiStreamingInformation.getNumberOfJpegStreams() : multiStreamingInformation.getTotalNumber();
                    videoResolutions = videoEncoderConfigurationOptions.getJPEG().getResolutionsAvailable();
                    frameRateRange = videoEncoderConfigurationOptions.getJPEG().getFrameRateRange();
                    encodingIntervalRange = videoEncoderConfigurationOptions.getJPEG().getEncodingIntervalRange();
                    multiStreamingDefinitionsType.getStreamDefinition().add(this.createOnvifStreamDefinitionType(numberOfStreams, frameRateRangeForBiggestResolution, encodingIntervalRange, null, codecType, streamName, videoResolutions, frameRateRange, null));
                }
                if (videoEncoderConfigurationOptions.getMPEG4() == null) continue;
                codecType = new CodecType();
                codecType.setValue(Codec.MPEG4.getType());
                numberOfStreams = multiStreamingInformation.getNumberOfMpeg4Streams() != null ? multiStreamingInformation.getNumberOfMpeg4Streams() : multiStreamingInformation.getTotalNumber();
                videoResolutions = videoEncoderConfigurationOptions.getMPEG4().getResolutionsAvailable();
                frameRateRange = videoEncoderConfigurationOptions.getMPEG4().getFrameRateRange();
                encodingIntervalRange = videoEncoderConfigurationOptions.getMPEG4().getEncodingIntervalRange();
                govLengthIntervalRange = videoEncoderConfigurationOptions.getMPEG4().getGovLengthRange();
                supportedMPEGProfileIds = new SupportedMPEGProfileIDs();
                List mpeg4Profiles = videoEncoderConfigurationOptions.getMPEG4().getMpeg4ProfilesSupported();
                if (mpeg4Profiles != null) {
                    for (Mpeg4Profile mpeg4Profile : mpeg4Profiles) {
                        if (mpeg4Profile == Mpeg4Profile.SP) {
                            supportedMPEGProfileIds.getInt().add(MpegProfile.SP.getType());
                            continue;
                        }
                        if (mpeg4Profile != Mpeg4Profile.ASP) continue;
                        supportedMPEGProfileIds.getInt().add(MpegProfile.ASP.getType());
                    }
                }
                multiStreamingDefinitionsType.getStreamDefinition().add(this.createOnvifStreamDefinitionType(numberOfStreams, frameRateRangeForBiggestResolution, encodingIntervalRange, govLengthIntervalRange, codecType, streamName, videoResolutions, frameRateRange, supportedMPEGProfileIds));
            }
        }
        return multiStreamingDefinitionsType;
    }

    public final Map<String, EventMessageDescription> getEventTypesMap() {
        if (this.eventTypesMap == null) {
            try {
                this.eventTypesMap = this.getOnvifCore().getEventService().getEventProperties();
            }
            catch (SeeTecException exception) {
                this.logger.warn("Could not receive event list from " + this, (Throwable)exception);
            }
        }
        return this.eventTypesMap;
    }

    private StreamDefinitionType createOnvifStreamDefinitionType(Integer numberOfStreams, IntRange frameRateRangeForBiggestResolution, IntRange encodingIntervalRange, IntRange govLengthIntervalRange, CodecType codecType, String streamName, List<VideoResolution> videoResolutions, IntRange frameRateRange, SupportedMPEGProfileIDs supportedMPEGProfilesType) throws SeeTecException {
        StreamDefinitionType streamDefinitionType = new StreamDefinitionType();
        streamDefinitionType.setNoOfHWMDInputs(1);
        streamDefinitionType.setMaxNumberOfStreams(numberOfStreams);
        streamDefinitionType.setDefaultMilliFPS(frameRateRangeForBiggestResolution.getMin() < 5 && frameRateRangeForBiggestResolution.getMax() > 5 ? 5000 : frameRateRangeForBiggestResolution.getMin() * 1000);
        streamDefinitionType.setHideFPSField(false);
        streamDefinitionType.setHideIFrameField(govLengthIntervalRange == null);
        streamDefinitionType.setMinIFrameDistance(1000);
        streamDefinitionType.setMaxIFrameDistance(100000);
        streamDefinitionType.setHideKompressionField(false);
        streamDefinitionType.setHideBandwithField(false);
        streamDefinitionType.setEncodingIntervalMin(encodingIntervalRange.getMin() * 1000);
        streamDefinitionType.setEncodingIntervalMax(encodingIntervalRange.getMax() * 1000);
        streamDefinitionType.setStreamingMode(codecType);
        SupportedTransmissionTypeIDsType supportedTransmissionTypeIDsType = new SupportedTransmissionTypeIDsType();
        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_UNICAST.getType());
        RealTimeStreamingCapabilities streamingCapabilities = this.getOnvifCore().getDeviceService().getCapabilities().getMedia().getStreamingCapabilities();
        if (streamingCapabilities != null) {
            boolean canRtpRtspTcp;
            boolean canRtpMulticastDevice = streamingCapabilities.isRTPMulticast() != null && streamingCapabilities.isRTPMulticast() != false;
            boolean canRtpMulticastDriver = this.getDeviceType() == 209601L || this.getDeviceType() == 205501L || this.getDeviceType() == 204203L || this.getDeviceType() == 206500L || this.getDeviceType() == 206600L;
            boolean canRtpTcp = streamingCapabilities.isRTPTCP() != null && streamingCapabilities.isRTPTCP() != false;
            boolean bl = canRtpRtspTcp = streamingCapabilities.isRTPRTSPTCP() != null && streamingCapabilities.isRTPRTSPTCP() != false;
            if (canRtpMulticastDevice && canRtpMulticastDriver) {
                supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_MULTICAST.getType());
            }
            if (canRtpRtspTcp) {
                supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_TCP.getType());
            }
            if (canRtpTcp || canRtpRtspTcp) {
                supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST.getType());
            }
        }
        streamDefinitionType.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
        List<Integer> rtspPorts = this.getOnvifCore().getDeviceService().getPorts(NetworkProtocolType.RTSP);
        RtspSettingsType rtspSettingsType = new RtspSettingsType();
        rtspSettingsType.setDefaultRtspPort(rtspPorts.size() > 0 ? rtspPorts.get(0) : 554);
        rtspSettingsType.setCanChangeRtspPort(rtspPorts.size() > 1);
        rtspSettingsType.setCanMultipleRtspPorts(false);
        streamDefinitionType.setRtspSettings(rtspSettingsType);
        BitrateSettingsType bitrateSettingsType = new BitrateSettingsType();
        bitrateSettingsType.setCanVBR(false);
        bitrateSettingsType.setCanVBRQuality(false);
        bitrateSettingsType.setCanCBR(true);
        bitrateSettingsType.setCanCBRQuality(true);
        bitrateSettingsType.setMaxBandwidth(51200000);
        bitrateSettingsType.setMinBandwidth(1024);
        bitrateSettingsType.setSupportedBitrates(null);
        streamDefinitionType.setBitrateSettings(bitrateSettingsType);
        streamDefinitionType.setName(streamName);
        SupportedCameraResolutionsType supportedCameraResolutionsType = new SupportedCameraResolutionsType();
        for (VideoResolution videoResolution : videoResolutions) {
            int width = videoResolution.getWidth();
            int height = videoResolution.getHeight();
            CameraResolutionType cameraResolutionType = new CameraResolutionType();
            cameraResolutionType.setDisplayResolution(width + "x" + height);
            cameraResolutionType.setWidth(width);
            cameraResolutionType.setHeight(height);
            cameraResolutionType.setMaxMilliFPS(frameRateRange.getMax() * 1000);
            cameraResolutionType.setMinMilliFPS(frameRateRange.getMin() * 1000);
            cameraResolutionType.setResolution(width + "x" + height);
            cameraResolutionType.setSupportedFrameRates(null);
            supportedCameraResolutionsType.getCameraResolution().add(cameraResolutionType);
        }
        streamDefinitionType.setSupportedCameraResolutions(supportedCameraResolutionsType);
        streamDefinitionType.setSupportedMPEGProfileIDs(supportedMPEGProfilesType);
        streamDefinitionType.setDefaultCameraResolutionIndex(0);
        streamDefinitionType.setDefaultTransmissionTypeIndex(0);
        return streamDefinitionType;
    }

    @Override
    protected final VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        long sourceType = 212207L;
        try {
            PTZ ptzConfiguration;
            List nodes;
            boolean ptzAvailable = this.getOnvifCore().getPtzService() != null;
            VideoCameraDefinition videoCameraDefinition = new VideoCameraDefinition();
            videoCameraDefinition.setManufacturer(this.getOnvifCore().getDeviceService().getDeviceInformation().getManufacturer());
            videoCameraDefinition.setComment("");
            videoCameraDefinition.setDefaultMediaID(ptzAvailable ? MediaID.VIDEO_SOURCE_PTZ.getType() : MediaID.VIDEO_SOURCE_DIGITAL.getType());
            videoCameraDefinition.setName(this.getOnvifCore().getDeviceService().getDeviceInformation().getDeviceModel());
            videoCameraDefinition.setEntityType(sourceType);
            videoCameraDefinition.setPreferAbsolutePTZ(false);
            FeaturesType featuresType = new FeaturesType();
            if (ptzAvailable && (nodes = (ptzConfiguration = this.getOnvifCore().getPtzService().getOnvifPtzService()).getNodes()).size() > 0) {
                PTZNode node = (PTZNode)ptzConfiguration.getNodes().get(0);
                PTZSpaces spaces = node.getSupportedPTZSpaces();
                featuresType.setCanAbsolutePan(false);
                featuresType.setCanAbsoluteTilt(false);
                featuresType.setCanAbsoluteZoom(false);
                featuresType.setCanContinuousPan(spaces.getContinuousPanTiltVelocitySpace().size() > 0);
                featuresType.setCanContinuousTilt(spaces.getContinuousPanTiltVelocitySpace().size() > 0);
                featuresType.setCanContinuousZoom(spaces.getContinuousZoomVelocitySpace().size() > 0);
                featuresType.setCanRelativePan(false);
                featuresType.setCanRelativeTilt(false);
                featuresType.setCanRelativeZoom(false);
                featuresType.setCanFocus(false);
                featuresType.setCanAutoFocus(false);
                featuresType.setCanIris(false);
                featuresType.setCanAutoIris(false);
                featuresType.setCanNullLux(false);
                featuresType.setCanAutoNullLux(false);
                featuresType.setCanPreset(node.getMaximumNumberOfPresets() > 0);
                featuresType.setMinPan(-180000);
                featuresType.setMaxPan(180000);
                featuresType.setMinTilt(0);
                featuresType.setMaxTilt(90000);
                featuresType.setMinZoom(0);
                featuresType.setMaxZoom(100000);
                featuresType.setMinSpeed(0);
                featuresType.setMaxSpeed(100000);
                featuresType.setPTZMinContinuousLevel(10000);
                featuresType.setPTZMaxContinuousLevel(100000);
                featuresType.setPTZContinuousSpeedFactor(1000);
            }
            videoCameraDefinition.setFeatures(featuresType);
            return videoCameraDefinition;
        }
        catch (SeeTecException exception) {
            this.logger.warn("Error while reading information from " + this, (Throwable)exception);
            throw exception;
        }
        catch (Exception exception) {
            this.logger.warn("Error while reading information from " + this, (Throwable)exception);
            throw new SeeTecException(-21600, exception.getMessage());
        }
    }

    @SuppressFBWarnings(value={"HARD_CODE_PASSWORD"}, justification="Wrong positive. Password TYPE and not passwort is set.")
    public static final int checkDeviceInfos(long type, String host, int port, boolean useAuthorization, String user, String pass, int timeout) {
        HTTPClientPolicy httpClientPolicy;
        HTTPConduit httpConduit;
        Client client;
        JaxWsProxyFactoryBean factory;
        Capabilities capabilities = null;
        try {
            factory = new JaxWsProxyFactoryBean();
            factory.setBindingId("http://schemas.xmlsoap.org/wsdl/soap12/");
            factory.setServiceClass(Device.class);
            factory.setAddress("http://" + host + ":" + port + "/onvif/device_service");
            Device device = (Device)factory.create(Device.class);
            client = ClientProxy.getClient((Object)device);
            httpConduit = (HTTPConduit)client.getConduit();
            httpClientPolicy = new HTTPClientPolicy();
            httpClientPolicy.setConnectionTimeout((long)timeout);
            httpClientPolicy.setReceiveTimeout((long)timeout);
            httpConduit.setClient(httpClientPolicy);
            ArrayList<CapabilityCategory> capabilityCategories = new ArrayList<CapabilityCategory>();
            capabilityCategories.add(CapabilityCategory.ALL);
            capabilities = device.getCapabilities(capabilityCategories);
        }
        catch (Exception e) {
            return -21697;
        }
        try {
            factory = new JaxWsProxyFactoryBean();
            factory.setBindingId("http://schemas.xmlsoap.org/wsdl/soap12/");
            factory.setServiceClass(Media.class);
            factory.setAddress(capabilities.getMedia() != null ? capabilities.getMedia().getXAddr() : null);
            Media media = (Media)factory.create(Media.class);
            client = ClientProxy.getClient((Object)media);
            httpConduit = (HTTPConduit)client.getConduit();
            httpClientPolicy = new HTTPClientPolicy();
            httpClientPolicy.setConnectionTimeout((long)timeout);
            httpClientPolicy.setReceiveTimeout((long)timeout);
            httpConduit.setClient(httpClientPolicy);
            if (useAuthorization) {
                Endpoint endpoint = client.getEndpoint();
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("action", "UsernameToken");
                properties.put("user", user);
                properties.put("passwordType", "PasswordDigest");
                properties.put("passwordCallbackRef", new WebServicePasswordHandler(pass));
                WSS4JOutInterceptor wssOut = new WSS4JOutInterceptor(properties);
                endpoint.getOutInterceptors().add(wssOut);
            }
            media.getProfiles();
        }
        catch (Exception e) {
            return -21701;
        }
        return 0;
    }

    private static boolean checkAuthenticationType(String host, int port, String user, String pass, int timeout, String authenticationType) {
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setBindingId("http://schemas.xmlsoap.org/wsdl/soap12/");
        factory.setServiceClass(Device.class);
        factory.setAddress("http://" + host + ":" + port + "/onvif/device_service");
        Device device = (Device)factory.create(Device.class);
        Client client = ClientProxy.getClient((Object)device);
        HTTPConduit httpConduit = (HTTPConduit)client.getConduit();
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setConnectionTimeout((long)timeout);
        httpClientPolicy.setReceiveTimeout((long)timeout);
        httpConduit.setClient(httpClientPolicy);
        ArrayList<CapabilityCategory> capabilityCategories = new ArrayList<CapabilityCategory>();
        capabilityCategories.add(CapabilityCategory.ALL);
        Capabilities capabilities = device.getCapabilities(capabilityCategories);
        factory.setServiceClass(Media.class);
        factory.setAddress(capabilities.getMedia() != null ? capabilities.getMedia().getXAddr() : null);
        Media media = (Media)factory.create(Media.class);
        Endpoint endpoint = client.getEndpoint();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("action", "UsernameToken");
        properties.put("user", user);
        properties.put("passwordType", authenticationType);
        properties.put("passwordCallbackRef", new WebServicePasswordHandler(pass));
        WSS4JOutInterceptor wssOut = new WSS4JOutInterceptor(properties);
        endpoint.getOutInterceptors().add(wssOut);
        try {
            media.getProfiles();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

